/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import org.eclipse.jetty.start.Module;

public class FileArg {
    public final String moduleName;
    public final String uri;
    public final String location;

    public FileArg(Module module, String uriLocation) {
        this(module == null ? null : module.getName(), uriLocation);
    }

    public FileArg(String uriLocation) {
        this((String)null, uriLocation);
    }

    private FileArg(String moduleName, String uriLocation) {
        this.moduleName = moduleName;
        String[] parts = uriLocation.split("\\|", 3);
        if (parts.length > 2) {
            StringBuilder err = new StringBuilder();
            String LN = System.lineSeparator();
            err.append("Unrecognized [file] argument: ").append(uriLocation);
            err.append(LN).append("Valid Syntaxes: ");
            err.append(LN).append("    <relative-path>       - eg: resources/");
            err.append(LN).append(" or <absolute-path>       - eg: /var/run/jetty.pid");
            err.append(LN).append(" or <uri>                 - eg: basehome:some/path");
            err.append(LN).append(" or <uri>|<rel-path>      - eg: http://machine/my.conf|resources/my.conf");
            err.append(LN).append(" or <uri>|<abs-path>      - eg: http://machine/glob.dat|/opt/run/glob.dat");
            err.append(LN).append("Known uri schemes: http, maven, home");
            throw new IllegalArgumentException(err.toString());
        }
        if (parts.length == 2) {
            this.uri = parts[0];
            this.location = parts[1];
        } else if (uriLocation.contains(":")) {
            this.uri = uriLocation;
            this.location = null;
        } else {
            this.uri = null;
            this.location = uriLocation;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileArg other = (FileArg)obj;
        if (this.uri == null ? other.uri != null : !this.uri.equals(other.uri)) {
            return false;
        }
        if (this.location == null) {
            return other.location == null;
        }
        return this.location.equals(other.location);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DownloadArg [uri=").append(this.uri).append(", location=").append(this.location).append("]");
        return builder.toString();
    }
}

