/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.lang.reflect.Method;
import org.apache.velocity.util.introspection.ConversionHandler;
import org.apache.velocity.util.introspection.IntrospectorBase;
import org.apache.velocity.util.introspection.MethodMap;
import org.slf4j.Logger;

public class Introspector
extends IntrospectorBase {
    public Introspector(Logger logger) {
        this(logger, null);
    }

    public Introspector(Logger logger, ConversionHandler conversionHandler) {
        super(logger, conversionHandler);
    }

    @Override
    public Method getMethod(Class clazz, String string, Object[] objectArray) throws IllegalArgumentException {
        try {
            return super.getMethod(clazz, string, objectArray);
        }
        catch (MethodMap.AmbiguousException ambiguousException) {
            StringBuilder stringBuilder = new StringBuilder("Introspection Error: Ambiguous method invocation ").append(string).append("(");
            for (int i = 0; i < objectArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                if (objectArray[i] == null) {
                    stringBuilder.append("null");
                    continue;
                }
                stringBuilder.append(objectArray[i].getClass().getName());
            }
            stringBuilder.append(") for class ").append(clazz);
            this.log.debug(stringBuilder.toString());
            return null;
        }
    }
}

