/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.parser.node;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.parser.node.AbstractExecutor;
import org.apache.velocity.util.ArrayListWrapper;
import org.apache.velocity.util.introspection.Introspector;
import org.slf4j.Logger;

public class PropertyExecutor
extends AbstractExecutor {
    private final Introspector introspector;
    private final boolean wrapArray;

    public PropertyExecutor(Logger logger, Introspector introspector, Class clazz, String string) {
        this(logger, introspector, clazz, string, false);
    }

    public PropertyExecutor(Logger logger, Introspector introspector, Class clazz, String string, boolean bl) {
        this.log = logger;
        this.introspector = introspector;
        this.wrapArray = bl;
        if (StringUtils.isNotEmpty((CharSequence)string)) {
            this.discover(clazz, string);
        }
    }

    protected Introspector getIntrospector() {
        return this.introspector;
    }

    protected void discover(Class clazz, String string) {
        try {
            Object[] objectArray = new Object[]{};
            StringBuilder stringBuilder = new StringBuilder("get");
            stringBuilder.append(string);
            this.setMethod(this.introspector.getMethod(clazz, stringBuilder.toString(), objectArray));
            if (!this.isAlive()) {
                char c = stringBuilder.charAt(3);
                if (Character.isLowerCase(c)) {
                    stringBuilder.setCharAt(3, Character.toUpperCase(c));
                } else {
                    stringBuilder.setCharAt(3, Character.toLowerCase(c));
                }
                this.setMethod(this.introspector.getMethod(clazz, stringBuilder.toString(), objectArray));
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            String string2 = "Exception while looking for property getter for '" + string;
            this.log.error(string2, (Throwable)exception);
            throw new VelocityException(string2, exception);
        }
    }

    @Override
    public Object execute(Object object) throws IllegalAccessException, InvocationTargetException {
        if (this.wrapArray) {
            object = new ArrayListWrapper(object);
        }
        return this.isAlive() ? this.getMethod().invoke(object, (Object[])null) : null;
    }
}

