/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.editorActions.CompletionAutoPopupHandler;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.ui.UIUtil;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import junit.framework.TestCase;

public class CompletionAutoPopupTester {
    private final CodeInsightTestFixture myFixture;

    public CompletionAutoPopupTester(CodeInsightTestFixture fixture) {
        this.myFixture = fixture;
    }

    public void runWithAutoPopupEnabled(Runnable r) {
        assert (!ApplicationManager.getApplication().isDispatchThread());
        TestModeFlags.set((Key)CompletionAutoPopupHandler.ourTestingAutopopup, (Object)true);
        try {
            r.run();
        }
        finally {
            TestModeFlags.reset((Key)CompletionAutoPopupHandler.ourTestingAutopopup);
            ((DocumentEx)this.myFixture.getEditor().getDocument()).setModificationStamp(0L);
        }
    }

    public void joinCompletion() {
        CompletionAutoPopupTester.waitPhase(phase -> !(phase instanceof CompletionPhase.CommittingDocuments) && !(phase instanceof CompletionPhase.Synchronous) && !(phase instanceof CompletionPhase.BgCalculation));
    }

    private static void waitPhase(Predicate<? super CompletionPhase> condition) {
        for (int j = 1; j < 1000; ++j) {
            CompletionPhase phase = (CompletionPhase)EdtTestUtil.runInEdtAndGet(() -> CompletionServiceImpl.getCompletionPhase());
            if (condition.test((CompletionPhase)phase)) {
                return;
            }
            if (j >= 400 && j % 100 == 0) {
                System.out.println("Free memory: " + Runtime.getRuntime().freeMemory() + " of " + Runtime.getRuntime().totalMemory() + "\n");
                UsefulTestCase.printThreadDump();
                System.out.println("\n\n----------------------------\n\n");
            }
            TimeoutUtil.sleep((long)10L);
        }
        TestCase.fail((String)("Too long completion: " + CompletionServiceImpl.getCompletionPhase()));
    }

    public void joinCommit(Runnable c1) {
        AtomicBoolean committed = new AtomicBoolean();
        AtomicBoolean run2 = new AtomicBoolean();
        AtomicBoolean executed = new AtomicBoolean(true);
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> executed.set(PsiDocumentManager.getInstance((Project)this.myFixture.getProject()).performWhenAllCommitted(() -> {
            run2.set(true);
            ApplicationManager.getApplication().invokeLater(() -> {
                c1.run();
                committed.set(true);
            });
        }))));
        assert (!ApplicationManager.getApplication().isWriteAccessAllowed());
        assert (!ApplicationManager.getApplication().isReadAccessAllowed());
        assert (!ApplicationManager.getApplication().isDispatchThread());
        long start = System.currentTimeMillis();
        while (!committed.get()) {
            if (System.currentTimeMillis() - start >= 20000L) {
                UsefulTestCase.printThreadDump();
                TestCase.fail((String)("too long waiting for documents to be committed. executed: " + executed + "; run: " + run2 + "; "));
            }
            UIUtil.pump();
        }
    }

    public void joinCommit() {
        this.joinCommit(EmptyRunnable.getInstance());
    }

    public void joinAutopopup() {
        CompletionAutoPopupTester.waitPhase(phase -> !(phase instanceof CompletionPhase.CommittingDocuments));
    }

    public LookupImpl getLookup() {
        return (LookupImpl)this.myFixture.getLookup();
    }

    public void typeWithPauses(String s) {
        for (int i = 0; i < s.length(); ++i) {
            this.myFixture.type(s.charAt(i));
            this.joinAutopopup();
            this.joinCompletion();
        }
    }
}

