/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.lang.Language;
import com.intellij.mock.MockLanguageFileType;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockFileTypeManager
extends FileTypeManagerEx {
    private final FileType fileType;

    public MockFileTypeManager(FileType fileType) {
        this.fileType = fileType;
    }

    public void registerFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            MockFileTypeManager.$$$reportNull$$$0(0);
        }
    }

    public void unregisterFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            MockFileTypeManager.$$$reportNull$$$0(1);
        }
    }

    @NotNull
    public String getIgnoredFilesList() {
        throw new IncorrectOperationException();
    }

    public void setIgnoredFilesList(@NotNull String list) {
        if (list == null) {
            MockFileTypeManager.$$$reportNull$$$0(2);
        }
    }

    public boolean isIgnoredFilesListEqualToCurrent(@NotNull String list) {
        if (list == null) {
            MockFileTypeManager.$$$reportNull$$$0(3);
        }
        return false;
    }

    public void save() {
    }

    @NotNull
    public String getExtension(@NotNull String fileName) {
        if (fileName == null) {
            MockFileTypeManager.$$$reportNull$$$0(4);
        }
        return "";
    }

    public void registerFileType(@NotNull FileType type, @NotNull List<? extends FileNameMatcher> defaultAssociations) {
        if (type == null) {
            MockFileTypeManager.$$$reportNull$$$0(5);
        }
        if (defaultAssociations == null) {
            MockFileTypeManager.$$$reportNull$$$0(6);
        }
    }

    public void fireFileTypesChanged() {
    }

    @NotNull
    public FileType getFileTypeByFileName(@NotNull String fileName) {
        if (fileName == null) {
            MockFileTypeManager.$$$reportNull$$$0(7);
        }
        FileType fileType = this.fileType;
        if (fileType == null) {
            MockFileTypeManager.$$$reportNull$$$0(8);
        }
        return fileType;
    }

    @NotNull
    public FileType getFileTypeByFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            MockFileTypeManager.$$$reportNull$$$0(9);
        }
        FileType fileType = this.fileType;
        if (fileType == null) {
            MockFileTypeManager.$$$reportNull$$$0(10);
        }
        return fileType;
    }

    @NotNull
    public FileType getFileTypeByExtension(@NotNull String extension) {
        if (extension == null) {
            MockFileTypeManager.$$$reportNull$$$0(11);
        }
        FileType fileType = this.fileType;
        if (fileType == null) {
            MockFileTypeManager.$$$reportNull$$$0(12);
        }
        return fileType;
    }

    public FileType @NotNull [] getRegisteredFileTypes() {
        if (FileType.EMPTY_ARRAY == null) {
            MockFileTypeManager.$$$reportNull$$$0(13);
        }
        return FileType.EMPTY_ARRAY;
    }

    public boolean isFileIgnored(@NotNull String name) {
        if (name == null) {
            MockFileTypeManager.$$$reportNull$$$0(14);
        }
        return false;
    }

    public boolean isFileIgnored(@NotNull VirtualFile file2) {
        if (file2 == null) {
            MockFileTypeManager.$$$reportNull$$$0(15);
        }
        return false;
    }

    public String @NotNull [] getAssociatedExtensions(@NotNull FileType type) {
        if (type == null) {
            MockFileTypeManager.$$$reportNull$$$0(16);
        }
        if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
            MockFileTypeManager.$$$reportNull$$$0(17);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    public void fireBeforeFileTypesChanged() {
    }

    public void addFileTypeListener(@NotNull FileTypeListener listener) {
        if (listener == null) {
            MockFileTypeManager.$$$reportNull$$$0(18);
        }
    }

    public void removeFileTypeListener(@NotNull FileTypeListener listener) {
        if (listener == null) {
            MockFileTypeManager.$$$reportNull$$$0(19);
        }
    }

    public FileType getKnownFileTypeOrAssociate(@NotNull VirtualFile file2, @NotNull Project project2) {
        if (file2 == null) {
            MockFileTypeManager.$$$reportNull$$$0(20);
        }
        if (project2 == null) {
            MockFileTypeManager.$$$reportNull$$$0(21);
        }
        return file2.getFileType();
    }

    @NotNull
    public List<FileNameMatcher> getAssociations(@NotNull FileType type) {
        if (type == null) {
            MockFileTypeManager.$$$reportNull$$$0(22);
        }
        List<FileNameMatcher> list = Collections.emptyList();
        if (list == null) {
            MockFileTypeManager.$$$reportNull$$$0(23);
        }
        return list;
    }

    public void associate(@NotNull FileType type, @NotNull FileNameMatcher matcher) {
        if (type == null) {
            MockFileTypeManager.$$$reportNull$$$0(24);
        }
        if (matcher == null) {
            MockFileTypeManager.$$$reportNull$$$0(25);
        }
    }

    public void removeAssociation(@NotNull FileType type, @NotNull FileNameMatcher matcher) {
        if (type == null) {
            MockFileTypeManager.$$$reportNull$$$0(26);
        }
        if (matcher == null) {
            MockFileTypeManager.$$$reportNull$$$0(27);
        }
    }

    @NotNull
    public FileType getStdFileType(@NotNull @NonNls String fileTypeName) {
        if (fileTypeName == null) {
            MockFileTypeManager.$$$reportNull$$$0(28);
        }
        if ("ARCHIVE".equals(fileTypeName)) {
            FileType fileType = UnknownFileType.INSTANCE;
            if (fileType == null) {
                MockFileTypeManager.$$$reportNull$$$0(29);
            }
            return fileType;
        }
        if ("PLAIN_TEXT".equals(fileTypeName)) {
            PlainTextFileType plainTextFileType = PlainTextFileType.INSTANCE;
            if (plainTextFileType == null) {
                MockFileTypeManager.$$$reportNull$$$0(30);
            }
            return plainTextFileType;
        }
        if ("CLASS".equals(fileTypeName)) {
            FileType fileType = MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.JavaClassFileType", fileTypeName);
            if (fileType == null) {
                MockFileTypeManager.$$$reportNull$$$0(31);
            }
            return fileType;
        }
        if ("JAVA".equals(fileTypeName)) {
            FileType fileType = MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.JavaFileType", fileTypeName);
            if (fileType == null) {
                MockFileTypeManager.$$$reportNull$$$0(32);
            }
            return fileType;
        }
        if ("XML".equals(fileTypeName)) {
            FileType fileType = MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.XmlFileType", fileTypeName);
            if (fileType == null) {
                MockFileTypeManager.$$$reportNull$$$0(33);
            }
            return fileType;
        }
        if ("DTD".equals(fileTypeName)) {
            FileType fileType = MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.DTDFileType", fileTypeName);
            if (fileType == null) {
                MockFileTypeManager.$$$reportNull$$$0(34);
            }
            return fileType;
        }
        if ("JSP".equals(fileTypeName)) {
            FileType fileType = MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.NewJspFileType", fileTypeName);
            if (fileType == null) {
                MockFileTypeManager.$$$reportNull$$$0(35);
            }
            return fileType;
        }
        if ("JSPX".equals(fileTypeName)) {
            FileType fileType = MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.JspxFileType", fileTypeName);
            if (fileType == null) {
                MockFileTypeManager.$$$reportNull$$$0(36);
            }
            return fileType;
        }
        if ("HTML".equals(fileTypeName)) {
            FileType fileType = MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.HtmlFileType", fileTypeName);
            if (fileType == null) {
                MockFileTypeManager.$$$reportNull$$$0(37);
            }
            return fileType;
        }
        if ("XHTML".equals(fileTypeName)) {
            FileType fileType = MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.XHtmlFileType", fileTypeName);
            if (fileType == null) {
                MockFileTypeManager.$$$reportNull$$$0(38);
            }
            return fileType;
        }
        if ("JavaScript".equals(fileTypeName)) {
            FileType fileType = MockFileTypeManager.loadFileTypeSafe("com.intellij.lang.javascript.JavaScriptFileType", fileTypeName);
            if (fileType == null) {
                MockFileTypeManager.$$$reportNull$$$0(39);
            }
            return fileType;
        }
        if ("Properties".equals(fileTypeName)) {
            FileType fileType = MockFileTypeManager.loadFileTypeSafe("com.intellij.lang.properties.PropertiesFileType", fileTypeName);
            if (fileType == null) {
                MockFileTypeManager.$$$reportNull$$$0(40);
            }
            return fileType;
        }
        if ("GUI_DESIGNER_FORM".equals(fileTypeName)) {
            FileType fileType = MockFileTypeManager.loadFileTypeSafe("com.intellij.uiDesigner.GuiFormFileType", fileTypeName);
            if (fileType == null) {
                MockFileTypeManager.$$$reportNull$$$0(41);
            }
            return fileType;
        }
        return new MockLanguageFileType((Language)PlainTextLanguage.INSTANCE, StringUtil.toLowerCase((String)fileTypeName));
    }

    private static FileType loadFileTypeSafe(String className, String fileTypeName) {
        try {
            return (FileType)Class.forName(className).getField("INSTANCE").get(null);
        }
        catch (Exception ignored) {
            return new MockLanguageFileType((Language)PlainTextLanguage.INSTANCE, StringUtil.toLowerCase((String)fileTypeName));
        }
    }

    @Nullable
    public FileType findFileTypeByName(@NotNull String fileTypeName) {
        if (fileTypeName == null) {
            MockFileTypeManager.$$$reportNull$$$0(42);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 23: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 23: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 5: 
            case 16: 
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultAssociations";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 23: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/mock/MockFileTypeManager";
                break;
            }
            case 9: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 28: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/mock/MockFileTypeManager";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeByFileName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeByFile";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeByExtension";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisteredFileTypes";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssociatedExtensions";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssociations";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getStdFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerFileType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "unregisterFileType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setIgnoredFilesList";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredFilesListEqualToCurrent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getExtension";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeByFileName";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 23: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeByFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeByExtension";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isFileIgnored";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAssociatedExtensions";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addFileTypeListener";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeFileTypeListener";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getKnownFileTypeOrAssociate";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getAssociations";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "associate";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "removeAssociation";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getStdFileType";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "findFileTypeByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 23: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

