/*
 * Decompiled with CFR 0.152.
 */
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.rt.execution.junit.MapSerializerUtil;
import com.intellij.testFramework.HeavyPlatformTestCase;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.TestApplicationManagerKt;
import com.intellij.util.CachedValuesManagerImpl;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ref.GCUtil;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;
import org.junit.Assume;
import org.junit.FixMethodOrder;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class _LastInSuiteTest
extends TestCase {
    private static final Set<String> EXTENSION_POINTS_WHITE_LIST = Collections.emptySet();

    protected void setUp() throws Exception {
        super.setUp();
        Disposer.setDebugMode((boolean)true);
    }

    public String getName() {
        return _LastInSuiteTest.getTestName(super.getName());
    }

    private static String getTestName(String name) {
        String buildConf = System.getProperty("teamcity.buildConfName");
        return buildConf == null ? name : name + "[" + buildConf + "]";
    }

    public void testDynamicExtensions() {
        Assume.assumeTrue((!EXTENSION_POINTS_WHITE_LIST.isEmpty() || SystemProperties.getBooleanProperty((String)"intellij.test.all.dynamic.extension.points", (boolean)false) ? 1 : 0) != 0);
        Map<ExtensionPoint<?>, Collection<WeakReference<Object>>> extensions = _LastInSuiteTest.collectDynamicNonPlatformExtensions();
        _LastInSuiteTest.unloadExtensionPoints(extensions.keySet());
        _LastInSuiteTest.startCorePluginUnload();
        _LastInSuiteTest.disposePluginDisposables();
        ProjectManager pm = ProjectManager.getInstanceIfCreated();
        if (pm != null) {
            for (Project project2 : pm.getOpenProjects()) {
                ((CachedValuesManagerImpl)CachedValuesManager.getManager((Project)project2)).clearCachedValues();
            }
        }
        _LastInSuiteTest.finishCorePluginUnload();
        GCUtil.tryGcSoftlyReachableObjects();
        System.gc();
        System.gc();
        String heapDump = HeavyPlatformTestCase.publishHeapDump("dynamicExtension");
        AtomicBoolean failed = new AtomicBoolean(false);
        extensions.forEach((ep, references) -> {
            String testName = _LastInSuiteTest.escape(_LastInSuiteTest.getTestName("Dynamic EP unloading " + ep.getName()));
            System.out.printf("##teamcity[testStarted name='%s']%n", testName);
            System.out.flush();
            List alive = ContainerUtil.mapNotNull((Collection)references, Reference::get);
            if (!alive.isEmpty()) {
                String aliveExtensions = StringUtil.join((Collection)alive, o -> o + " (" + o.getClass() + ")", (String)"\n");
                System.out.printf("##teamcity[%s name='%s' message='%s']%n", "testFailed", testName, _LastInSuiteTest.escape("Not unloaded extensions:\n" + aliveExtensions + "\n\nSee testDynamicExtensions output to find a heapDump"));
                System.out.flush();
                failed.set(true);
            } else {
                System.out.printf("##teamcity[testFinished name='%s']%n", testName);
                System.out.flush();
            }
        });
        if (failed.get()) {
            _LastInSuiteTest.fail((String)("Some of dynamic extensions have not been unloaded. See individual tests for details. Heap dump: " + heapDump));
        }
    }

    private static void disposePluginDisposables() {
        DynamicPlugins.INSTANCE.getPluginDisposables().forEach((plugin, disposable) -> Disposer.dispose((Disposable)disposable));
    }

    @NotNull
    private static String escape(String s) {
        String string = MapSerializerUtil.escapeStr(s, MapSerializerUtil.STD_ESCAPER);
        if (string == null) {
            _LastInSuiteTest.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static void unloadExtensionPoints(@NotNull Set<ExtensionPoint<?>> extensionPoints) {
        if (extensionPoints == null) {
            _LastInSuiteTest.$$$reportNull$$$0(1);
        }
        for (ExtensionPoint<?> ep : extensionPoints) {
            ApplicationManager.getApplication().invokeAndWait(() -> ep.unregisterExtensions((a, b) -> false, false));
        }
    }

    private static void startCorePluginUnload() {
        IdeaPluginDescriptor corePlugin = PluginManagerCore.getPlugin((PluginId)PluginManagerCore.CORE_ID);
        assert (corePlugin != null);
        WriteAction.runAndWait(() -> ((DynamicPluginListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(DynamicPluginListener.TOPIC)).beforePluginUnload(corePlugin, false));
    }

    private static void finishCorePluginUnload() {
        IdeaPluginDescriptor corePlugin = PluginManagerCore.getPlugin((PluginId)PluginManagerCore.CORE_ID);
        assert (corePlugin != null);
        WriteAction.runAndWait(() -> ((DynamicPluginListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(DynamicPluginListener.TOPIC)).pluginUnloaded(corePlugin, false));
    }

    @NotNull
    private static Map<ExtensionPoint<?>, Collection<WeakReference<Object>>> collectDynamicNonPlatformExtensions() {
        boolean useWhiteList = !SystemProperties.getBooleanProperty((String)"intellij.test.all.dynamic.extension.points", (boolean)false);
        ExtensionsArea area = Extensions.getRootArea();
        HashMap extensions = new HashMap();
        ProjectManager pm = ProjectManager.getInstanceIfCreated();
        if (pm != null) {
            for (Project project2 : pm.getOpenProjects()) {
                _LastInSuiteTest.collectForArea(project2.getExtensionArea(), useWhiteList, extensions);
            }
        }
        _LastInSuiteTest.collectForArea(area, useWhiteList, extensions);
        HashMap hashMap = extensions;
        if (hashMap == null) {
            _LastInSuiteTest.$$$reportNull$$$0(2);
        }
        return hashMap;
    }

    private static void collectForArea(ExtensionsArea area, boolean useWhiteList, Map<ExtensionPoint<?>, Collection<WeakReference<Object>>> extensions) {
        if (area == null) {
            return;
        }
        for (ExtensionPoint ep : area.getExtensionPoints()) {
            if (!ep.isDynamic() || useWhiteList && !EXTENSION_POINTS_WHITE_LIST.contains(ep.getName())) continue;
            extensions.put(ep, ep.extensions().filter(e -> !_LastInSuiteTest.isPlatformExtension(ep, e)).map(WeakReference::new).collect(Collectors.toList()));
        }
    }

    private static boolean isPlatformExtension(ExtensionPoint<?> ep, Object extension) {
        PluginDescriptor plugin = ((ExtensionPointImpl)ep).getPluginDescriptor(extension);
        return plugin != null && plugin.getPluginId() == PluginManagerCore.CORE_ID;
    }

    public void testProjectLeak() {
        if (Boolean.getBoolean("idea.test.guimode")) {
            Application application = ApplicationManager.getApplication();
            application.invokeAndWait(() -> {
                IdeEventQueue.getInstance().flushQueue();
                application.exit(true, true, false);
            });
            ShutDownTracker.getInstance().waitFor(100L, TimeUnit.SECONDS);
            return;
        }
        TestApplicationManagerKt.disposeApplicationAndCheckForLeaks();
    }

    public void testStatistics() {
        long started = _FirstInSuiteTest.getSuiteStartTime();
        if (started != 0L) {
            long testSuiteDuration = System.nanoTime() - started;
            System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.totalTimeMs' value='%d']", testSuiteDuration / 1000000L));
        }
        LightPlatformTestCase.reportTestExecutionStatistics();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_LastInSuiteTest";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPoints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "escape";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "_LastInSuiteTest";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "collectDynamicNonPlatformExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "unloadExtensionPoints";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

