/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.validation;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.intellij.lang.regexp.RegExpLanguageHost;
import org.intellij.lang.regexp.RegExpLanguageHosts;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.RegExpAtom;
import org.intellij.lang.regexp.psi.RegExpBackref;
import org.intellij.lang.regexp.psi.RegExpBoundary;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpCharRange;
import org.intellij.lang.regexp.psi.RegExpClass;
import org.intellij.lang.regexp.psi.RegExpClassElement;
import org.intellij.lang.regexp.psi.RegExpClosure;
import org.intellij.lang.regexp.psi.RegExpElement;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNamedCharacter;
import org.intellij.lang.regexp.psi.RegExpNamedGroupRef;
import org.intellij.lang.regexp.psi.RegExpNumber;
import org.intellij.lang.regexp.psi.RegExpOptions;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.intellij.lang.regexp.psi.RegExpPosixBracketExpression;
import org.intellij.lang.regexp.psi.RegExpProperty;
import org.intellij.lang.regexp.psi.RegExpPyCondRef;
import org.intellij.lang.regexp.psi.RegExpQuantifier;
import org.intellij.lang.regexp.psi.RegExpRecursiveElementVisitor;
import org.intellij.lang.regexp.psi.RegExpSetOptions;
import org.intellij.lang.regexp.psi.RegExpSimpleClass;
import org.intellij.lang.regexp.validation.SimplifyQuantifierAction;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RegExpAnnotator
extends RegExpElementVisitor
implements Annotator {
    private static final Set<String> POSIX_CHARACTER_CLASSES = ContainerUtil.newHashSet((Object[])new String[]{"alnum", "alpha", "ascii", "blank", "cntrl", "digit", "graph", "lower", "print", "punct", "space", "upper", "word", "xdigit"});
    private AnnotationHolder myHolder;
    private final RegExpLanguageHosts myLanguageHosts;
    private final Key<Map<String, RegExpGroup>> NAMED_GROUP_MAP = new Key("REG_EXP_NAMED_GROUP_MAP");

    public RegExpAnnotator() {
        this.myLanguageHosts = RegExpLanguageHosts.getInstance();
    }

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            RegExpAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            RegExpAnnotator.$$$reportNull$$$0(1);
        }
        assert (this.myHolder == null) : "unsupported concurrent annotator invocation";
        try {
            this.myHolder = holder;
            psiElement.accept((PsiElementVisitor)this);
        }
        finally {
            this.myHolder = null;
        }
    }

    @Override
    public void visitRegExpSetOptions(RegExpSetOptions options) {
        this.checkValidFlag(options.getOnOptions(), false);
        this.checkValidFlag(options.getOffOptions(), true);
    }

    private void checkValidFlag(@Nullable RegExpOptions options, boolean skipMinus) {
        int start2;
        if (options == null) {
            return;
        }
        String text2 = options.getText();
        int length = text2.length();
        for (int i = start2 = skipMinus ? 1 : 0; i < length; ++i) {
            int c = text2.codePointAt(i);
            if (Character.isBmpCodePoint(c) && this.myLanguageHosts.supportsInlineOptionFlag((char)c, options)) continue;
            int offset = options.getTextOffset() + i;
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, "Unknown inline option flag").range(new TextRange(offset, offset + 1)).create();
        }
    }

    @Override
    public void visitRegExpCharRange(RegExpCharRange range2) {
        int nextSiblingValue;
        PsiElement nextSibling;
        int prevSiblingValue;
        PsiElement prevSibling;
        RegExpChar from = range2.getFrom();
        RegExpChar to = range2.getTo();
        if (to == null) {
            return;
        }
        int fromCodePoint = from.getValue();
        int toCodePoint = to.getValue();
        if (fromCodePoint == -1 || toCodePoint == -1) {
            return;
        }
        int errorStart = range2.getTextOffset();
        int errorEnd = errorStart + range2.getTextLength();
        if (!Character.isSupplementaryCodePoint(fromCodePoint) && Character.isLowSurrogate((char)fromCodePoint) && (prevSibling = range2.getPrevSibling()) instanceof RegExpChar && !Character.isSupplementaryCodePoint(prevSiblingValue = ((RegExpChar)prevSibling).getValue()) && Character.isHighSurrogate((char)prevSiblingValue)) {
            fromCodePoint = Character.toCodePoint((char)prevSiblingValue, (char)fromCodePoint);
            errorStart -= prevSibling.getTextLength();
        }
        if (!Character.isSupplementaryCodePoint(toCodePoint) && Character.isHighSurrogate((char)toCodePoint) && (nextSibling = range2.getNextSibling()) instanceof RegExpChar && !Character.isSupplementaryCodePoint(nextSiblingValue = ((RegExpChar)nextSibling).getValue()) && Character.isLowSurrogate((char)nextSiblingValue)) {
            toCodePoint = Character.toCodePoint((char)toCodePoint, (char)nextSiblingValue);
            errorEnd += nextSibling.getTextLength();
        }
        if (toCodePoint < fromCodePoint) {
            this.myHolder.createErrorAnnotation(new TextRange(errorStart, errorEnd), "Illegal character range (to < from)");
        } else if (toCodePoint == fromCodePoint) {
            this.myHolder.createWarningAnnotation(new TextRange(errorStart, errorEnd), "Redundant character range");
        }
    }

    @Override
    public void visitRegExpBoundary(RegExpBoundary boundary) {
        if (!this.myLanguageHosts.supportsBoundary(boundary)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, "This boundary is not supported in this regex dialect").create();
        }
    }

    @Override
    public void visitSimpleClass(RegExpSimpleClass simpleClass) {
        if (!this.myLanguageHosts.supportsSimpleClass(simpleClass)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, "Illegal/unsupported escape sequence").create();
        }
    }

    @Override
    public void visitRegExpClass(RegExpClass regExpClass) {
        if (!(regExpClass.getParent() instanceof RegExpClass)) {
            this.checkForDuplicates(regExpClass, new HashSet<Object>());
        }
    }

    private void checkForDuplicates(RegExpClassElement element2, Set<Object> seen) {
        if (element2 instanceof RegExpChar) {
            RegExpChar regExpChar = (RegExpChar)element2;
            int value2 = regExpChar.getValue();
            if (value2 != -1 && !seen.add(value2)) {
                this.myHolder.newAnnotation(HighlightSeverity.WARNING, "Duplicate character '" + regExpChar.getText() + "' inside character class").range((PsiElement)regExpChar).create();
            }
        } else if (element2 instanceof RegExpSimpleClass) {
            RegExpSimpleClass regExpSimpleClass = (RegExpSimpleClass)element2;
            RegExpSimpleClass.Kind kind = regExpSimpleClass.getKind();
            if (!seen.add((Object)kind)) {
                this.myHolder.newAnnotation(HighlightSeverity.WARNING, "Duplicate predefined character class '" + regExpSimpleClass.getText() + "' inside character class").range((PsiElement)regExpSimpleClass).create();
            }
        } else if (element2 instanceof RegExpClass) {
            RegExpClass regExpClass = (RegExpClass)element2;
            for (RegExpClassElement classElement : regExpClass.getElements()) {
                this.checkForDuplicates(classElement, seen);
            }
        }
    }

    @Override
    public void visitRegExpChar(RegExpChar ch) {
        RegExpChar.Type charType;
        PsiElement child2 = ch.getFirstChild();
        IElementType type = child2.getNode().getElementType();
        if (type == StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, "Illegal/unsupported escape sequence").create();
            return;
        }
        if (type == RegExpTT.BAD_HEX_VALUE) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, "Illegal hexadecimal escape sequence").create();
            return;
        }
        if (type == RegExpTT.BAD_OCT_VALUE) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, "Illegal octal escape sequence").create();
            return;
        }
        if (type == StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, "Illegal unicode escape sequence").create();
            return;
        }
        String text2 = ch.getUnescapedText();
        if (type == RegExpTT.ESC_CTRL_CHARACTER && text2.equals("\\b") && !this.myLanguageHosts.supportsLiteralBackspace(ch)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, "Illegal/unsupported escape sequence").create();
        }
        if ((charType = ch.getType()) == RegExpChar.Type.HEX || charType == RegExpChar.Type.UNICODE) {
            if (ch.getValue() == -1) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, "Illegal unicode escape sequence").create();
                return;
            }
            if (text2.charAt(text2.length() - 1) == '}' && !this.myLanguageHosts.supportsExtendedHexCharacter(ch)) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, "This hex character syntax is not supported in this regex dialect").create();
            }
        }
    }

    @Override
    public void visitRegExpProperty(RegExpProperty property) {
        ASTNode category = property.getCategoryNode();
        if (category == null) {
            return;
        }
        if (!this.myLanguageHosts.supportsPropertySyntax(property)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, "Property escape sequences are not supported in this regex dialect").create();
            return;
        }
        String propertyName = category.getText();
        ASTNode next = category.getTreeNext();
        if (next == null || next.getElementType() != RegExpTT.EQ) {
            if (!this.myLanguageHosts.isValidCategory(category.getPsi(), propertyName)) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, "Unknown character category").range(category).highlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL).create();
            }
        } else {
            if (!this.myLanguageHosts.isValidPropertyName(category.getPsi(), propertyName)) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, "Unknown property name").range(category).highlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL).create();
                return;
            }
            ASTNode valueNode = property.getValueNode();
            if (valueNode != null && !this.myLanguageHosts.isValidPropertyValue(category.getPsi(), propertyName, valueNode.getText())) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, "Unknown property value").range(valueNode).highlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL).create();
            }
        }
    }

    @Override
    public void visitRegExpNamedCharacter(RegExpNamedCharacter namedCharacter) {
        ASTNode node;
        if (!this.myLanguageHosts.supportsNamedCharacters(namedCharacter)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, "Named Unicode characters are not allowed in this regex dialect").create();
        } else if (!this.myLanguageHosts.isValidNamedCharacter(namedCharacter) && (node = namedCharacter.getNameNode()) != null) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, "Unknown character name").range(node).highlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL).create();
        }
    }

    @Override
    public void visitRegExpBackref(RegExpBackref backref) {
        RegExpGroup group = backref.resolve();
        if (group == null) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, "Unresolved back reference").highlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL).create();
        } else if (PsiTreeUtil.isAncestor((PsiElement)group, (PsiElement)backref, (boolean)true)) {
            this.myHolder.newAnnotation(HighlightSeverity.WARNING, "Back reference is nested into the capturing group it refers to").create();
        }
    }

    @Override
    public void visitRegExpGroup(RegExpGroup group) {
        RegExpGroup.Type groupType;
        ASTNode node;
        AnnotationSession session2;
        Map namedGroups;
        ASTNode node2;
        String name;
        RegExpPattern pattern = group.getPattern();
        if (pattern != null) {
            RegExpGroup.Type type;
            RegExpAtom[] atoms;
            RegExpBranch[] branches = pattern.getBranches();
            if (RegExpAnnotator.isEmpty(branches) && group.getNode().getLastChildNode().getElementType() == RegExpTT.GROUP_END) {
                this.myHolder.newAnnotation(HighlightSeverity.WARNING, "Empty group").create();
            } else if (branches.length == 1 && (atoms = branches[0].getAtoms()).length == 1 && atoms[0] instanceof RegExpGroup && ((type = group.getType()) == RegExpGroup.Type.CAPTURING_GROUP || type == RegExpGroup.Type.ATOMIC || type == RegExpGroup.Type.NON_CAPTURING)) {
                RegExpGroup innerGroup = (RegExpGroup)atoms[0];
                if (group.isCapturing() == innerGroup.isCapturing()) {
                    this.myHolder.newAnnotation(HighlightSeverity.WARNING, "Redundant group nesting").create();
                }
            }
        }
        if (group.isAnyNamedGroup() && !this.myLanguageHosts.supportsNamedGroupSyntax(group)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, "This named group syntax is not supported in this regex dialect").create();
        }
        if (group.getType() == RegExpGroup.Type.ATOMIC && !this.myLanguageHosts.supportsPossessiveQuantifiers(group)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, "Atomic groups are not supported in this regex dialect").create();
        }
        if ((name = group.getName()) != null && !this.myLanguageHosts.isValidGroupName(name, group) && (node2 = group.getNode().findChildByType(RegExpTT.NAME)) != null) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, "Invalid group name").range(node2).create();
        }
        if ((namedGroups = (Map)this.NAMED_GROUP_MAP.get((UserDataHolder)(session2 = this.myHolder.getCurrentAnnotationSession()), new HashMap())).isEmpty()) {
            session2.putUserData(this.NAMED_GROUP_MAP, (Object)namedGroups);
        }
        if (namedGroups.put(name, group) != null && (node = group.getNode().findChildByType(RegExpTT.NAME)) != null) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, "Group with name '" + name + "' already defined").range(node).create();
        }
        if ((groupType = group.getType()) == RegExpGroup.Type.POSITIVE_LOOKBEHIND || groupType == RegExpGroup.Type.NEGATIVE_LOOKBEHIND) {
            RegExpLanguageHost.Lookbehind support = this.myLanguageHosts.supportsLookbehind(group);
            if (support == RegExpLanguageHost.Lookbehind.NOT_SUPPORTED) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, "Look-behind groups are not supported in this regex dialect").create();
            } else {
                group.accept(new LookbehindVisitor(support, this.myHolder));
            }
        }
    }

    @Override
    public void visitRegExpNamedGroupRef(RegExpNamedGroupRef groupRef) {
        if (!this.myLanguageHosts.supportsNamedGroupRefSyntax(groupRef)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, "This named group reference syntax is not supported in this regex dialect").create();
            return;
        }
        if (groupRef.getGroupName() == null) {
            return;
        }
        RegExpGroup group = groupRef.resolve();
        if (group == null) {
            ASTNode node = groupRef.getNode().findChildByType(RegExpTT.NAME);
            if (node != null) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, "Unresolved named group reference").range(node).highlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL).create();
            }
        } else if (PsiTreeUtil.isAncestor((PsiElement)group, (PsiElement)groupRef, (boolean)true)) {
            this.myHolder.newAnnotation(HighlightSeverity.WARNING, "Group reference is nested into the named group it refers to").create();
        }
    }

    public void visitComment(@NotNull PsiComment comment) {
        if (comment == null) {
            RegExpAnnotator.$$$reportNull$$$0(2);
        }
        if (comment.getText().startsWith("(?#") && !this.myLanguageHosts.supportsPerl5EmbeddedComments(comment)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, "Embedded comments are not supported in this regex dialect").create();
        }
    }

    @Override
    public void visitRegExpPyCondRef(RegExpPyCondRef condRef) {
        if (!this.myLanguageHosts.supportsPythonConditionalRefs(condRef)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, "Conditional references are not supported in this regex dialect").create();
        }
    }

    private static boolean isEmpty(RegExpBranch[] branches) {
        for (RegExpBranch branch : branches) {
            if (branch.getAtoms().length <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public void visitRegExpClosure(RegExpClosure closure) {
        if (closure.getAtom() instanceof RegExpSetOptions) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, "Dangling metacharacter").range((PsiElement)closure.getQuantifier()).create();
        }
    }

    @Override
    public void visitRegExpQuantifier(RegExpQuantifier quantifier) {
        if (quantifier.isCounted()) {
            String max;
            RegExpNumber minElement = quantifier.getMin();
            String min = minElement == null ? "" : minElement.getText();
            RegExpNumber maxElement = quantifier.getMax();
            String string = max = maxElement == null ? "" : maxElement.getText();
            if (!max.isEmpty() && max.equals(min)) {
                if ("1".equals(max)) {
                    this.myHolder.newAnnotation(HighlightSeverity.WEAK_WARNING, "Single repetition").withFix((IntentionAction)new SimplifyQuantifierAction(quantifier, null)).create();
                } else {
                    ASTNode node = quantifier.getNode();
                    if (node.findChildByType(RegExpTT.COMMA) != null) {
                        this.myHolder.newAnnotation(HighlightSeverity.WEAK_WARNING, "Fixed repetition range").withFix((IntentionAction)new SimplifyQuantifierAction(quantifier, "{" + max + "}")).create();
                    }
                }
            } else if (("0".equals(min) || min.isEmpty()) && "1".equals(max)) {
                this.myHolder.newAnnotation(HighlightSeverity.WEAK_WARNING, "Repetition range replaceable by '?'").withFix((IntentionAction)new SimplifyQuantifierAction(quantifier, "?")).create();
            } else if (("0".equals(min) || min.isEmpty()) && max.isEmpty()) {
                this.myHolder.newAnnotation(HighlightSeverity.WEAK_WARNING, "Repetition range replaceable by '*'").withFix((IntentionAction)new SimplifyQuantifierAction(quantifier, "*")).create();
            } else if ("1".equals(min) && max.isEmpty()) {
                this.myHolder.newAnnotation(HighlightSeverity.WEAK_WARNING, "Repetition range replaceable by '+'").withFix((IntentionAction)new SimplifyQuantifierAction(quantifier, "+")).create();
            }
            Number minValue = null;
            if (minElement != null && (minValue = this.myLanguageHosts.getQuantifierValue(minElement)) == null) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, "Repetition value too large").range((PsiElement)minElement).create();
            }
            Number maxValue = null;
            if (maxElement != null && (maxValue = this.myLanguageHosts.getQuantifierValue(maxElement)) == null) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, "Repetition value too large").range((PsiElement)maxElement).create();
            }
            if (minValue != null && maxValue != null && (minValue.longValue() > maxValue.longValue() || minValue.doubleValue() > maxValue.doubleValue())) {
                TextRange range2 = new TextRange(minElement.getTextOffset(), maxElement.getTextOffset() + maxElement.getTextLength());
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, "Illegal repetition range (min > max)").range(range2).create();
            }
        }
        if (quantifier.isPossessive() && !this.myLanguageHosts.supportsPossessiveQuantifiers(quantifier)) {
            ASTNode modifier = quantifier.getModifier();
            assert (modifier != null);
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, "Nested quantifier in regexp").range(modifier).create();
        }
    }

    @Override
    public void visitPosixBracketExpression(RegExpPosixBracketExpression posixBracketExpression) {
        ASTNode node;
        String className = posixBracketExpression.getClassName();
        if (!(POSIX_CHARACTER_CLASSES.contains(className) || "<".equals(className) || ">".equals(className) || (node = posixBracketExpression.getNode().findChildByType(RegExpTT.NAME)) == null)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, "Unknown POSIX character class").range(node).highlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL).create();
        }
    }

    private static void registerFix(Annotation a, IntentionAction action2) {
        if (a != null) {
            a.registerFix(action2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
        }
        objectArray2[1] = "org/intellij/lang/regexp/validation/RegExpAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitComment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class LookbehindVisitor
    extends RegExpRecursiveElementVisitor {
        private final RegExpLanguageHost.Lookbehind mySupport;
        private final AnnotationHolder myHolder;
        private int myLength = 0;
        private boolean myStop = false;

        LookbehindVisitor(RegExpLanguageHost.Lookbehind support, AnnotationHolder holder) {
            this.mySupport = support;
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpElement(RegExpElement element2) {
            if (this.myStop) {
                return;
            }
            super.visitRegExpElement(element2);
        }

        @Override
        public void visitRegExpChar(RegExpChar ch) {
            super.visitRegExpChar(ch);
            ++this.myLength;
        }

        @Override
        public void visitSimpleClass(RegExpSimpleClass simpleClass) {
            super.visitSimpleClass(simpleClass);
            ++this.myLength;
        }

        @Override
        public void visitRegExpClass(RegExpClass regExpClass) {
            super.visitRegExpClass(regExpClass);
            ++this.myLength;
        }

        @Override
        public void visitRegExpProperty(RegExpProperty property) {
            super.visitRegExpProperty(property);
            ++this.myLength;
        }

        @Override
        public void visitRegExpBackref(RegExpBackref backref) {
            super.visitRegExpBackref(backref);
            if (this.mySupport != RegExpLanguageHost.Lookbehind.FULL) {
                this.stopAndReportError(backref, "Group reference not allowed inside lookbehind");
            }
        }

        @Override
        public void visitRegExpPattern(RegExpPattern pattern) {
            RegExpBranch[] branches;
            if (this.mySupport != RegExpLanguageHost.Lookbehind.FIXED_LENGTH_ALTERNATION) {
                super.visitRegExpPattern(pattern);
                return;
            }
            int length = this.myLength;
            int branchLength = -1;
            for (RegExpBranch branch : branches = pattern.getBranches()) {
                this.myLength = 0;
                super.visitRegExpBranch(branch);
                if (branchLength == -1) {
                    branchLength = this.myLength;
                    continue;
                }
                if (branchLength == this.myLength) continue;
                this.stopAndReportError(pattern, "Alternation alternatives needs to have the same length inside lookbehind");
                return;
            }
            this.myLength = length;
        }

        @Override
        public void visitRegExpQuantifier(RegExpQuantifier quantifier) {
            super.visitRegExpQuantifier(quantifier);
            if (this.mySupport == RegExpLanguageHost.Lookbehind.FULL) {
                return;
            }
            if (quantifier.isCounted()) {
                RegExpNumber minElement = quantifier.getMin();
                RegExpNumber maxElement = quantifier.getMax();
                if (minElement != null && maxElement != null) {
                    try {
                        long min = Long.parseLong(minElement.getText());
                        long max = Long.parseLong(maxElement.getText());
                        if (min == max) {
                            this.myLength = (int)((long)this.myLength + min);
                            return;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (this.mySupport != RegExpLanguageHost.Lookbehind.FINITE_REPETITION) {
                    this.stopAndReportError(quantifier, "Unequal min and max in counted quantifier not allowed inside lookbehind");
                }
            } else {
                ASTNode token = quantifier.getToken();
                assert (token != null);
                String tokenText = token.getText();
                if ("?".equals(tokenText) && this.mySupport == RegExpLanguageHost.Lookbehind.FINITE_REPETITION) {
                    return;
                }
                this.stopAndReportError(quantifier, tokenText + " repetition not allowed inside lookbehind");
            }
        }

        @Override
        public void visitRegExpNamedGroupRef(RegExpNamedGroupRef groupRef) {
            super.visitRegExpNamedGroupRef(groupRef);
            if (this.mySupport != RegExpLanguageHost.Lookbehind.FULL) {
                this.stopAndReportError(groupRef, "Named group reference not allowed inside lookbehind");
            }
        }

        @Override
        public void visitRegExpPyCondRef(RegExpPyCondRef condRef) {
            super.visitRegExpPyCondRef(condRef);
            if (this.mySupport != RegExpLanguageHost.Lookbehind.FULL) {
                this.stopAndReportError(condRef, "Conditional group reference not allowed inside lookbehind");
            }
        }

        @Override
        public void visitPosixBracketExpression(RegExpPosixBracketExpression posixBracketExpression) {
            super.visitPosixBracketExpression(posixBracketExpression);
            ++this.myLength;
        }

        public void stopAndReportError(RegExpElement element2, @NotNull @Nls String message) {
            if (message == null) {
                LookbehindVisitor.$$$reportNull$$$0(0);
            }
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, message).range((PsiElement)element2).create();
            this.myStop = true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/intellij/lang/regexp/validation/RegExpAnnotator$LookbehindVisitor", "stopAndReportError"));
        }
    }
}

