/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspace.legacyBridge.facet;

import com.google.common.collect.HashBiMap;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManagerBase;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.impl.FacetModelBase;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.facet.impl.invalid.InvalidFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.workspace.api.FacetEntity;
import com.intellij.workspace.api.ImlModelEntitiesKt;
import com.intellij.workspace.legacyBridge.intellij.LegacyBridgeModule;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.facet.FacetState;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0010\b\u0010\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010J\u0014\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\b\u0010\u0013\u001a\u00020\u000eH\u0016J\u0017\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\u001b\u0010\u0017\u001a\u0004\u0018\u00010\u00072\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\bH\u0000\u00a2\u0006\u0002\b\u0019J\u001b\u0010\u001a\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u001bJ\u0019\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u0012\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u001dJ\u001e\u0010\u001e\u001a\u00020\u000e2\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0006J\u0015\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b J\u0014\u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\u0007J\u001c\u0010\"\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0007R$\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006%"}, d2={"Lcom/intellij/workspace/legacyBridge/facet/FacetModelViaWorkspaceModel;", "Lcom/intellij/facet/impl/FacetModelBase;", "legacyBridgeModule", "Lcom/intellij/workspace/legacyBridge/intellij/LegacyBridgeModule;", "(Lcom/intellij/workspace/legacyBridge/intellij/LegacyBridgeModule;)V", "entityToFacet", "Lcom/google/common/collect/HashBiMap;", "Lcom/intellij/workspace/api/FacetEntity;", "Lcom/intellij/facet/Facet;", "getEntityToFacet", "()Lcom/google/common/collect/HashBiMap;", "getLegacyBridgeModule", "()Lcom/intellij/workspace/legacyBridge/intellij/LegacyBridgeModule;", "checkConsistency", "", "facetEntities", "", "createFacet", "entity", "facetsChanged", "getAllFacets", "", "()[Lcom/intellij/facet/Facet;", "getEntity", "facet", "getEntity$intellij_platform_workspaceModel_ide", "getFacet", "getFacet$intellij_platform_workspaceModel_ide", "getOrCreateFacet", "getOrCreateFacet$intellij_platform_workspaceModel_ide", "populateFrom", "mapping", "populateFrom$intellij_platform_workspaceModel_ide", "removeEntity", "updateEntity", "oldEntity", "newEntity", "intellij.platform.workspaceModel.ide"})
public class FacetModelViaWorkspaceModel
extends FacetModelBase {
    @NotNull
    private final HashBiMap<FacetEntity, Facet<?>> entityToFacet;
    @NotNull
    private final LegacyBridgeModule legacyBridgeModule;

    @NotNull
    protected final HashBiMap<FacetEntity, Facet<?>> getEntityToFacet() {
        return this.entityToFacet;
    }

    @NotNull
    public Facet<?>[] getAllFacets() {
        Set set = (Set)this.entityToFacet.values();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"entityToFacet.values");
        Collection $this$toTypedArray$iv = set;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Facet[] facetArray = thisCollection$iv.toArray(new Facet[0]);
        if (facetArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return facetArray;
    }

    @NotNull
    public final Facet<?> getOrCreateFacet$intellij_platform_workspaceModel_ide(@NotNull FacetEntity entity) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        Map $this$getOrPut$iv = (Map)this.entityToFacet;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(entity);
        if (value$iv == null) {
            boolean bl = false;
            Facet<?> answer$iv = this.createFacet(entity);
            $this$getOrPut$iv.put(entity, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Intrinsics.checkExpressionValueIsNotNull(object, (String)"entityToFacet.getOrPut(e\u2026) { createFacet(entity) }");
        return (Facet)object;
    }

    @Nullable
    public final Facet<?> getFacet$intellij_platform_workspaceModel_ide(@NotNull FacetEntity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        return (Facet)this.entityToFacet.get((Object)entity);
    }

    @Nullable
    public final FacetEntity getEntity$intellij_platform_workspaceModel_ide(@NotNull Facet<?> facet) {
        Intrinsics.checkParameterIsNotNull(facet, (String)"facet");
        return (FacetEntity)this.entityToFacet.inverse().get(facet);
    }

    private final Facet<?> createFacet(FacetEntity entity) {
        Facet<?> underlyingFacet;
        Facet<?> facet;
        boolean bl;
        boolean bl2;
        FacetEntity facetEntity;
        FacetTypeRegistry registry = FacetTypeRegistry.getInstance();
        FacetType facetType = registry.findFacetType(entity.getFacetType());
        FacetEntity facetEntity2 = entity.getUnderlyingFacet();
        if (facetEntity2 != null) {
            facetEntity = facetEntity2;
            bl2 = false;
            bl = false;
            FacetEntity it = facetEntity;
            boolean bl3 = false;
            facet = this.getOrCreateFacet$intellij_platform_workspaceModel_ide(it);
        } else {
            facet = underlyingFacet = null;
        }
        if (facetType == null) {
            Element element2;
            facetEntity = new FacetState();
            Module module = this.legacyBridgeModule;
            bl2 = false;
            bl = false;
            FacetEntity $this$apply = facetEntity;
            boolean bl4 = false;
            $this$apply.setName(entity.getName());
            $this$apply.setFacetType(entity.getFacetType());
            FacetEntity facetEntity3 = $this$apply;
            String string = entity.getConfigurationXmlTag();
            if (string != null) {
                String string2 = string;
                FacetEntity facetEntity4 = facetEntity3;
                boolean bl5 = false;
                boolean bl6 = false;
                String it = string2;
                boolean bl7 = false;
                Element element3 = JDOMUtil.load((CharSequence)it);
                facetEntity3 = facetEntity4;
                element2 = element3;
            } else {
                element2 = null;
            }
            facetEntity3.setConfiguration(element2);
            FacetEntity facetEntity5 = facetEntity;
            InvalidFacet invalidFacet = FacetManagerBase.createInvalidFacet(module, (FacetState)facetEntity5, underlyingFacet, ProjectBundle.message((String)"error.message.unknown.facet.type.0", (Object[])new Object[]{entity.getFacetType()}), true, true);
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)invalidFacet), (String)"FacetManagerBase.createI\u2026y.facetType), true, true)");
            return invalidFacet;
        }
        FacetConfiguration configuration = facetType.createDefaultConfiguration();
        String configurationXmlTag = entity.getConfigurationXmlTag();
        if (configurationXmlTag != null) {
            FacetUtil.loadFacetConfiguration(configuration, JDOMUtil.load((CharSequence)configurationXmlTag));
        }
        Facet facet2 = facetType.createFacet((Module)this.legacyBridgeModule, entity.getName(), configuration, underlyingFacet);
        Intrinsics.checkExpressionValueIsNotNull((Object)facet2, (String)"facetType.createFacet(le\u2026uration, underlyingFacet)");
        return facet2;
    }

    public final void populateFrom(@NotNull HashBiMap<FacetEntity, Facet<?>> mapping2) {
        Intrinsics.checkParameterIsNotNull(mapping2, (String)"mapping");
        this.entityToFacet.putAll((Map)mapping2);
    }

    public final void populateFrom$intellij_platform_workspaceModel_ide(@NotNull FacetModelViaWorkspaceModel mapping2) {
        Intrinsics.checkParameterIsNotNull((Object)mapping2, (String)"mapping");
        this.entityToFacet.putAll((Map)mapping2.entityToFacet);
    }

    @Nullable
    public final Facet<?> removeEntity(@NotNull FacetEntity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        return (Facet)this.entityToFacet.remove((Object)entity);
    }

    @Nullable
    public final Facet<?> updateEntity(@NotNull FacetEntity oldEntity, @NotNull FacetEntity newEntity2) {
        Intrinsics.checkParameterIsNotNull((Object)oldEntity, (String)"oldEntity");
        Intrinsics.checkParameterIsNotNull((Object)newEntity2, (String)"newEntity");
        Facet oldFacet = (Facet)this.entityToFacet.remove((Object)oldEntity);
        if (oldFacet != null) {
            ((Map)this.entityToFacet).put(newEntity2, oldFacet);
        }
        return (Facet)this.entityToFacet.get((Object)newEntity2);
    }

    @Override
    public void facetsChanged() {
        super.facetsChanged();
    }

    public final void checkConsistency(@NotNull List<? extends FacetEntity> facetEntities) {
        Intrinsics.checkParameterIsNotNull(facetEntities, (String)"facetEntities");
        Set facetEntitiesSet = CollectionsKt.toSet((Iterable)facetEntities);
        for (FacetEntity facetEntity : facetEntities) {
            FacetEntity entityFromMapping;
            Set facetsFromStorage;
            Facet facet = (Facet)this.entityToFacet.get((Object)facetEntity);
            if (facet == null) {
                throw (Throwable)new IllegalStateException("No facet registered for " + facetEntity + " (name = " + facetEntity.getName() + ')');
            }
            if (Intrinsics.areEqual((Object)facet.getName(), (Object)facetEntity.getName()) ^ true) {
                throw (Throwable)new IllegalStateException("Different name");
            }
            Object object = this.entityToFacet.inverse().get((Object)facet);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            if (!(Intrinsics.areEqual((Object)(facetsFromStorage = SequencesKt.toSet(ImlModelEntitiesKt.getFacets((entityFromMapping = (FacetEntity)object).getModule()))), (Object)facetEntitiesSet) ^ true)) continue;
            throw (Throwable)new IllegalStateException("Different set of facets from " + facetEntity + " storage: expected " + facetEntitiesSet + " but was " + facetsFromStorage);
        }
        Set set = this.entityToFacet.keySet();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"entityToFacet.keys");
        FacetEntity facetEntity = (FacetEntity)CollectionsKt.firstOrNull((Iterable)SetsKt.minus((Set)set, (Iterable)facetEntities));
        if (facetEntity != null) {
            throw (Throwable)new IllegalStateException("Stale entity " + facetEntity + " (name = " + facetEntity.getName() + ") in the mapping");
        }
    }

    @NotNull
    protected final LegacyBridgeModule getLegacyBridgeModule() {
        return this.legacyBridgeModule;
    }

    public FacetModelViaWorkspaceModel(@NotNull LegacyBridgeModule legacyBridgeModule) {
        Intrinsics.checkParameterIsNotNull((Object)legacyBridgeModule, (String)"legacyBridgeModule");
        this.legacyBridgeModule = legacyBridgeModule;
        HashBiMap hashBiMap = HashBiMap.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)hashBiMap, (String)"HashBiMap.create<FacetEntity, Facet<*>>()");
        this.entityToFacet = hashBiMap;
    }
}

