/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.snapshot;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.vfs.newvfs.persistent.FlushingDaemon;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.hash.ContentHashEnumerator;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.IOUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class IndexedHashesSupport {
    private static final Logger LOG = Logger.getInstance(IndexedHashesSupport.class);
    private static final MessageDigest CONTENT_HASH_WITH_FILE_TYPE_DIGEST = DigestUtil.sha1();
    private static volatile ContentHashEnumerator ourTextContentHashes;

    public static int getVersion() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initContentHashesEnumerator() throws IOException {
        if (ourTextContentHashes != null) {
            return;
        }
        Class<IndexedHashesSupport> clazz = IndexedHashesSupport.class;
        synchronized (IndexedHashesSupport.class) {
            if (ourTextContentHashes != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            File hashEnumeratorFile = new File(IndexInfrastructure.getPersistentIndexRoot(), "textContentHashes");
            try {
                ContentHashEnumerator hashEnumerator = new ContentHashEnumerator(hashEnumeratorFile.toPath());
                FlushingDaemon.everyFiveSeconds(IndexedHashesSupport::flushContentHashes);
                ShutDownTracker.getInstance().registerShutdownTask(IndexedHashesSupport::flushContentHashes);
                ourTextContentHashes = hashEnumerator;
            }
            catch (IOException ex) {
                IOUtil.deleteAllFilesStartingWith((File)hashEnumeratorFile);
                throw ex;
            }
            return;
        }
    }

    public static void flushContentHashes() {
        if (ourTextContentHashes != null && ourTextContentHashes.isDirty()) {
            ourTextContentHashes.force();
        }
    }

    static int enumerateHash(byte @NotNull [] digest) throws IOException {
        if (digest == null) {
            IndexedHashesSupport.$$$reportNull$$$0(0);
        }
        return ourTextContentHashes.enumerate(digest);
    }

    public static void initIndexedHash(@NotNull FileContentImpl content2) {
        if (content2 == null) {
            IndexedHashesSupport.$$$reportNull$$$0(1);
        }
        boolean binary = content2.getFileTypeWithoutSubstitution().isBinary();
        byte[] fileContentHash = IndexedHashesSupport.calculateIndexedHashForFileContent(content2, binary);
        byte[] documentHash = binary ? null : IndexedHashesSupport.calculateIndexedHashForDocument(content2);
        content2.setHashes(fileContentHash, documentHash != null ? documentHash : fileContentHash);
    }

    public static byte @NotNull [] getOrInitIndexedHash(@NotNull FileContentImpl content2, boolean fromDocument) {
        byte[] hash2;
        if (content2 == null) {
            IndexedHashesSupport.$$$reportNull$$$0(2);
        }
        if ((hash2 = content2.getHash(fromDocument)) == null) {
            IndexedHashesSupport.initIndexedHash(content2);
            hash2 = content2.getHash(fromDocument);
            LOG.assertTrue(hash2 != null);
        }
        if (hash2 == null) {
            IndexedHashesSupport.$$$reportNull$$$0(3);
        }
        return hash2;
    }

    private static byte @NotNull [] calculateIndexedHashForFileContent(@NotNull FileContentImpl content2, boolean binary) {
        if (content2 == null) {
            IndexedHashesSupport.$$$reportNull$$$0(4);
        }
        byte[] contentHash = null;
        if (content2.isPhysicalContent()) {
            contentHash = ((PersistentFSImpl)PersistentFS.getInstance()).getContentHashIfStored(content2.getFile());
        }
        if (contentHash == null) {
            contentHash = IndexedHashesSupport.calculateContentHash((FileContent)content2);
        }
        return IndexedHashesSupport.mergeIndexedHash(contentHash, binary ? null : content2.getCharset());
    }

    private static byte[] calculateContentHash(@NotNull FileContent content2) {
        if (content2 == null) {
            IndexedHashesSupport.$$$reportNull$$$0(5);
        }
        return DigestUtil.calculateContentHash((MessageDigest)CONTENT_HASH_WITH_FILE_TYPE_DIGEST, (byte[])content2.getContent());
    }

    private static byte @Nullable [] calculateIndexedHashForDocument(@NotNull FileContentImpl content2) {
        PsiFile file2;
        PsiDocumentManager psiDocumentManager;
        Document document;
        if (content2 == null) {
            IndexedHashesSupport.$$$reportNull$$$0(6);
        }
        if ((document = FileDocumentManager.getInstance().getCachedDocument(content2.getFile())) != null && (psiDocumentManager = PsiDocumentManager.getInstance((Project)content2.getProject())).isUncommited(document) && (file2 = psiDocumentManager.getCachedPsiFile(document)) != null) {
            Charset charset = content2.getCharset();
            return IndexedHashesSupport.mergeIndexedHash(DigestUtil.calculateContentHash((MessageDigest)CONTENT_HASH_WITH_FILE_TYPE_DIGEST, (byte[])file2.getText().getBytes(charset)), charset);
        }
        return null;
    }

    private static byte @NotNull [] mergeIndexedHash(byte @NotNull [] binaryContentHash, @Nullable Charset charsetOrNullForBinary) {
        if (binaryContentHash == null) {
            IndexedHashesSupport.$$$reportNull$$$0(7);
        }
        byte[] charsetBytes = charsetOrNullForBinary != null ? charsetOrNullForBinary.name().getBytes(StandardCharsets.UTF_8) : ArrayUtilRt.EMPTY_BYTE_ARRAY;
        byte[] byArray = DigestUtil.calculateMergedHash((MessageDigest)CONTENT_HASH_WITH_FILE_TYPE_DIGEST, (byte[][])new byte[][]{binaryContentHash, charsetBytes});
        if (byArray == null) {
            IndexedHashesSupport.$$$reportNull$$$0(8);
        }
        return byArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "digest";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/snapshot/IndexedHashesSupport";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryContentHash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/snapshot/IndexedHashesSupport";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrInitIndexedHash";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeIndexedHash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "enumerateHash";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "initIndexedHash";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOrInitIndexedHash";
                break;
            }
            case 3: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calculateIndexedHashForFileContent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calculateContentHash";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "calculateIndexedHashForDocument";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "mergeIndexedHash";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

