/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.roots;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.util.indexing.roots.IndexableFilesIterationMethods;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0007\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J,\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J$\u0010\u0014\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lcom/intellij/util/indexing/roots/IndexableFilesIterationMethods;", "", "()V", "followSymlinks", "", "getFollowSymlinks", "()Z", "iterateAllRoots", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileFilter", "Lcom/intellij/openapi/vfs/VirtualFileFilter;", "contentIterator", "Lcom/intellij/openapi/roots/ContentIterator;", "visitedFileSet", "Lcom/intellij/util/containers/ConcurrentBitSet;", "iterateNonExcludedRoots", "project", "Lcom/intellij/openapi/project/Project;", "iterateNonProjectRoots", "intellij.platform.lang.impl"})
public final class IndexableFilesIterationMethods {
    public static final IndexableFilesIterationMethods INSTANCE;

    private final boolean getFollowSymlinks() {
        return Registry.is((String)"indexer.follows.symlinks");
    }

    public final boolean iterateNonExcludedRoots(@NotNull Project project, @NotNull Iterable<? extends VirtualFile> roots, @NotNull ContentIterator contentIterator, @NotNull ConcurrentBitSet visitedFileSet) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(roots, (String)"roots");
        Intrinsics.checkParameterIsNotNull((Object)contentIterator, (String)"contentIterator");
        Intrinsics.checkParameterIsNotNull((Object)visitedFileSet, (String)"visitedFileSet");
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)projectFileIndex, (String)"ProjectFileIndex.getInstance(project)");
        ProjectFileIndex projectFileIndex2 = projectFileIndex;
        VirtualFileFilter acceptFilter2 = new VirtualFileFilter(projectFileIndex2){
            final /* synthetic */ ProjectFileIndex $projectFileIndex;

            public final boolean accept(VirtualFile file2) {
                boolean $i$f$runReadAction = false;
                return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<T>(this, file2){
                    final /* synthetic */ iterateNonExcludedRoots.acceptFilter.1 this$0;
                    final /* synthetic */ VirtualFile $file$inlined;
                    {
                        this.this$0 = var1_1;
                        this.$file$inlined = virtualFile;
                    }

                    public final T compute() {
                        boolean bl = false;
                        return (T)Boolean.valueOf(!this.this$0.$projectFileIndex.isExcluded(this.$file$inlined));
                    }
                });
            }
            {
                this.$projectFileIndex = projectFileIndex;
            }
        };
        return this.iterateAllRoots(roots, acceptFilter2, contentIterator, visitedFileSet);
    }

    public final boolean iterateNonProjectRoots(@NotNull Iterable<? extends VirtualFile> roots, @NotNull ContentIterator contentIterator, @NotNull ConcurrentBitSet visitedFileSet) {
        Intrinsics.checkParameterIsNotNull(roots, (String)"roots");
        Intrinsics.checkParameterIsNotNull((Object)contentIterator, (String)"contentIterator");
        Intrinsics.checkParameterIsNotNull((Object)visitedFileSet, (String)"visitedFileSet");
        VirtualFileFilter virtualFileFilter = VirtualFileFilter.ALL;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileFilter, (String)"VirtualFileFilter.ALL");
        return this.iterateAllRoots(roots, virtualFileFilter, contentIterator, visitedFileSet);
    }

    private final boolean iterateAllRoots(Iterable<? extends VirtualFile> roots, VirtualFileFilter fileFilter, ContentIterator contentIterator, ConcurrentBitSet visitedFileSet) {
        boolean bl;
        block5: {
            VirtualFileFilter virtualFileFilter = fileFilter.and(new VirtualFileFilter(visitedFileSet){
                final /* synthetic */ ConcurrentBitSet $visitedFileSet;

                public final boolean accept(VirtualFile it) {
                    return it instanceof VirtualFileWithId && ((VirtualFileWithId)it).getId() > 0 && !this.$visitedFileSet.set(((VirtualFileWithId)it).getId());
                }
                {
                    this.$visitedFileSet = concurrentBitSet;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileFilter, (String)"fileFilter\n      .and { \u2026sitedFileSet.set(it.id) }");
            VirtualFileFilter finalFilter2 = virtualFileFilter;
            Iterable<? extends VirtualFile> $this$all$iv = roots;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator<? extends VirtualFile> iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    VirtualFileVisitor.Option[] optionArray;
                    VirtualFile element$iv;
                    VirtualFile root = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (INSTANCE.getFollowSymlinks()) {
                        optionArray = new VirtualFileVisitor.Option[]{};
                    } else {
                        VirtualFileVisitor.Option[] optionArray2 = new VirtualFileVisitor.Option[1];
                        optionArray = optionArray2;
                        VirtualFileVisitor.Option option2 = VirtualFileVisitor.NO_FOLLOW_SYMLINKS;
                        Intrinsics.checkExpressionValueIsNotNull((Object)option2, (String)"VirtualFileVisitor.NO_FOLLOW_SYMLINKS");
                        optionArray2[0] = option2;
                    }
                    VirtualFileVisitor.Option[] options = optionArray;
                    if (VfsUtilCore.iterateChildrenRecursively((VirtualFile)root, (VirtualFileFilter)finalFilter2, (ContentIterator)contentIterator, (VirtualFileVisitor.Option[])Arrays.copyOf(options, options.length))) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    private IndexableFilesIterationMethods() {
    }

    static {
        IndexableFilesIterationMethods indexableFilesIterationMethods;
        INSTANCE = indexableFilesIterationMethods = new IndexableFilesIterationMethods();
    }
}

