/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.tree.ui.Control;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ClassicPainter
implements Control.Painter {
    private static final int GAP = 2;
    private final Boolean myPaintLines;
    private final Integer myLeftIndent;
    private final Integer myRightIndent;
    private final Integer myLeafIndent;

    ClassicPainter(@Nullable Boolean paintLines, @Nullable Integer leftIndent, @Nullable Integer rightIndent, @Nullable Integer leafIndent) {
        this.myPaintLines = paintLines;
        this.myLeftIndent = leftIndent;
        this.myRightIndent = rightIndent;
        this.myLeafIndent = leafIndent;
    }

    @Override
    public int getRendererOffset(@NotNull Control control, int depth, boolean leaf) {
        if (control == null) {
            ClassicPainter.$$$reportNull$$$0(0);
        }
        if (depth < 0) {
            return -1;
        }
        if (depth == 0) {
            return 0;
        }
        int controlWidth = control.getWidth();
        int left = this.getLeftIndent(controlWidth / 2);
        int right = this.getRightIndent();
        int offset = this.getLeafIndent(leaf);
        if (offset < 0) {
            offset = Math.max(controlWidth + left - controlWidth / 2 + JBUIScale.scale((int)2), left + right);
        }
        return depth > 1 ? (depth - 1) * (left + right) + offset : offset;
    }

    @Override
    public int getControlOffset(@NotNull Control control, int depth, boolean leaf) {
        if (control == null) {
            ClassicPainter.$$$reportNull$$$0(1);
        }
        if (depth <= 0 || leaf) {
            return -1;
        }
        int controlWidth = control.getWidth();
        int left = this.getLeftIndent(controlWidth / 2);
        int offset = left - controlWidth / 2;
        return depth > 1 ? (depth - 1) * (left + this.getRightIndent()) + offset : offset;
    }

    @Override
    public void paint(@NotNull Component c, @NotNull Graphics g, int x, int y, int width, int height, @NotNull Control control, int depth, boolean leaf, boolean expanded, boolean selected2) {
        int controlX;
        if (c == null) {
            ClassicPainter.$$$reportNull$$$0(2);
        }
        if (g == null) {
            ClassicPainter.$$$reportNull$$$0(3);
        }
        if (control == null) {
            ClassicPainter.$$$reportNull$$$0(4);
        }
        if (depth <= 0) {
            return;
        }
        boolean paintLines = this.getPaintLines();
        if (!paintLines && leaf) {
            return;
        }
        int controlWidth = control.getWidth();
        int left = this.getLeftIndent(controlWidth / 2);
        int indent = left + this.getRightIndent();
        int n = controlX = !leaf && depth > 1 ? (depth - 1) * indent + x : (x += left - controlWidth / 2);
        if (paintLines && (depth != 1 || !leaf && expanded)) {
            int offset;
            g.setColor((Color)LINE_COLOR);
            while (--depth > 0) {
                ClassicPainter.paintLine(g, x, y, controlWidth, height);
                x += indent;
            }
            if (!leaf && expanded && (offset = (height - control.getHeight()) / 2) > 0) {
                ClassicPainter.paintLine(g, x, y + height - offset, controlWidth, offset);
            }
        }
        if (leaf) {
            return;
        }
        control.paint(c, g, controlX, y, controlWidth, height, expanded, selected2);
    }

    static boolean getPaintLines(@Nullable Boolean paintLines) {
        if (paintLines != null) {
            return paintLines;
        }
        if (UIManager.getBoolean("Tree.paintLines")) {
            return true;
        }
        UISettings settings = UISettings.getInstanceOrNull();
        return settings != null && settings.getShowTreeIndentGuides();
    }

    private boolean getPaintLines() {
        return ClassicPainter.getPaintLines(this.myPaintLines);
    }

    private int getLeftIndent(int min) {
        return Math.max(min, this.myLeftIndent != null ? JBUIScale.scale((int)this.myLeftIndent) : UIManager.getInt("Tree.leftChildIndent"));
    }

    private int getRightIndent() {
        int old;
        int n = old = this.myRightIndent == null ? Registry.intValue((String)"ide.ui.tree.indent", (int)-1) : -1;
        if (old >= 0) {
            return JBUIScale.scale((int)old);
        }
        return Math.max(0, this.myRightIndent != null ? JBUIScale.scale((int)this.myRightIndent) : UIManager.getInt("Tree.rightChildIndent"));
    }

    private int getLeafIndent(boolean leaf) {
        return !leaf || this.myLeafIndent == null ? -1 : JBUIScale.scale((int)this.myLeafIndent);
    }

    private static void paintLine(@NotNull Graphics g, int x, int y, int width, int height) {
        if (g == null) {
            ClassicPainter.$$$reportNull$$$0(5);
        }
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            double dx = (double)x + (double)width / 2.0 - PaintUtil.devPixel((Graphics2D)g2d);
            LinePainter2D.paint((Graphics2D)g2d, (double)dx, (double)y, (double)dx, (double)(y + height), (LinePainter2D.StrokeType)LinePainter2D.StrokeType.CENTERED, (double)1.0, (Object)RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g.drawLine(x += width / 2, y, x, y + height);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "control";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/tree/ui/ClassicPainter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getRendererOffset";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getControlOffset";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "paint";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "paintLine";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

