/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.RemoteServerConfigurable;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.impl.configuration.DelegatingRemoteServerConfigurable;
import com.intellij.remoteServer.impl.configuration.RemoteServerConnectionTester;
import com.intellij.remoteServer.impl.configuration.RemoteServerImpl;
import com.intellij.remoteServer.util.CloudDataLoader;
import com.intellij.remoteServer.util.DelayedRunner;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleRemoteServerConfigurable
extends NamedConfigurable<RemoteServer<?>> {
    private final RemoteServerConfigurable myConfigurable;
    private final RemoteServer<?> myServer;
    private String myServerName;
    private boolean myNew;
    private JPanel myMainPanel;
    private JPanel mySettingsPanel;
    private JBLabel myConnectionStatusLabel;
    private final DelayedRunner myRunner;
    private ConnectionTester myConnectionTester;
    private final RemoteServer<?> myInnerServer;
    private boolean myInnerApplied;
    private boolean myAppliedButNeedsCheck;
    private boolean myConnected;
    private CloudDataLoader myDataLoader = CloudDataLoader.NULL;

    public <C extends ServerConfiguration> SingleRemoteServerConfigurable(RemoteServer<C> server, Runnable treeUpdater, boolean isNew) {
        super(true, treeUpdater);
        this.myServer = server;
        this.myNew = isNew;
        this.$$$setupUI$$$();
        this.myServerName = this.myServer.getName();
        ServerConfiguration configuration = server.getConfiguration();
        ServerConfiguration innerConfiguration = (ServerConfiguration)XmlSerializerUtil.createCopy((Object)configuration);
        this.myInnerServer = new RemoteServerImpl<ServerConfiguration>("<temp inner server>", server.getType(), innerConfiguration);
        this.myInnerApplied = false;
        this.myAppliedButNeedsCheck = isNew || server.getType().canAutoDetectConfiguration();
        this.myConfigurable = SingleRemoteServerConfigurable.createConfigurable(server, innerConfiguration);
        this.myConnected = false;
        this.myRunner = new DelayedRunner(this.myMainPanel){

            @Override
            protected boolean wasChanged() {
                boolean result2;
                if (!SingleRemoteServerConfigurable.this.myConfigurable.canCheckConnection()) {
                    return false;
                }
                boolean modified = SingleRemoteServerConfigurable.this.myConfigurable.isModified();
                boolean bl = result2 = modified || SingleRemoteServerConfigurable.this.myAppliedButNeedsCheck;
                if (result2) {
                    SingleRemoteServerConfigurable.this.myAppliedButNeedsCheck = false;
                    SingleRemoteServerConfigurable.this.setConnectionStatus(false, false, "");
                    SingleRemoteServerConfigurable.this.myConnectionTester = null;
                    if (modified) {
                        try {
                            SingleRemoteServerConfigurable.this.myConfigurable.apply();
                            SingleRemoteServerConfigurable.this.myInnerApplied = true;
                        }
                        catch (ConfigurationException e) {
                            SingleRemoteServerConfigurable.this.setConnectionStatus(true, false, e.getMessage());
                        }
                    }
                }
                return result2;
            }

            @Override
            protected void run() {
                SingleRemoteServerConfigurable.this.setConnectionStatus(false, false, "Connecting...");
                SingleRemoteServerConfigurable.this.myConnectionTester = new ConnectionTester();
                SingleRemoteServerConfigurable.this.myConnectionTester.testConnection();
            }
        };
    }

    private static <C extends ServerConfiguration> RemoteServerConfigurable createConfigurable(RemoteServer<C> server, C configuration) {
        try {
            return server.getType().createServerConfigurable(configuration);
        }
        catch (UnsupportedOperationException e) {
            return new DelegatingRemoteServerConfigurable(server.getType().createConfigurable(configuration));
        }
    }

    private void setConnectionStatus(boolean error, boolean connected, String text2) {
        boolean changed2 = this.myConnected != connected;
        this.myConnected = connected;
        this.setConnectionStatusText(error, text2);
        if (changed2) {
            this.notifyDataLoader();
        }
    }

    protected void setConnectionStatusText(boolean error, String text2) {
        this.myConnectionStatusLabel.setText(UIUtil.toHtml((String)text2));
        this.myConnectionStatusLabel.setVisible(StringUtil.isNotEmpty((String)text2));
    }

    public void setDataLoader(CloudDataLoader dataLoader) {
        this.myDataLoader = dataLoader;
        this.notifyDataLoader();
    }

    private void notifyDataLoader() {
        if (this.myConnected) {
            this.myDataLoader.loadCloudData();
        } else {
            this.myDataLoader.clearCloudData();
        }
    }

    public RemoteServer<?> getEditableObject() {
        return this.myServer;
    }

    public String getBannerSlogan() {
        return this.myServer.getName();
    }

    public JComponent createOptionsPanel() {
        this.mySettingsPanel.add("Center", this.myConfigurable.createComponent());
        return this.myMainPanel;
    }

    @Nls
    public String getDisplayName() {
        return this.myServerName;
    }

    @Nullable
    public String getHelpTopic() {
        return this.myServer.getType().getHelpTopic();
    }

    public void setDisplayName(String name) {
        this.myServerName = name;
    }

    public boolean isModified() {
        return this.myNew || this.myConfigurable.isModified() || this.myInnerApplied || !this.myServerName.equals(this.myServer.getName());
    }

    public void apply() throws ConfigurationException {
        boolean uncheckedApply = this.myConfigurable.isModified();
        this.myConfigurable.apply();
        XmlSerializerUtil.copyBean((Object)this.myInnerServer.getConfiguration(), (Object)this.myServer.getConfiguration());
        this.myServer.setName(this.myServerName);
        this.myNew = false;
        this.myAppliedButNeedsCheck = uncheckedApply;
        this.myInnerApplied = false;
    }

    public void reset() {
        this.myConfigurable.reset();
    }

    public void disposeUIResources() {
        this.myConfigurable.disposeUIResources();
        Disposer.dispose((Disposable)this.myRunner);
    }

    @Nullable
    public Icon getIcon(boolean expanded) {
        return this.myServer.getType().getIcon();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 10, 0, 10), -1, -1, false, false));
        this.mySettingsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myConnectionStatusLabel = jBLabel = new JBLabel();
        jBLabel.setText(" ");
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 0, 1, 6, 0, new Dimension(10, -1), new Dimension(10, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private class ConnectionTester {
        private final RemoteServerConnectionTester myTester;

        ConnectionTester() {
            this.myTester = new RemoteServerConnectionTester(SingleRemoteServerConfigurable.this.myInnerServer);
        }

        public void testConnection() {
            this.myTester.testConnection(this::testFinished);
        }

        public void testFinished(boolean connected, @NotNull String connectionStatus) {
            if (connectionStatus == null) {
                ConnectionTester.$$$reportNull$$$0(0);
            }
            UIUtil.invokeLaterIfNeeded(() -> {
                if (SingleRemoteServerConfigurable.this.myConnectionTester == this) {
                    SingleRemoteServerConfigurable.this.setConnectionStatus(!connected, connected, connected ? "Connection successful" : "Cannot connect: " + connectionStatus);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionStatus", "com/intellij/remoteServer/impl/configuration/SingleRemoteServerConfigurable$ConnectionTester", "testFinished"));
        }
    }
}

