/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.PresentableId;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SshConfigCredentialsHolder {
    private static final String SSH_CREDENTIALS_ID = "SSH_CREDENTIALS_ID";
    private static final String SSH_CONFIG_NAME = "SSH_CONFIG_NAME";
    private static final String SSH_CONFIG_ID = "SSH_CONFIG_ID";
    public static final String SSH_CONFIG_PREFIX = "sshConfig://";
    @NotNull
    private String myCredentialsId;
    @Nullable
    private PresentableId mySshId;

    public SshConfigCredentialsHolder() {
        this(null);
    }

    public SshConfigCredentialsHolder(@Nullable PresentableId presentableId) {
        this.mySshId = presentableId;
        this.myCredentialsId = this.constructCredentialsId();
    }

    @NotNull
    public String getCredentialsId() {
        String string = this.myCredentialsId;
        if (string == null) {
            SshConfigCredentialsHolder.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public PresentableId getSshId() {
        return this.mySshId;
    }

    public void setSshId(@Nullable PresentableId sshId) {
        this.mySshId = sshId;
    }

    public void save(@NotNull Element element2) {
        if (element2 == null) {
            SshConfigCredentialsHolder.$$$reportNull$$$0(1);
        }
        if (this.mySshId != null) {
            if (this.mySshId.getId() != null) {
                element2.setAttribute(SSH_CONFIG_ID, this.mySshId.getId());
            }
            if (this.mySshId.getName() != null) {
                element2.setAttribute(SSH_CONFIG_NAME, this.mySshId.getName());
            }
        }
        element2.setAttribute(SSH_CREDENTIALS_ID, StringUtil.notNullize((String)this.myCredentialsId));
    }

    public void load(@NotNull Element element2) {
        if (element2 == null) {
            SshConfigCredentialsHolder.$$$reportNull$$$0(2);
        }
        this.mySshId = PresentableId.createId(element2.getAttributeValue(SSH_CONFIG_ID), element2.getAttributeValue(SSH_CONFIG_NAME));
        String credentialsId = element2.getAttributeValue(SSH_CREDENTIALS_ID);
        this.myCredentialsId = credentialsId == null ? this.constructCredentialsId() : credentialsId;
    }

    public void cleanConfigData() {
        this.mySshId = null;
        this.myCredentialsId = this.constructCredentialsId();
    }

    @NotNull
    private String constructCredentialsId() {
        String string = SSH_CONFIG_PREFIX + (this.mySshId == null || this.mySshId.getName() == null ? "<unknown>" : this.mySshId.getName());
        if (string == null) {
            SshConfigCredentialsHolder.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void copyFrom(SshConfigCredentialsHolder credentials) {
        this.myCredentialsId = credentials.myCredentialsId;
        this.mySshId = credentials.mySshId == null ? null : credentials.mySshId.clone();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remote/SshConfigCredentialsHolder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCredentialsId";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remote/SshConfigCredentialsHolder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "constructCredentialsId";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

