/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util.proximity;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.Weigher;
import com.intellij.psi.WeighingComparable;
import com.intellij.psi.WeighingService;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.psi.util.ProximityLocation;
import com.intellij.psi.util.proximity.ProximityStatistician;
import com.intellij.psi.util.proximity.ProximityWeigher;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.FactoryMap;
import java.util.Comparator;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class PsiProximityComparator
implements Comparator<Object> {
    public static final Key<ProximityStatistician> STATISTICS_KEY = Key.create((String)"proximity");
    public static final Key<ProximityWeigher> WEIGHER_KEY = Key.create((String)"proximity");
    private static final Key<Module> MODULE_BY_LOCATION = Key.create((String)"ModuleByLocation");
    private final PsiElement myContext;
    private final Map<PsiElement, WeighingComparable<PsiElement, ProximityLocation>> myProximities;
    private final Module myContextModule;

    public PsiProximityComparator(@Nullable PsiElement context) {
        this.myContext = context;
        this.myContextModule = context == null ? null : ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        this.myProximities = FactoryMap.create(key -> PsiProximityComparator.getProximity(key, this.myContext));
    }

    @Override
    public int compare(Object o1, Object o2) {
        PsiElement element2;
        PsiElement element1 = o1 instanceof PsiElement ? (PsiElement)o1 : null;
        PsiElement psiElement = element2 = o2 instanceof PsiElement ? (PsiElement)o2 : null;
        if (element1 == null) {
            return element2 == null ? 0 : 1;
        }
        if (element2 == null) {
            return -1;
        }
        if (this.myContext != null && this.myContextModule != null) {
            int count2;
            StatisticsManager statisticsManager;
            int count1;
            ProximityLocation location2 = new ProximityLocation(this.myContext, this.myContextModule);
            StatisticsInfo info1 = StatisticsManager.serialize(STATISTICS_KEY, (Object)element1, (Object)location2);
            StatisticsInfo info2 = StatisticsManager.serialize(STATISTICS_KEY, (Object)element2, (Object)location2);
            if (info1 != null && info2 != null && (count1 = (statisticsManager = StatisticsManager.getInstance()).getLastUseRecency(info1)) != (count2 = statisticsManager.getLastUseRecency(info2))) {
                return count1 < count2 ? -1 : 1;
            }
        }
        WeighingComparable<PsiElement, ProximityLocation> proximity1 = this.myProximities.get(element1);
        WeighingComparable<PsiElement, ProximityLocation> proximity2 = this.myProximities.get(element2);
        if (proximity1 == null || proximity2 == null) {
            return 0;
        }
        return -proximity1.compareTo(proximity2);
    }

    @Nullable
    public static WeighingComparable<PsiElement, ProximityLocation> getProximity(PsiElement element2, PsiElement context) {
        if (element2 == null) {
            return null;
        }
        Module contextModule = context != null ? ModuleUtilCore.findModuleForPsiElement((PsiElement)context) : null;
        return WeighingService.weigh(WEIGHER_KEY, (Object)element2, (Object)new ProximityLocation(context, contextModule));
    }

    @Nullable
    public static WeighingComparable<PsiElement, ProximityLocation> getProximity(Computable<? extends PsiElement> elementComputable, PsiElement context, ProcessingContext processingContext) {
        PsiElement element2 = (PsiElement)elementComputable.compute();
        if (element2 == null || context == null) {
            return null;
        }
        Module contextModule = (Module)processingContext.get(MODULE_BY_LOCATION);
        if (contextModule == null) {
            contextModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
            processingContext.put(MODULE_BY_LOCATION, (Object)contextModule);
        }
        return new WeighingComparable(elementComputable, (Object)new ProximityLocation(context, contextModule, processingContext), WeighingService.getWeighers(WEIGHER_KEY).toArray(new Weigher[0]));
    }
}

