/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.StubForwardIndexExternalizer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CompressionUtil;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.PersistentHashMapValueStorage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class SerializedStubTreeDataExternalizer
implements DataExternalizer<SerializedStubTree> {
    private final boolean myIncludeInputs;
    @NotNull
    private final SerializationManagerEx mySerializationManager;
    private final StubForwardIndexExternalizer<?> myStubIndexesExternalizer;

    public SerializedStubTreeDataExternalizer(boolean inputs, @NotNull SerializationManagerEx manager, @NotNull StubForwardIndexExternalizer<?> externalizer) {
        if (manager == null) {
            SerializedStubTreeDataExternalizer.$$$reportNull$$$0(0);
        }
        if (externalizer == null) {
            SerializedStubTreeDataExternalizer.$$$reportNull$$$0(1);
        }
        this.myIncludeInputs = inputs;
        this.mySerializationManager = manager;
        this.myStubIndexesExternalizer = externalizer;
    }

    public final void save(@NotNull DataOutput out, @NotNull SerializedStubTree tree) throws IOException {
        if (out == null) {
            SerializedStubTreeDataExternalizer.$$$reportNull$$$0(2);
        }
        if (tree == null) {
            SerializedStubTreeDataExternalizer.$$$reportNull$$$0(3);
        }
        if (PersistentHashMapValueStorage.COMPRESSION_ENABLED) {
            DataInputOutputUtil.writeINT((DataOutput)out, (int)tree.myTreeByteLength);
            out.write(tree.myTreeBytes, 0, tree.myTreeByteLength);
            if (this.myIncludeInputs) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)tree.myIndexedStubByteLength);
                out.write(tree.myIndexedStubBytes, 0, tree.myIndexedStubByteLength);
            }
        } else {
            CompressionUtil.writeCompressed((DataOutput)out, (byte[])tree.myTreeBytes, (int)0, (int)tree.myTreeByteLength);
            if (this.myIncludeInputs) {
                CompressionUtil.writeCompressed((DataOutput)out, (byte[])tree.myIndexedStubBytes, (int)0, (int)tree.myIndexedStubByteLength);
            }
        }
    }

    @NotNull
    public final SerializedStubTree read(@NotNull DataInput in) throws IOException {
        if (in == null) {
            SerializedStubTreeDataExternalizer.$$$reportNull$$$0(4);
        }
        if (PersistentHashMapValueStorage.COMPRESSION_ENABLED) {
            byte[] indexedStubBytes;
            int indexedStubByteLength;
            int serializedStubsLength = DataInputOutputUtil.readINT((DataInput)in);
            byte[] bytes = new byte[serializedStubsLength];
            in.readFully(bytes);
            if (this.myIncludeInputs) {
                indexedStubByteLength = DataInputOutputUtil.readINT((DataInput)in);
                indexedStubBytes = new byte[indexedStubByteLength];
                in.readFully(indexedStubBytes);
            } else {
                indexedStubByteLength = 0;
                indexedStubBytes = ArrayUtil.EMPTY_BYTE_ARRAY;
            }
            return new SerializedStubTree(bytes, bytes.length, indexedStubBytes, indexedStubByteLength, null, this.myStubIndexesExternalizer, this.mySerializationManager);
        }
        byte[] treeBytes = CompressionUtil.readCompressed((DataInput)in);
        byte[] indexedStubBytes = this.myIncludeInputs ? CompressionUtil.readCompressed((DataInput)in) : ArrayUtil.EMPTY_BYTE_ARRAY;
        return new SerializedStubTree(treeBytes, treeBytes.length, indexedStubBytes, indexedStubBytes.length, null, this.myStubIndexesExternalizer, this.mySerializationManager);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalizer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/stubs/SerializedStubTreeDataExternalizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "save";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

