/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubForwardIndexExternalizer;
import com.intellij.psi.stubs.StubIdList;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexEx;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubTree;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SerializedStubTree {
    private static final MessageDigest HASHER = DigestUtil.sha256();
    final byte[] myTreeBytes;
    final int myTreeByteLength;
    final byte[] myIndexedStubBytes;
    final int myIndexedStubByteLength;
    private Map<StubIndexKey, Map<Object, StubIdList>> myIndexedStubs;
    private final SerializationManagerEx mySerializationManager;
    @NotNull
    private volatile StubForwardIndexExternalizer<?> myStubIndexesExternalizer;
    private byte[] myTreeHash;

    private void setStubIndexesExternalizer(@NotNull StubForwardIndexExternalizer<?> stubIndexesExternalizer) {
        if (stubIndexesExternalizer == null) {
            SerializedStubTree.$$$reportNull$$$0(0);
        }
        this.myStubIndexesExternalizer = stubIndexesExternalizer;
    }

    public SerializedStubTree(byte @NotNull [] treeBytes, int treeByteLength, byte @NotNull [] indexedStubBytes, int indexedStubByteLength, @Nullable Map<StubIndexKey, Map<Object, StubIdList>> indexedStubs, @NotNull StubForwardIndexExternalizer<?> stubIndexesExternalizer, @NotNull SerializationManagerEx serializationManager) {
        if (stubIndexesExternalizer == null) {
            SerializedStubTree.$$$reportNull$$$0(1);
        }
        if (serializationManager == null) {
            SerializedStubTree.$$$reportNull$$$0(2);
        }
        if (treeBytes == null) {
            SerializedStubTree.$$$reportNull$$$0(3);
        }
        if (indexedStubBytes == null) {
            SerializedStubTree.$$$reportNull$$$0(4);
        }
        this.myTreeBytes = treeBytes;
        this.myTreeByteLength = treeByteLength;
        this.myIndexedStubBytes = indexedStubBytes;
        this.myIndexedStubByteLength = indexedStubByteLength;
        this.myIndexedStubs = indexedStubs;
        this.myStubIndexesExternalizer = stubIndexesExternalizer;
        this.mySerializationManager = serializationManager;
    }

    @NotNull
    public static SerializedStubTree serializeStub(@NotNull Stub rootStub, @NotNull SerializationManagerEx serializationManager, @NotNull StubForwardIndexExternalizer<?> forwardIndexExternalizer) throws IOException {
        if (rootStub == null) {
            SerializedStubTree.$$$reportNull$$$0(5);
        }
        if (serializationManager == null) {
            SerializedStubTree.$$$reportNull$$$0(6);
        }
        if (forwardIndexExternalizer == null) {
            SerializedStubTree.$$$reportNull$$$0(7);
        }
        BufferExposingByteArrayOutputStream bytes = new BufferExposingByteArrayOutputStream();
        serializationManager.serialize(rootStub, (OutputStream)bytes);
        byte[] treeBytes = bytes.getInternalBuffer();
        int treeByteLength = bytes.size();
        ObjectStubBase root = (ObjectStubBase)rootStub;
        Map<StubIndexKey, Map<Object, StubIdList>> indexedStubs = SerializedStubTree.indexTree((Stub)root);
        BufferExposingByteArrayOutputStream indexBytes = new BufferExposingByteArrayOutputStream();
        forwardIndexExternalizer.save((DataOutput)new DataOutputStream((OutputStream)indexBytes), indexedStubs);
        byte[] indexedStubBytes = indexBytes.getInternalBuffer();
        int indexedStubByteLength = indexBytes.size();
        return new SerializedStubTree(treeBytes, treeByteLength, indexedStubBytes, indexedStubByteLength, indexedStubs, forwardIndexExternalizer, serializationManager);
    }

    @NotNull
    public SerializedStubTree reSerialize(@NotNull SerializationManagerEx currentSerializationManager, @NotNull SerializationManagerEx newSerializationManager, @NotNull StubForwardIndexExternalizer currentForwardIndexSerializer, @NotNull StubForwardIndexExternalizer newForwardIndexSerializer) throws IOException {
        int reSerializedIndexByteLength;
        byte[] reSerializedIndexBytes;
        if (currentSerializationManager == null) {
            SerializedStubTree.$$$reportNull$$$0(8);
        }
        if (newSerializationManager == null) {
            SerializedStubTree.$$$reportNull$$$0(9);
        }
        if (currentForwardIndexSerializer == null) {
            SerializedStubTree.$$$reportNull$$$0(10);
        }
        if (newForwardIndexSerializer == null) {
            SerializedStubTree.$$$reportNull$$$0(11);
        }
        BufferExposingByteArrayOutputStream outStub = new BufferExposingByteArrayOutputStream();
        currentSerializationManager.reSerialize(new ByteArrayInputStream(this.myTreeBytes, 0, this.myTreeByteLength), (OutputStream)outStub, newSerializationManager);
        if (currentForwardIndexSerializer == newForwardIndexSerializer) {
            reSerializedIndexBytes = this.myIndexedStubBytes;
            reSerializedIndexByteLength = this.myIndexedStubByteLength;
        } else {
            BufferExposingByteArrayOutputStream reSerializedStubIndices = new BufferExposingByteArrayOutputStream();
            if (this.myIndexedStubs == null) {
                this.setStubIndexesExternalizer(currentForwardIndexSerializer);
                this.restoreIndexedStubs();
            }
            assert (this.myIndexedStubs != null);
            newForwardIndexSerializer.save((DataOutput)new DataOutputStream((OutputStream)reSerializedStubIndices), this.myIndexedStubs);
            reSerializedIndexBytes = reSerializedStubIndices.getInternalBuffer();
            reSerializedIndexByteLength = reSerializedStubIndices.size();
        }
        return new SerializedStubTree(outStub.getInternalBuffer(), outStub.size(), reSerializedIndexBytes, reSerializedIndexByteLength, this.myIndexedStubs, newForwardIndexSerializer, newSerializationManager);
    }

    void restoreIndexedStubs() throws IOException {
        if (this.myIndexedStubs == null) {
            this.myIndexedStubs = this.myStubIndexesExternalizer.read(new DataInputStream(new ByteArrayInputStream(this.myIndexedStubBytes, 0, this.myIndexedStubByteLength)));
        }
    }

    <K> StubIdList restoreIndexedStubs(@NotNull StubIndexKey<K, ?> indexKey, @NotNull K key) throws IOException {
        Map<StubIndexKey, Map<Object, StubIdList>> incompleteMap;
        if (indexKey == null) {
            SerializedStubTree.$$$reportNull$$$0(12);
        }
        if (key == null) {
            SerializedStubTree.$$$reportNull$$$0(13);
        }
        if ((incompleteMap = this.myStubIndexesExternalizer.doRead(new DataInputStream(new ByteArrayInputStream(this.myIndexedStubBytes, 0, this.myIndexedStubByteLength)), indexKey, key)) == null) {
            return null;
        }
        Map<Object, StubIdList> map2 = incompleteMap.get(indexKey);
        return map2 == null ? null : map2.get(key);
    }

    @NotNull
    public Map<StubIndexKey, Map<Object, StubIdList>> getStubIndicesValueMap() {
        Map<StubIndexKey, Map<Object, StubIdList>> map2 = this.myIndexedStubs;
        if (map2 == null) {
            SerializedStubTree.$$$reportNull$$$0(14);
        }
        return map2;
    }

    public Map<StubIndexKey, Map<Object, StubIdList>> readStubIndicesValueMap() throws IOException {
        this.restoreIndexedStubs();
        return this.myIndexedStubs;
    }

    @NotNull
    public Stub getStub() throws SerializerNotFoundException {
        Stub stub = this.getStub(this.mySerializationManager);
        if (stub == null) {
            SerializedStubTree.$$$reportNull$$$0(15);
        }
        return stub;
    }

    @NotNull
    public Stub getStub(@NotNull SerializationManagerEx serializationManager) throws SerializerNotFoundException {
        if (serializationManager == null) {
            SerializedStubTree.$$$reportNull$$$0(16);
        }
        Stub stub = serializationManager.deserialize((InputStream)new UnsyncByteArrayInputStream(this.myTreeBytes, 0, this.myTreeByteLength));
        if (stub == null) {
            SerializedStubTree.$$$reportNull$$$0(17);
        }
        return stub;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof SerializedStubTree)) {
            return false;
        }
        SerializedStubTree thatTree = (SerializedStubTree)that;
        int length = this.myTreeByteLength;
        if (length != thatTree.myTreeByteLength) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (this.myTreeBytes[i] == thatTree.myTreeBytes[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result2 = 1;
        for (int i = 0; i < this.myTreeByteLength; ++i) {
            result2 = 31 * result2 + this.myTreeBytes[i];
        }
        return result2;
    }

    @NotNull
    static Map<StubIndexKey, Map<Object, StubIdList>> indexTree(@NotNull Stub root) {
        if (root == null) {
            SerializedStubTree.$$$reportNull$$$0(18);
        }
        ObjectStubTree objectStubTree = root instanceof PsiFileStub ? new StubTree((PsiFileStub)root, false) : new ObjectStubTree((ObjectStubBase)root, false);
        StubIndexEx indexImpl = (StubIndexEx)StubIndex.getInstance();
        Map<StubIndexKey, Map<Object, StubIdList>> map2 = objectStubTree.indexStubTree(k -> indexImpl.getKeyHashingStrategy((StubIndexKey)k));
        for (StubIndexKey key : map2.keySet()) {
            Map<Object, StubIdList> value2 = map2.get(key);
            for (Object k2 : value2.keySet()) {
                int[] ints = (int[])value2.get(k2);
                StubIdList stubList = ints.length == 1 ? new StubIdList(ints[0]) : new StubIdList(ints, ints.length);
                value2.put(k2, stubList);
            }
        }
        Map<StubIndexKey, Map<Object, StubIdList>> map3 = map2;
        if (map3 == null) {
            SerializedStubTree.$$$reportNull$$$0(19);
        }
        return map3;
    }

    public synchronized byte @NotNull [] getTreeHash() {
        if (this.myTreeHash == null) {
            this.myTreeHash = DigestUtil.calculateContentHash((MessageDigest)HASHER, (byte[])this.myTreeBytes, (int)0, (int)this.myTreeByteLength);
        }
        if (this.myTreeHash == null) {
            SerializedStubTree.$$$reportNull$$$0(20);
        }
        return this.myTreeHash;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubIndexesExternalizer";
                break;
            }
            case 2: 
            case 6: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializationManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeBytes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexedStubBytes";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootStub";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forwardIndexExternalizer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSerializationManager";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSerializationManager";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentForwardIndexSerializer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newForwardIndexSerializer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexKey";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/SerializedStubTree";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/SerializedStubTree";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubIndicesValueMap";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getStub";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "indexTree";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeHash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setStubIndexesExternalizer";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "serializeStub";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "reSerialize";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "restoreIndexedStubs";
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getStub";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "indexTree";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

