/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.search.FileTypeIndexImpl;
import com.intellij.psi.search.FileTypeKeyDescriptor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.VfsAwareMapReduceIndex;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.MapInputDataDiffBuilder;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

class FileTypeMapReduceIndex
extends VfsAwareMapReduceIndex<FileType, Void> {
    private static final Logger LOG = Logger.getInstance(FileTypeIndexImpl.class);

    FileTypeMapReduceIndex(@NotNull FileBasedIndexExtension<FileType, Void> extension, @NotNull IndexStorage<FileType, Void> storage) throws IOException {
        if (extension == null) {
            FileTypeMapReduceIndex.$$$reportNull$$$0(0);
        }
        if (storage == null) {
            FileTypeMapReduceIndex.$$$reportNull$$$0(1);
        }
        super(extension, storage);
    }

    @Override
    public boolean isIndexedStateForFile(int fileId, @NotNull IndexedFile file2) {
        boolean isIndexed;
        if (file2 == null) {
            FileTypeMapReduceIndex.$$$reportNull$$$0(2);
        }
        if (!(isIndexed = super.isIndexedStateForFile(fileId, file2))) {
            return false;
        }
        try {
            Collection inputData = ((MapInputDataDiffBuilder)this.getKeysDiffBuilder(fileId)).getKeys();
            FileType indexedFileType = (FileType)ContainerUtil.getFirstItem((Collection)inputData);
            return FileTypeKeyDescriptor.INSTANCE.isEqual(indexedFileType, file2.getFileType());
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/search/FileTypeMapReduceIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isIndexedStateForFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

