/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.inspectionsTree;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.ide.IdeTooltip;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.ui.InspectionsAggregationUtil;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionConfigTreeNode;
import com.intellij.profile.codeInspection.ui.inspectionsTree.MultiScopeSeverityIcon;
import com.intellij.profile.codeInspection.ui.inspectionsTree.ScopesAndSeveritiesHintTable;
import com.intellij.profile.codeInspection.ui.table.ScopesAndSeveritiesTable;
import com.intellij.profile.codeInspection.ui.table.ThreeStateCheckBoxRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.IconTableCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import one.util.streamex.MoreCollectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionsConfigTreeTable
extends TreeTable {
    private static final Logger LOG = Logger.getInstance(InspectionsConfigTreeTable.class);
    private static final int TREE_COLUMN = 0;
    private static final int SEVERITIES_COLUMN = 1;
    private static final int IS_ENABLED_COLUMN = 2;

    public static int getAdditionalPadding() {
        return SystemInfo.isMac ? 16 : 0;
    }

    public static InspectionsConfigTreeTable create(InspectionsConfigTreeTableSettings settings, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            InspectionsConfigTreeTable.$$$reportNull$$$0(0);
        }
        return new InspectionsConfigTreeTable(new InspectionsConfigTreeTableModel(settings, parentDisposable));
    }

    private InspectionsConfigTreeTable(final InspectionsConfigTreeTableModel model) {
        super((TreeTableModel)model);
        TableColumn severitiesColumn = this.getColumnModel().getColumn(1);
        severitiesColumn.setCellRenderer(new IconTableCellRenderer<Icon>(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value2, boolean selected2, boolean focus, int row, int column) {
                Component component2 = super.getTableCellRendererComponent(table, value2, false, focus, row, column);
                Color bg = selected2 ? table.getSelectionBackground() : table.getBackground();
                component2.setBackground(bg);
                ((JLabel)component2).setText("");
                return component2;
            }

            @Override
            protected Icon getIcon(@NotNull Icon value2, JTable table, int row) {
                if (value2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return value2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/profile/codeInspection/ui/inspectionsTree/InspectionsConfigTreeTable$1", "getIcon"));
            }
        });
        severitiesColumn.setMaxWidth(JBUIScale.scale((int)20));
        TableColumn isEnabledColumn = this.getColumnModel().getColumn(2);
        isEnabledColumn.setMaxWidth(JBUIScale.scale((int)(22 + InspectionsConfigTreeTable.getAdditionalPadding())));
        ThreeStateCheckBoxRenderer boxRenderer = new ThreeStateCheckBoxRenderer();
        boxRenderer.setOpaque(true);
        isEnabledColumn.setCellRenderer(boxRenderer);
        isEnabledColumn.setCellEditor(new ThreeStateCheckBoxRenderer());
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Object maybeIcon;
                Point point = e.getPoint();
                int column = InspectionsConfigTreeTable.this.columnAtPoint(point);
                int row = InspectionsConfigTreeTable.this.rowAtPoint(point);
                if (column == 1 && row >= 0 && row < InspectionsConfigTreeTable.this.getRowCount() && (maybeIcon = InspectionsConfigTreeTable.this.getModel().getValueAt(row, column)) instanceof MultiScopeSeverityIcon) {
                    MultiScopeSeverityIcon icon2 = (MultiScopeSeverityIcon)maybeIcon;
                    LinkedHashMap<String, HighlightDisplayLevel> scopeToAverageSeverityMap = icon2.getScopeToAverageSeverityMap();
                    Object component2 = null;
                    if (scopeToAverageSeverityMap.size() == 1 && icon2.getDefaultScopeName().equals(ContainerUtil.getFirstItem(scopeToAverageSeverityMap.keySet()))) {
                        HighlightDisplayLevel level = (HighlightDisplayLevel)ContainerUtil.getFirstItem(scopeToAverageSeverityMap.values());
                        if (level != null) {
                            JLabel label2 = new JLabel();
                            label2.setIcon(level.getIcon());
                            label2.setText(SingleInspectionProfilePanel.renderSeverity(level.getSeverity()));
                            component2 = label2;
                        }
                    } else {
                        component2 = new ScopesAndSeveritiesHintTable(scopeToAverageSeverityMap, icon2.getDefaultScopeName());
                    }
                    IdeTooltipManager.getInstance().show(new IdeTooltip((Component)((Object)InspectionsConfigTreeTable.this), point, (JComponent)component2, new Object[0]), false);
                }
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                InspectionConfigTreeNode node;
                TreePath path = InspectionsConfigTreeTable.this.getTree().getPathForRow(InspectionsConfigTreeTable.this.getTree().getLeadSelectionRow());
                if (path != null && (node = (InspectionConfigTreeNode)path.getLastPathComponent()).isLeaf()) {
                    model.swapInspectionEnableState();
                }
                return true;
            }
        }.installOn((Component)((Object)this));
        this.setTransferHandler(new TransferHandler(){

            @Override
            @Nullable
            protected Transferable createTransferable(JComponent c) {
                TreePath path = InspectionsConfigTreeTable.this.getTree().getPathForRow(InspectionsConfigTreeTable.this.getTree().getLeadSelectionRow());
                if (path != null) {
                    return new TextTransferable(StringUtil.join((Collection)ContainerUtil.mapNotNull((Object[])path.getPath(), (Function)((NullableFunction)o -> o == path.getPath()[0] ? null : o.toString())), (String)" | "));
                }
                return null;
            }

            @Override
            public int getSourceActions(JComponent c) {
                return 1;
            }
        });
        this.setTableHeader((JTableHeader)new JBTable.InvisibleResizableHeader(){

            protected boolean canMoveOrResizeColumn(int modelIndex) {
                return false;
            }
        });
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setResizingAllowed(false);
        this.registerKeyboardAction(__ -> {
            model.swapInspectionEnableState();
            this.updateUI();
        }, KeyStroke.getKeyStroke(32, 0), 0);
        this.getEmptyText().setText(AnalysisBundle.message((String)"inspections.settings.empty.text", (Object[])new Object[0]));
    }

    @Nullable
    public InspectionConfigTreeNode.Tool getStrictlySelectedToolNode() {
        TreePath[] paths = this.getTree().getSelectionPaths();
        return paths != null && paths.length == 1 && paths[0].getLastPathComponent() instanceof InspectionConfigTreeNode.Tool ? (InspectionConfigTreeNode.Tool)paths[0].getLastPathComponent() : null;
    }

    public Collection<InspectionConfigTreeNode.Tool> getSelectedToolNodes() {
        return InspectionsAggregationUtil.getInspectionsNodes(this.getTree().getSelectionPaths());
    }

    public void paint(@NotNull Graphics g) {
        if (g == null) {
            InspectionsConfigTreeTable.$$$reportNull$$$0(1);
        }
        super.paint(g);
        UIUtil.fixOSXEditorBackground((JTable)((Object)this));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
        }
        objectArray2[1] = "com/intellij/profile/codeInspection/ui/inspectionsTree/InspectionsConfigTreeTable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "paint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MultiColoredHighlightSeverityIconSink {
        private final Map<String, SeverityAndOccurrences> myScopeToAverageSeverityMap = new HashMap<String, SeverityAndOccurrences>();
        private String myDefaultScopeName;

        private MultiColoredHighlightSeverityIconSink() {
        }

        Icon constructIcon(@NotNull InspectionProfileImpl inspectionProfile) {
            Map<String, HighlightSeverity> computedSeverities;
            if (inspectionProfile == null) {
                MultiColoredHighlightSeverityIconSink.$$$reportNull$$$0(0);
            }
            if ((computedSeverities = this.computeSeverities()) == null) {
                return null;
            }
            boolean allScopesHasMixedSeverity = true;
            for (HighlightSeverity severity : computedSeverities.values()) {
                if (severity.equals((Object)ScopesAndSeveritiesTable.MIXED_FAKE_SEVERITY)) continue;
                allScopesHasMixedSeverity = false;
                break;
            }
            return allScopesHasMixedSeverity ? ScopesAndSeveritiesTable.MIXED_FAKE_LEVEL.getIcon() : new MultiScopeSeverityIcon(computedSeverities, this.myDefaultScopeName, inspectionProfile);
        }

        @Nullable
        private Map<String, HighlightSeverity> computeSeverities() {
            if (this.myScopeToAverageSeverityMap.isEmpty()) {
                return null;
            }
            HashMap<String, HighlightSeverity> result2 = new HashMap<String, HighlightSeverity>();
            Map.Entry entry = (Map.Entry)ContainerUtil.getFirstItem(this.myScopeToAverageSeverityMap.entrySet());
            result2.put((String)entry.getKey(), ((SeverityAndOccurrences)entry.getValue()).getPrimarySeverity());
            if (this.myScopeToAverageSeverityMap.size() == 1) {
                return result2;
            }
            SeverityAndOccurrences defaultSeveritiesAndOccurrences = this.myScopeToAverageSeverityMap.get(this.myDefaultScopeName);
            if (defaultSeveritiesAndOccurrences == null) {
                for (Map.Entry<String, SeverityAndOccurrences> e : this.myScopeToAverageSeverityMap.entrySet()) {
                    HighlightSeverity primarySeverity = e.getValue().getPrimarySeverity();
                    if (primarySeverity == null) continue;
                    result2.put(e.getKey(), primarySeverity);
                }
                return result2;
            }
            int allInspectionsCount = defaultSeveritiesAndOccurrences.getOccurrencesSize();
            Map<String, HighlightSeverity> allScopes = defaultSeveritiesAndOccurrences.getOccurrences();
            for (String currentScope : this.myScopeToAverageSeverityMap.keySet()) {
                SeverityAndOccurrences currentSeverityAndOccurrences = this.myScopeToAverageSeverityMap.get(currentScope);
                if (currentSeverityAndOccurrences == null) continue;
                HighlightSeverity currentSeverity = currentSeverityAndOccurrences.getPrimarySeverity();
                if (currentSeverity == ScopesAndSeveritiesTable.MIXED_FAKE_SEVERITY || currentSeverityAndOccurrences.getOccurrencesSize() == allInspectionsCount || this.myDefaultScopeName.equals(currentScope)) {
                    result2.put(currentScope, currentSeverity);
                    continue;
                }
                HashSet<String> toolsToCheck = new HashSet<String>(allScopes.keySet());
                toolsToCheck.removeAll(currentSeverityAndOccurrences.getOccurrences().keySet());
                boolean doContinue = false;
                Map<String, HighlightSeverity> lowerScopeOccurrences = this.myScopeToAverageSeverityMap.get(this.myDefaultScopeName).getOccurrences();
                for (String toolName : toolsToCheck) {
                    HighlightSeverity currentToolSeverity = lowerScopeOccurrences.get(toolName);
                    if (currentToolSeverity == null || currentSeverity.equals((Object)currentToolSeverity)) continue;
                    result2.put(currentScope, ScopesAndSeveritiesTable.MIXED_FAKE_SEVERITY);
                    doContinue = true;
                    break;
                }
                if (doContinue) continue;
                result2.put(currentScope, currentSeverity);
            }
            return result2;
        }

        public void put(@NotNull ScopeToolState defaultState, @NotNull List<? extends ScopeToolState> nonDefault) {
            if (defaultState == null) {
                MultiColoredHighlightSeverityIconSink.$$$reportNull$$$0(1);
            }
            if (nonDefault == null) {
                MultiColoredHighlightSeverityIconSink.$$$reportNull$$$0(2);
            }
            this.putOne(defaultState);
            if (this.myDefaultScopeName == null) {
                this.myDefaultScopeName = defaultState.getScopeName();
            }
            for (ScopeToolState scopeToolState : nonDefault) {
                this.putOne(scopeToolState);
            }
        }

        private void putOne(ScopeToolState state) {
            if (!state.isEnabled()) {
                return;
            }
            Icon icon2 = state.getLevel().getIcon();
            String scopeName = state.getScopeName();
            if (icon2 instanceof HighlightDisplayLevel.ColoredIcon) {
                SeverityAndOccurrences severityAndOccurrences = this.myScopeToAverageSeverityMap.get(scopeName);
                String inspectionName = state.getTool().getShortName();
                if (severityAndOccurrences == null) {
                    this.myScopeToAverageSeverityMap.put(scopeName, new SeverityAndOccurrences().incOccurrences(inspectionName, state.getLevel().getSeverity()));
                } else {
                    severityAndOccurrences.incOccurrences(inspectionName, state.getLevel().getSeverity());
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inspectionProfile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultState";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nonDefault";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/profile/codeInspection/ui/inspectionsTree/InspectionsConfigTreeTable$MultiColoredHighlightSeverityIconSink";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "constructIcon";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "put";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SeverityAndOccurrences {
        private HighlightSeverity myPrimarySeverity;
        private final Map<String, HighlightSeverity> myOccurrences = new HashMap<String, HighlightSeverity>();

        private SeverityAndOccurrences() {
        }

        @NotNull
        SeverityAndOccurrences incOccurrences(@NotNull String toolName, @NotNull HighlightSeverity severity) {
            if (toolName == null) {
                SeverityAndOccurrences.$$$reportNull$$$0(0);
            }
            if (severity == null) {
                SeverityAndOccurrences.$$$reportNull$$$0(1);
            }
            if (this.myPrimarySeverity == null) {
                this.myPrimarySeverity = severity;
            } else if (!Comparing.equal((Object)severity, (Object)this.myPrimarySeverity)) {
                this.myPrimarySeverity = ScopesAndSeveritiesTable.MIXED_FAKE_SEVERITY;
            }
            this.myOccurrences.put(toolName, severity);
            SeverityAndOccurrences severityAndOccurrences = this;
            if (severityAndOccurrences == null) {
                SeverityAndOccurrences.$$$reportNull$$$0(2);
            }
            return severityAndOccurrences;
        }

        HighlightSeverity getPrimarySeverity() {
            return this.myPrimarySeverity;
        }

        int getOccurrencesSize() {
            return this.myOccurrences.size();
        }

        @NotNull
        public Map<String, HighlightSeverity> getOccurrences() {
            Map<String, HighlightSeverity> map2 = this.myOccurrences;
            if (map2 == null) {
                SeverityAndOccurrences.$$$reportNull$$$0(3);
            }
            return map2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "severity";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/profile/codeInspection/ui/inspectionsTree/InspectionsConfigTreeTable$SeverityAndOccurrences";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/profile/codeInspection/ui/inspectionsTree/InspectionsConfigTreeTable$SeverityAndOccurrences";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "incOccurrences";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOccurrences";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "incOccurrences";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class InspectionsConfigTreeTableModel
    extends DefaultTreeModel
    implements TreeTableModel {
        private final InspectionsConfigTreeTableSettings mySettings;
        private final Runnable myUpdateRunnable;
        private TreeTable myTreeTable;
        private final Alarm myUpdateAlarm;

        InspectionsConfigTreeTableModel(@NotNull InspectionsConfigTreeTableSettings settings, @NotNull Disposable parentDisposable) {
            if (settings == null) {
                InspectionsConfigTreeTableModel.$$$reportNull$$$0(0);
            }
            if (parentDisposable == null) {
                InspectionsConfigTreeTableModel.$$$reportNull$$$0(1);
            }
            super(settings.getRoot());
            this.mySettings = settings;
            this.myUpdateRunnable = () -> {
                settings.updateRightPanel();
                ((AbstractTableModel)this.myTreeTable.getModel()).fireTableDataChanged();
            };
            this.myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, parentDisposable);
        }

        public int getColumnCount() {
            return 3;
        }

        @Nullable
        public String getColumnName(int column) {
            return null;
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return TreeTableModel.class;
                }
                case 1: {
                    return Icon.class;
                }
                case 2: {
                    return Boolean.class;
                }
            }
            throw new IllegalArgumentException();
        }

        @Nullable
        public Object getValueAt(Object node, int column) {
            if (column == 0) {
                return null;
            }
            InspectionConfigTreeNode treeNode = (InspectionConfigTreeNode)node;
            List<HighlightDisplayKey> inspectionsKeys = InspectionsAggregationUtil.getInspectionsKeys(treeNode);
            if (column == 1) {
                MultiColoredHighlightSeverityIconSink sink = new MultiColoredHighlightSeverityIconSink();
                for (HighlightDisplayKey selectedInspectionsNode : inspectionsKeys) {
                    String toolId = selectedInspectionsNode.toString();
                    if (!this.mySettings.getInspectionProfile().getTools(toolId, this.mySettings.getProject()).isEnabled()) continue;
                    sink.put(this.mySettings.getInspectionProfile().getToolDefaultState(toolId, this.mySettings.getProject()), this.mySettings.getInspectionProfile().getNonDefaultTools(toolId, this.mySettings.getProject()));
                }
                return sink.constructIcon(this.mySettings.getInspectionProfile());
            }
            if (column == 2) {
                return this.isEnabled(inspectionsKeys);
            }
            throw new IllegalArgumentException();
        }

        @Nullable
        private Boolean isEnabled(@NotNull List<HighlightDisplayKey> selectedInspectionsNodes) {
            if (selectedInspectionsNodes == null) {
                InspectionsConfigTreeTableModel.$$$reportNull$$$0(2);
            }
            return ((Optional)selectedInspectionsNodes.stream().map(key -> this.mySettings.getInspectionProfile().getTools(key.toString(), this.mySettings.getProject())).flatMap(tools -> tools.isEnabled() ? tools.getTools().stream().map(ScopeToolState::isEnabled) : Stream.of(Boolean.valueOf(false))).distinct().collect(MoreCollectors.onlyOne())).orElse(null);
        }

        public boolean isCellEditable(Object node, int column) {
            return column == 2;
        }

        public void setValueAt(Object aValue, Object node, int column) {
            LOG.assertTrue(column == 2);
            if (aValue == null) {
                return;
            }
            boolean doEnable = (Boolean)aValue;
            InspectionProfileImpl profile = this.mySettings.getInspectionProfile();
            for (InspectionConfigTreeNode.Tool aNode : InspectionsAggregationUtil.getInspectionsNodes((InspectionConfigTreeNode)node)) {
                InspectionProfileImpl.setToolEnabled(doEnable, profile, aNode.getKey().toString(), this.mySettings.getProject());
                this.mySettings.onChanged(aNode);
            }
            this.updateRightPanel();
        }

        void swapInspectionEnableState() {
            LOG.assertTrue(this.myTreeTable != null);
            TreePath[] selectionPaths = this.myTreeTable.getTree().getSelectionPaths();
            if (selectionPaths == null) {
                return;
            }
            HashSet tools = new HashSet();
            ArrayList nodes = new ArrayList();
            for (TreePath selectionPath : selectionPaths) {
                InspectionConfigTreeNode node = (InspectionConfigTreeNode)selectionPath.getLastPathComponent();
                InspectionsConfigTreeTableModel.collectInspectionFromNodes(node, tools, nodes);
            }
            int[] selectedRows = this.myTreeTable.getSelectedRows();
            Boolean state = null;
            for (int selectedRow : selectedRows) {
                Boolean value2 = (Boolean)this.myTreeTable.getValueAt(selectedRow, 2);
                if (state == null) {
                    state = value2;
                    continue;
                }
                if (state.equals(value2)) continue;
                state = null;
                break;
            }
            boolean newState2 = !Boolean.TRUE.equals(state);
            InspectionProfileImpl profile = this.mySettings.getInspectionProfile();
            for (HighlightDisplayKey tool : tools) {
                InspectionProfileImpl.setToolEnabled(newState2, profile, tool.toString(), this.mySettings.getProject());
            }
            for (InspectionConfigTreeNode node : nodes) {
                this.mySettings.onChanged(node);
            }
            this.updateRightPanel();
        }

        private void updateRightPanel() {
            if (this.myTreeTable != null && !this.myUpdateAlarm.isDisposed()) {
                this.myUpdateAlarm.cancelAllRequests();
                this.myUpdateAlarm.addRequest(this.myUpdateRunnable, 10, ModalityState.stateForComponent((Component)this.myTreeTable));
            }
        }

        private static void collectInspectionFromNodes(InspectionConfigTreeNode node, Set<? super HighlightDisplayKey> tools, List<? super InspectionConfigTreeNode> nodes) {
            if (node == null) {
                return;
            }
            nodes.add(node);
            if (node instanceof InspectionConfigTreeNode.Group) {
                for (int i = 0; i < node.getChildCount(); ++i) {
                    InspectionsConfigTreeTableModel.collectInspectionFromNodes((InspectionConfigTreeNode)node.getChildAt(i), tools, nodes);
                }
            } else {
                tools.add((HighlightDisplayKey)((InspectionConfigTreeNode.Tool)node).getKey());
            }
        }

        public void setTree(JTree tree) {
            this.myTreeTable = ((TreeTableTree)tree).getTreeTable();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentDisposable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedInspectionsNodes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/profile/codeInspection/ui/inspectionsTree/InspectionsConfigTreeTable$InspectionsConfigTreeTableModel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabled";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class InspectionsConfigTreeTableSettings {
        private final TreeNode myRoot;
        private final Project myProject;

        public InspectionsConfigTreeTableSettings(@NotNull TreeNode root, @NotNull Project project) {
            if (root == null) {
                InspectionsConfigTreeTableSettings.$$$reportNull$$$0(0);
            }
            if (project == null) {
                InspectionsConfigTreeTableSettings.$$$reportNull$$$0(1);
            }
            this.myRoot = root;
            this.myProject = project;
        }

        @NotNull
        public TreeNode getRoot() {
            TreeNode treeNode = this.myRoot;
            if (treeNode == null) {
                InspectionsConfigTreeTableSettings.$$$reportNull$$$0(2);
            }
            return treeNode;
        }

        @NotNull
        public Project getProject() {
            Project project = this.myProject;
            if (project == null) {
                InspectionsConfigTreeTableSettings.$$$reportNull$$$0(3);
            }
            return project;
        }

        @NotNull
        protected abstract InspectionProfileImpl getInspectionProfile();

        protected abstract void onChanged(@NotNull InspectionConfigTreeNode var1);

        public abstract void updateRightPanel();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/profile/codeInspection/ui/inspectionsTree/InspectionsConfigTreeTable$InspectionsConfigTreeTableSettings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/profile/codeInspection/ui/inspectionsTree/InspectionsConfigTreeTable$InspectionsConfigTreeTableSettings";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRoot";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

