/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status.widget;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.SimplePersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.wm.StatusBarWidgetFactory;
import com.intellij.openapi.wm.impl.status.widget.StatusBarState;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service
@State(name="StatusBar", storages={@Storage(deprecated=true, value="window.state.xml", roamingType=RoamingType.DISABLED), @Storage(value="ide.general.xml")})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\b\u0010\u000b\u001a\u00020\tH\u0002J\b\u0010\f\u001a\u00020\tH\u0016J\u0016\u0010\r\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0005\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/wm/impl/status/widget/StatusBarWidgetSettings;", "Lcom/intellij/openapi/components/SimplePersistentStateComponent;", "Lcom/intellij/openapi/wm/impl/status/widget/StatusBarState;", "()V", "isEnabled", "", "factory", "Lcom/intellij/openapi/wm/StatusBarWidgetFactory;", "loadState", "", "state", "migrateShowMemoryIndicatorSettings", "noStateLoaded", "setEnabled", "newValue", "intellij.platform.ide.impl"})
public final class StatusBarWidgetSettings
extends SimplePersistentStateComponent<StatusBarState> {
    public final boolean isEnabled(@NotNull StatusBarWidgetFactory factory) {
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        Boolean bl = ((StatusBarState)this.getState()).getWidgets().get(factory.getId());
        return bl != null ? bl.booleanValue() : factory.isEnabledByDefault();
    }

    public void loadState(@NotNull StatusBarState state) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)state), (String)"state");
        super.loadState((BaseState)state);
        this.migrateShowMemoryIndicatorSettings();
    }

    public void noStateLoaded() {
        super.noStateLoaded();
        this.migrateShowMemoryIndicatorSettings();
    }

    private final void migrateShowMemoryIndicatorSettings() {
        if (UISettings.Companion.getInstance().getShowMemoryIndicator()) {
            UISettings.Companion.getInstance().setShowMemoryIndicator(false);
            ((StatusBarState)this.getState()).getWidgets().put("Memory", true);
        }
    }

    public final void setEnabled(@NotNull StatusBarWidgetFactory factory, boolean newValue) {
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        if (factory.isEnabledByDefault() == newValue) {
            ((StatusBarState)this.getState()).getWidgets().remove(factory.getId());
        } else {
            Map<String, Boolean> map2 = ((StatusBarState)this.getState()).getWidgets();
            String string = factory.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"factory.id");
            map2.put(string, newValue);
        }
    }

    public StatusBarWidgetSettings() {
        super((BaseState)new StatusBarState());
    }
}

