/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ext.LibraryDependentToolWindow;
import com.intellij.openapi.wm.ext.LibrarySearchHelper;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;

public class LibraryDependentToolWindowManager
implements StartupActivity {
    private static final Executor ourExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"LibraryDependentToolWindowManager");

    public void runActivity(final @NotNull Project project) {
        Application application;
        if (project == null) {
            LibraryDependentToolWindowManager.$$$reportNull$$$0(0);
        }
        if ((application = ApplicationManager.getApplication()).isUnitTestMode() || application.isHeadlessEnvironment()) {
            return;
        }
        ModuleRootListener rootListener = new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                LibraryDependentToolWindowManager.this.checkToolWindowStatuses(project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/wm/impl/LibraryDependentToolWindowManager$1", "rootsChanged"));
            }
        };
        this.checkToolWindowStatuses(project);
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)rootListener);
        LibraryDependentToolWindow.EXTENSION_POINT_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<LibraryDependentToolWindow>(){

            public void extensionAdded(@NotNull LibraryDependentToolWindow extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(1);
                }
                LibraryDependentToolWindowManager.this.checkToolWindowStatuses(project, Collections.singletonList(extension));
            }

            public void extensionRemoved(@NotNull LibraryDependentToolWindow extension, @NotNull PluginDescriptor pluginDescriptor) {
                ToolWindow window;
                if (extension == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(3);
                }
                if ((window = ToolWindowManager.getInstance((Project)project).getToolWindow(extension.id)) != null) {
                    window.remove();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/wm/impl/LibraryDependentToolWindowManager$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)project);
    }

    private void checkToolWindowStatuses(@NotNull Project project) {
        if (project == null) {
            LibraryDependentToolWindowManager.$$$reportNull$$$0(1);
        }
        this.checkToolWindowStatuses(project, LibraryDependentToolWindow.EXTENSION_POINT_NAME.getExtensionList());
    }

    private void checkToolWindowStatuses(@NotNull Project project, @NotNull List<LibraryDependentToolWindow> extensions2) {
        if (project == null) {
            LibraryDependentToolWindowManager.$$$reportNull$$$0(2);
        }
        if (extensions2 == null) {
            LibraryDependentToolWindowManager.$$$reportNull$$$0(3);
        }
        ModalityState currentModalityState = ModalityState.current();
        ReadAction.nonBlocking(() -> new HashSet(ContainerUtil.findAll((Collection)extensions2, ltw -> {
            LibrarySearchHelper helper = ltw.getLibrarySearchHelper();
            return helper != null && helper.isLibraryExists(project);
        }))).inSmartMode(project).coalesceBy(new Object[]{this}).finishOnUiThread(currentModalityState, existing -> {
            ToolWindowManagerEx toolWindowManagerEx = ToolWindowManagerEx.getInstanceEx(project);
            for (LibraryDependentToolWindow libraryToolWindow : extensions2) {
                ToolWindow toolWindow = toolWindowManagerEx.getToolWindow(libraryToolWindow.id);
                if (existing.contains(libraryToolWindow)) {
                    if (toolWindow != null) continue;
                    toolWindowManagerEx.initToolWindow((ToolWindowEP)libraryToolWindow);
                    continue;
                }
                if (toolWindow == null) continue;
                toolWindow.remove();
            }
        }).submit(ourExecutor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/wm/impl/LibraryDependentToolWindowManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkToolWindowStatuses";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

