/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.roots.impl.ModifiableModelCommitterService;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class ModifiableModelCommitterServiceImpl
implements ModifiableModelCommitterService {
    private static final Logger LOG = Logger.getInstance(ModifiableModelCommitter.class);

    @Override
    public void multiCommit(@NotNull Collection<? extends ModifiableRootModel> rootModels, @NotNull ModifiableModuleModel moduleModel) {
        if (rootModels == null) {
            ModifiableModelCommitterServiceImpl.$$$reportNull$$$0(0);
        }
        if (moduleModel == null) {
            ModifiableModelCommitterServiceImpl.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        List<RootModelImpl> modelsToCommit = ModifiableModelCommitterServiceImpl.getSortedChangedModels(rootModels, moduleModel);
        SmartList modelsToDispose = new SmartList(rootModels);
        modelsToDispose.removeAll(modelsToCommit);
        ModuleManagerImpl.commitModelWithRunnable(moduleModel, () -> ModifiableModelCommitterServiceImpl.lambda$multiCommit$0(modelsToCommit, (List)modelsToDispose));
    }

    @NotNull
    private static List<RootModelImpl> getSortedChangedModels(@NotNull Collection<? extends ModifiableRootModel> rootModels, @NotNull ModifiableModuleModel moduleModel) {
        if (rootModels == null) {
            ModifiableModelCommitterServiceImpl.$$$reportNull$$$0(2);
        }
        if (moduleModel == null) {
            ModifiableModelCommitterServiceImpl.$$$reportNull$$$0(3);
        }
        List result2 = null;
        for (ModifiableRootModel modifiableRootModel : rootModels) {
            RootModelImpl rootModel = (RootModelImpl)modifiableRootModel;
            if (!rootModel.isChanged()) continue;
            if (result2 == null) {
                result2 = new SmartList();
            }
            result2.add(rootModel);
        }
        if (result2 == null) {
            List<RootModelImpl> list2 = Collections.emptyList();
            if (list2 == null) {
                ModifiableModelCommitterServiceImpl.$$$reportNull$$$0(4);
            }
            return list2;
        }
        if (result2.size() > 1) {
            result2.sort(ModifiableModelCommitterServiceImpl.createDFSTBuilder(result2, moduleModel).comparator());
        }
        List list3 = result2;
        if (list3 == null) {
            ModifiableModelCommitterServiceImpl.$$$reportNull$$$0(5);
        }
        return list3;
    }

    @NotNull
    private static DFSTBuilder<RootModelImpl> createDFSTBuilder(@NotNull List<? extends RootModelImpl> rootModels, final @NotNull ModifiableModuleModel moduleModel) {
        Module[] modules;
        if (rootModels == null) {
            ModifiableModelCommitterServiceImpl.$$$reportNull$$$0(6);
        }
        if (moduleModel == null) {
            ModifiableModelCommitterServiceImpl.$$$reportNull$$$0(7);
        }
        final HashMap<String, RootModelImpl> nameToModel = new HashMap<String, RootModelImpl>();
        for (RootModelImpl rootModelImpl : rootModels) {
            String name = rootModelImpl.getModule().getName();
            LOG.assertTrue(!nameToModel.containsKey(name), (Object)name);
            nameToModel.put(name, rootModelImpl);
        }
        for (Module module : modules = moduleModel.getModules()) {
            String name = module.getName();
            if (nameToModel.containsKey(name)) continue;
            RootModelImpl rootModel = ((ModuleRootManagerImpl)ModuleRootManager.getInstance((Module)module)).getRootModel();
            nameToModel.put(name, rootModel);
        }
        final Collection collection = nameToModel.values();
        InboundSemiGraph<RootModelImpl> graph2 = new InboundSemiGraph<RootModelImpl>(){

            @NotNull
            public Collection<RootModelImpl> getNodes() {
                Collection collection2 = collection;
                if (collection2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return collection2;
            }

            @NotNull
            public Iterator<RootModelImpl> getIn(RootModelImpl rootModel) {
                OrderEnumerator entries = rootModel.orderEntries().withoutSdk().withoutLibraries().withoutModuleSourceEntries();
                List namesList = (List)entries.process((RootPolicy)new RootPolicy<List<String>>(){

                    public List<String> visitModuleOrderEntry(@NotNull ModuleOrderEntry moduleOrderEntry, List<String> strings) {
                        Module module;
                        if (moduleOrderEntry == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if ((module = moduleOrderEntry.getModule()) != null && !module.isDisposed()) {
                            strings.add(module.getName());
                        } else {
                            Module moduleToBeRenamed = moduleModel.getModuleToBeRenamed(moduleOrderEntry.getModuleName());
                            if (moduleToBeRenamed != null && !moduleToBeRenamed.isDisposed()) {
                                strings.add(moduleToBeRenamed.getName());
                            }
                        }
                        return strings;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleOrderEntry", "com/intellij/openapi/roots/impl/ModifiableModelCommitterServiceImpl$1$1", "visitModuleOrderEntry"));
                    }
                }, new ArrayList());
                String[] names2 = ArrayUtilRt.toStringArray((Collection)namesList);
                ArrayList<RootModelImpl> result2 = new ArrayList<RootModelImpl>();
                for (String name : names2) {
                    RootModelImpl depRootModel = (RootModelImpl)nameToModel.get(name);
                    if (depRootModel == null) continue;
                    result2.add(depRootModel);
                }
                Iterator<RootModelImpl> iterator2 = result2.iterator();
                if (iterator2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return iterator2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/openapi/roots/impl/ModifiableModelCommitterServiceImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNodes";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIn";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        return new DFSTBuilder(GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)graph2)));
    }

    private static /* synthetic */ void lambda$multiCommit$0(List modelsToCommit, List modelsToDispose) {
        for (RootModelImpl model : modelsToCommit) {
            ModuleRootManagerImpl.doCommit(model);
        }
        for (RootModelImpl model : modelsToDispose) {
            if (model instanceof RootModelImpl) {
                model.checkModuleExtensionModification();
            }
            model.dispose();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModels";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModel";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/ModifiableModelCommitterServiceImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/ModifiableModelCommitterServiceImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedChangedModels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "multiCommit";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSortedChangedModels";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createDFSTBuilder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

