/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.NullableConsumer;
import com.intellij.util.text.UniqueNameGenerator;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkConfigurationUtil {
    private static final Logger LOG = Logger.getInstance(SdkConfigurationUtil.class);

    private SdkConfigurationUtil() {
    }

    public static void createSdk(@Nullable Project project, Sdk @NotNull [] existingSdks, @NotNull NullableConsumer<? super Sdk> onSdkCreatedCallBack, boolean createIfExists, SdkType ... sdkTypes) {
        if (onSdkCreatedCallBack == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(0);
        }
        if (existingSdks == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(1);
        }
        if (sdkTypes == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(2);
        }
        SdkConfigurationUtil.createSdk(project, existingSdks, onSdkCreatedCallBack, createIfExists, true, sdkTypes);
    }

    public static void createSdk(@Nullable Project project, final Sdk @NotNull [] existingSdks, final @NotNull NullableConsumer<? super Sdk> onSdkCreatedCallBack, final boolean createIfExists, boolean followSymLinks, final SdkType ... sdkTypes) {
        if (onSdkCreatedCallBack == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(3);
        }
        if (existingSdks == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(4);
        }
        if (sdkTypes == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(5);
        }
        if (sdkTypes.length == 0) {
            onSdkCreatedCallBack.consume(null);
            return;
        }
        FileChooserDescriptor descriptor2 = SdkConfigurationUtil.createCompositeDescriptor(sdkTypes);
        if (!followSymLinks) {
            descriptor2.setForcedToUseIdeaFileChooser(true);
        }
        VirtualFile suggestedDir = SdkConfigurationUtil.getSuggestedSdkRoot(sdkTypes[0]);
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, (Project)project, (VirtualFile)suggestedDir, (Consumer)new FileChooser.FileChooserConsumer(){

            public void consume(List<VirtualFile> selectedFiles) {
                for (SdkType sdkType : sdkTypes) {
                    String path = selectedFiles.get(0).getPath();
                    if (!sdkType.isValidSdkHome(path)) continue;
                    Sdk newSdk = null;
                    if (!createIfExists) {
                        for (Sdk sdk2 : existingSdks) {
                            if (!path.equals(sdk2.getHomePath())) continue;
                            newSdk = sdk2;
                            break;
                        }
                    }
                    if (newSdk == null) {
                        newSdk = SdkConfigurationUtil.setupSdk(existingSdks, selectedFiles.get(0), sdkType, false, null, null);
                    }
                    onSdkCreatedCallBack.consume(newSdk);
                    return;
                }
                onSdkCreatedCallBack.consume(null);
            }

            public void cancelled() {
                onSdkCreatedCallBack.consume(null);
            }
        });
    }

    public static void createSdk(@Nullable Project project, Sdk @NotNull [] existingSdks, @NotNull NullableConsumer<? super Sdk> onSdkCreatedCallBack, SdkType ... sdkTypes) {
        if (onSdkCreatedCallBack == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(6);
        }
        if (existingSdks == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(7);
        }
        if (sdkTypes == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(8);
        }
        SdkConfigurationUtil.createSdk(project, existingSdks, onSdkCreatedCallBack, true, sdkTypes);
    }

    @NotNull
    private static FileChooserDescriptor createCompositeDescriptor(final SdkType ... sdkTypes) {
        if (sdkTypes == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(9);
        }
        return new FileChooserDescriptor(sdkTypes[0].getHomeChooserDescriptor()){

            public void validateSelectedFiles(VirtualFile @NotNull [] files2) throws Exception {
                if (files2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (files2.length > 0) {
                    for (SdkType type : sdkTypes) {
                        if (!type.isValidSdkHome(files2[0].getPath())) continue;
                        return;
                    }
                }
                String key = files2.length > 0 && files2[0].isDirectory() ? "sdk.configure.home.invalid.error" : "sdk.configure.home.file.invalid.error";
                throw new Exception(ProjectBundle.message((String)key, (Object[])new Object[]{sdkTypes[0].getPresentableName()}));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/projectRoots/impl/SdkConfigurationUtil$2", "validateSelectedFiles"));
            }
        };
    }

    public static void addSdk(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(10);
        }
        ApplicationManager.getApplication().runWriteAction(() -> ProjectJdkTable.getInstance().addJdk(sdk2));
    }

    public static void removeSdk(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(11);
        }
        ApplicationManager.getApplication().runWriteAction(() -> ProjectJdkTable.getInstance().removeJdk(sdk2));
    }

    @Nullable
    public static Sdk setupSdk(Sdk @NotNull [] allSdks, @NotNull VirtualFile homeDir, @NotNull SdkType sdkType, boolean silent, @Nullable SdkAdditionalData additionalData, @Nullable String customSdkSuggestedName) {
        if (homeDir == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(12);
        }
        if (sdkType == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(13);
        }
        if (allSdks == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(14);
        }
        ProjectJdkImpl sdk2 = null;
        try {
            sdk2 = SdkConfigurationUtil.createSdk(Arrays.asList(allSdks), homeDir, sdkType, additionalData, customSdkSuggestedName);
            sdkType.setupSdkPaths((Sdk)sdk2);
        }
        catch (Throwable e) {
            LOG.warn("Error creating or configuring sdk: homeDir=[" + homeDir + "]; sdkType=[" + sdkType + "]; additionalData=[" + additionalData + "]; customSdkSuggestedName=[" + customSdkSuggestedName + "]; sdk=[" + (Object)((Object)sdk2) + "]", e);
            if (!silent) {
                Messages.showErrorDialog((String)ProjectBundle.message((String)"dialog.message.error.configuring.sdk.0.please.make.sure.that.1.is.a.valid.home.path.for.this.sdk.type", (Object[])new Object[]{e.getMessage(), FileUtil.toSystemDependentName((String)homeDir.getPath())}), (String)ProjectBundle.message((String)"dialog.title.error.configuring.sdk", (Object[])new Object[0]));
            }
            return null;
        }
        return sdk2;
    }

    @NotNull
    public static ProjectJdkImpl createSdk(@NotNull Collection<? extends Sdk> allSdks, @NotNull VirtualFile homeDir, @NotNull SdkType sdkType, @Nullable SdkAdditionalData additionalData, @Nullable String customSdkSuggestedName) {
        if (allSdks == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(15);
        }
        if (homeDir == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(16);
        }
        if (sdkType == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(17);
        }
        return SdkConfigurationUtil.createSdk(allSdks, sdkType.sdkPath(homeDir), sdkType, additionalData, customSdkSuggestedName);
    }

    @NotNull
    public static ProjectJdkImpl createSdk(@NotNull Collection<? extends Sdk> allSdks, @NotNull String homePath, @NotNull SdkType sdkType, @Nullable SdkAdditionalData additionalData, @Nullable String customSdkSuggestedName) {
        if (allSdks == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(18);
        }
        if (homePath == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(19);
        }
        if (sdkType == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(20);
        }
        String sdkName = customSdkSuggestedName == null ? SdkConfigurationUtil.createUniqueSdkName(sdkType, homePath, allSdks) : SdkConfigurationUtil.createUniqueSdkName(customSdkSuggestedName, allSdks);
        ProjectJdkImpl sdk2 = new ProjectJdkImpl(sdkName, (SdkTypeId)sdkType);
        if (additionalData != null) {
            sdk2.setSdkAdditionalData(additionalData);
        }
        sdk2.setHomePath(homePath);
        ProjectJdkImpl projectJdkImpl = sdk2;
        if (projectJdkImpl == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(21);
        }
        return projectJdkImpl;
    }

    public static void setDirectoryProjectSdk(@NotNull Project project, @Nullable Sdk sdk2) {
        if (project == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(22);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            ProjectRootManager.getInstance((Project)project).setProjectSdk(sdk2);
            Module[] modules = ModuleManager.getInstance((Project)project).getModules();
            if (modules.length > 0) {
                ModuleRootModificationUtil.setSdkInherited((Module)modules[0]);
            }
        });
    }

    public static void configureDirectoryProjectSdk(@NotNull Project project, @Nullable Comparator<? super Sdk> preferredSdkComparator, SdkType ... sdkTypes) {
        Sdk existingSdk;
        if (project == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(23);
        }
        if (sdkTypes == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(24);
        }
        if ((existingSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk()) != null && ArrayUtil.contains((Object)existingSdk.getSdkType(), (Object[])sdkTypes)) {
            return;
        }
        Sdk sdk2 = SdkConfigurationUtil.findOrCreateSdk(preferredSdkComparator, sdkTypes);
        if (sdk2 != null) {
            SdkConfigurationUtil.setDirectoryProjectSdk(project, sdk2);
        }
    }

    @Nullable
    public static Sdk findOrCreateSdk(@Nullable Comparator<? super Sdk> comparator2, SdkType ... sdkTypes) {
        Project defaultProject;
        Sdk sdk2;
        if (sdkTypes == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(25);
        }
        if ((sdk2 = ProjectRootManager.getInstance((Project)(defaultProject = ProjectManager.getInstance().getDefaultProject())).getProjectSdk()) != null) {
            for (SdkType type : sdkTypes) {
                if (sdk2.getSdkType() != type) continue;
                return sdk2;
            }
        }
        for (SdkType type : sdkTypes) {
            List sdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)type);
            if (sdks.isEmpty()) continue;
            if (comparator2 != null) {
                Collections.sort(sdks, comparator2);
            }
            return (Sdk)sdks.get(0);
        }
        for (SdkType sdkType : sdkTypes) {
            Sdk an_sdk;
            String suggestedHomePath = sdkType.suggestHomePath();
            if (suggestedHomePath == null || !sdkType.isValidSdkHome(suggestedHomePath) || (an_sdk = SdkConfigurationUtil.createAndAddSDK(suggestedHomePath, sdkType)) == null) continue;
            return an_sdk;
        }
        return null;
    }

    @Nullable
    public static Sdk createAndAddSDK(@NotNull String path, @NotNull SdkType sdkType) {
        VirtualFile sdkHome;
        if (path == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(26);
        }
        if (sdkType == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(27);
        }
        if ((sdkHome = (VirtualFile)WriteAction.compute(() -> LocalFileSystem.getInstance().refreshAndFindFileByPath(path))) != null) {
            Sdk newSdk = SdkConfigurationUtil.setupSdk(ProjectJdkTable.getInstance().getAllJdks(), sdkHome, sdkType, true, null, null);
            if (newSdk != null) {
                SdkConfigurationUtil.addSdk(newSdk);
            }
            return newSdk;
        }
        return null;
    }

    @NotNull
    public static String createUniqueSdkName(@NotNull SdkType type, String home, Collection<? extends Sdk> sdks) {
        if (type == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(28);
        }
        return SdkConfigurationUtil.createUniqueSdkName(type.suggestSdkName(null, home), sdks);
    }

    @NotNull
    public static String createUniqueSdkName(@NotNull String suggestedName, @NotNull Collection<? extends Sdk> sdks) {
        if (suggestedName == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(29);
        }
        if (sdks == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(30);
        }
        Set nameList = sdks.stream().map(jdk -> jdk.getName()).collect(Collectors.toSet());
        String string = UniqueNameGenerator.generateUniqueName((String)suggestedName, (String)"", (String)"", (String)" (", (String)")", o -> !nameList.contains(o));
        if (string == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(31);
        }
        return string;
    }

    public static void selectSdkHome(@NotNull SdkType sdkType, @NotNull Consumer<? super String> consumer) {
        if (sdkType == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(32);
        }
        if (consumer == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(33);
        }
        SdkConfigurationUtil.selectSdkHome(sdkType, null, consumer);
    }

    public static void selectSdkHome(@NotNull SdkType sdkType, @Nullable Component component2, @NotNull Consumer<? super String> consumer) {
        if (sdkType == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(34);
        }
        if (consumer == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(35);
        }
        FileChooserDescriptor descriptor2 = sdkType.getHomeChooserDescriptor();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Sdk sdk2 = ProjectJdkTable.getInstance().findMostRecentSdkOfType((SdkTypeId)sdkType);
            if (sdk2 == null) {
                throw new RuntimeException("No SDK of type " + sdkType + " found");
            }
            consumer.consume((Object)sdk2.getHomePath());
            return;
        }
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, null, (Component)component2, (VirtualFile)SdkConfigurationUtil.getSuggestedSdkRoot(sdkType), chosen -> {
            String path = ((VirtualFile)chosen.get(0)).getPath();
            if (sdkType.isValidSdkHome(path)) {
                consumer.consume((Object)path);
                return;
            }
            String adjustedPath = sdkType.adjustSelectedSdkHome(path);
            if (sdkType.isValidSdkHome(adjustedPath)) {
                consumer.consume((Object)adjustedPath);
            }
        });
    }

    @Nullable
    public static VirtualFile getSuggestedSdkRoot(@NotNull SdkType sdkType) {
        String homePath;
        if (sdkType == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(36);
        }
        return (homePath = sdkType.suggestHomePath()) == null ? null : LocalFileSystem.getInstance().findFileByPath(homePath);
    }

    @NotNull
    public static List<String> filterExistingPaths(@NotNull SdkType sdkType, Collection<String> sdkHomes, Sdk[] sdks) {
        if (sdkType == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(37);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        for (String sdkHome : sdkHomes) {
            if (SdkConfigurationUtil.findByPath(sdkType, sdks, sdkHome) != null) continue;
            result2.add(sdkHome);
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(38);
        }
        return arrayList;
    }

    @Nullable
    private static Sdk findByPath(@NotNull SdkType sdkType, Sdk @NotNull [] sdks, @NotNull String sdkHome) {
        if (sdkType == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(39);
        }
        if (sdkHome == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(40);
        }
        if (sdks == null) {
            SdkConfigurationUtil.$$$reportNull$$$0(41);
        }
        for (Sdk sdk2 : sdks) {
            String path = sdk2.getHomePath();
            if (sdk2.getSdkType() != sdkType || path == null || !FileUtil.pathsEqual((String)FileUtil.toSystemIndependentName((String)path), (String)FileUtil.toSystemIndependentName((String)sdkHome))) continue;
            return sdk2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 21: 
            case 31: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 21: 
            case 31: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSdkCreatedCallBack";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingSdks";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkTypes";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homeDir";
                break;
            }
            case 13: 
            case 17: 
            case 20: 
            case 27: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkType";
                break;
            }
            case 14: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allSdks";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 21: 
            case 31: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/SdkConfigurationUtil";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestedName";
                break;
            }
            case 30: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdks";
                break;
            }
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHome";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/SdkConfigurationUtil";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createSdk";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createUniqueSdkName";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "filterExistingPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createSdk";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createCompositeDescriptor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addSdk";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeSdk";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setupSdk";
                break;
            }
            case 21: 
            case 31: 
            case 38: {
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setDirectoryProjectSdk";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "configureDirectoryProjectSdk";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateSdk";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createAndAddSDK";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createUniqueSdkName";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "selectSdkHome";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getSuggestedSdkRoot";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "filterExistingPaths";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "findByPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 21: 
            case 31: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

