/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.projectRoots.impl.JavaHomeFinderBasic;
import com.intellij.openapi.projectRoots.impl.JavaHomeFinderMac;
import com.intellij.openapi.projectRoots.impl.JavaHomeFinderWindows;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.lang.JavaVersion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class JavaHomeFinder {
    @NotNull
    public static List<String> suggestHomePaths() {
        return JavaHomeFinder.suggestHomePaths(false);
    }

    @NotNull
    public static List<String> suggestHomePaths(boolean forceEmbeddedJava) {
        JavaHomeFinderBasic javaFinder = JavaHomeFinder.getFinder(forceEmbeddedJava);
        if (javaFinder == null) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                JavaHomeFinder.$$$reportNull$$$0(0);
            }
            return list2;
        }
        Set<String> foundPaths = javaFinder.findExistingJdks();
        ArrayList<String> paths = new ArrayList<String>(foundPaths);
        paths.sort((o1, o2) -> Comparing.compare((Comparable)JavaVersion.tryParse((String)o2), (Comparable)JavaVersion.tryParse((String)o1)));
        ArrayList<String> arrayList = paths;
        if (arrayList == null) {
            JavaHomeFinder.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static JavaHomeFinderBasic getFinder(boolean forceEmbeddedJava) {
        boolean detectorIsEnabled;
        boolean bl = detectorIsEnabled = forceEmbeddedJava || Registry.is((String)"java.detector.enabled", (boolean)true);
        if (!detectorIsEnabled) {
            return null;
        }
        if (SystemInfo.isWindows) {
            return new JavaHomeFinderWindows(forceEmbeddedJava);
        }
        if (SystemInfo.isMac) {
            return new JavaHomeFinderMac(forceEmbeddedJava);
        }
        if (SystemInfo.isLinux) {
            return new JavaHomeFinderBasic(forceEmbeddedJava, "/usr/java", "/opt/java", "/usr/lib/jvm");
        }
        if (SystemInfo.isSolaris) {
            return new JavaHomeFinderBasic(forceEmbeddedJava, "/usr/jdk");
        }
        return new JavaHomeFinderBasic(forceEmbeddedJava, new String[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/JavaHomeFinder", "suggestHomePaths"));
    }
}

