/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.CommonBundle;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.newEditor.AbstractEditor;
import com.intellij.openapi.options.newEditor.OptionsEditorColleague;
import com.intellij.openapi.options.newEditor.SettingsEditor;
import com.intellij.openapi.options.newEditor.SettingsFilter;
import com.intellij.openapi.options.newEditor.SettingsTreeView;
import com.intellij.openapi.options.newEditor.SingleSettingEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.IdeUICustomization;
import com.intellij.ui.SearchTextField;
import com.intellij.util.ui.JBDimension;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SettingsDialog
extends DialogWrapper
implements DataProvider {
    public static final String DIMENSION_KEY = "SettingsEditor";
    private final String myDimensionServiceKey;
    private final AbstractEditor myEditor;
    private final boolean myApplyButtonNeeded;
    private boolean myResetButtonNeeded;

    public SettingsDialog(Project project, String key, @NotNull Configurable configurable2, boolean showApplyButton, boolean showResetButton) {
        if (configurable2 == null) {
            SettingsDialog.$$$reportNull$$$0(0);
        }
        super(project, true);
        this.myDimensionServiceKey = key;
        this.myEditor = new SingleSettingEditor(this.myDisposable, configurable2);
        this.myApplyButtonNeeded = showApplyButton;
        this.myResetButtonNeeded = showResetButton;
        this.init(configurable2, project);
    }

    public SettingsDialog(@NotNull Component parent, String key, @NotNull Configurable configurable2, boolean showApplyButton, boolean showResetButton) {
        if (parent == null) {
            SettingsDialog.$$$reportNull$$$0(1);
        }
        if (configurable2 == null) {
            SettingsDialog.$$$reportNull$$$0(2);
        }
        super(parent, true);
        this.myDimensionServiceKey = key;
        this.myEditor = new SingleSettingEditor(this.myDisposable, configurable2);
        this.myApplyButtonNeeded = showApplyButton;
        this.myResetButtonNeeded = showResetButton;
        this.init(configurable2, null);
    }

    public SettingsDialog(@NotNull Project project, @NotNull List<? extends ConfigurableGroup> groups, @Nullable Configurable configurable2, @Nullable String filter2) {
        if (project == null) {
            SettingsDialog.$$$reportNull$$$0(3);
        }
        if (groups == null) {
            SettingsDialog.$$$reportNull$$$0(4);
        }
        super(project, true);
        this.myDimensionServiceKey = DIMENSION_KEY;
        this.myEditor = new SettingsEditor(this.myDisposable, project, groups, configurable2, filter2, this::treeViewFactory);
        this.myApplyButtonNeeded = true;
        this.init(null, project);
    }

    public SettingsDialog(@NotNull Project project, @Nullable Component parentComponent, @NotNull List<? extends ConfigurableGroup> groups, @Nullable Configurable configurable2, @Nullable String filter2) {
        if (project == null) {
            SettingsDialog.$$$reportNull$$$0(5);
        }
        if (groups == null) {
            SettingsDialog.$$$reportNull$$$0(6);
        }
        super(project, parentComponent, true, DialogWrapper.IdeModalityType.IDE);
        this.myDimensionServiceKey = DIMENSION_KEY;
        this.myEditor = new SettingsEditor(this.myDisposable, project, groups, configurable2, filter2, this::treeViewFactory);
        this.myApplyButtonNeeded = true;
        this.init(null, project);
    }

    @NotNull
    protected SettingsTreeView treeViewFactory(@NotNull SettingsFilter filter2, @NotNull List<? extends ConfigurableGroup> groups) {
        if (filter2 == null) {
            SettingsDialog.$$$reportNull$$$0(7);
        }
        if (groups == null) {
            SettingsDialog.$$$reportNull$$$0(8);
        }
        return new SettingsTreeView(filter2, groups);
    }

    private void init(@Nullable Configurable configurable2, @Nullable Project project) {
        JRootPane rootPane;
        String name = configurable2 == null ? null : configurable2.getDisplayName();
        String title = CommonBundle.settingsTitle();
        if (project != null && project.isDefault()) {
            title = IdeUICustomization.getInstance().projectMessage("title.for.new.projects", new Object[]{title});
        }
        this.setTitle(name == null ? title : name.replace('\n', ' '));
        ShortcutSet set = SettingsDialog.getFindActionShortcutSet();
        if (set != null) {
            new SearchTextField.FindAction().registerCustomShortcutSet(set, (JComponent)this.getRootPane(), this.myDisposable);
        }
        this.init();
        if (configurable2 == null && (rootPane = this.getPeer().getRootPane()) != null) {
            rootPane.setMinimumSize((Dimension)new JBDimension(900, 700));
        }
    }

    protected void setHelpTooltip(JButton helpButton) {
        if (Registry.is((String)"ide.helptooltip.enabled")) {
            new HelpTooltip().setDescription(ActionsBundle.actionDescription((String)"HelpTopics")).installOn((JComponent)helpButton);
        } else {
            super.setHelpTooltip(helpButton);
        }
    }

    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            SettingsDialog.$$$reportNull$$$0(9);
        }
        if (this.myEditor instanceof DataProvider) {
            DataProvider provider = (DataProvider)this.myEditor;
            return provider.getData(dataId);
        }
        return null;
    }

    protected String getDimensionServiceKey() {
        return this.myDimensionServiceKey;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myEditor.getPreferredFocusedComponent();
    }

    public boolean isTypeAheadEnabled() {
        return true;
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        DialogWrapper.DialogStyle dialogStyle = DialogWrapper.DialogStyle.COMPACT;
        if (dialogStyle == null) {
            SettingsDialog.$$$reportNull$$$0(10);
        }
        return dialogStyle;
    }

    protected JComponent createCenterPanel() {
        return this.myEditor;
    }

    protected void tryAddOptionsListener(OptionsEditorColleague colleague) {
        if (this.myEditor instanceof SettingsEditor) {
            ((SettingsEditor)this.myEditor).addOptionsListener(colleague);
        }
    }

    protected Action @NotNull [] createActions() {
        Action reset2;
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(this.getOKAction());
        actions.add(this.getCancelAction());
        Action apply2 = this.myEditor.getApplyAction();
        if (apply2 != null && this.myApplyButtonNeeded) {
            actions.add(apply2);
        }
        if ((reset2 = this.myEditor.getResetAction()) != null && this.myResetButtonNeeded) {
            actions.add(reset2);
        }
        if (this.getHelpId() != null) {
            actions.add(this.getHelpAction());
        }
        Action[] actionArray = actions.toArray(new Action[0]);
        if (actionArray == null) {
            SettingsDialog.$$$reportNull$$$0(11);
        }
        return actionArray;
    }

    @Nullable
    protected String getHelpId() {
        return this.myEditor.getHelpTopic();
    }

    public void doOKAction() {
        this.applyAndClose(true);
    }

    public void applyAndClose(boolean scheduleSave) {
        if (this.myEditor.apply()) {
            if (scheduleSave) {
                SaveAndSyncHandler.getInstance().scheduleSave(new SaveAndSyncHandler.SaveTask(null, false, true), false);
            }
            super.doOKAction();
        }
    }

    public void doCancelAction(AWTEvent source) {
        if ((source instanceof KeyEvent || source instanceof ActionEvent) && !this.myEditor.cancel(source)) {
            return;
        }
        super.doCancelAction(source);
    }

    @Nullable
    static ShortcutSet getFindActionShortcutSet() {
        AnAction action2 = ActionManager.getInstance().getAction("Find");
        return action2 == null ? null : action2.getShortcutSet();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/newEditor/SettingsDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/newEditor/SettingsDialog";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyle";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "treeViewFactory";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

