/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPointChangeListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.MasterDetails;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableVisitor;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.CardLayoutPanel;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.GradientViewport;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class ConfigurableCardPanel
extends CardLayoutPanel<Configurable, Configurable, JComponent> {
    private static final Logger LOG = Logger.getInstance(ConfigurableCardPanel.class);
    private final Map<Configurable, Disposable> myListeners = new ConcurrentHashMap<Configurable, Disposable>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Configurable prepare(Configurable key) {
        long time = System.currentTimeMillis();
        try {
            ConfigurableWrapper.cast(Configurable.class, (UnnamedConfigurable)key);
        }
        catch (Exception unexpected) {
            LOG.error("cannot prepare configurable", (Throwable)unexpected);
        }
        finally {
            ConfigurableCardPanel.warn(key, "prepare", time);
        }
        return key;
    }

    @Override
    protected JComponent create(Configurable configurable2) {
        if (configurable2 == null) {
            return null;
        }
        return (JComponent)ReadAction.compute(() -> {
            JComponent component2 = ConfigurableCardPanel.createConfigurableComponent(configurable2);
            if (configurable2 instanceof ConfigurableWrapper && component2 != null) {
                this.addEPChangesListener((ConfigurableWrapper)configurable2);
            }
            return component2;
        });
    }

    protected void addEPChangesListener(@NotNull ConfigurableWrapper wrapper2) {
        if (wrapper2 == null) {
            ConfigurableCardPanel.$$$reportNull$$$0(0);
        }
        if (wrapper2.getExtensionPoint().dynamic) {
            return;
        }
        Configurable.WithEpDependencies configurable2 = ConfigurableWrapper.cast(Configurable.WithEpDependencies.class, (UnnamedConfigurable)wrapper2);
        if (configurable2 != null && !this.myListeners.containsKey(wrapper2)) {
            Disposable disposable2 = Disposer.newDisposable();
            Collection dependencies = configurable2.getDependencies();
            ExtensionPointChangeListener listener2 = () -> ApplicationManager.getApplication().invokeLater(() -> {
                wrapper2.disposeUIResources();
                this.resetValue(wrapper2);
            }, ModalityState.stateForComponent((Component)this), __ -> this.isDisposed());
            for (BaseExtensionPointName dependency : dependencies) {
                if (dependency instanceof ExtensionPointName) {
                    Extensions.getRootArea().getExtensionPoint(dependency.getName()).addExtensionPointListener(listener2, false, disposable2);
                    continue;
                }
                if (!(dependency instanceof ProjectExtensionPointName)) continue;
                Project project = wrapper2.getProject();
                assert (project != null);
                ((ProjectExtensionPointName)dependency).getPoint((AreaInstance)project).addExtensionPointListener(listener2, false, disposable2);
            }
            this.myListeners.put((Configurable)wrapper2, disposable2);
        }
    }

    public static JComponent createConfigurableComponent(Configurable configurable2) {
        return configurable2 == null ? null : (JComponent)ReadAction.compute(() -> {
            JComponent component2 = null;
            long time = System.currentTimeMillis();
            try {
                component2 = configurable2.createComponent();
            }
            catch (Exception unexpected) {
                LOG.error("cannot create configurable component", (Throwable)unexpected);
            }
            finally {
                ConfigurableCardPanel.warn(configurable2, "create", time);
            }
            if (component2 != null) {
                ConfigurableCardPanel.reset(configurable2);
                if (ConfigurableWrapper.cast(MasterDetails.class, (UnnamedConfigurable)configurable2) == null) {
                    if (ConfigurableWrapper.cast(Configurable.NoMargin.class, (UnnamedConfigurable)configurable2) == null) {
                        if (!component2.getClass().equals(JPanel.class) && !component2.getClass().equals(DialogPanel.class)) {
                            JPanel panel2 = new JPanel(new BorderLayout());
                            panel2.add("Center", component2);
                            component2 = panel2;
                        }
                        component2.setBorder((Border)JBUI.Borders.empty((int)11, (int)16, (int)16, (int)16));
                    }
                    if (ConfigurableWrapper.cast(Configurable.NoScroll.class, (UnnamedConfigurable)configurable2) == null) {
                        JScrollPane scroll = ScrollPaneFactory.createScrollPane(null, (boolean)true);
                        scroll.setViewport((JViewport)((Object)new GradientViewport(component2, (Insets)JBUI.insetsTop((int)5), true)));
                        scroll.getVerticalScrollBar().setBackground(JBColor.PanelBackground);
                        scroll.getHorizontalScrollBar().setBackground(JBColor.PanelBackground);
                        component2 = scroll;
                    }
                }
            }
            return component2;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dispose(Configurable configurable2) {
        if (configurable2 != null) {
            long time = System.currentTimeMillis();
            try {
                configurable2.disposeUIResources();
                Disposable disposer = this.myListeners.remove(configurable2);
                if (disposer != null) {
                    Disposer.dispose((Disposable)disposer);
                }
            }
            catch (Exception unexpected) {
                LOG.error("cannot dispose configurable", (Throwable)unexpected);
            }
            finally {
                ConfigurableCardPanel.warn(configurable2, "dispose", time);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset(Configurable configurable2) {
        if (configurable2 != null) {
            long time = System.currentTimeMillis();
            try {
                configurable2.reset();
            }
            catch (Exception unexpected) {
                LOG.error("cannot reset configurable", (Throwable)unexpected);
            }
            finally {
                ConfigurableCardPanel.warn(configurable2, "reset", time);
            }
        }
    }

    static void warn(Configurable configurable2, String action2, long time) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            time = System.currentTimeMillis() - time;
            int threshold = Registry.intValue((String)"ide.settings.configurable.loading.threshold", (int)0);
            if (0 < threshold && (long)threshold < time) {
                String name = configurable2.getDisplayName();
                String id2 = ConfigurableVisitor.getId(configurable2);
                LOG.warn(time + " ms to " + action2 + " '" + name + "' id=" + id2);
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        for (Disposable value2 : this.myListeners.values()) {
            Disposer.dispose((Disposable)value2);
        }
        this.myListeners.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapper", "com/intellij/openapi/options/ex/ConfigurableCardPanel", "addEPChangesListener"));
    }
}

