/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class RemovedMappingTracker {
    private final Map<FileNameMatcher, RemovedMapping> myRemovedMappings = new HashMap<FileNameMatcher, RemovedMapping>();
    @NonNls
    private static final String ELEMENT_REMOVED_MAPPING = "removed_mapping";
    @NonNls
    private static final String ATTRIBUTE_APPROVED = "approved";
    @NonNls
    private static final String ATTRIBUTE_TYPE = "type";

    RemovedMappingTracker() {
    }

    void clear() {
        this.myRemovedMappings.clear();
    }

    public void add(@NotNull FileNameMatcher matcher, @NotNull String fileTypeName, boolean approved) {
        if (matcher == null) {
            RemovedMappingTracker.$$$reportNull$$$0(0);
        }
        if (fileTypeName == null) {
            RemovedMappingTracker.$$$reportNull$$$0(1);
        }
        this.myRemovedMappings.put(matcher, new RemovedMapping(matcher, fileTypeName, approved));
    }

    public void load(@NotNull Element e) {
        if (e == null) {
            RemovedMappingTracker.$$$reportNull$$$0(2);
        }
        for (RemovedMapping mapping2 : RemovedMappingTracker.readRemovedMappings(e)) {
            this.myRemovedMappings.put(mapping2.myFileNameMatcher, mapping2);
        }
    }

    @NotNull
    static List<RemovedMapping> readRemovedMappings(@NotNull Element e) {
        List children2;
        if (e == null) {
            RemovedMappingTracker.$$$reportNull$$$0(3);
        }
        if ((children2 = e.getChildren(ELEMENT_REMOVED_MAPPING)).isEmpty()) {
            List<RemovedMapping> list2 = Collections.emptyList();
            if (list2 == null) {
                RemovedMappingTracker.$$$reportNull$$$0(4);
            }
            return list2;
        }
        ArrayList<RemovedMapping> result2 = new ArrayList<RemovedMapping>();
        for (Element mapping2 : children2) {
            String ext = mapping2.getAttributeValue("ext");
            ExtensionFileNameMatcher matcher = ext == null ? FileTypeManager.parseFromString((String)mapping2.getAttributeValue("pattern")) : new ExtensionFileNameMatcher(ext);
            boolean approved = Boolean.parseBoolean(mapping2.getAttributeValue(ATTRIBUTE_APPROVED));
            String fileTypeName = mapping2.getAttributeValue(ATTRIBUTE_TYPE);
            if (fileTypeName == null) continue;
            RemovedMapping removedMapping = new RemovedMapping((FileNameMatcher)matcher, fileTypeName, approved);
            result2.add(removedMapping);
        }
        ArrayList<RemovedMapping> arrayList = result2;
        if (arrayList == null) {
            RemovedMappingTracker.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public void save(@NotNull Element element2) {
        if (element2 == null) {
            RemovedMappingTracker.$$$reportNull$$$0(6);
        }
        for (RemovedMapping mapping2 : this.myRemovedMappings.values()) {
            Element content2 = RemovedMappingTracker.writeRemovedMapping(mapping2.myFileTypeName, mapping2.myFileNameMatcher, true, mapping2.myApproved);
            if (content2 == null) continue;
            element2.addContent(content2);
        }
    }

    void saveRemovedMappingsForFileType(@NotNull Element map2, @NotNull String fileTypeName, @NotNull Set<? extends FileNameMatcher> associations, boolean specifyTypeName) {
        if (map2 == null) {
            RemovedMappingTracker.$$$reportNull$$$0(7);
        }
        if (fileTypeName == null) {
            RemovedMappingTracker.$$$reportNull$$$0(8);
        }
        if (associations == null) {
            RemovedMappingTracker.$$$reportNull$$$0(9);
        }
        for (FileNameMatcher fileNameMatcher : associations) {
            Element content2 = RemovedMappingTracker.writeRemovedMapping(fileTypeName, fileNameMatcher, specifyTypeName, this.isApproved(fileNameMatcher));
            if (content2 == null) continue;
            map2.addContent(content2);
        }
    }

    boolean hasRemovedMapping(@NotNull FileNameMatcher matcher) {
        if (matcher == null) {
            RemovedMappingTracker.$$$reportNull$$$0(10);
        }
        return this.myRemovedMappings.containsKey(matcher);
    }

    private boolean isApproved(@NotNull FileNameMatcher matcher) {
        RemovedMapping mapping2;
        if (matcher == null) {
            RemovedMappingTracker.$$$reportNull$$$0(11);
        }
        return (mapping2 = this.myRemovedMappings.get(matcher)) != null && mapping2.isApproved();
    }

    void approveRemoval(@NotNull String fileTypeName, @NotNull FileNameMatcher matcher) {
        if (fileTypeName == null) {
            RemovedMappingTracker.$$$reportNull$$$0(12);
        }
        if (matcher == null) {
            RemovedMappingTracker.$$$reportNull$$$0(13);
        }
        this.myRemovedMappings.put(matcher, new RemovedMapping(matcher, fileTypeName, true));
    }

    @NotNull
    public List<RemovedMapping> getRemovedMappings() {
        return new ArrayList<RemovedMapping>(this.myRemovedMappings.values());
    }

    List<FileNameMatcher> getMappingsForFileType(@NotNull String name) {
        if (name == null) {
            RemovedMappingTracker.$$$reportNull$$$0(14);
        }
        ArrayList<FileNameMatcher> result2 = new ArrayList<FileNameMatcher>();
        for (RemovedMapping mapping2 : this.myRemovedMappings.values()) {
            if (!mapping2.myFileTypeName.equals(name)) continue;
            result2.add(mapping2.myFileNameMatcher);
        }
        return result2;
    }

    void removeMatching(@NotNull BiPredicate<? super FileNameMatcher, ? super String> predicate) {
        if (predicate == null) {
            RemovedMappingTracker.$$$reportNull$$$0(15);
        }
        this.myRemovedMappings.entrySet().removeIf(next -> predicate.test(((RemovedMapping)next.getValue()).myFileNameMatcher, ((RemovedMapping)next.getValue()).myFileTypeName));
    }

    @NotNull
    List<RemovedMapping> retrieveUnapprovedMappings() {
        ArrayList<RemovedMapping> result2 = new ArrayList<RemovedMapping>();
        Iterator<Map.Entry<FileNameMatcher, RemovedMapping>> it = this.myRemovedMappings.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<FileNameMatcher, RemovedMapping> next = it.next();
            if (next.getValue().isApproved()) continue;
            result2.add(next.getValue());
            it.remove();
        }
        ArrayList<RemovedMapping> arrayList = result2;
        if (arrayList == null) {
            RemovedMappingTracker.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    private static Element writeRemovedMapping(@NotNull String fileTypeName, @NotNull FileNameMatcher matcher, boolean specifyTypeName, boolean approved) {
        if (fileTypeName == null) {
            RemovedMappingTracker.$$$reportNull$$$0(17);
        }
        if (matcher == null) {
            RemovedMappingTracker.$$$reportNull$$$0(18);
        }
        Element mapping2 = new Element(ELEMENT_REMOVED_MAPPING);
        if (matcher instanceof ExtensionFileNameMatcher) {
            mapping2.setAttribute("ext", ((ExtensionFileNameMatcher)matcher).getExtension());
        } else if (AbstractFileType.writePattern(matcher, mapping2)) {
            return null;
        }
        if (approved) {
            mapping2.setAttribute(ATTRIBUTE_APPROVED, "true");
        }
        if (specifyTypeName) {
            mapping2.setAttribute(ATTRIBUTE_TYPE, fileTypeName);
        }
        return mapping2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 1: 
            case 8: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeName";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/impl/RemovedMappingTracker";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "associations";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/impl/RemovedMappingTracker";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "readRemovedMappings";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveUnapprovedMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readRemovedMappings";
                break;
            }
            case 4: 
            case 5: 
            case 16: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "saveRemovedMappingsForFileType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasRemovedMapping";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isApproved";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "approveRemoval";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getMappingsForFileType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeMatching";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "writeRemovedMapping";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class RemovedMapping {
        private final FileNameMatcher myFileNameMatcher;
        private final String myFileTypeName;
        private boolean myApproved;

        private RemovedMapping(@NotNull FileNameMatcher matcher, @NotNull String name, boolean approved) {
            if (matcher == null) {
                RemovedMapping.$$$reportNull$$$0(0);
            }
            if (name == null) {
                RemovedMapping.$$$reportNull$$$0(1);
            }
            this.myFileNameMatcher = matcher;
            this.myFileTypeName = name;
            this.myApproved = approved;
        }

        public FileNameMatcher getFileNameMatcher() {
            return this.myFileNameMatcher;
        }

        public String getFileTypeName() {
            return this.myFileTypeName;
        }

        public boolean isApproved() {
            return this.myApproved;
        }

        public void setApproved(boolean approved) {
            this.myApproved = approved;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "matcher";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/fileTypes/impl/RemovedMappingTracker$RemovedMapping";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

