/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorEmptyTextPainter {
    public void paintEmptyText(@NotNull JComponent splitters, @NotNull Graphics g) {
        if (splitters == null) {
            EditorEmptyTextPainter.$$$reportNull$$$0(0);
        }
        if (g == null) {
            EditorEmptyTextPainter.$$$reportNull$$$0(1);
        }
        UISettings.setupAntialiasing((Graphics)g);
        UIUtil.TextPainter painter = EditorEmptyTextPainter.createTextPainter();
        this.advertiseActions(splitters, painter);
        painter.draw(g, (width, height) -> {
            Dimension s = splitters.getSize();
            int w = (s.width - width) / 2;
            int h = (int)((double)s.height * this.heightRatio());
            return Couple.of((Object)w, (Object)h);
        });
    }

    protected double heightRatio() {
        return 0.375;
    }

    protected void advertiseActions(@NotNull JComponent splitters, @NotNull UIUtil.TextPainter painter) {
        if (splitters == null) {
            EditorEmptyTextPainter.$$$reportNull$$$0(2);
        }
        if (painter == null) {
            EditorEmptyTextPainter.$$$reportNull$$$0(3);
        }
        this.appendSearchEverywhere(painter);
        this.appendToolWindow(painter, IdeBundle.message((String)"empty.text.project.view", (Object[])new Object[0]), "Project", splitters);
        this.appendAction(painter, IdeBundle.message((String)"empty.text.go.to.file", (Object[])new Object[0]), this.getActionShortcutText("GotoFile"));
        this.appendAction(painter, IdeBundle.message((String)"empty.text.recent.files", (Object[])new Object[0]), this.getActionShortcutText("RecentFiles"));
        this.appendAction(painter, IdeBundle.message((String)"empty.text.navigation.bar", (Object[])new Object[0]), this.getActionShortcutText("ShowNavBar"));
        this.appendDnd(painter);
    }

    protected void appendDnd(@NotNull UIUtil.TextPainter painter) {
        if (painter == null) {
            EditorEmptyTextPainter.$$$reportNull$$$0(4);
        }
        this.appendLine(painter, IdeBundle.message((String)"empty.text.drop.files.to.open", (Object[])new Object[0]));
    }

    protected void appendSearchEverywhere(@NotNull UIUtil.TextPainter painter) {
        if (painter == null) {
            EditorEmptyTextPainter.$$$reportNull$$$0(5);
        }
        Shortcut[] shortcuts = KeymapUtil.getActiveKeymapShortcuts((String)"SearchEverywhere").getShortcuts();
        String message = IdeBundle.message((String)"double.ctrl.or.shift.shortcut", (Object[])new Object[]{SystemInfo.isMac ? "\u21e7" : "Shift"});
        this.appendAction(painter, IdeBundle.message((String)"empty.text.search.everywhere", (Object[])new Object[0]), shortcuts.length == 0 ? message : KeymapUtil.getShortcutsText((Shortcut[])shortcuts));
    }

    protected void appendToolWindow(@NotNull UIUtil.TextPainter painter, @NotNull @Nls String action2, @NotNull String toolWindowId, @NotNull JComponent splitters) {
        if (painter == null) {
            EditorEmptyTextPainter.$$$reportNull$$$0(6);
        }
        if (action2 == null) {
            EditorEmptyTextPainter.$$$reportNull$$$0(7);
        }
        if (toolWindowId == null) {
            EditorEmptyTextPainter.$$$reportNull$$$0(8);
        }
        if (splitters == null) {
            EditorEmptyTextPainter.$$$reportNull$$$0(9);
        }
        if (!EditorEmptyTextPainter.isToolwindowVisible(splitters, toolWindowId)) {
            String activateActionId = ActivateToolWindowAction.getActionIdForToolWindow(toolWindowId);
            this.appendAction(painter, action2, this.getActionShortcutText(activateActionId));
        }
    }

    protected void appendAction(@NotNull UIUtil.TextPainter painter, @NotNull @Nls String action2, @Nullable String shortcut) {
        if (painter == null) {
            EditorEmptyTextPainter.$$$reportNull$$$0(10);
        }
        if (action2 == null) {
            EditorEmptyTextPainter.$$$reportNull$$$0(11);
        }
        if (StringUtil.isEmpty((String)shortcut)) {
            return;
        }
        this.appendLine(painter, action2 + " <shortcut>" + shortcut + "</shortcut>");
    }

    protected void appendLine(@NotNull UIUtil.TextPainter painter, @NotNull String line) {
        if (painter == null) {
            EditorEmptyTextPainter.$$$reportNull$$$0(12);
        }
        if (line == null) {
            EditorEmptyTextPainter.$$$reportNull$$$0(13);
        }
        painter.appendLine(line);
    }

    @NotNull
    protected String getActionShortcutText(@NonNls @NotNull String actionId) {
        if (actionId == null) {
            EditorEmptyTextPainter.$$$reportNull$$$0(14);
        }
        String string = KeymapUtil.getFirstKeyboardShortcutText((String)actionId);
        if (string == null) {
            EditorEmptyTextPainter.$$$reportNull$$$0(15);
        }
        return string;
    }

    protected static boolean isToolwindowVisible(@NotNull JComponent splitters, @NotNull String toolwindowId) {
        Project project;
        ProjectFrameHelper frame;
        if (splitters == null) {
            EditorEmptyTextPainter.$$$reportNull$$$0(16);
        }
        if (toolwindowId == null) {
            EditorEmptyTextPainter.$$$reportNull$$$0(17);
        }
        if ((frame = ProjectFrameHelper.getFrameHelper(SwingUtilities.getWindowAncestor(splitters))) != null && (project = frame.getProject()) != null) {
            if (!project.isInitialized()) {
                return true;
            }
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(toolwindowId);
            return toolWindow != null && toolWindow.isVisible();
        }
        return false;
    }

    @NotNull
    public static UIUtil.TextPainter createTextPainter() {
        UIUtil.TextPainter textPainter = new UIUtil.TextPainter().withLineSpacing(1.8f).withColor((Color)JBColor.namedColor((String)"Editor.foreground", (Color)new JBColor((Color)Gray._80, (Color)Gray._160))).withFont((Font)JBUI.Fonts.label((float)16.0f));
        if (textPainter == null) {
            EditorEmptyTextPainter.$$$reportNull$$$0(18);
        }
        return textPainter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "splitters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "painter";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowId";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/EditorEmptyTextPainter";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolwindowId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/EditorEmptyTextPainter";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionShortcutText";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextPainter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "paintEmptyText";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "advertiseActions";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "appendDnd";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendSearchEverywhere";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "appendToolWindow";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "appendAction";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "appendLine";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getActionShortcutText";
                break;
            }
            case 15: 
            case 18: {
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isToolwindowVisible";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

