/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractDependencyData;
import com.intellij.openapi.externalSystem.model.project.DependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.Named;
import com.intellij.openapi.externalSystem.model.project.OrderAware;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.project.dependencies.ComponentDependencies;
import com.intellij.openapi.externalSystem.model.project.dependencies.DependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.DependencyScopeNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.FileCollectionDependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.ProjectDependencies;
import com.intellij.openapi.externalSystem.model.project.dependencies.ProjectDependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.ReferenceNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.UnknownDependencyNode;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProviderImpl;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.externalSystem.view.ExternalProjectsStructure;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.ExternalSystemViewContributor;
import com.intellij.openapi.externalSystem.view.ModuleNode;
import com.intellij.openapi.externalSystem.view.TasksNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TLongObjectHashMap;
import java.awt.event.InputEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.lang.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemViewDefaultContributor
extends ExternalSystemViewContributor {
    private static final Key<?>[] KEYS = new Key[]{ProjectKeys.MODULE, ProjectKeys.DEPENDENCIES_GRAPH, ProjectKeys.MODULE_DEPENDENCY, ProjectKeys.LIBRARY_DEPENDENCY, ProjectKeys.TASK};

    @Override
    @NotNull
    public ProjectSystemId getSystemId() {
        ProjectSystemId projectSystemId = ProjectSystemId.IDE;
        if (projectSystemId == null) {
            ExternalSystemViewDefaultContributor.$$$reportNull$$$0(0);
        }
        return projectSystemId;
    }

    @Override
    @NotNull
    public List<Key<?>> getKeys() {
        List<Key<?>> list2 = Arrays.asList(KEYS);
        if (list2 == null) {
            ExternalSystemViewDefaultContributor.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<ExternalSystemNode<?>> createNodes(ExternalProjectsView externalProjectsView, MultiMap<Key<?>, DataNode<?>> dataNodes) {
        SmartList result2 = new SmartList();
        ExternalSystemViewDefaultContributor.addModuleNodes(externalProjectsView, dataNodes, result2);
        Collection tasksNodes = dataNodes.get((Object)ProjectKeys.TASK);
        if (!tasksNodes.isEmpty()) {
            TasksNode tasksNode = new TasksNode(externalProjectsView, tasksNodes);
            if (externalProjectsView.useTasksNode()) {
                result2.add(tasksNode);
            } else {
                ContainerUtil.addAll((Collection)result2, (Object[])tasksNode.getChildren());
            }
        }
        ExternalSystemViewDefaultContributor.addDependenciesNode(externalProjectsView, dataNodes, result2);
        SmartList smartList = result2;
        if (smartList == null) {
            ExternalSystemViewDefaultContributor.$$$reportNull$$$0(2);
        }
        return smartList;
    }

    @Override
    @Nullable
    public String getDisplayName(@NotNull DataNode node) {
        if (node == null) {
            ExternalSystemViewDefaultContributor.$$$reportNull$$$0(3);
        }
        return ExternalSystemViewDefaultContributor.getNodeDisplayName(node);
    }

    private static void addDependenciesNode(@NotNull ExternalProjectsView externalProjectsView, @NotNull MultiMap<Key<?>, DataNode<?>> dataNodes, @NotNull List<? super ExternalSystemNode<?>> result2) {
        Collection depsGraph;
        if (externalProjectsView == null) {
            ExternalSystemViewDefaultContributor.$$$reportNull$$$0(4);
        }
        if (dataNodes == null) {
            ExternalSystemViewDefaultContributor.$$$reportNull$$$0(5);
        }
        if (result2 == null) {
            ExternalSystemViewDefaultContributor.$$$reportNull$$$0(6);
        }
        if (!(depsGraph = dataNodes.get((Object)ProjectKeys.DEPENDENCIES_GRAPH)).isEmpty()) {
            MyDependenciesNode depNode = new MyDependenciesNode(externalProjectsView);
            for (DataNode dataNode : depsGraph) {
                if (!(dataNode.getData() instanceof ProjectDependencies)) continue;
                ProjectDependencies projectDependencies = (ProjectDependencies)dataNode.getData();
                for (ComponentDependencies componentDependencies : projectDependencies.getComponentsDependencies()) {
                    depNode.add(new DependencyScopeExternalSystemNode(externalProjectsView, componentDependencies.getCompileDependenciesGraph()));
                    depNode.add(new DependencyScopeExternalSystemNode(externalProjectsView, componentDependencies.getRuntimeDependenciesGraph()));
                }
            }
            if (depNode.hasChildren()) {
                result2.add(depNode);
            }
            return;
        }
        Collection moduleDeps = dataNodes.get((Object)ProjectKeys.MODULE_DEPENDENCY);
        Collection libDeps = dataNodes.get((Object)ProjectKeys.LIBRARY_DEPENDENCY);
        if (!moduleDeps.isEmpty() || !libDeps.isEmpty()) {
            MyDependenciesNode depNode = new MyDependenciesNode(externalProjectsView);
            boolean addDepNode = false;
            for (DataNode dataNode : moduleDeps) {
                if (!(dataNode.getData() instanceof ModuleDependencyData)) continue;
                ModuleDependencyDataExternalSystemNode moduleDependencyDataExternalSystemNode = new ModuleDependencyDataExternalSystemNode(externalProjectsView, (DataNode<ModuleDependencyData>)dataNode);
                if (dataNode.getParent() != null && dataNode.getParent().getData() instanceof AbstractDependencyData) {
                    result2.add(moduleDependencyDataExternalSystemNode);
                    continue;
                }
                depNode.add(moduleDependencyDataExternalSystemNode);
                addDepNode = true;
            }
            for (DataNode dataNode : libDeps) {
                if (!(dataNode.getData() instanceof LibraryDependencyData)) continue;
                LibraryDependencyDataExternalSystemNode libraryDependencyDataExternalSystemNode = new LibraryDependencyDataExternalSystemNode(externalProjectsView, (DataNode<LibraryDependencyData>)dataNode);
                if (((LibraryData)((LibraryDependencyData)dataNode.getData()).getTarget()).isUnresolved()) {
                    libraryDependencyDataExternalSystemNode.setErrorLevel(ExternalProjectsStructure.ErrorLevel.ERROR, "Unable to resolve " + ((LibraryData)((LibraryDependencyData)dataNode.getData()).getTarget()).getExternalName());
                } else {
                    libraryDependencyDataExternalSystemNode.setErrorLevel(ExternalProjectsStructure.ErrorLevel.NONE, new String[0]);
                }
                if (dataNode.getParent() != null && dataNode.getParent().getData() instanceof ModuleData) {
                    depNode.add(libraryDependencyDataExternalSystemNode);
                    addDepNode = true;
                    continue;
                }
                result2.add(libraryDependencyDataExternalSystemNode);
            }
            if (addDepNode) {
                result2.add(depNode);
            }
        }
    }

    private static void addModuleNodes(@NotNull ExternalProjectsView externalProjectsView, @NotNull MultiMap<Key<?>, DataNode<?>> dataNodes, @NotNull List<? super ExternalSystemNode<?>> result2) {
        Collection moduleDataNodes;
        if (externalProjectsView == null) {
            ExternalSystemViewDefaultContributor.$$$reportNull$$$0(7);
        }
        if (dataNodes == null) {
            ExternalSystemViewDefaultContributor.$$$reportNull$$$0(8);
        }
        if (result2 == null) {
            ExternalSystemViewDefaultContributor.$$$reportNull$$$0(9);
        }
        if (!(moduleDataNodes = dataNodes.get((Object)ProjectKeys.MODULE)).isEmpty()) {
            AbstractExternalSystemSettings systemSettings = ExternalSystemApiUtil.getSettings((Project)externalProjectsView.getProject(), (ProjectSystemId)externalProjectsView.getSystemId());
            HashMap<String, ModuleNode> groupToModule = new HashMap<String, ModuleNode>(moduleDataNodes.size());
            ArrayList<ModuleNode> moduleNodes = new ArrayList<ModuleNode>();
            for (DataNode dataNode : moduleDataNodes) {
                ModuleData data2 = (ModuleData)dataNode.getData();
                ExternalProjectSettings projectSettings = systemSettings.getLinkedProjectSettings(data2.getLinkedExternalProjectPath());
                DataNode projectDataNode = ExternalSystemApiUtil.findParent((DataNode)dataNode, (Key)ProjectKeys.PROJECT);
                boolean isRoot = projectSettings != null && data2.getLinkedExternalProjectPath().equals(projectSettings.getExternalProjectPath()) && projectDataNode != null && ((ProjectData)projectDataNode.getData()).getInternalName().equals(data2.getInternalName());
                ModuleNode moduleNode = new ModuleNode(externalProjectsView, (DataNode<ModuleData>)dataNode, null, isRoot);
                moduleNodes.add(moduleNode);
                String group = moduleNode.getIdeGrouping();
                if (group == null) continue;
                groupToModule.put(group, moduleNode);
            }
            for (ModuleNode moduleNode : moduleNodes) {
                ModuleNode parent;
                moduleNode.setAllModules(moduleNodes);
                String parentGroup = moduleNode.getIdeParentGrouping();
                ModuleNode moduleNode2 = parent = parentGroup != null ? (ModuleNode)groupToModule.get(parentGroup) : null;
                if (parent == null) continue;
                moduleNode.setParent(parent);
            }
            result2.addAll(moduleNodes);
        }
    }

    @NotNull
    private static String getNodeDisplayName(@NotNull DataNode<?> node) {
        Object data2;
        if (node == null) {
            ExternalSystemViewDefaultContributor.$$$reportNull$$$0(10);
        }
        if ((data2 = node.getData()) instanceof LibraryDependencyData) {
            LibraryDependencyData libraryDependencyData = (LibraryDependencyData)data2;
            String externalName = libraryDependencyData.getExternalName();
            if (StringUtil.isEmpty((String)externalName)) {
                Set paths = ((LibraryData)libraryDependencyData.getTarget()).getPaths(LibraryPathType.BINARY);
                if (paths.size() == 1) {
                    String relativePathToRoot = null;
                    String path = ExternalSystemApiUtil.toCanonicalPath((String)((String)paths.iterator().next()));
                    DataNode projectDataDataNode = ExternalSystemApiUtil.findParent(node, (Key)ProjectKeys.PROJECT);
                    if (projectDataDataNode != null) {
                        relativePathToRoot = FileUtil.getRelativePath((String)((ProjectData)projectDataDataNode.getData()).getLinkedExternalProjectPath(), (String)path, (char)'/');
                        relativePathToRoot = relativePathToRoot != null && StringUtil.startsWith((CharSequence)relativePathToRoot, (CharSequence)"../../") ? new File(relativePathToRoot).getName() : relativePathToRoot;
                    }
                    String string = (String)ObjectUtils.notNull(relativePathToRoot, (Object)path);
                    if (string == null) {
                        ExternalSystemViewDefaultContributor.$$$reportNull$$$0(11);
                    }
                    return string;
                }
                return "<file set>";
            }
            String string = externalName;
            if (string == null) {
                ExternalSystemViewDefaultContributor.$$$reportNull$$$0(12);
            }
            return string;
        }
        if (data2 instanceof Named) {
            String string = ((Named)data2).getExternalName();
            if (string == null) {
                ExternalSystemViewDefaultContributor.$$$reportNull$$$0(13);
            }
            return string;
        }
        if (data2 instanceof TaskData) {
            String string = ((TaskData)data2).getName();
            if (string == null) {
                ExternalSystemViewDefaultContributor.$$$reportNull$$$0(14);
            }
            return string;
        }
        String string = StringUtil.notNullize((String)node.toString());
        if (string == null) {
            ExternalSystemViewDefaultContributor.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Override
    public ExternalProjectsStructure.ErrorLevel getErrorLevel(DataNode<?> dataNode) {
        if (ProjectKeys.LIBRARY_DEPENDENCY.equals((Object)dataNode.getKey()) && ((LibraryData)((LibraryDependencyData)dataNode.getData()).getTarget()).isUnresolved()) {
            return ExternalProjectsStructure.ErrorLevel.ERROR;
        }
        return super.getErrorLevel(dataNode);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectsView";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataNodes";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createNodes";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayName";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addDependenciesNode";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addModuleNodes";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getNodeDisplayName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LibraryDependencyDataExternalSystemNode
    extends DependencyDataExternalSystemNode<LibraryDependencyData> {
        LibraryDependencyDataExternalSystemNode(ExternalProjectsView externalProjectsView, DataNode<LibraryDependencyData> dataNode) {
            super(externalProjectsView, (ExternalSystemNode)null, dataNode);
        }

        protected void update(@NotNull PresentationData presentation) {
            if (presentation == null) {
                LibraryDependencyDataExternalSystemNode.$$$reportNull$$$0(0);
            }
            super.update(presentation);
            presentation.setIcon(AllIcons.Nodes.PpLib);
            LibraryDependencyData data2 = (LibraryDependencyData)this.getData();
            if (data2 != null) {
                this.setNameAndTooltip(this.getName(), null, data2.getScope().getDisplayName());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor$LibraryDependencyDataExternalSystemNode", "update"));
        }
    }

    private static class ModuleDependencyDataExternalSystemNode
    extends DependencyDataExternalSystemNode<ModuleDependencyData> {
        ModuleDependencyDataExternalSystemNode(ExternalProjectsView externalProjectsView, DataNode<ModuleDependencyData> dataNode) {
            super(externalProjectsView, (ExternalSystemNode)null, dataNode);
        }

        protected void update(@NotNull PresentationData presentation) {
            if (presentation == null) {
                ModuleDependencyDataExternalSystemNode.$$$reportNull$$$0(0);
            }
            super.update(presentation);
            presentation.setIcon(this.getUiAware().getProjectIcon());
            ModuleDependencyData data2 = (ModuleDependencyData)this.getData();
            if (data2 != null) {
                this.setNameAndTooltip(this.getName(), null, data2.getScope().getDisplayName());
            }
        }

        @Override
        @NotNull
        protected List<? extends ExternalSystemNode<?>> doBuildChildren() {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                ModuleDependencyDataExternalSystemNode.$$$reportNull$$$0(1);
            }
            return list2;
        }

        @Override
        public ExternalProjectsStructure.ErrorLevel getChildrenErrorLevel() {
            return ExternalProjectsStructure.ErrorLevel.NONE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor$ModuleDependencyDataExternalSystemNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor$ModuleDependencyDataExternalSystemNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doBuildChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class DependencyDataExternalSystemNode<T extends DependencyData<?>>
    extends ExternalSystemNode<T> {
        private final Navigatable myNavigatable;

        DependencyDataExternalSystemNode(@NotNull ExternalProjectsView externalProjectsView, @Nullable ExternalSystemNode parent, @Nullable DataNode<T> dataNode) {
            if (externalProjectsView == null) {
                DependencyDataExternalSystemNode.$$$reportNull$$$0(0);
            }
            super(externalProjectsView, parent, dataNode);
            this.myNavigatable = new OrderEntryNavigatable(this.getProject(), () -> this.getOrderEntry());
        }

        @Override
        @Nullable
        public Navigatable getNavigatable() {
            return this.myNavigatable;
        }

        @Nullable
        private OrderEntry getOrderEntry() {
            DependencyData data2 = (DependencyData)this.getData();
            if (data2 == null) {
                return null;
            }
            Project project = this.getProject();
            if (project == null) {
                return null;
            }
            return new IdeModelsProviderImpl(project).findIdeModuleOrderEntry(data2);
        }

        @Override
        public int compareTo(@NotNull ExternalSystemNode node) {
            int order2;
            int order1;
            if (node == null) {
                DependencyDataExternalSystemNode.$$$reportNull$$$0(1);
            }
            DependencyData myData = (DependencyData)this.getData();
            Object thatData = node.getData();
            if (myData instanceof OrderAware && thatData instanceof OrderAware && (order1 = ((OrderAware)myData).getOrder()) != (order2 = ((OrderAware)thatData).getOrder())) {
                return order1 < order2 ? -1 : 1;
            }
            String dependencyName = DependencyDataExternalSystemNode.getDependencySimpleName(this);
            String thatDependencyName = DependencyDataExternalSystemNode.getDependencySimpleName(node);
            return StringUtil.compare((String)dependencyName, (String)thatDependencyName, (boolean)true);
        }

        @NotNull
        private static String getDependencySimpleName(@NotNull ExternalSystemNode<?> node) {
            Set paths;
            LibraryDependencyData dependencyData;
            String externalName;
            Object thatData;
            if (node == null) {
                DependencyDataExternalSystemNode.$$$reportNull$$$0(2);
            }
            if ((thatData = node.getData()) instanceof LibraryDependencyData && StringUtil.isEmpty((String)(externalName = (dependencyData = (LibraryDependencyData)thatData).getExternalName())) && (paths = ((LibraryData)dependencyData.getTarget()).getPaths(LibraryPathType.BINARY)).size() == 1) {
                String string = new File((String)paths.iterator().next()).getName();
                if (string == null) {
                    DependencyDataExternalSystemNode.$$$reportNull$$$0(3);
                }
                return string;
            }
            String string = node.getName();
            if (string == null) {
                DependencyDataExternalSystemNode.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "externalProjectsView";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor$DependencyDataExternalSystemNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor$DependencyDataExternalSystemNode";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependencySimpleName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getDependencySimpleName";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class OrderEntryNavigatable
        implements Navigatable {
            @NotNull
            private final Supplier<OrderEntry> myProvider;
            @Nullable
            private final Project myProject;
            @Nullable
            private OrderEntry myOrderEntry;

            OrderEntryNavigatable(@Nullable Project project, @NotNull Supplier<OrderEntry> provider) {
                if (provider == null) {
                    OrderEntryNavigatable.$$$reportNull$$$0(0);
                }
                this.myProject = project;
                this.myProvider = provider;
            }

            public void navigate(boolean requestFocus) {
                if (this.myOrderEntry != null && this.myProject != null) {
                    ProjectSettingsService.getInstance(this.myProject).openModuleDependenciesSettings(this.myOrderEntry.getOwnerModule(), this.myOrderEntry);
                }
            }

            public boolean canNavigate() {
                this.myOrderEntry = this.myProvider.get();
                return this.myOrderEntry != null;
            }

            public boolean canNavigateToSource() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor$DependencyDataExternalSystemNode$OrderEntryNavigatable", "<init>"));
            }
        }
    }

    private static class DependencyExternalSystemNode
    extends ExternalSystemNode<Object> {
        @NotNull
        private final DependencyNode myDependencyNode;
        @NotNull
        private final TLongObjectHashMap<DependencyNode> myDependencyNodeMap;
        @Nullable
        private DependencyNode myReferencedNode;
        private final String myName;

        DependencyExternalSystemNode(@NotNull ExternalProjectsView externalProjectsView, @NotNull DependencyNode dependencyNode, @NotNull TLongObjectHashMap<DependencyNode> dependencyNodeMap) {
            if (externalProjectsView == null) {
                DependencyExternalSystemNode.$$$reportNull$$$0(0);
            }
            if (dependencyNode == null) {
                DependencyExternalSystemNode.$$$reportNull$$$0(1);
            }
            if (dependencyNodeMap == null) {
                DependencyExternalSystemNode.$$$reportNull$$$0(2);
            }
            super(externalProjectsView, null);
            this.myDependencyNode = dependencyNode;
            this.myDependencyNodeMap = dependencyNodeMap;
            if (this.myDependencyNode instanceof ReferenceNode) {
                this.myReferencedNode = (DependencyNode)this.myDependencyNodeMap.get(this.myDependencyNode.getId());
            }
            this.myName = this.myReferencedNode != null ? MessageFormat.format("{0}{1}", this.myReferencedNode.getDisplayName(), this.myReferencedNode.getDependencies().isEmpty() ? "" : " (*)") : this.myDependencyNode.getDisplayName();
        }

        @Override
        public String getName() {
            return this.myName;
        }

        protected void update(@NotNull PresentationData presentation) {
            String tooltip;
            if (presentation == null) {
                DependencyExternalSystemNode.$$$reportNull$$$0(3);
            }
            super.update(presentation);
            boolean isProjectDependency = this.myDependencyNode instanceof ProjectDependencyNode || this.myReferencedNode instanceof ProjectDependencyNode;
            presentation.setIcon(isProjectDependency ? this.getUiAware().getProjectIcon() : AllIcons.Nodes.PpLib);
            if (this.myReferencedNode != null) {
                tooltip = ExternalSystemBundle.message((String)"external.system.view.nodes.dependency_reference_node_tooltip", (Object[])new Object[0]);
            } else if (this.myDependencyNode instanceof FileCollectionDependencyNode) {
                String path = ((FileCollectionDependencyNode)this.myDependencyNode).getPath();
                tooltip = StringUtil.join((Object[])path.split(File.pathSeparator), s -> StringEscapeUtils.escapeHtml((String)s) + "<br/>", (String)"");
            } else {
                tooltip = null;
            }
            this.setNameAndTooltip(this.getName(), tooltip, (String)null);
        }

        @Override
        @NotNull
        protected List<ExternalSystemNode<?>> doBuildChildren() {
            if (this.myReferencedNode != null) {
                List<ExternalSystemNode<?>> list2 = Collections.emptyList();
                if (list2 == null) {
                    DependencyExternalSystemNode.$$$reportNull$$$0(4);
                }
                return list2;
            }
            ArrayList myChildNodes = new ArrayList();
            for (DependencyNode dependency : this.myDependencyNode.getDependencies()) {
                myChildNodes.add(new DependencyExternalSystemNode(this.getExternalProjectsView(), dependency, this.myDependencyNodeMap));
            }
            ArrayList arrayList = myChildNodes;
            if (arrayList == null) {
                DependencyExternalSystemNode.$$$reportNull$$$0(5);
            }
            return arrayList;
        }

        @Override
        public void handleDoubleClickOrEnter(SimpleTree tree, InputEvent inputEvent) {
            if (this.myReferencedNode == null) {
                super.handleDoubleClickOrEnter(tree, inputEvent);
            } else {
                this.selectAndExpandReferencedNode();
            }
        }

        private void selectAndExpandReferencedNode() {
            ExternalProjectsStructure structure = this.getStructure();
            if (structure == null) {
                return;
            }
            DependencyScopeExternalSystemNode scopeNode = this.findParent(DependencyScopeExternalSystemNode.class);
            if (scopeNode == null) {
                return;
            }
            DependencyExternalSystemNode referencedNode = this.findReferencedNode(scopeNode);
            if (referencedNode != null) {
                structure.select(referencedNode);
                structure.expand(referencedNode);
            }
        }

        @Nullable
        private DependencyExternalSystemNode findReferencedNode(ExternalSystemNode<?> node) {
            for (ExternalSystemNode<?> child2 : node.getChildren()) {
                if (child2 instanceof DependencyExternalSystemNode && ((DependencyExternalSystemNode)child2).myDependencyNode == this.myReferencedNode) {
                    return (DependencyExternalSystemNode)child2;
                }
                DependencyExternalSystemNode referencedNode = this.findReferencedNode(child2);
                if (referencedNode == null) continue;
                return referencedNode;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "externalProjectsView";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencyNode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencyNodeMap";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor$DependencyExternalSystemNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor$DependencyExternalSystemNode";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doBuildChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DependencyScopeExternalSystemNode
    extends ExternalSystemNode<Object> {
        private final DependencyScopeNode myDependenciesGraph;
        private final TLongObjectHashMap<DependencyNode> myDependencyNodeMap;

        DependencyScopeExternalSystemNode(@NotNull ExternalProjectsView externalProjectsView, @NotNull DependencyScopeNode dependenciesGraph) {
            if (externalProjectsView == null) {
                DependencyScopeExternalSystemNode.$$$reportNull$$$0(0);
            }
            if (dependenciesGraph == null) {
                DependencyScopeExternalSystemNode.$$$reportNull$$$0(1);
            }
            super(externalProjectsView, null);
            this.myDependencyNodeMap = new TLongObjectHashMap();
            this.myDependenciesGraph = dependenciesGraph;
        }

        @Override
        public String getName() {
            return this.myDependenciesGraph.getScope();
        }

        protected void update(@NotNull PresentationData presentation) {
            if (presentation == null) {
                DependencyScopeExternalSystemNode.$$$reportNull$$$0(2);
            }
            super.update(presentation);
            presentation.setIcon(AllIcons.Nodes.PpLibFolder);
            String description = this.myDependenciesGraph.getDescription();
            if (description != null) {
                this.setNameAndTooltip(this.getName(), description, (String)null);
            }
        }

        @Override
        @NotNull
        protected List<ExternalSystemNode<?>> doBuildChildren() {
            DependencyScopeExternalSystemNode.buildNodesMap(this.myDependencyNodeMap, (DependencyNode)this.myDependenciesGraph);
            ArrayList myChildNodes = new ArrayList();
            for (DependencyNode dependency : this.myDependenciesGraph.getDependencies()) {
                myChildNodes.add(new DependencyExternalSystemNode(this.getExternalProjectsView(), dependency, this.myDependencyNodeMap));
            }
            ArrayList arrayList = myChildNodes;
            if (arrayList == null) {
                DependencyScopeExternalSystemNode.$$$reportNull$$$0(3);
            }
            return arrayList;
        }

        @Override
        public ExternalProjectsStructure.ErrorLevel getChildrenErrorLevel() {
            return DependencyScopeExternalSystemNode.getErrorLevelRecursively((DependencyNode)this.myDependenciesGraph);
        }

        @NotNull
        private static ExternalProjectsStructure.ErrorLevel getErrorLevelRecursively(@NotNull DependencyNode node) {
            if (node == null) {
                DependencyScopeExternalSystemNode.$$$reportNull$$$0(4);
            }
            if (node instanceof UnknownDependencyNode) {
                ExternalProjectsStructure.ErrorLevel errorLevel = ExternalProjectsStructure.ErrorLevel.ERROR;
                if (errorLevel == null) {
                    DependencyScopeExternalSystemNode.$$$reportNull$$$0(5);
                }
                return errorLevel;
            }
            ExternalProjectsStructure.ErrorLevel result2 = ExternalProjectsStructure.ErrorLevel.NONE;
            for (DependencyNode dependencyNode : node.getDependencies()) {
                ExternalProjectsStructure.ErrorLevel eachLevel = DependencyScopeExternalSystemNode.getErrorLevelRecursively(dependencyNode);
                if (result2.compareTo(eachLevel) > 0) {
                    result2 = eachLevel;
                }
                if (result2 != ExternalProjectsStructure.ErrorLevel.ERROR) continue;
                break;
            }
            ExternalProjectsStructure.ErrorLevel errorLevel = result2;
            if (errorLevel == null) {
                DependencyScopeExternalSystemNode.$$$reportNull$$$0(6);
            }
            return errorLevel;
        }

        private static void buildNodesMap(@NotNull TLongObjectHashMap<DependencyNode> dependencyNodeMap, @NotNull DependencyNode node) {
            if (dependencyNodeMap == null) {
                DependencyScopeExternalSystemNode.$$$reportNull$$$0(7);
            }
            if (node == null) {
                DependencyScopeExternalSystemNode.$$$reportNull$$$0(8);
            }
            for (DependencyNode child2 : node.getDependencies()) {
                if (child2 instanceof ReferenceNode) continue;
                dependencyNodeMap.put(child2.getId(), (Object)child2);
                DependencyScopeExternalSystemNode.buildNodesMap(dependencyNodeMap, child2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "externalProjectsView";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependenciesGraph";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor$DependencyScopeExternalSystemNode";
                    break;
                }
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencyNodeMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor$DependencyScopeExternalSystemNode";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doBuildChildren";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorLevelRecursively";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getErrorLevelRecursively";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "buildNodesMap";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @Order(value=20)
    private static class MyDependenciesNode
    extends ExternalSystemNode<Object> {
        MyDependenciesNode(ExternalProjectsView externalProjectsView) {
            super(externalProjectsView, null, null);
        }

        protected void update(@NotNull PresentationData presentation) {
            if (presentation == null) {
                MyDependenciesNode.$$$reportNull$$$0(0);
            }
            super.update(presentation);
            presentation.setIcon(AllIcons.Nodes.PpLibFolder);
        }

        @Override
        public String getName() {
            return "Dependencies";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor$MyDependenciesNode", "update"));
        }
    }
}

