/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.build.BuildProgressListener;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.FinishBuildEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemOutputMessageDispatcher;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\r\u001a\u00020\u000eJ\f\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H$J\u0018\u0010\u0011\u001a\u00020\u000e2\u000e\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tH\u0016J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R1\u0010\u0007\u001a%\u0012\u001c\u0012\u001a\u0012\u0006\u0012\u0004\u0018\u00010\n \u000b*\f\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\t0\t0\b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/openapi/externalSystem/service/execution/AbstractOutputMessageDispatcher;", "Lcom/intellij/openapi/externalSystem/service/execution/ExternalSystemOutputMessageDispatcher;", "buildProgressListener", "Lcom/intellij/build/BuildProgressListener;", "(Lcom/intellij/build/BuildProgressListener;)V", "isClosed", "", "onCompletionHandlers", "Lcom/intellij/util/containers/ConcurrentList;", "Ljava/util/function/Consumer;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "close", "", "closeAndGetFuture", "Ljava/util/concurrent/CompletableFuture;", "invokeOnCompletion", "handler", "onEvent", "buildId", "", "event", "Lcom/intellij/build/events/BuildEvent;", "Companion", "intellij.platform.externalSystem.impl"})
@ApiStatus.Experimental
public abstract class AbstractOutputMessageDispatcher
implements ExternalSystemOutputMessageDispatcher {
    private final ConcurrentList<Consumer<Throwable>> onCompletionHandlers;
    private volatile boolean isClosed;
    private final BuildProgressListener buildProgressListener;
    private static final Logger LOG;
    public static final Companion Companion;

    public void onEvent(@NotNull Object buildId, @NotNull BuildEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)buildId, (String)"buildId");
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        BuildEvent buildEvent = event;
        if (buildEvent instanceof FinishBuildEvent) {
            this.invokeOnCompletion(new Consumer<Throwable>(this, buildId, event){
                final /* synthetic */ AbstractOutputMessageDispatcher this$0;
                final /* synthetic */ Object $buildId;
                final /* synthetic */ BuildEvent $event;

                public final void accept(@Nullable Throwable it) {
                    AbstractOutputMessageDispatcher.access$getBuildProgressListener$p(this.this$0).onEvent(this.$buildId, this.$event);
                }
                {
                    this.this$0 = abstractOutputMessageDispatcher;
                    this.$buildId = object;
                    this.$event = buildEvent;
                }
            });
        } else {
            this.buildProgressListener.onEvent(buildId, event);
        }
    }

    @Override
    public void invokeOnCompletion(@NotNull Consumer<Throwable> handler2) {
        Intrinsics.checkParameterIsNotNull(handler2, (String)"handler");
        if (this.isClosed) {
            LOG.warn("Attempt to add completion handler for closed output dispatcher, the handler will be ignored", LOG.isDebugEnabled() ? new Throwable() : null);
        } else {
            this.onCompletionHandlers.add(handler2);
        }
    }

    @NotNull
    protected abstract CompletableFuture<?> closeAndGetFuture();

    @Override
    public final void close() {
        CompletableFuture<?> future2 = this.closeAndGetFuture();
        this.isClosed = true;
        for (Consumer handler2 : CollectionsKt.asReversedMutable((List)((List)this.onCompletionHandlers))) {
            future2.whenComplete((BiConsumer)new BiConsumer<Object, Throwable>(handler2){
                final /* synthetic */ Consumer $handler;

                public final void accept(Object $noName_0, Throwable u) {
                    this.$handler.accept(u);
                }
                {
                    this.$handler = consumer;
                }
            });
        }
        this.onCompletionHandlers.clear();
    }

    public AbstractOutputMessageDispatcher(@NotNull BuildProgressListener buildProgressListener) {
        Intrinsics.checkParameterIsNotNull((Object)buildProgressListener, (String)"buildProgressListener");
        this.buildProgressListener = buildProgressListener;
        ConcurrentList concurrentList = ContainerUtil.createConcurrentList();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentList, (String)"ContainerUtil.createConc\u2026t<Consumer<Throwable?>>()");
        this.onCompletionHandlers = concurrentList;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AbstractOutputMessageDispatcher.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ BuildProgressListener access$getBuildProgressListener$p(AbstractOutputMessageDispatcher $this) {
        return $this.buildProgressListener;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/externalSystem/service/execution/AbstractOutputMessageDispatcher$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

