/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap.mapping;

import com.intellij.diagnostic.Dumpable;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.TextChangeImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapsStorage;
import com.intellij.openapi.editor.impl.softwrap.mapping.IncrementalCacheUpdateEvent;
import com.intellij.openapi.editor.impl.softwrap.mapping.SoftWrapAwareDocumentParsingListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachingSoftWrapDataMapper
implements SoftWrapAwareDocumentParsingListener,
Dumpable {
    private static final Logger LOG = Logger.getInstance(CachingSoftWrapDataMapper.class);
    private final List<SoftWrapImpl> myAffectedByUpdateSoftWraps;
    private final EditorEx myEditor;
    private final SoftWrapsStorage myStorage;

    public CachingSoftWrapDataMapper(@NotNull EditorEx editor, @NotNull SoftWrapsStorage storage) {
        if (editor == null) {
            CachingSoftWrapDataMapper.$$$reportNull$$$0(0);
        }
        if (storage == null) {
            CachingSoftWrapDataMapper.$$$reportNull$$$0(1);
        }
        this.myAffectedByUpdateSoftWraps = new ArrayList<SoftWrapImpl>();
        this.myEditor = editor;
        this.myStorage = storage;
    }

    public boolean matchesOldSoftWrap(SoftWrap newSoftWrap, int lengthDiff) {
        return Collections.binarySearch(this.myAffectedByUpdateSoftWraps, new SoftWrapImpl(new TextChangeImpl(newSoftWrap.getText(), newSoftWrap.getStart() - lengthDiff, newSoftWrap.getEnd() - lengthDiff), newSoftWrap.getIndentInColumns(), newSoftWrap.getIndentInPixels()), (o1, o2) -> {
            int offsetDiff = o1.getStart() - o2.getStart();
            if (offsetDiff != 0) {
                return offsetDiff;
            }
            int textDiff = o1.getText().toString().compareTo(o2.getText().toString());
            if (textDiff != 0) {
                return textDiff;
            }
            int colIndentDiff = o1.getIndentInColumns() - o2.getIndentInColumns();
            if (colIndentDiff != 0) {
                return colIndentDiff;
            }
            return o1.getIndentInPixels() - o2.getIndentInPixels();
        }) >= 0;
    }

    @Override
    public void recalculationEnds() {
    }

    @Override
    public void onCacheUpdateStart(@NotNull IncrementalCacheUpdateEvent event) {
        if (event == null) {
            CachingSoftWrapDataMapper.$$$reportNull$$$0(2);
        }
        int startOffset = event.getStartOffset();
        this.myAffectedByUpdateSoftWraps.clear();
        this.myAffectedByUpdateSoftWraps.addAll(this.myStorage.removeStartingFrom(startOffset + 1));
    }

    @Override
    public void onRecalculationEnd(@NotNull IncrementalCacheUpdateEvent event) {
        if (event == null) {
            CachingSoftWrapDataMapper.$$$reportNull$$$0(3);
        }
        this.advanceSoftWrapOffsets(event);
    }

    @Override
    public void reset() {
        this.myAffectedByUpdateSoftWraps.clear();
    }

    private void advanceSoftWrapOffsets(@NotNull IncrementalCacheUpdateEvent event) {
        if (event == null) {
            CachingSoftWrapDataMapper.$$$reportNull$$$0(4);
        }
        int lengthDiff = event.getLengthDiff();
        int recalcEndOffsetTranslated = event.getActualEndOffset() - lengthDiff;
        int firstIndex = -1;
        int softWrappedLinesDiff = this.myStorage.getNumberOfSoftWrapsInRange(event.getStartOffset() + 1, this.myEditor.getDocument().getTextLength());
        boolean softWrapsChanged = softWrappedLinesDiff > 0;
        for (int i = 0; i < this.myAffectedByUpdateSoftWraps.size(); ++i) {
            SoftWrapImpl softWrap = this.myAffectedByUpdateSoftWraps.get(i);
            if (firstIndex < 0) {
                if (softWrap.getStart() > recalcEndOffsetTranslated) {
                    firstIndex = i;
                    if (lengthDiff == 0) {
                        break;
                    }
                } else {
                    --softWrappedLinesDiff;
                    softWrapsChanged = true;
                }
            }
            if (firstIndex < 0 || i < firstIndex) continue;
            softWrap.advance(lengthDiff);
        }
        if (firstIndex >= 0) {
            List<SoftWrapImpl> updated = this.myAffectedByUpdateSoftWraps.subList(firstIndex, this.myAffectedByUpdateSoftWraps.size());
            SoftWrapImpl lastSoftWrap = this.getLastSoftWrap();
            if (lastSoftWrap != null && lastSoftWrap.getStart() >= updated.get(0).getStart()) {
                LOG.error("Invalid soft wrap recalculation", new Attachment[]{new Attachment("state.txt", this.myEditor.getSoftWrapModel().toString())});
            }
            this.myStorage.addAll(updated);
        }
        this.myAffectedByUpdateSoftWraps.clear();
        if (softWrapsChanged) {
            this.myStorage.notifyListenersAboutChange();
        }
    }

    @Nullable
    SoftWrapImpl getLastSoftWrap() {
        List<SoftWrapImpl> softWraps = this.myStorage.getSoftWraps();
        return softWraps.isEmpty() ? null : softWraps.get(softWraps.size() - 1);
    }

    @NotNull
    public String dumpState() {
        String string = "Soft wraps affected by current update: " + this.myAffectedByUpdateSoftWraps;
        if (string == null) {
            CachingSoftWrapDataMapper.$$$reportNull$$$0(5);
        }
        return string;
    }

    public String toString() {
        return this.dumpState();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onCacheUpdateStart";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onRecalculationEnd";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "advanceSoftWrapOffsets";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

