/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.diagnostic.Dumpable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.impl.AfterLineEndInlayImpl;
import com.intellij.openapi.editor.impl.BlockInlayImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.HardReferencingRangeMarkerTree;
import com.intellij.openapi.editor.impl.InlayImpl;
import com.intellij.openapi.editor.impl.InlineInlayImpl;
import com.intellij.openapi.editor.impl.IntervalTreeImpl;
import com.intellij.openapi.editor.impl.MarkerTreeWithPartialSums;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.util.DocumentEventUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlayModelImpl
implements InlayModel,
PrioritizedDocumentListener,
Disposable,
Dumpable {
    private static final Logger LOG = Logger.getInstance(InlayModelImpl.class);
    private static final Comparator<Inlay> INLINE_ELEMENTS_COMPARATOR = Comparator.comparingInt(i -> i.getOffset()).thenComparing(i -> i.isRelatedToPrecedingText());
    private static final Comparator<BlockInlayImpl> BLOCK_ELEMENTS_PRIORITY_COMPARATOR = Comparator.comparingInt(i -> -i.myPriority);
    private static final Comparator<BlockInlayImpl> BLOCK_ELEMENTS_COMPARATOR = Comparator.comparing(i -> i.getPlacement()).thenComparing(i -> i.getPlacement() == Inlay.Placement.ABOVE_LINE ? i.myPriority : -i.myPriority);
    private static final Comparator<AfterLineEndInlayImpl> AFTER_LINE_END_ELEMENTS_OFFSET_COMPARATOR = Comparator.comparingInt(i -> i.getOffset()).thenComparingInt(i -> i.myOrder);
    private static final Comparator<AfterLineEndInlayImpl> AFTER_LINE_END_ELEMENTS_COMPARATOR = Comparator.comparingInt(i -> i.myOrder);
    private static final Processor<InlayImpl> UPDATE_PROCESSOR = inlay -> {
        inlay.update();
        return true;
    };
    private final EditorImpl myEditor;
    private final EventDispatcher<InlayModel.Listener> myDispatcher;
    private final List<InlayImpl> myInlaysInvalidatedOnMove;
    final RangeMarkerTree<InlineInlayImpl> myInlineElementsTree;
    final MarkerTreeWithPartialSums<BlockInlayImpl> myBlockElementsTree;
    final RangeMarkerTree<AfterLineEndInlayImpl> myAfterLineEndElementsTree;
    boolean myMoveInProgress;
    boolean myPutMergedIntervalsAtBeginning;
    private boolean myConsiderCaretPositionOnDocumentUpdates;
    private List<Inlay> myInlaysAtCaret;
    private boolean myInBatchMode;

    InlayModelImpl(@NotNull EditorImpl editor) {
        if (editor == null) {
            InlayModelImpl.$$$reportNull$$$0(0);
        }
        this.myDispatcher = EventDispatcher.create(InlayModel.Listener.class);
        this.myInlaysInvalidatedOnMove = new ArrayList<InlayImpl>();
        this.myConsiderCaretPositionOnDocumentUpdates = true;
        this.myEditor = editor;
        this.myInlineElementsTree = new InlineElementsTree(editor.getDocument());
        this.myBlockElementsTree = new BlockElementsTree(editor.getDocument());
        this.myAfterLineEndElementsTree = new AfterLineEndElementTree(editor.getDocument());
        this.myEditor.getDocument().addDocumentListener(this, this);
    }

    @Override
    public int getPriority() {
        return 150;
    }

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        List<Inlay> inlays;
        int inlayCount;
        if (event == null) {
            InlayModelImpl.$$$reportNull$$$0(1);
        }
        if (this.myEditor.getDocument().isInBulkUpdate()) {
            return;
        }
        if (this.myInBatchMode) {
            LOG.error("Document shouldn't be changed during batch inlay operation");
        }
        int offset = event.getOffset();
        if (this.myConsiderCaretPositionOnDocumentUpdates && event.getOldLength() == 0 && offset == this.myEditor.getCaretModel().getOffset() && (inlayCount = (inlays = this.getInlineElementsInRange(offset, offset)).size()) > 0) {
            VisualPosition inlaysStartPosition = this.myEditor.offsetToVisualPosition(offset, false, false);
            VisualPosition caretPosition = this.myEditor.getCaretModel().getVisualPosition();
            if (inlaysStartPosition.line == caretPosition.line && caretPosition.column >= inlaysStartPosition.column && caretPosition.column <= inlaysStartPosition.column + inlayCount) {
                this.myInlaysAtCaret = inlays;
                for (int i = 0; i < inlayCount; ++i) {
                    ((InlayImpl)inlays.get(i)).setStickingToRight(i >= caretPosition.column - inlaysStartPosition.column);
                }
            }
        }
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        if (event == null) {
            InlayModelImpl.$$$reportNull$$$0(2);
        }
        if (this.myInlaysAtCaret != null) {
            for (Inlay inlay : this.myInlaysAtCaret) {
                ((InlayImpl)inlay).setStickingToRight(inlay.isRelatedToPrecedingText());
            }
            this.myInlaysAtCaret = null;
        }
        if (DocumentEventUtil.isMoveInsertion(event)) {
            for (InlayImpl inlayImpl : this.myInlaysInvalidatedOnMove) {
                this.notifyRemoved(inlayImpl);
            }
            this.myInlaysInvalidatedOnMove.clear();
        }
    }

    void reinitSettings() {
        this.myInlineElementsTree.processAll(UPDATE_PROCESSOR);
        this.myBlockElementsTree.processAll(UPDATE_PROCESSOR);
        this.myAfterLineEndElementsTree.processAll(UPDATE_PROCESSOR);
    }

    public void dispose() {
        this.myInlineElementsTree.dispose(this.myEditor.getDocument());
        this.myBlockElementsTree.dispose(this.myEditor.getDocument());
        this.myAfterLineEndElementsTree.dispose(this.myEditor.getDocument());
    }

    @Nullable
    public <T extends EditorCustomElementRenderer> Inlay<T> addInlineElement(int offset, boolean relatesToPrecedingText, @NotNull T renderer) {
        if (renderer == null) {
            InlayModelImpl.$$$reportNull$$$0(3);
        }
        EditorImpl.assertIsDispatchThread();
        DocumentEx document = this.myEditor.getDocument();
        if (DocumentUtil.isInsideSurrogatePair(document, offset)) {
            return null;
        }
        offset = Math.max(0, Math.min(document.getTextLength(), offset));
        InlineInlayImpl<T> inlay = new InlineInlayImpl<T>(this.myEditor, offset, relatesToPrecedingText, renderer);
        this.notifyAdded(inlay);
        return inlay;
    }

    @Nullable
    public <T extends EditorCustomElementRenderer> Inlay<T> addBlockElement(int offset, boolean relatesToPrecedingText, boolean showAbove, int priority, @NotNull T renderer) {
        if (renderer == null) {
            InlayModelImpl.$$$reportNull$$$0(4);
        }
        EditorImpl.assertIsDispatchThread();
        offset = Math.max(0, Math.min(this.myEditor.getDocument().getTextLength(), offset));
        BlockInlayImpl<T> inlay = new BlockInlayImpl<T>(this.myEditor, offset, relatesToPrecedingText, showAbove, priority, renderer);
        this.notifyAdded(inlay);
        return inlay;
    }

    @Nullable
    public <T extends EditorCustomElementRenderer> Inlay<T> addAfterLineEndElement(int offset, boolean relatesToPrecedingText, @NotNull T renderer) {
        if (renderer == null) {
            InlayModelImpl.$$$reportNull$$$0(5);
        }
        EditorImpl.assertIsDispatchThread();
        DocumentEx document = this.myEditor.getDocument();
        offset = Math.max(0, Math.min(document.getTextLength(), offset));
        AfterLineEndInlayImpl<T> inlay = new AfterLineEndInlayImpl<T>(this.myEditor, offset, relatesToPrecedingText, renderer);
        this.notifyAdded(inlay);
        return inlay;
    }

    @NotNull
    public List<Inlay> getInlineElementsInRange(int startOffset, int endOffset) {
        List<Inlay> range2;
        List<Inlay> list2 = range2 = InlayModelImpl.getElementsInRange(this.myInlineElementsTree, startOffset, endOffset, inlay -> true, INLINE_ELEMENTS_COMPARATOR);
        if (list2 == null) {
            InlayModelImpl.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @NotNull
    public <T> List<Inlay<? extends T>> getInlineElementsInRange(int startOffset, int endOffset, @NotNull Class<T> type) {
        List<Inlay<T>> range2;
        if (type == null) {
            InlayModelImpl.$$$reportNull$$$0(7);
        }
        List<Inlay<T>> list2 = range2 = InlayModelImpl.getElementsInRange(this.myInlineElementsTree, startOffset, endOffset, inlay -> type.isInstance(inlay.myRenderer), INLINE_ELEMENTS_COMPARATOR);
        if (list2 == null) {
            InlayModelImpl.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @NotNull
    public List<Inlay> getBlockElementsInRange(int startOffset, int endOffset) {
        List<Inlay> range2;
        List<Inlay> list2 = range2 = InlayModelImpl.getElementsInRange(this.myBlockElementsTree, startOffset, endOffset, inlay -> true, BLOCK_ELEMENTS_PRIORITY_COMPARATOR);
        if (list2 == null) {
            InlayModelImpl.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @NotNull
    public <T> List<Inlay<? extends T>> getBlockElementsInRange(int startOffset, int endOffset, @NotNull Class<T> type) {
        List<Inlay<T>> range2;
        if (type == null) {
            InlayModelImpl.$$$reportNull$$$0(10);
        }
        List<Inlay<T>> list2 = range2 = InlayModelImpl.getElementsInRange(this.myBlockElementsTree, startOffset, endOffset, inlay -> type.isInstance(inlay.myRenderer), BLOCK_ELEMENTS_PRIORITY_COMPARATOR);
        if (list2 == null) {
            InlayModelImpl.$$$reportNull$$$0(11);
        }
        return list2;
    }

    private static <T extends Inlay> List<T> getElementsInRange(@NotNull IntervalTreeImpl<? extends T> tree, int startOffset, int endOffset, Predicate<? super T> predicate, Comparator<? super T> comparator2) {
        if (tree == null) {
            InlayModelImpl.$$$reportNull$$$0(12);
        }
        ArrayList result2 = new ArrayList();
        tree.processOverlappingWith(startOffset, endOffset, inlay -> {
            if (predicate.test(inlay)) {
                result2.add(inlay);
            }
            return true;
        });
        Collections.sort(result2, comparator2);
        return result2;
    }

    @NotNull
    public List<Inlay> getBlockElementsForVisualLine(int visualLine, boolean above) {
        int visibleLineCount = this.myEditor.getVisibleLineCount();
        if (visualLine < 0 || visualLine >= visibleLineCount || this.myBlockElementsTree.size() == 0) {
            List<Inlay> list2 = Collections.emptyList();
            if (list2 == null) {
                InlayModelImpl.$$$reportNull$$$0(13);
            }
            return list2;
        }
        ArrayList<Inlay> result2 = new ArrayList<Inlay>();
        int startOffset = this.myEditor.visualLineStartOffset(visualLine);
        int endOffset = visualLine == visibleLineCount - 1 ? this.myEditor.getDocument().getTextLength() : this.myEditor.visualLineStartOffset(visualLine + 1) - 1;
        this.myBlockElementsTree.processOverlappingWith(startOffset, endOffset, (Processor<BlockInlayImpl>)((Processor)inlay -> {
            if (inlay.myShowAbove == above && !this.myEditor.getFoldingModel().isOffsetCollapsed(inlay.getOffset())) {
                result2.add((Inlay)inlay);
            }
            return true;
        }));
        if (above) {
            Collections.reverse(result2);
        }
        Collections.sort(result2, BLOCK_ELEMENTS_COMPARATOR);
        ArrayList<Inlay> arrayList = result2;
        if (arrayList == null) {
            InlayModelImpl.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    public int getHeightOfBlockElementsBeforeVisualLine(int visualLine) {
        int endOffset;
        if (visualLine < 0 || !this.hasBlockElements()) {
            return 0;
        }
        int visibleLineCount = this.myEditor.getVisibleLineCount();
        if (visualLine >= visibleLineCount) {
            return this.myBlockElementsTree.getSumOfValuesUpToOffset(Integer.MAX_VALUE) - this.myEditor.getFoldingModel().getTotalHeightOfFoldedBlockInlays();
        }
        int[] result2 = new int[]{0};
        int startOffset = this.myEditor.visualLineStartOffset(visualLine);
        int n = endOffset = visualLine >= visibleLineCount - 1 ? this.myEditor.getDocument().getTextLength() : this.myEditor.visualLineStartOffset(visualLine + 1) - 1;
        if (visualLine > 0) {
            result2[0] = result2[0] + (this.myBlockElementsTree.getSumOfValuesUpToOffset(startOffset - 1) - this.myEditor.getFoldingModel().getHeightOfFoldedBlockInlaysBefore(startOffset));
        }
        this.myBlockElementsTree.processOverlappingWith(startOffset, endOffset, (Processor<BlockInlayImpl>)((Processor)inlay -> {
            if (inlay.myShowAbove && !this.myEditor.getFoldingModel().isOffsetCollapsed(inlay.getOffset())) {
                result2[0] = result2[0] + inlay.getHeightInPixels();
            }
            return true;
        }));
        return result2[0];
    }

    public boolean hasBlockElements() {
        return this.myBlockElementsTree.size() > 0;
    }

    public boolean hasInlineElementsInRange(int startOffset, int endOffset) {
        return !this.myInlineElementsTree.processOverlappingWith(startOffset, endOffset, (Processor<InlineInlayImpl>)((Processor)inlay -> false));
    }

    public boolean hasInlineElements() {
        return this.myInlineElementsTree.size() > 0;
    }

    public boolean hasInlineElementAt(int offset) {
        return !this.myInlineElementsTree.processOverlappingWith(offset, offset, (Processor<InlineInlayImpl>)((Processor)inlay -> false));
    }

    public boolean hasInlineElementAt(@NotNull VisualPosition visualPosition) {
        int offset;
        int inlayCount;
        if (visualPosition == null) {
            InlayModelImpl.$$$reportNull$$$0(15);
        }
        if ((inlayCount = this.getInlineElementsInRange(offset = this.myEditor.logicalPositionToOffset(this.myEditor.visualToLogicalPosition(visualPosition)), offset).size()) == 0) {
            return false;
        }
        VisualPosition inlayStartPosition = this.myEditor.offsetToVisualPosition(offset, false, false);
        return visualPosition.line == inlayStartPosition.line && visualPosition.column >= inlayStartPosition.column && visualPosition.column < inlayStartPosition.column + inlayCount;
    }

    @Nullable
    public Inlay getInlineElementAt(@NotNull VisualPosition visualPosition) {
        int offset;
        List<Inlay> inlays;
        if (visualPosition == null) {
            InlayModelImpl.$$$reportNull$$$0(16);
        }
        if ((inlays = this.getInlineElementsInRange(offset = this.myEditor.logicalPositionToOffset(this.myEditor.visualToLogicalPosition(visualPosition)), offset)).isEmpty()) {
            return null;
        }
        VisualPosition inlayStartPosition = this.myEditor.offsetToVisualPosition(offset, false, false);
        if (visualPosition.line != inlayStartPosition.line) {
            return null;
        }
        int inlayIndex = visualPosition.column - inlayStartPosition.column;
        return inlayIndex >= 0 && inlayIndex < inlays.size() ? inlays.get(inlayIndex) : null;
    }

    @Nullable
    public Inlay getElementAt(@NotNull Point point) {
        Inlay inlay;
        List<Inlay> inlays;
        if (point == null) {
            InlayModelImpl.$$$reportNull$$$0(17);
        }
        Insets insets = this.myEditor.getContentComponent().getInsets();
        if (point.y < insets.top) {
            return null;
        }
        int relX = point.x - insets.left;
        if (relX < 0) {
            return null;
        }
        boolean hasInlineElements = this.hasInlineElements();
        boolean hasBlockElements = this.hasBlockElements();
        boolean hasAfterLineEndElements = this.hasAfterLineEndElements();
        if (!(hasInlineElements || hasBlockElements || hasAfterLineEndElements)) {
            return null;
        }
        VisualPosition visualPosition = this.myEditor.xyToVisualPosition(point);
        if (hasBlockElements) {
            int visualLine = visualPosition.line;
            int baseY = this.myEditor.visualLineToY(visualLine);
            if (point.y < baseY) {
                List<Inlay> inlays2 = this.getBlockElementsForVisualLine(visualLine, true);
                int yDiff = baseY - point.y;
                for (int i = inlays2.size() - 1; i >= 0; --i) {
                    Inlay inlay2 = inlays2.get(i);
                    int height = inlay2.getHeightInPixels();
                    if (yDiff <= height) {
                        return relX < inlay2.getWidthInPixels() ? inlay2 : null;
                    }
                    yDiff -= height;
                }
                LOG.error("Inconsistent state: " + point + ", " + visualPosition + ", baseY=" + baseY + ", " + inlays2, new Attachment[]{new Attachment("editorState.txt", this.myEditor.dumpState())});
                return null;
            }
            int lineBottom = baseY + this.myEditor.getLineHeight();
            if (point.y >= lineBottom) {
                List<Inlay> inlays3 = this.getBlockElementsForVisualLine(visualLine, false);
                int yDiff = point.y - lineBottom;
                for (Inlay inlay3 : inlays3) {
                    int height = inlay3.getHeightInPixels();
                    if (yDiff < height) {
                        return relX < inlay3.getWidthInPixels() ? inlay3 : null;
                    }
                    yDiff -= height;
                }
                LOG.error("Inconsistent state: " + point + ", " + visualPosition + ", lineBottom=" + lineBottom + ", " + inlays3, new Attachment[]{new Attachment("editorState.txt", this.myEditor.dumpState())});
                return null;
            }
        }
        int offset = -1;
        if (hasInlineElements && !(inlays = this.getInlineElementsInRange(offset = this.myEditor.logicalPositionToOffset(this.myEditor.visualToLogicalPosition(visualPosition)), offset)).isEmpty()) {
            VisualPosition startVisualPosition = this.myEditor.offsetToVisualPosition(offset);
            Point inlayPoint = this.myEditor.visualPositionToXY(startVisualPosition);
            if (point.y < inlayPoint.y || point.y >= inlayPoint.y + this.myEditor.getLineHeight()) {
                return null;
            }
            inlay = InlayModelImpl.findInlay(inlays, point.x, inlayPoint.x);
            if (inlay != null) {
                return inlay;
            }
        }
        if (hasAfterLineEndElements) {
            List<Inlay> inlays4;
            if (offset < 0) {
                offset = this.myEditor.logicalPositionToOffset(this.myEditor.visualToLogicalPosition(visualPosition));
            }
            int logicalLine = this.myEditor.getDocument().getLineNumber(offset);
            if (offset == this.myEditor.getDocument().getLineEndOffset(logicalLine) && !this.myEditor.getFoldingModel().isOffsetCollapsed(offset) && !(inlays4 = this.myEditor.getInlayModel().getAfterLineEndElementsForLogicalLine(logicalLine)).isEmpty()) {
                Rectangle bounds2 = inlays4.get(0).getBounds();
                assert (bounds2 != null);
                if (point.y < bounds2.y || point.y >= bounds2.y + bounds2.height) {
                    return null;
                }
                inlay = InlayModelImpl.findInlay(inlays4, point.x, bounds2.x);
                if (inlay != null) {
                    return inlay;
                }
            }
        }
        return null;
    }

    private static Inlay findInlay(List<? extends Inlay> inlays, int x, int startX) {
        for (Inlay inlay : inlays) {
            int endX = startX + inlay.getWidthInPixels();
            if (x >= startX && x < endX) {
                return inlay;
            }
            startX = endX;
        }
        return null;
    }

    @NotNull
    public List<Inlay> getAfterLineEndElementsInRange(int startOffset, int endOffset) {
        List<Inlay> range2;
        if (!this.hasAfterLineEndElements()) {
            List<Inlay> list2 = Collections.emptyList();
            if (list2 == null) {
                InlayModelImpl.$$$reportNull$$$0(18);
            }
            return list2;
        }
        List<Inlay> list3 = range2 = InlayModelImpl.getElementsInRange(this.myAfterLineEndElementsTree, startOffset, endOffset, inlay -> true, AFTER_LINE_END_ELEMENTS_OFFSET_COMPARATOR);
        if (list3 == null) {
            InlayModelImpl.$$$reportNull$$$0(19);
        }
        return list3;
    }

    @NotNull
    public <T> List<Inlay<? extends T>> getAfterLineEndElementsInRange(int startOffset, int endOffset, @NotNull Class<T> type) {
        List<Inlay<T>> range2;
        if (type == null) {
            InlayModelImpl.$$$reportNull$$$0(20);
        }
        if (!this.hasAfterLineEndElements()) {
            List<Inlay<? extends T>> list2 = Collections.emptyList();
            if (list2 == null) {
                InlayModelImpl.$$$reportNull$$$0(21);
            }
            return list2;
        }
        List<Inlay<T>> list3 = range2 = InlayModelImpl.getElementsInRange(this.myAfterLineEndElementsTree, startOffset, endOffset, inlay -> type.isInstance(inlay.myRenderer), AFTER_LINE_END_ELEMENTS_OFFSET_COMPARATOR);
        if (list3 == null) {
            InlayModelImpl.$$$reportNull$$$0(22);
        }
        return list3;
    }

    @NotNull
    public List<Inlay> getAfterLineEndElementsForLogicalLine(int logicalLine) {
        DocumentEx document = this.myEditor.getDocument();
        if (!this.hasAfterLineEndElements() || logicalLine < 0 || logicalLine > 0 && logicalLine >= document.getLineCount()) {
            List<Inlay> list2 = Collections.emptyList();
            if (list2 == null) {
                InlayModelImpl.$$$reportNull$$$0(23);
            }
            return list2;
        }
        ArrayList<Inlay> result2 = new ArrayList<Inlay>();
        int startOffset = document.getLineStartOffset(logicalLine);
        int endOffset = document.getLineEndOffset(logicalLine);
        this.myAfterLineEndElementsTree.processOverlappingWith(startOffset, endOffset, (Processor<AfterLineEndInlayImpl>)((Processor)inlay -> {
            result2.add((Inlay)inlay);
            return true;
        }));
        result2.sort(AFTER_LINE_END_ELEMENTS_COMPARATOR);
        ArrayList<Inlay> arrayList = result2;
        if (arrayList == null) {
            InlayModelImpl.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    public boolean hasAfterLineEndElements() {
        return this.myAfterLineEndElementsTree.size() > 0;
    }

    public void setConsiderCaretPositionOnDocumentUpdates(boolean enabled) {
        this.myConsiderCaretPositionOnDocumentUpdates = enabled;
    }

    public void execute(boolean batchMode, @NotNull Runnable operation) {
        if (operation == null) {
            InlayModelImpl.$$$reportNull$$$0(25);
        }
        EditorImpl.assertIsDispatchThread();
        if (this.myInBatchMode || !batchMode) {
            operation.run();
        } else {
            try {
                this.notifyBatchModeStarting();
                this.myInBatchMode = true;
                operation.run();
            }
            finally {
                this.myInBatchMode = false;
                this.notifyBatchModeFinished();
            }
        }
    }

    public boolean isInBatchMode() {
        return this.myInBatchMode;
    }

    public void addListener(@NotNull InlayModel.Listener listener2, @NotNull Disposable disposable2) {
        if (listener2 == null) {
            InlayModelImpl.$$$reportNull$$$0(26);
        }
        if (disposable2 == null) {
            InlayModelImpl.$$$reportNull$$$0(27);
        }
        EditorImpl.assertIsDispatchThread();
        this.myDispatcher.addListener((EventListener)listener2, disposable2);
    }

    private void notifyAdded(InlayImpl inlay) {
        ((InlayModel.Listener)this.myDispatcher.getMulticaster()).onAdded((Inlay)inlay);
    }

    void notifyChanged(InlayImpl inlay, int changeFlags) {
        ((InlayModel.Listener)this.myDispatcher.getMulticaster()).onUpdated((Inlay)inlay, changeFlags);
    }

    void notifyRemoved(InlayImpl inlay) {
        ((InlayModel.Listener)this.myDispatcher.getMulticaster()).onRemoved((Inlay)inlay);
    }

    private void notifyBatchModeStarting() {
        List listeners = this.myDispatcher.getListeners();
        for (int i = listeners.size() - 1; i >= 0; --i) {
            ((InlayModel.Listener)listeners.get(i)).onBatchModeStart((Editor)this.myEditor);
        }
    }

    private void notifyBatchModeFinished() {
        ((InlayModel.Listener)this.myDispatcher.getMulticaster()).onBatchModeFinish((Editor)this.myEditor);
    }

    public void validateState() {
        for (Inlay inlay : this.getInlineElementsInRange(0, this.myEditor.getDocument().getTextLength())) {
            LOG.assertTrue(!DocumentUtil.isInsideSurrogatePair(this.myEditor.getDocument(), inlay.getOffset()));
        }
    }

    @NotNull
    public String dumpState() {
        String string = "Inline elements: " + InlayModelImpl.dumpInlays(this.myInlineElementsTree) + ", after-line-end elements: " + InlayModelImpl.dumpInlays(this.myAfterLineEndElementsTree) + ", block elements: " + InlayModelImpl.dumpInlays(this.myBlockElementsTree);
        if (string == null) {
            InlayModelImpl.$$$reportNull$$$0(28);
        }
        return string;
    }

    private static String dumpInlays(RangeMarkerTree<? extends InlayImpl> tree) {
        StringJoiner joiner = new StringJoiner(",", "[", "]");
        tree.processAll((Processor<? extends InlayImpl>)((Processor)o -> {
            joiner.add(Integer.toString(o.getOffset()));
            return true;
        }));
        return joiner.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/InlayModelImpl";
                break;
            }
            case 7: 
            case 10: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visualPosition";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/InlayModelImpl";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInlineElementsInRange";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlockElementsInRange";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlockElementsForVisualLine";
                break;
            }
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getAfterLineEndElementsInRange";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAfterLineEndElementsForLogicalLine";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "beforeDocumentChange";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addInlineElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addBlockElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addAfterLineEndElement";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getInlineElementsInRange";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getBlockElementsInRange";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getElementsInRange";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "hasInlineElementAt";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getInlineElementAt";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getElementAt";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getAfterLineEndElementsInRange";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class AfterLineEndElementTree
    extends HardReferencingRangeMarkerTree<AfterLineEndInlayImpl> {
        AfterLineEndElementTree(Document document) {
            if (document == null) {
                AfterLineEndElementTree.$$$reportNull$$$0(0);
            }
            super(document);
        }

        @Override
        void fireBeforeRemoved(@NotNull AfterLineEndInlayImpl inlay, @NotNull @NonNls Object reason) {
            if (inlay == null) {
                AfterLineEndElementTree.$$$reportNull$$$0(1);
            }
            if (reason == null) {
                AfterLineEndElementTree.$$$reportNull$$$0(2);
            }
            if (inlay.getUserData(InlayImpl.OFFSET_BEFORE_DISPOSAL) == null) {
                InlayModelImpl.this.notifyRemoved(inlay);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inlay";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reason";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/impl/InlayModelImpl$AfterLineEndElementTree";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fireBeforeRemoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class BlockElementsTree
    extends MarkerTreeWithPartialSums<BlockInlayImpl> {
        BlockElementsTree(Document document) {
            if (document == null) {
                BlockElementsTree.$$$reportNull$$$0(0);
            }
            super(document);
        }

        @Override
        void fireBeforeRemoved(@NotNull BlockInlayImpl inlay, @NotNull @NonNls Object reason) {
            if (inlay == null) {
                BlockElementsTree.$$$reportNull$$$0(1);
            }
            if (reason == null) {
                BlockElementsTree.$$$reportNull$$$0(2);
            }
            if (inlay.getUserData(InlayImpl.OFFSET_BEFORE_DISPOSAL) == null) {
                InlayModelImpl.this.notifyRemoved(inlay);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inlay";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reason";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/impl/InlayModelImpl$BlockElementsTree";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fireBeforeRemoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class InlineElementsTree
    extends HardReferencingRangeMarkerTree<InlineInlayImpl> {
        InlineElementsTree(Document document) {
            if (document == null) {
                InlineElementsTree.$$$reportNull$$$0(0);
            }
            super(document);
        }

        @Override
        @NotNull
        protected HardReferencingRangeMarkerTree.Node<InlineInlayImpl> createNewNode(@NotNull InlineInlayImpl key, int start2, int end, boolean greedyToLeft, boolean greedyToRight, boolean stickingToRight, int layer) {
            if (key == null) {
                InlineElementsTree.$$$reportNull$$$0(1);
            }
            return new HardReferencingRangeMarkerTree.Node<InlineInlayImpl>((RangeMarkerTree)this, key, start2, end, greedyToLeft, greedyToRight, stickingToRight){

                @Override
                void addIntervalsFrom(@NotNull IntervalTreeImpl.IntervalNode<InlineInlayImpl> otherNode) {
                    if (otherNode == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.addIntervalsFrom(otherNode);
                    if (InlayModelImpl.this.myPutMergedIntervalsAtBeginning) {
                        List added = ContainerUtil.subList((List)this.intervals, (int)(this.intervals.size() - otherNode.intervals.size()));
                        ArrayList addedCopy = new ArrayList(added);
                        added.clear();
                        this.intervals.addAll(0, addedCopy);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherNode", "com/intellij/openapi/editor/impl/InlayModelImpl$InlineElementsTree$1", "addIntervalsFrom"));
                }
            };
        }

        @Override
        void fireBeforeRemoved(@NotNull InlineInlayImpl inlay, @NotNull @NonNls Object reason) {
            if (inlay == null) {
                InlineElementsTree.$$$reportNull$$$0(2);
            }
            if (reason == null) {
                InlineElementsTree.$$$reportNull$$$0(3);
            }
            if (inlay.getUserData(InlayImpl.OFFSET_BEFORE_DISPOSAL) == null) {
                if (InlayModelImpl.this.myMoveInProgress) {
                    InlayModelImpl.this.myInlaysInvalidatedOnMove.add(inlay);
                } else {
                    InlayModelImpl.this.notifyRemoved(inlay);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inlay";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reason";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/impl/InlayModelImpl$InlineElementsTree";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createNewNode";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fireBeforeRemoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

