/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.TextChange;
import com.intellij.openapi.editor.impl.TextChangeImpl;
import com.intellij.util.text.StringFactory;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BulkChangesMerger {
    public static final BulkChangesMerger INSTANCE = new BulkChangesMerger();
    private static final Logger LOG = Logger.getInstance(BulkChangesMerger.class);

    public CharSequence mergeToCharSequence(char @NotNull [] text2, int textLength, @NotNull List<? extends TextChange> changes) {
        if (changes == null) {
            BulkChangesMerger.$$$reportNull$$$0(0);
        }
        if (text2 == null) {
            BulkChangesMerger.$$$reportNull$$$0(1);
        }
        return StringFactory.createShared((char[])this.mergeToCharArray(text2, textLength, changes));
    }

    public char @NotNull [] mergeToCharArray(char @NotNull [] text2, int textLength, @NotNull List<? extends TextChange> changes) {
        int n;
        if (changes == null) {
            BulkChangesMerger.$$$reportNull$$$0(2);
        }
        if (text2 == null) {
            BulkChangesMerger.$$$reportNull$$$0(3);
        }
        int newLength = textLength;
        for (TextChange textChange : changes) {
            newLength += textChange.getText().length() - (textChange.getEnd() - textChange.getStart());
        }
        char[] data2 = new char[newLength];
        int n2 = textLength;
        int newEndOffset = data2.length;
        for (int i = changes.size() - 1; i >= 0; --i) {
            TextChange change = changes.get(i);
            void symbolsToMoveNumber = n - change.getEnd();
            System.arraycopy(text2, change.getEnd(), data2, newEndOffset - symbolsToMoveNumber, (int)symbolsToMoveNumber);
            newEndOffset -= symbolsToMoveNumber;
            char[] changeSymbols = change.getChars();
            System.arraycopy(changeSymbols, 0, data2, newEndOffset -= changeSymbols.length, changeSymbols.length);
            n = change.getStart();
        }
        if (n > 0) {
            System.arraycopy(text2, 0, data2, 0, n);
        }
        if (data2 == null) {
            BulkChangesMerger.$$$reportNull$$$0(4);
        }
        return data2;
    }

    public void mergeInPlace(char @NotNull [] data2, int length, @NotNull List<? extends TextChangeImpl> changes) throws IllegalArgumentException {
        if (changes == null) {
            BulkChangesMerger.$$$reportNull$$$0(5);
        }
        if (data2 == null) {
            BulkChangesMerger.$$$reportNull$$$0(6);
        }
        if (changes.isEmpty()) {
            return;
        }
        int diff = 0;
        for (TextChangeImpl textChangeImpl : changes) {
            diff += textChangeImpl.getDiff();
        }
        if (length + diff > data2.length) {
            throw new IllegalArgumentException(String.format("Can't perform in-place changes merge. Reason: data array is not big enough to hold resulting text. Current size: %d, minimum size: %d", data2.length, length + diff));
        }
        try {
            Context context = new Context(changes, data2, length, length + diff);
            while (!context.isComplete()) {
                if (!context.startGroup()) {
                    return;
                }
                context.endGroup();
            }
        }
        catch (RuntimeException e) {
            StringBuilder stringBuilder = new StringBuilder();
            for (TextChangeImpl textChangeImpl : changes) {
                stringBuilder.append(textChangeImpl.getText().length()).append(":").append(textChangeImpl.getStart()).append("-").append(textChangeImpl.getEnd()).append(",");
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.setLength(stringBuilder.length() - 1);
            }
            LOG.error(String.format("Invalid attempt to perform in-place document changes merge detected. Initial text length: %d, data array length: %d, changes: [%s], changes diff: %d", length, data2.length, stringBuilder, diff), (Throwable)e);
            char[] merged = this.mergeToCharArray(data2, length, changes);
            System.arraycopy(merged, 0, data2, 0, length + diff);
        }
    }

    private static void copy(char @NotNull [] data2, int offset, @NotNull CharSequence text2) {
        if (text2 == null) {
            BulkChangesMerger.$$$reportNull$$$0(7);
        }
        if (data2 == null) {
            BulkChangesMerger.$$$reportNull$$$0(8);
        }
        for (int i = 0; i < text2.length(); ++i) {
            data2[i + offset] = text2.charAt(i);
        }
    }

    public int updateOffset(int originalOffset, @NotNull List<? extends TextChange> changes) {
        if (changes == null) {
            BulkChangesMerger.$$$reportNull$$$0(9);
        }
        int offset = originalOffset;
        for (TextChange textChange : changes) {
            if (originalOffset <= textChange.getStart()) continue;
            offset += textChange.getText().length() - (textChange.getEnd() - textChange.getStart());
        }
        return offset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/BulkChangesMerger";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/BulkChangesMerger";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeToCharArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "mergeToCharSequence";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "mergeToCharArray";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "mergeInPlace";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateOffset";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Context {
        private final List<? extends TextChangeImpl> myChanges;
        private final char[] myData;
        private final int myInputLength;
        private final int myOutputLength;
        private int myDataStartOffset;
        private int myDataEndOffset;
        private int myChangeGroupStartIndex;
        private int myChangeGroupEndIndex;
        private int myDiff;
        private int myFirstChangeShift;
        private int myLastChangeShift;

        Context(@NotNull List<? extends TextChangeImpl> changes, char @NotNull [] data2, int inputLength, int outputLength) {
            if (changes == null) {
                Context.$$$reportNull$$$0(0);
            }
            if (data2 == null) {
                Context.$$$reportNull$$$0(1);
            }
            this.myChanges = changes;
            this.myData = data2;
            this.myInputLength = inputLength;
            this.myOutputLength = outputLength;
        }

        public boolean startGroup() {
            boolean first = true;
            while (this.myDiff == 0 && this.myChangeGroupStartIndex < this.myChanges.size()) {
                TextChangeImpl change = this.myChanges.get(this.myChangeGroupStartIndex);
                this.myDiff = change.getDiff();
                if (first) {
                    this.myDiff += this.myFirstChangeShift;
                }
                if (this.myDiff != 0) {
                    this.myDataStartOffset = change.getStart();
                    if (!first) break;
                    this.myDataStartOffset += this.myFirstChangeShift;
                    break;
                }
                BulkChangesMerger.copy(this.myData, change.getStart() + (first ? this.myFirstChangeShift : 0), change.getText());
                ++this.myChangeGroupStartIndex;
                first = false;
            }
            return this.myDiff != 0;
        }

        public void endGroup() {
            boolean includeEndChange = false;
            this.myLastChangeShift = 0;
            this.myChangeGroupEndIndex = this.myChangeGroupStartIndex + 1;
            while (this.myChangeGroupEndIndex < this.myChanges.size()) {
                assert (this.myDiff != 0) : String.format("Text: '%s', length: %d, changes: %s, change group indices: %d-%d", Arrays.toString(this.myData), this.myInputLength, this.myChanges, this.myChangeGroupStartIndex, this.myChangeGroupEndIndex);
                TextChangeImpl change = this.myChanges.get(this.myChangeGroupEndIndex);
                int newDiff = this.myDiff + change.getDiff();
                if (newDiff == 0) {
                    this.myDataEndOffset = change.getEnd();
                    includeEndChange = true;
                    break;
                }
                if (this.myDiff > 0 != newDiff > 0) {
                    this.myDataEndOffset = change.getStart() + this.myDiff;
                    this.myLastChangeShift = this.myDiff;
                    break;
                }
                this.myDiff = newDiff;
                ++this.myChangeGroupEndIndex;
            }
            if (this.myChangeGroupEndIndex >= this.myChanges.size()) {
                if (this.myDiff > 0) {
                    this.processLastPositiveGroup();
                } else {
                    this.processLastNegativeGroup();
                }
                this.myChangeGroupStartIndex = this.myChangeGroupEndIndex = this.myChanges.size();
            } else if (this.myDiff > 0) {
                this.processPositiveGroup(includeEndChange);
            } else {
                this.processNegativeGroup(includeEndChange);
            }
            this.myDiff = 0;
            this.myChangeGroupStartIndex = this.myChangeGroupEndIndex;
            if (includeEndChange) {
                ++this.myChangeGroupStartIndex;
            }
            this.myFirstChangeShift = this.myLastChangeShift;
        }

        private void processPositiveGroup(boolean includeEndChange) {
            int outputOffset = this.myDataEndOffset;
            int prevChangeStart = -1;
            for (int i = this.myChangeGroupEndIndex; i >= this.myChangeGroupStartIndex; --i) {
                int length;
                TextChangeImpl change = this.myChanges.get(i);
                if (prevChangeStart >= 0) {
                    length = prevChangeStart - change.getEnd();
                    System.arraycopy(this.myData, change.getEnd(), this.myData, outputOffset - length, length);
                    outputOffset -= length;
                }
                prevChangeStart = change.getStart();
                if (i == this.myChangeGroupEndIndex && !includeEndChange || (length = change.getText().length()) <= 0) continue;
                BulkChangesMerger.copy(this.myData, outputOffset - length, change.getText());
                outputOffset -= length;
            }
        }

        private void processLastPositiveGroup() {
            int end = this.myChanges.get(this.myChanges.size() - 1).getEnd();
            int length = this.myInputLength - end;
            this.myDataEndOffset = this.myOutputLength - length;
            System.arraycopy(this.myData, end, this.myData, this.myDataEndOffset, length);
            this.myChangeGroupEndIndex = this.myChanges.size() - 1;
            this.processPositiveGroup(true);
        }

        private void processNegativeGroup(boolean includeEndChange) {
            int prevChangeEnd = -1;
            for (int i = this.myChangeGroupStartIndex; i <= this.myChangeGroupEndIndex; ++i) {
                int length;
                TextChangeImpl change = this.myChanges.get(i);
                if (prevChangeEnd >= 0) {
                    length = change.getStart() - prevChangeEnd;
                    System.arraycopy(this.myData, prevChangeEnd, this.myData, this.myDataStartOffset, length);
                    this.myDataStartOffset += length;
                }
                prevChangeEnd = change.getEnd();
                if (i == this.myChangeGroupEndIndex && !includeEndChange) {
                    return;
                }
                length = change.getText().length();
                if (length <= 0) continue;
                BulkChangesMerger.copy(this.myData, this.myDataStartOffset, change.getText());
                this.myDataStartOffset += length;
            }
        }

        private void processLastNegativeGroup() {
            this.myChangeGroupEndIndex = this.myChanges.size() - 1;
            this.processNegativeGroup(true);
            int end = this.myChanges.get(this.myChangeGroupEndIndex).getEnd();
            System.arraycopy(this.myData, end, this.myData, this.myDataStartOffset, this.myInputLength - end);
        }

        public boolean isComplete() {
            return this.myChangeGroupStartIndex >= this.myChanges.size();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "changes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "data";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/impl/BulkChangesMerger$Context";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

