/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCopyPasteHelper;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorTextInsertHandler;
import com.intellij.openapi.editor.actions.BasePasteHandler;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.Producer;
import java.awt.datatransfer.Transferable;

public class PasteAction
extends TextComponentEditorAction {
    private static final Logger LOG = Logger.getInstance(PasteAction.class);
    public static final DataKey<Producer<Transferable>> TRANSFERABLE_PROVIDER = DataKey.create((String)"PasteTransferableProvider");

    public PasteAction() {
        super((EditorActionHandler)new Handler());
    }

    public void update(Editor editor, Presentation presentation, DataContext dataContext) {
        EditorActionHandler handler2 = this.getHandler();
        if (!(handler2 instanceof EditorTextInsertHandler)) {
            if (handler2 != null) {
                PluginException.logPluginError((Logger)LOG, (String)("Handler for EditorPaste action (" + handler2.getClass() + ") should implement com.intellij.openapi.editor.actionSystem.EditorTextInsertHandler"), null, handler2.getClass());
            } else {
                LOG.error("No handler for EditorPaste");
            }
        }
        super.update(editor, presentation, dataContext);
    }

    private static class Handler
    extends BasePasteHandler {
        private Handler() {
        }

        @Override
        public void executeWriteAction(Editor editor, Caret caret, DataContext dataContext) {
            TextRange[] ranges;
            TextRange range2 = null;
            if (this.myTransferable != null && (ranges = EditorCopyPasteHelper.getInstance().pasteTransferable(editor, this.myTransferable)) != null && ranges.length == 1) {
                range2 = ranges[0];
            }
            editor.putUserData(EditorEx.LAST_PASTED_REGION, range2);
        }
    }
}

