/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.ide.lightEdit.LightEditUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.impl.EditorChangeAction;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.AbstractFileViewProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DocumentUndoProvider
implements DocumentListener {
    private static final Key<Boolean> UNDOING_EDITOR_CHANGE = Key.create((String)"DocumentUndoProvider.UNDOING_EDITOR_CHANGE");

    private DocumentUndoProvider() {
    }

    @NotNull
    private static UndoManagerImpl getUndoManager(@Nullable Project project) {
        UndoManagerImpl undoManagerImpl = (UndoManagerImpl)(project == null ? UndoManager.getGlobalInstance() : UndoManager.getInstance((Project)project));
        if (undoManagerImpl == null) {
            DocumentUndoProvider.$$$reportNull$$$0(0);
        }
        return undoManagerImpl;
    }

    public static void startDocumentUndo(@Nullable Document doc) {
        if (doc != null) {
            doc.putUserData(UNDOING_EDITOR_CHANGE, (Object)Boolean.TRUE);
        }
    }

    public static void finishDocumentUndo(@Nullable Document doc) {
        if (doc != null) {
            doc.putUserData(UNDOING_EDITOR_CHANGE, null);
        }
    }

    public void beforeDocumentChange(@NotNull DocumentEvent e) {
        Project lightEditProject;
        Document document;
        if (e == null) {
            DocumentUndoProvider.$$$reportNull$$$0(1);
        }
        if (!DocumentUndoProvider.shouldProcess(document = e.getDocument())) {
            return;
        }
        DocumentUndoProvider.handleBeforeDocumentChange(DocumentUndoProvider.getUndoManager(null), document);
        ProjectManager projectManager = ProjectManager.getInstanceIfCreated();
        if (projectManager != null) {
            for (Project project : projectManager.getOpenProjects()) {
                DocumentUndoProvider.handleBeforeDocumentChange(DocumentUndoProvider.getUndoManager(project), document);
            }
        }
        if ((lightEditProject = LightEditUtil.getProjectIfCreated()) != null) {
            DocumentUndoProvider.handleBeforeDocumentChange(DocumentUndoProvider.getUndoManager(lightEditProject), document);
        }
    }

    private static void handleBeforeDocumentChange(@NotNull UndoManagerImpl undoManager, @NotNull Document document) {
        if (undoManager == null) {
            DocumentUndoProvider.$$$reportNull$$$0(2);
        }
        if (document == null) {
            DocumentUndoProvider.$$$reportNull$$$0(3);
        }
        if (undoManager.isActive() && DocumentUndoProvider.isUndoable(undoManager, document) && undoManager.isUndoOrRedoInProgress() && document.getUserData(UNDOING_EDITOR_CHANGE) != Boolean.TRUE) {
            throw new IllegalStateException("Do not change documents during undo as it will break undo sequence.");
        }
    }

    public void documentChanged(@NotNull DocumentEvent e) {
        Project lightEditProject;
        Document document;
        if (e == null) {
            DocumentUndoProvider.$$$reportNull$$$0(4);
        }
        if (!DocumentUndoProvider.shouldProcess(document = e.getDocument())) {
            return;
        }
        DocumentUndoProvider.handleDocumentChanged(DocumentUndoProvider.getUndoManager(null), document, e);
        ProjectManager projectManager = ProjectManager.getInstanceIfCreated();
        if (projectManager != null) {
            for (Project project : projectManager.getOpenProjects()) {
                DocumentUndoProvider.handleDocumentChanged(DocumentUndoProvider.getUndoManager(project), document, e);
            }
        }
        if ((lightEditProject = LightEditUtil.getProjectIfCreated()) != null) {
            DocumentUndoProvider.handleDocumentChanged(DocumentUndoProvider.getUndoManager(lightEditProject), document, e);
        }
    }

    private static void handleDocumentChanged(@NotNull UndoManagerImpl undoManager, @NotNull Document document, @NotNull DocumentEvent e) {
        if (undoManager == null) {
            DocumentUndoProvider.$$$reportNull$$$0(5);
        }
        if (document == null) {
            DocumentUndoProvider.$$$reportNull$$$0(6);
        }
        if (e == null) {
            DocumentUndoProvider.$$$reportNull$$$0(7);
        }
        if (undoManager.isActive() && DocumentUndoProvider.isUndoable(undoManager, document)) {
            DocumentUndoProvider.registerUndoableAction(undoManager, e);
        } else {
            DocumentUndoProvider.registerNonUndoableAction(undoManager, document);
        }
    }

    private static boolean shouldProcess(@NotNull Document document) {
        if (document == null) {
            DocumentUndoProvider.$$$reportNull$$$0(8);
        }
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            return false;
        }
        return !UndoManagerImpl.isCopy(document) && DocumentUndoProvider.shouldRecordActions(document);
    }

    private static boolean shouldRecordActions(@NotNull Document document) {
        if (document == null) {
            DocumentUndoProvider.$$$reportNull$$$0(9);
        }
        if (document.getUserData(UndoConstants.DONT_RECORD_UNDO) == Boolean.TRUE) {
            return false;
        }
        VirtualFile vFile = FileDocumentManager.getInstance().getFile(document);
        if (vFile == null) {
            return true;
        }
        return vFile.getUserData(AbstractFileViewProvider.FREE_THREADED) != Boolean.TRUE && vFile.getUserData(UndoConstants.DONT_RECORD_UNDO) != Boolean.TRUE;
    }

    private static void registerUndoableAction(@NotNull UndoManagerImpl undoManager, @NotNull DocumentEvent e) {
        if (undoManager == null) {
            DocumentUndoProvider.$$$reportNull$$$0(10);
        }
        if (e == null) {
            DocumentUndoProvider.$$$reportNull$$$0(11);
        }
        undoManager.undoableActionPerformed((UndoableAction)new EditorChangeAction(e));
    }

    private static void registerNonUndoableAction(@NotNull UndoManagerImpl undoManager, @NotNull Document document) {
        if (undoManager == null) {
            DocumentUndoProvider.$$$reportNull$$$0(12);
        }
        if (document == null) {
            DocumentUndoProvider.$$$reportNull$$$0(13);
        }
        DocumentReference ref = DocumentReferenceManager.getInstance().create(document);
        undoManager.nonundoableActionPerformed(ref, false);
    }

    private static boolean isUndoable(@NotNull UndoManagerImpl undoManager, @NotNull Document document) {
        DocumentReference ref;
        VirtualFile file2;
        if (undoManager == null) {
            DocumentUndoProvider.$$$reportNull$$$0(14);
        }
        if (document == null) {
            DocumentUndoProvider.$$$reportNull$$$0(15);
        }
        if ((file2 = (ref = DocumentReferenceManager.getInstance().create(document)).getFile()) != null && file2.getUserData(UndoConstants.FORCE_RECORD_UNDO) == Boolean.TRUE) {
            return true;
        }
        return !UndoManagerImpl.isRefresh() || undoManager.isUndoOrRedoAvailable(ref);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/command/impl/DocumentUndoProvider";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "undoManager";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUndoManager";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/command/impl/DocumentUndoProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "beforeDocumentChange";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleBeforeDocumentChange";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "handleDocumentChanged";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "shouldProcess";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "shouldRecordActions";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "registerUndoableAction";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "registerNonUndoableAction";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isUndoable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

