/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.constraints;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.WeakReferenceDisposableWrapper;
import com.intellij.openapi.application.constraints.ExpirableConstrainedExecution;
import com.intellij.openapi.application.constraints.Expiration;
import com.intellij.openapi.application.constraints.ExpirationKt;
import com.intellij.openapi.application.constraints.JobExpiration;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.DisposableHandle;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u001a\u001e\u0010\b\u001a\u00020\t*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u0001H\u0000\u001a\u0012\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b\u001a\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u000f*\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013\u001a\u0018\u0010\u0014\u001a\u00020\u000e*\u00020\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0018\u0010\u0004\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0003\u00a8\u0006\u0018"}, d2={"isDisposed", "", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/Disposable;)Z", "isDisposing", "tryRegisterDisposable", "parent", "child", "cancelJobOnDisposal", "Ljava/lang/AutoCloseable;", "job", "Lkotlinx/coroutines/Job;", "weaklyReferencedJob", "cancelJobOnExpiration", "Lcom/intellij/openapi/application/constraints/Expiration$Handle;", "Lcom/intellij/openapi/application/constraints/Expiration;", "composeExpiration", "Lcom/intellij/openapi/application/constraints/Expiration$Companion;", "expirationSet", "", "invokeOnExpiration", "block", "Lkotlin/Function0;", "", "intellij.platform.ide.impl"})
public final class ExpirationKt {
    @Nullable
    public static final Expiration composeExpiration(@NotNull Expiration.Companion $this$composeExpiration, @NotNull Collection<? extends Expiration> expirationSet) {
        Expiration expiration;
        Intrinsics.checkParameterIsNotNull((Object)$this$composeExpiration, (String)"$this$composeExpiration");
        Intrinsics.checkParameterIsNotNull(expirationSet, (String)"expirationSet");
        switch (expirationSet.size()) {
            case 0: {
                expiration = null;
                break;
            }
            case 1: {
                expiration = (Expiration)CollectionsKt.single((Iterable)expirationSet);
                break;
            }
            default: {
                CompletableJob job2 = SupervisorKt.SupervisorJob$default(null, (int)1, null);
                Iterable $this$forEach$iv = expirationSet;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Expiration it = (Expiration)element$iv;
                    boolean bl = false;
                    ExpirationKt.cancelJobOnExpiration(it, (Job)job2);
                }
                expiration = new JobExpiration((Job)job2);
            }
        }
        return expiration;
    }

    @NotNull
    public static final Expiration.Handle invokeOnExpiration(@NotNull Expiration $this$invokeOnExpiration, @NotNull Function0<Unit> block) {
        Intrinsics.checkParameterIsNotNull((Object)$this$invokeOnExpiration, (String)"$this$invokeOnExpiration");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        Expiration expiration = $this$invokeOnExpiration;
        boolean $i$f$Runnable = false;
        Runnable runnable2 = new Runnable(block){
            final /* synthetic */ Function0 $block;
            {
                this.$block = function0;
            }

            public final void run() {
                this.$block.invoke();
            }
        };
        return expiration.invokeOnExpiration(runnable2);
    }

    @NotNull
    public static final Expiration.Handle cancelJobOnExpiration(@NotNull Expiration $this$cancelJobOnExpiration, @NotNull Job job2) {
        Intrinsics.checkParameterIsNotNull((Object)$this$cancelJobOnExpiration, (String)"$this$cancelJobOnExpiration");
        Intrinsics.checkParameterIsNotNull((Object)job2, (String)"job");
        Expiration.Handle handle = ExpirationKt.invokeOnExpiration($this$cancelJobOnExpiration, (Function0<Unit>)((Function0)new Function0<Unit>(job2){
            final /* synthetic */ Job $job;

            public final void invoke() {
                Job.DefaultImpls.cancel$default((Job)this.$job, null, (int)1, null);
            }
            {
                this.$job = job2;
                super(0);
            }
        }));
        boolean bl = false;
        boolean bl2 = false;
        Expiration.Handle registration = handle;
        boolean bl3 = false;
        job2.invokeOnCompletion((Function1)new Function1<Throwable, Unit>(registration){
            final /* synthetic */ Expiration.Handle $registration;

            public final void invoke(@Nullable Throwable it) {
                this.$registration.unregisterHandler();
            }
            {
                this.$registration = handle;
                super(1);
            }
        });
        return handle;
    }

    public static final boolean isDisposed(@NotNull Disposable $this$isDisposed) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isDisposed, (String)"$this$isDisposed");
        return Disposer.isDisposed((Disposable)$this$isDisposed);
    }

    public static final boolean isDisposing(@NotNull Disposable $this$isDisposing) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isDisposing, (String)"$this$isDisposing");
        return Disposer.isDisposing((Disposable)$this$isDisposing);
    }

    private static final boolean tryRegisterDisposable(Disposable parent, Disposable child2) {
        if (!ExpirationKt.isDisposing(parent) && !ExpirationKt.isDisposed(parent)) {
            try {
                Disposer.register((Disposable)parent, (Disposable)child2);
                return true;
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
        }
        return false;
    }

    @NotNull
    public static final AutoCloseable cancelJobOnDisposal(@NotNull Disposable $this$cancelJobOnDisposal, @NotNull Job job2, boolean weaklyReferencedJob) {
        Disposable childRef;
        Intrinsics.checkParameterIsNotNull((Object)$this$cancelJobOnDisposal, (String)"$this$cancelJobOnDisposal");
        Intrinsics.checkParameterIsNotNull((Object)job2, (String)"job");
        ExpirableConstrainedExecution.Companion.RunOnce runOnce = new ExpirableConstrainedExecution.Companion.RunOnce();
        Disposable child2 = new Disposable(runOnce, job2){
            final /* synthetic */ ExpirableConstrainedExecution.Companion.RunOnce $runOnce;
            final /* synthetic */ Job $job;

            public final void dispose() {
                this.$runOnce.invoke((Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ cancelJobOnDisposal.child.1 this$0;

                    public final void invoke() {
                        Job.DefaultImpls.cancel$default((Job)this.this$0.$job, null, (int)1, null);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
            }
            {
                this.$runOnce = runOnce;
                this.$job = job2;
            }
        };
        Disposable disposable2 = childRef = !weaklyReferencedJob ? child2 : (Disposable)new WeakReferenceDisposableWrapper(child2);
        if (!ExpirationKt.tryRegisterDisposable($this$cancelJobOnDisposal, childRef)) {
            Disposer.dispose((Disposable)childRef);
            ObjectUtils.reachabilityFence((Object)child2);
            return cancelJobOnDisposal.1.INSTANCE;
        }
        Function1<Throwable, Unit> completionHandler2 = new Function1<Throwable, Unit>(runOnce, childRef, child2){
            @NotNull
            private final Disposable hardRefToChild;
            final /* synthetic */ ExpirableConstrainedExecution.Companion.RunOnce $runOnce;
            final /* synthetic */ Disposable $childRef;
            final /* synthetic */ Disposable $child;

            public static /* synthetic */ void hardRefToChild$annotations() {
            }

            @NotNull
            public final Disposable getHardRefToChild() {
                return this.hardRefToChild;
            }

            public void invoke(@Nullable Throwable cause) {
                this.$runOnce.invoke((Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ cancelJobOnDisposal.completionHandler.1 this$0;

                    public final void invoke() {
                        Disposer.dispose((Disposable)this.this$0.$childRef);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
            }
            {
                this.$runOnce = $captured_local_variable$0;
                this.$childRef = $captured_local_variable$1;
                this.$child = $captured_local_variable$2;
                this.hardRefToChild = $captured_local_variable$2;
            }
        };
        DisposableHandle jobCompletionUnregisteringHandle = job2.invokeOnCompletion((Function1)completionHandler2);
        return new AutoCloseable(jobCompletionUnregisteringHandle, completionHandler2){
            final /* synthetic */ DisposableHandle $jobCompletionUnregisteringHandle;
            final /* synthetic */ cancelJobOnDisposal.completionHandler.1 $completionHandler;

            public final void close() {
                this.$jobCompletionUnregisteringHandle.dispose();
                this.$completionHandler.invoke(null);
            }
            {
                this.$jobCompletionUnregisteringHandle = disposableHandle;
                this.$completionHandler = var2_2;
            }
        };
    }

    public static /* synthetic */ AutoCloseable cancelJobOnDisposal$default(Disposable disposable2, Job job2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return ExpirationKt.cancelJobOnDisposal(disposable2, job2, bl);
    }
}

