/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.notification.impl.NotificationSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="NotificationConfiguration", storages={@Storage(value="notifications.xml")})
public final class NotificationsConfigurationImpl
extends NotificationsConfiguration
implements PersistentStateComponent<Element>,
Disposable {
    private static final Logger LOG = Logger.getInstance(NotificationsConfiguration.class);
    private static final String SHOW_BALLOONS_ATTRIBUTE = "showBalloons";
    private static final String SYSTEM_NOTIFICATIONS_ATTRIBUTE = "systemNotifications";
    private static final Comparator<NotificationSettings> NOTIFICATION_SETTINGS_COMPARATOR = (o1, o2) -> o1.getGroupId().compareToIgnoreCase(o2.getGroupId());
    private final Map<String, NotificationSettings> myIdToSettingsMap = new THashMap();
    private final Map<String, String> myToolWindowCapable = new THashMap();
    public boolean SHOW_BALLOONS = true;
    public boolean SYSTEM_NOTIFICATIONS = true;

    public static NotificationsConfigurationImpl getInstanceImpl() {
        return (NotificationsConfigurationImpl)NotificationsConfigurationImpl.getNotificationsConfiguration();
    }

    public synchronized boolean hasToolWindowCapability(@NotNull String groupId2) {
        if (groupId2 == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(0);
        }
        return this.getToolWindowId(groupId2) != null || this.myToolWindowCapable.containsKey(groupId2);
    }

    @Nullable
    public String getToolWindowId(@NotNull String groupId2) {
        NotificationGroup group;
        if (groupId2 == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(1);
        }
        return (group = NotificationGroup.findRegisteredGroup((String)groupId2)) == null ? null : group.getToolWindowId();
    }

    public synchronized NotificationSettings[] getAllSettings() {
        THashSet settings = new THashSet(this.myIdToSettingsMap.values());
        for (NotificationGroup group : NotificationGroup.getAllRegisteredGroups()) {
            if (group.getDisplayId().startsWith("LIGHTWEIGHT")) continue;
            settings.add(NotificationsConfigurationImpl.getSettings(group.getDisplayId()));
        }
        NotificationSettings[] result2 = settings.toArray(new NotificationSettings[0]);
        Arrays.sort(result2, NOTIFICATION_SETTINGS_COMPARATOR);
        return result2;
    }

    public static void remove(String ... toRemove2) {
        NotificationsConfigurationImpl.getInstanceImpl().doRemove(toRemove2);
    }

    private synchronized void doRemove(String ... toRemove2) {
        for (String groupId2 : toRemove2) {
            this.myIdToSettingsMap.remove(groupId2);
            this.myToolWindowCapable.remove(groupId2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static NotificationSettings getSettings(@NotNull String groupId2) {
        NotificationSettings settings;
        NotificationsConfigurationImpl impl;
        if (groupId2 == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(2);
        }
        NotificationsConfigurationImpl notificationsConfigurationImpl = impl = NotificationsConfigurationImpl.getInstanceImpl();
        synchronized (notificationsConfigurationImpl) {
            settings = impl.myIdToSettingsMap.get(groupId2);
        }
        NotificationSettings notificationSettings = settings == null ? NotificationsConfigurationImpl.getDefaultSettings(groupId2) : settings;
        if (notificationSettings == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(3);
        }
        return notificationSettings;
    }

    @NotNull
    private static NotificationSettings getDefaultSettings(String groupId2) {
        NotificationGroup group = NotificationGroup.findRegisteredGroup((String)groupId2);
        if (group != null) {
            return new NotificationSettings(groupId2, group.getDisplayType(), group.isLogByDefault(), false);
        }
        return new NotificationSettings(groupId2, NotificationDisplayType.BALLOON, true, false);
    }

    public synchronized void dispose() {
        this.myIdToSettingsMap.clear();
    }

    public void register(@NotNull String groupDisplayName, @NotNull NotificationDisplayType displayType) {
        if (groupDisplayName == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(4);
        }
        if (displayType == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(5);
        }
        this.register(groupDisplayName, displayType, true);
    }

    public void register(@NotNull String groupDisplayName, @NotNull NotificationDisplayType displayType, boolean shouldLog) {
        if (groupDisplayName == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(6);
        }
        if (displayType == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(7);
        }
        this.register(groupDisplayName, displayType, shouldLog, false);
    }

    public void register(@NotNull String groupDisplayName, @NotNull NotificationDisplayType displayType, boolean shouldLog, boolean shouldReadAloud) {
        if (groupDisplayName == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(8);
        }
        if (displayType == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(9);
        }
        if (!this.isRegistered(groupDisplayName)) {
            new NotificationGroup(groupDisplayName, displayType, shouldLog);
            this.changeSettings(groupDisplayName, displayType, shouldLog, shouldReadAloud);
        } else if (displayType == NotificationDisplayType.TOOL_WINDOW && !this.hasToolWindowCapability(groupDisplayName)) {
            this.changeSettings(NotificationsConfigurationImpl.getSettings(groupDisplayName).withDisplayType(NotificationDisplayType.TOOL_WINDOW));
            this.myToolWindowCapable.put(groupDisplayName, null);
        }
    }

    public void changeSettings(String groupDisplayName, NotificationDisplayType displayType, boolean shouldLog, boolean shouldReadAloud) {
        this.changeSettings(new NotificationSettings(groupDisplayName, displayType, shouldLog, shouldReadAloud));
    }

    public synchronized void changeSettings(NotificationSettings settings) {
        String groupDisplayName = settings.getGroupId();
        if (settings.equals(NotificationsConfigurationImpl.getDefaultSettings(groupDisplayName))) {
            this.myIdToSettingsMap.remove(groupDisplayName);
        } else {
            this.myIdToSettingsMap.put(groupDisplayName, settings);
        }
    }

    public synchronized boolean isRegistered(@NotNull String id2) {
        if (id2 == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(10);
        }
        return this.myIdToSettingsMap.containsKey(id2) || NotificationGroup.findRegisteredGroup((String)id2) != null;
    }

    public synchronized Element getState() {
        Element element2 = new Element("NotificationsConfiguration");
        NotificationSettings[] sortedNotifications = this.myIdToSettingsMap.values().toArray(new NotificationSettings[0]);
        Arrays.sort(sortedNotifications, NOTIFICATION_SETTINGS_COMPARATOR);
        for (NotificationSettings settings : sortedNotifications) {
            element2.addContent(settings.save());
        }
        if (!this.SHOW_BALLOONS) {
            element2.setAttribute(SHOW_BALLOONS_ATTRIBUTE, "false");
        }
        if (!this.SYSTEM_NOTIFICATIONS) {
            element2.setAttribute(SYSTEM_NOTIFICATIONS_ATTRIBUTE, "false");
        }
        return element2;
    }

    public synchronized void loadState(@NotNull Element state) {
        if (state == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(11);
        }
        this.myIdToSettingsMap.clear();
        for (Element child2 : state.getChildren("notification")) {
            NotificationSettings settings = NotificationSettings.load(child2);
            if (settings == null) continue;
            String id2 = settings.getGroupId();
            LOG.assertTrue(!this.myIdToSettingsMap.containsKey(id2), (Object)String.format("Settings for '%s' already loaded!", id2));
            this.myIdToSettingsMap.put(id2, settings);
        }
        this.doRemove("Log Only");
        if ("false".equals(state.getAttributeValue(SHOW_BALLOONS_ATTRIBUTE))) {
            this.SHOW_BALLOONS = false;
        }
        if ("false".equals(state.getAttributeValue(SYSTEM_NOTIFICATIONS_ATTRIBUTE))) {
            this.SYSTEM_NOTIFICATIONS = false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/notification/impl/NotificationsConfigurationImpl";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupDisplayName";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/notification/impl/NotificationsConfigurationImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasToolWindowCapability";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getToolWindowId";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSettings";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isRegistered";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class MyNotificationListener
    implements Notifications {
        MyNotificationListener() {
        }

        public void notify(@NotNull Notification notification) {
            if (notification == null) {
                MyNotificationListener.$$$reportNull$$$0(0);
            }
            NotificationsConfigurationImpl.getInstanceImpl().notify(notification);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/impl/NotificationsConfigurationImpl$MyNotificationListener", "notify"));
        }
    }
}

