/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.ui;

import com.intellij.ide.GeneralSettings;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.jdkEx.JdkEx;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import gnu.trove.THashSet;
import java.awt.DisplayMode;
import java.awt.GraphicsEnvironment;
import java.util.Set;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

public class UiInfoUsageCollector
extends ApplicationUsagesCollector {
    @NotNull
    public String getGroupId() {
        return "ui.info.features";
    }

    public int getVersion() {
        return 4;
    }

    @NotNull
    public Set<MetricEvent> getMetrics() {
        return UiInfoUsageCollector.getDescriptors();
    }

    @NotNull
    public static Set<MetricEvent> getDescriptors() {
        THashSet set = new THashSet();
        UiInfoUsageCollector.addValue((Set<? super MetricEvent>)set, "Nav.Bar", UiInfoUsageCollector.navbar() ? "visible" : "floating");
        UiInfoUsageCollector.addValue((Set<? super MetricEvent>)set, "Nav.Bar.members", UISettings.getInstance().getShowMembersInNavigationBar() ? "visible" : "hidden");
        UiInfoUsageCollector.addValue((Set<? super MetricEvent>)set, "Toolbar", UiInfoUsageCollector.toolbar() ? "visible" : "hidden");
        UiInfoUsageCollector.addValue((Set<? super MetricEvent>)set, "Status.bar", UiInfoUsageCollector.status() ? "visible" : "hidden");
        UiInfoUsageCollector.addValue((Set<? super MetricEvent>)set, "Tool.Window.buttons", UiInfoUsageCollector.stripes() ? "visible" : "hidden");
        UiInfoUsageCollector.addValue((Set<? super MetricEvent>)set, "Toolbar.and.NavBar", new FeatureUsageData().addData("toolbar", UiInfoUsageCollector.toolbar() ? "visible" : "hidden").addData("navbar", UiInfoUsageCollector.navbar() ? "visible" : "hidden"));
        UiInfoUsageCollector.addValue((Set<? super MetricEvent>)set, "Recent.files.limit", new FeatureUsageData().addData("count", UiInfoUsageCollector.recent()).addData("grouped", UiInfoUsageCollector.recentPeriod(UiInfoUsageCollector.recent())));
        UISettings ui = UISettings.getInstance();
        UiInfoUsageCollector.addEnabled((Set<? super MetricEvent>)set, "Show.Editor.Tabs.In.Single.Row", ui.getScrollTabLayoutInEditor());
        UiInfoUsageCollector.addEnabled((Set<? super MetricEvent>)set, "Hide.Editor.Tabs.If.Needed", ui.getScrollTabLayoutInEditor() && ui.getHideTabsIfNeeded());
        UiInfoUsageCollector.addEnabled((Set<? super MetricEvent>)set, "Block.cursor", EditorSettingsExternalizable.getInstance().isBlockCursor());
        UiInfoUsageCollector.addEnabled((Set<? super MetricEvent>)set, "Line.Numbers", EditorSettingsExternalizable.getInstance().isLineNumbersShown());
        UiInfoUsageCollector.addEnabled((Set<? super MetricEvent>)set, "Gutter.Icons", EditorSettingsExternalizable.getInstance().areGutterIconsShown());
        UiInfoUsageCollector.addEnabled((Set<? super MetricEvent>)set, "Soft.Wraps", EditorSettingsExternalizable.getInstance().isUseSoftWraps());
        UiInfoUsageCollector.addValue((Set<? super MetricEvent>)set, "Tabs", UiInfoUsageCollector.getTabsSetting());
        UiInfoUsageCollector.addEnabled((Set<? super MetricEvent>)set, "Retina", UIUtil.isRetina());
        UiInfoUsageCollector.addEnabled((Set<? super MetricEvent>)set, "Show.tips.on.startup", GeneralSettings.getInstance().isShowTipsOnStartup());
        UiInfoUsageCollector.addEnabled((Set<? super MetricEvent>)set, "Allow.merging.buttons", ui.getAllowMergeButtons());
        PropertiesComponent properties = PropertiesComponent.getInstance();
        UiInfoUsageCollector.addEnabled((Set<? super MetricEvent>)set, "QuickDoc.Show.Toolwindow", properties.isTrueValue("ShowDocumentationInToolWindow"));
        UiInfoUsageCollector.addEnabled((Set<? super MetricEvent>)set, "QuickDoc.AutoUpdate", properties.getBoolean("DocumentationAutoUpdateEnabled", true));
        UIManager.LookAndFeelInfo laf = LafManager.getInstance().getCurrentLookAndFeel();
        UiInfoUsageCollector.addValue((Set<? super MetricEvent>)set, "Look.and.Feel", StringUtil.notNullize((String)(laf != null ? laf.getName() : null), (String)"unknown"));
        UiInfoUsageCollector.addValue((Set<? super MetricEvent>)set, "Hidpi.Mode", JreHiDpiUtil.isJreHiDPIEnabled() ? "per_monitor_dpi" : "system_dpi");
        UiInfoUsageCollector.addEnabled((Set<? super MetricEvent>)set, "Screen.Reader", ScreenReader.isActive());
        UiInfoUsageCollector.addScreenScale((Set<? super MetricEvent>)set);
        THashSet tHashSet = set;
        if (tHashSet == null) {
            UiInfoUsageCollector.$$$reportNull$$$0(0);
        }
        return tHashSet;
    }

    @NotNull
    private static String recentPeriod(int recent) {
        if (recent < 15) {
            return "less.than.15";
        }
        if (16 < recent && recent < 31) {
            return "[15_30]";
        }
        if (30 < recent && recent < 51) {
            return "[30_50]";
        }
        return "[more.than.50]";
    }

    @NotNull
    private static String getTabsSetting() {
        int place = UiInfoUsageCollector.tabPlace();
        if (place == 0) {
            return "None";
        }
        if (place == 1) {
            return "Top";
        }
        if (place == 3) {
            return "Bottom";
        }
        if (place == 2) {
            return "Left";
        }
        if (place == 4) {
            return "Right";
        }
        return "Unknown";
    }

    private static void addValue(Set<? super MetricEvent> set, String key, FeatureUsageData data2) {
        set.add((MetricEvent)MetricEventFactoryKt.newMetric((String)key, (FeatureUsageData)data2));
    }

    private static void addValue(Set<? super MetricEvent> set, String key, String value2) {
        set.add((MetricEvent)MetricEventFactoryKt.newMetric((String)key, (FeatureUsageData)new FeatureUsageData().addValue((Object)value2)));
    }

    private static void addEnabled(Set<? super MetricEvent> set, String key, boolean enabled) {
        set.add((MetricEvent)MetricEventFactoryKt.newBooleanMetric((String)key, (boolean)enabled));
    }

    private static int tabPlace() {
        return UISettings.getInstance().getEditorTabPlacement();
    }

    private static int recent() {
        return UISettings.getInstance().getRecentFilesLimit();
    }

    private static boolean stripes() {
        return UISettings.getInstance().getHideToolStripes();
    }

    private static boolean status() {
        return UISettings.getInstance().getShowStatusBar();
    }

    private static boolean toolbar() {
        return UISettings.getInstance().getShowMainToolbar();
    }

    private static boolean navbar() {
        return UISettings.getInstance().getShowNavigationBar();
    }

    private static void addScreenScale(Set<? super MetricEvent> set) {
        int scaleBase;
        float scale = JBUIScale.sysScale();
        float scaleFract = scale - (float)(scaleBase = (int)Math.floor(scale));
        scaleFract = scaleFract == 0.0f ? 0.0f : (scaleFract < 0.375f ? 0.25f : (scaleFract < 0.625f ? 0.5f : 0.75f));
        scale = (float)scaleBase + scaleFract;
        boolean isScaleMode = false;
        if (!GraphicsEnvironment.isHeadless()) {
            DisplayMode dm = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode();
            isScaleMode = JdkEx.getDisplayModeEx().isDefault(dm);
        }
        FeatureUsageData data2 = new FeatureUsageData().addData("scale_mode", isScaleMode).addData("scale", scale);
        set.add((MetricEvent)MetricEventFactoryKt.newMetric((String)"Screen.Scale", (FeatureUsageData)data2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/collectors/fus/ui/UiInfoUsageCollector", "getDescriptors"));
    }
}

