/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.configurable;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.psi.search.TodoPattern;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.FormBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

class FilterDialog
extends DialogWrapper {
    private final TodoFilter myFilter;
    private final int myFilterIndex;
    private final List<? extends TodoFilter> myFilters;
    private final JTextField myNameField;
    private final JScrollPane myPatternsScrollPane;

    FilterDialog(Component parent, TodoFilter filter2, int filterIndex, List<? extends TodoFilter> filters, List<TodoPattern> patterns) {
        super(parent, true);
        this.setTitle(IdeBundle.message((String)"title.add.todo.filter", (Object[])new Object[0]));
        this.myFilter = filter2;
        this.myFilterIndex = filterIndex;
        this.myFilters = filters;
        this.myNameField = new JBTextField(filter2.getName());
        CheckBoxList patternsList = new CheckBoxList();
        patternsList.setSelectionMode(2);
        patternsList.setCheckBoxListListener((index, value2) -> {
            if (value2) {
                this.myFilter.addTodoPattern((TodoPattern)patternsList.getItemAt(index));
            } else {
                this.myFilter.removeTodoPattern((TodoPattern)patternsList.getItemAt(index));
            }
        });
        for (TodoPattern pattern : patterns) {
            patternsList.addItem((Object)pattern, pattern.getPatternString(), this.myFilter.contains(pattern));
        }
        if (patternsList.getItemsCount() > 0) {
            patternsList.setSelectedIndex(0);
        }
        this.myPatternsScrollPane = ScrollPaneFactory.createScrollPane((Component)patternsList);
        this.myPatternsScrollPane.setMinimumSize(new Dimension(300, -1));
        this.init();
    }

    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        ArrayList<ValidationInfo> result2 = new ArrayList<ValidationInfo>();
        String filterName = this.getNewFilterName();
        if (filterName.isEmpty()) {
            result2.add(new ValidationInfo(IdeBundle.message((String)"error.filter.name.should.be.specified", (Object[])new Object[0]), (JComponent)this.myNameField));
        } else {
            for (int i = 0; i < this.myFilters.size(); ++i) {
                TodoFilter filter2 = this.myFilters.get(i);
                if (this.myFilterIndex == i || !filterName.equals(filter2.getName())) continue;
                result2.add(new ValidationInfo(IdeBundle.message((String)"error.filter.with.the.same.name.already.exists", (Object[])new Object[0]), (JComponent)this.myNameField));
            }
        }
        if (this.myFilter.isEmpty()) {
            result2.add(new ValidationInfo(IdeBundle.message((String)"error.filter.should.contain.at.least.one.pattern", (Object[])new Object[0]), (JComponent)this.myPatternsScrollPane));
        }
        ArrayList<ValidationInfo> arrayList = result2;
        if (arrayList == null) {
            FilterDialog.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @NotNull
    private String getNewFilterName() {
        String string = this.myNameField.getText().trim();
        if (string == null) {
            FilterDialog.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected void doOKAction() {
        this.myFilter.setName(this.getNewFilterName());
        super.doOKAction();
    }

    protected String getHelpId() {
        return "reference.idesettings.todo.editfilter";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    protected JComponent createCenterPanel() {
        JPanel patternListPanel = new JPanel(new BorderLayout());
        patternListPanel.setBorder(IdeBorderFactory.createTitledBorder((String)IdeBundle.message((String)"group.todo.filter.patterns", (Object[])new Object[0])));
        patternListPanel.add((Component)this.myPatternsScrollPane, "Center");
        return FormBuilder.createFormBuilder().addLabeledComponent(IdeBundle.message((String)"label.todo.filter.name", (Object[])new Object[0]), (JComponent)this.myNameField).addComponentFillVertically((JComponent)patternListPanel, 0).getPanel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/todo/configurable/FilterDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "doValidateAll";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewFilterName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

