/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.impl.AbstractUrl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.NonNls;

public class DirectoryUrl
extends AbstractUrl {
    @NonNls
    private static final String ELEMENT_TYPE = "directory";

    public DirectoryUrl(String url, String moduleName) {
        super(url, moduleName, ELEMENT_TYPE);
    }

    public static DirectoryUrl create(PsiDirectory directory) {
        Project project = directory.getProject();
        VirtualFile virtualFile = directory.getVirtualFile();
        Module module = ModuleUtil.findModuleForFile((VirtualFile)virtualFile, (Project)project);
        return new DirectoryUrl(virtualFile.getUrl(), module != null ? module.getName() : null);
    }

    @Override
    public Object[] createPath(Project project) {
        Module module;
        if (this.moduleName != null && (module = (Module)ReadAction.compute(() -> ModuleManager.getInstance((Project)project).findModuleByName(this.moduleName))) == null) {
            return null;
        }
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        VirtualFile file2 = virtualFileManager.findFileByUrl(this.url);
        if (file2 == null) {
            return null;
        }
        PsiDirectory directory = (PsiDirectory)ReadAction.compute(() -> PsiManager.getInstance((Project)project).findDirectory(file2));
        if (directory == null) {
            return null;
        }
        return new Object[]{directory};
    }

    @Override
    protected AbstractUrl createUrl(String moduleName, String url) {
        return new DirectoryUrl(url, moduleName);
    }

    @Override
    public AbstractUrl createUrlByElement(Object element2) {
        if (element2 instanceof PsiDirectory) {
            return DirectoryUrl.create((PsiDirectory)element2);
        }
        return null;
    }
}

