/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.errorTreeView.impl;

import com.intellij.ide.ExporterToTextFile;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.ErrorViewStructure;
import com.intellij.ide.errorTreeView.NavigatableMessageElement;
import com.intellij.util.SystemProperties;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.TooManyListenersException;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class ErrorViewTextExporter
implements ExporterToTextFile {
    private final JCheckBox myCbShowDetails;
    private final ErrorViewStructure myStructure;
    private ChangeListener myChangeListener;

    public ErrorViewTextExporter(ErrorViewStructure treeStructure) {
        this.myStructure = treeStructure;
        this.myCbShowDetails = new JCheckBox(IdeBundle.message((String)"checkbox.errortree.export.details", (Object[])new Object[0]));
        this.myCbShowDetails.setSelected(true);
        this.myCbShowDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ErrorViewTextExporter.this.myChangeListener.stateChanged(null);
            }
        });
    }

    public JComponent getSettingsEditor() {
        return this.myCbShowDetails;
    }

    public void addSettingsChangedListener(ChangeListener listener2) throws TooManyListenersException {
        if (this.myChangeListener != null) {
            throw new TooManyListenersException();
        }
        this.myChangeListener = listener2;
    }

    public void removeSettingsChangedListener(ChangeListener listener2) {
        this.myChangeListener = null;
    }

    @NotNull
    public String getReportText() {
        StringBuffer buffer = new StringBuffer();
        this.getReportText(buffer, (ErrorTreeElement)this.myStructure.getRootElement(), this.myCbShowDetails.isSelected(), 0);
        String string = buffer.toString();
        if (string == null) {
            ErrorViewTextExporter.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getDefaultFilePath() {
        return "";
    }

    public boolean canExport() {
        return true;
    }

    private void getReportText(StringBuffer buffer, ErrorTreeElement element2, boolean withUsages, int indent) {
        ErrorTreeElement[] children2;
        String newline = SystemProperties.getLineSeparator();
        for (ErrorTreeElement child2 : children2 = this.myStructure.getChildElements(element2)) {
            if (!(child2 instanceof ErrorTreeElement) || !withUsages && child2 instanceof NavigatableMessageElement) continue;
            ErrorTreeElement childElement = child2;
            if (buffer.length() > 0) {
                buffer.append(newline);
            }
            ErrorViewTextExporter.shift(buffer, indent);
            ErrorViewTextExporter.exportElement(childElement, buffer, indent, newline);
            this.getReportText(buffer, childElement, withUsages, indent + 4);
        }
    }

    public static void exportElement(ErrorTreeElement element2, StringBuffer buffer, int baseIntent, String newline) {
        int startLength = buffer.length();
        buffer.append(element2.getKind().getPresentableText());
        buffer.append(element2.getExportTextPrefix());
        int localIndent = startLength - buffer.length();
        String[] text2 = element2.getText();
        if (text2 != null && text2.length > 0) {
            buffer.append(text2[0]);
            for (int i = 1; i < text2.length; ++i) {
                buffer.append(newline);
                ErrorViewTextExporter.shift(buffer, baseIntent + localIndent);
                buffer.append(text2[i]);
            }
        }
    }

    private static void shift(StringBuffer buffer, int indent) {
        for (int i = 0; i < indent; ++i) {
            buffer.append(' ');
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/errorTreeView/impl/ErrorViewTextExporter", "getReportText"));
    }
}

