/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarksListener;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentListener;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="BookmarkManager", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$"), @Storage(value="$WORKSPACE_FILE$", deprecated=true)})
public final class BookmarkManager
implements PersistentStateComponent<Element> {
    private static final int MAX_AUTO_DESCRIPTION_SIZE = 50;
    private final MultiMap<VirtualFile, Bookmark> myBookmarks;
    private final Map<Trinity<VirtualFile, Integer, String>, Bookmark> myDeletedDocumentBookmarks;
    private final Map<Document, List<Trinity<Bookmark, Integer, String>>> myBeforeChangeData;
    private final Project myProject;
    private boolean mySortedState;
    private final AtomicReference<List<Bookmark>> myPendingState;

    public static BookmarkManager getInstance(@NotNull Project project) {
        if (project == null) {
            BookmarkManager.$$$reportNull$$$0(0);
        }
        return (BookmarkManager)ServiceManager.getService((Project)project, BookmarkManager.class);
    }

    public BookmarkManager(@NotNull Project project) {
        if (project == null) {
            BookmarkManager.$$$reportNull$$$0(1);
        }
        this.myBookmarks = MultiMap.createConcurrentSet();
        this.myDeletedDocumentBookmarks = new HashMap<Trinity<VirtualFile, Integer, String>, Bookmark>();
        this.myBeforeChangeData = new HashMap<Document, List<Trinity<Bookmark, Integer, String>>>();
        this.myPendingState = new AtomicReference();
        this.myProject = project;
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(EditorColorsManager.TOPIC, __ -> this.colorsChanged());
        EditorEventMulticaster multicaster = EditorFactory.getInstance().getEventMulticaster();
        multicaster.addDocumentListener((DocumentListener)new MyDocumentListener(), (Disposable)this.myProject);
        multicaster.addEditorMouseListener((EditorMouseListener)new MyEditorMouseListener(), (Disposable)this.myProject);
        this.mySortedState = UISettings.getInstance().getSortBookmarks();
        connection.subscribe(UISettingsListener.TOPIC, uiSettings -> {
            if (this.mySortedState != uiSettings.getSortBookmarks()) {
                this.mySortedState = uiSettings.getSortBookmarks();
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (!project.isDisposed()) {
                        ((BookmarksListener)project.getMessageBus().syncPublisher(BookmarksListener.TOPIC)).bookmarksOrderChanged();
                    }
                });
            }
        });
    }

    public void editDescription(@NotNull Bookmark bookmark, @NotNull JComponent popup2) {
        if (bookmark == null) {
            BookmarkManager.$$$reportNull$$$0(2);
        }
        if (popup2 == null) {
            BookmarkManager.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        String description = Messages.showInputDialog((Component)popup2, (String)IdeBundle.message((String)"action.bookmark.edit.description.dialog.message", (Object[])new Object[0]), (String)IdeBundle.message((String)"action.bookmark.edit.description.dialog.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)bookmark.getDescription(), null);
        if (description != null) {
            this.setDescription(bookmark, description);
        }
    }

    public void addEditorBookmark(@NotNull Editor editor, int lineIndex) {
        if (editor == null) {
            BookmarkManager.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Document document = editor.getDocument();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        if (psiFile == null) {
            return;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        this.addTextBookmark(virtualFile, lineIndex, BookmarkManager.getAutoDescription(editor, lineIndex));
    }

    @NotNull
    public Bookmark addTextBookmark(@NotNull VirtualFile file2, int lineIndex, @NotNull String description) {
        if (file2 == null) {
            BookmarkManager.$$$reportNull$$$0(5);
        }
        if (description == null) {
            BookmarkManager.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Bookmark b = new Bookmark(this.myProject, file2, lineIndex, description);
        this.myBookmarks.values().forEach(bookmark -> ++bookmark.index);
        this.myBookmarks.putValue((Object)file2, (Object)b);
        this.getPublisher().bookmarkAdded(b);
        Bookmark bookmark2 = b;
        if (bookmark2 == null) {
            BookmarkManager.$$$reportNull$$$0(7);
        }
        return bookmark2;
    }

    @NotNull
    private BookmarksListener getPublisher() {
        BookmarksListener bookmarksListener = (BookmarksListener)this.myProject.getMessageBus().syncPublisher(BookmarksListener.TOPIC);
        if (bookmarksListener == null) {
            BookmarkManager.$$$reportNull$$$0(8);
        }
        return bookmarksListener;
    }

    public void addFileBookmark(@NotNull VirtualFile file2, @NotNull String description) {
        if (file2 == null) {
            BookmarkManager.$$$reportNull$$$0(9);
        }
        if (description == null) {
            BookmarkManager.$$$reportNull$$$0(10);
        }
        if (this.findFileBookmark(file2) != null) {
            return;
        }
        this.addTextBookmark(file2, -1, description);
    }

    @NotNull
    private static String getAutoDescription(@NotNull Editor editor, int lineIndex) {
        String autoDescription;
        if (editor == null) {
            BookmarkManager.$$$reportNull$$$0(11);
        }
        if ((autoDescription = editor.getSelectionModel().getSelectedText()) == null) {
            Document document = editor.getDocument();
            autoDescription = document.getCharsSequence().subSequence(document.getLineStartOffset(lineIndex), document.getLineEndOffset(lineIndex)).toString().trim();
        }
        if (autoDescription.length() > 50) {
            String string = autoDescription.substring(0, 50) + "...";
            if (string == null) {
                BookmarkManager.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = autoDescription;
        if (string == null) {
            BookmarkManager.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public List<Bookmark> getValidBookmarks() {
        List answer = ContainerUtil.filter((Collection)this.myBookmarks.values(), b -> b.isValid());
        if (UISettings.getInstance().getSortBookmarks()) {
            Collections.sort(answer);
        } else {
            Collections.sort(answer, Comparator.comparingInt(b -> b.index));
        }
        List list2 = answer;
        if (list2 == null) {
            BookmarkManager.$$$reportNull$$$0(14);
        }
        return list2;
    }

    @Nullable
    public Bookmark findEditorBookmark(@NotNull Document document, int line) {
        VirtualFile file2;
        if (document == null) {
            BookmarkManager.$$$reportNull$$$0(15);
        }
        if ((file2 = FileDocumentManager.getInstance().getFile(document)) == null) {
            return null;
        }
        return (Bookmark)ContainerUtil.find((Iterable)this.myBookmarks.get((Object)file2), bookmark -> bookmark.getLine() == line);
    }

    @Nullable
    public Bookmark findFileBookmark(@NotNull VirtualFile file2) {
        if (file2 == null) {
            BookmarkManager.$$$reportNull$$$0(16);
        }
        return (Bookmark)ContainerUtil.find((Iterable)this.myBookmarks.get((Object)file2), bookmark -> bookmark.getLine() == -1);
    }

    @Nullable
    public Bookmark findBookmarkForMnemonic(char m) {
        char mm = Character.toUpperCase(m);
        return (Bookmark)ContainerUtil.find((Iterable)this.myBookmarks.values(), bookmark -> bookmark.getMnemonic() == mm);
    }

    public boolean hasBookmarksWithMnemonics() {
        return ContainerUtil.or((Iterable)this.myBookmarks.values(), bookmark -> bookmark.getMnemonic() != '\u0000');
    }

    public void removeBookmark(@NotNull Bookmark bookmark) {
        if (bookmark == null) {
            BookmarkManager.$$$reportNull$$$0(17);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        VirtualFile file2 = bookmark.getFile();
        if (this.myBookmarks.remove((Object)file2, (Object)bookmark)) {
            int index = bookmark.index;
            this.myBookmarks.values().forEach(b -> {
                b.index = b.index - (b.index > index ? 1 : 0);
            });
            bookmark.release();
            this.getPublisher().bookmarkRemoved(bookmark);
        }
    }

    public Element getState() {
        Element container2 = new Element("BookmarkManager");
        this.writeExternal(container2);
        return container2;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            BookmarkManager.$$$reportNull$$$0(18);
        }
        this.myPendingState.set(BookmarkManager.readExternal(state));
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> ApplicationManager.getApplication().invokeLater(() -> {
            List newList = this.myPendingState.getAndSet(null);
            if (newList != null) {
                this.applyNewState(newList, true);
            }
        }, ModalityState.NON_MODAL, this.myProject.getDisposed()));
    }

    public void applyNewStateInTestMode(@NotNull List<Bookmark> newList) {
        if (newList == null) {
            BookmarkManager.$$$reportNull$$$0(19);
        }
        this.applyNewState(newList, false);
    }

    private void applyNewState(@NotNull List<Bookmark> newList, boolean fireEvents) {
        if (newList == null) {
            BookmarkManager.$$$reportNull$$$0(20);
        }
        if (!this.myBookmarks.isEmpty()) {
            Bookmark[] bookmarks;
            for (Bookmark bookmark : bookmarks = this.myBookmarks.values().toArray(new Bookmark[0])) {
                bookmark.release();
            }
            this.myBookmarks.clear();
        }
        int bookmarkIndex = newList.size() - 1;
        ArrayList<Bookmark> addedBookmarks = new ArrayList<Bookmark>(newList.size());
        for (Bookmark bookmark : newList) {
            Bookmark old;
            OpenFileDescriptor target2 = bookmark.init(this.myProject);
            if (target2 == null || target2.getLine() == -1 && this.findFileBookmark(target2.getFile()) != null) continue;
            bookmark.index = bookmarkIndex--;
            char mnemonic = bookmark.getMnemonic();
            if (mnemonic != '\u0000' && (old = this.findBookmarkForMnemonic(mnemonic)) != null) {
                this.removeBookmark(old);
            }
            this.myBookmarks.putValue((Object)target2.getFile(), (Object)bookmark);
            addedBookmarks.add(bookmark);
        }
        if (fireEvents) {
            for (Bookmark bookmark : addedBookmarks) {
                this.getPublisher().bookmarkAdded(bookmark);
            }
        }
    }

    @NotNull
    private static List<Bookmark> readExternal(@NotNull Element element2) {
        if (element2 == null) {
            BookmarkManager.$$$reportNull$$$0(21);
        }
        ArrayList<Bookmark> result2 = new ArrayList<Bookmark>();
        for (Element bookmarkElement : element2.getChildren("bookmark")) {
            String url = bookmarkElement.getAttributeValue("url");
            if (StringUtil.isEmptyOrSpaces((String)url)) continue;
            String line = bookmarkElement.getAttributeValue("line");
            String description = StringUtil.notNullize((String)bookmarkElement.getAttributeValue("description"));
            String mnemonic = bookmarkElement.getAttributeValue("mnemonic");
            int lineIndex = -1;
            if (line != null) {
                try {
                    lineIndex = Integer.parseInt(line);
                }
                catch (NumberFormatException ignore) {
                    continue;
                }
            }
            Bookmark bookmark = new Bookmark(url, lineIndex, description);
            if (mnemonic != null && mnemonic.length() == 1) {
                bookmark.setMnemonic(mnemonic.charAt(0));
            }
            result2.add(bookmark);
        }
        ArrayList<Bookmark> arrayList = result2;
        if (arrayList == null) {
            BookmarkManager.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    private void writeExternal(Element element2) {
        ArrayList bookmarks = new ArrayList(this.myBookmarks.values());
        Collections.sort(bookmarks, Comparator.comparingInt(o -> o.index).reversed());
        for (Bookmark bookmark : bookmarks) {
            char mnemonic;
            int line;
            if (!bookmark.isValid()) continue;
            Element bookmarkElement = new Element("bookmark");
            bookmarkElement.setAttribute("url", bookmark.getFile().getUrl());
            String description = bookmark.nullizeEmptyDescription();
            if (description != null) {
                bookmarkElement.setAttribute("description", description);
            }
            if ((line = bookmark.getLine()) >= 0) {
                bookmarkElement.setAttribute("line", String.valueOf(line));
            }
            if ((mnemonic = bookmark.getMnemonic()) != '\u0000') {
                bookmarkElement.setAttribute("mnemonic", String.valueOf(mnemonic));
            }
            element2.addContent(bookmarkElement);
        }
    }

    public void moveBookmarkUp(@NotNull Bookmark bookmark) {
        if (bookmark == null) {
            BookmarkManager.$$$reportNull$$$0(23);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        int index = bookmark.index;
        if (index > 0) {
            Bookmark other = (Bookmark)ContainerUtil.find((Iterable)this.myBookmarks.values(), b -> b.index == index - 1);
            other.index = index;
            bookmark.index = index - 1;
            EventQueue.invokeLater(() -> {
                this.getPublisher().bookmarkChanged(bookmark);
                this.getPublisher().bookmarkChanged(other);
            });
        }
    }

    public void moveBookmarkDown(@NotNull Bookmark bookmark) {
        if (bookmark == null) {
            BookmarkManager.$$$reportNull$$$0(24);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        int index = bookmark.index;
        if (index < this.myBookmarks.values().size() - 1) {
            Bookmark other = (Bookmark)ContainerUtil.find((Iterable)this.myBookmarks.values(), b -> b.index == index + 1);
            other.index = index;
            bookmark.index = index + 1;
            EventQueue.invokeLater(() -> {
                this.getPublisher().bookmarkChanged(bookmark);
                this.getPublisher().bookmarkChanged(other);
            });
        }
    }

    @Nullable
    public Bookmark findLineBookmark(@NotNull Editor editor, boolean isWrapped, boolean next) {
        VirtualFile file2;
        if (editor == null) {
            BookmarkManager.$$$reportNull$$$0(25);
        }
        if ((file2 = FileDocumentManager.getInstance().getFile(editor.getDocument())) == null) {
            return null;
        }
        ArrayList bookmarksForDocument = new ArrayList(this.myBookmarks.get((Object)file2));
        if (bookmarksForDocument.isEmpty()) {
            return null;
        }
        int sign = next ? 1 : -1;
        Collections.sort(bookmarksForDocument, (o1, o2) -> sign * (o1.getLine() - o2.getLine()));
        int caretLine = editor.getCaretModel().getLogicalPosition().line;
        for (Bookmark bookmark : bookmarksForDocument) {
            if (next && bookmark.getLine() > caretLine) {
                return bookmark;
            }
            if (next || bookmark.getLine() >= caretLine) continue;
            return bookmark;
        }
        return isWrapped && !bookmarksForDocument.isEmpty() ? (Bookmark)bookmarksForDocument.get(0) : null;
    }

    public void setMnemonic(@NotNull Bookmark bookmark, char c) {
        if (bookmark == null) {
            BookmarkManager.$$$reportNull$$$0(26);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Bookmark old = this.findBookmarkForMnemonic(c);
        if (old != null) {
            this.removeBookmark(old);
        }
        bookmark.setMnemonic(c);
        this.getPublisher().bookmarkChanged(bookmark);
    }

    public void setDescription(@NotNull Bookmark bookmark, @NotNull String description) {
        if (bookmark == null) {
            BookmarkManager.$$$reportNull$$$0(27);
        }
        if (description == null) {
            BookmarkManager.$$$reportNull$$$0(28);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        bookmark.setDescription(description);
        this.getPublisher().bookmarkChanged(bookmark);
    }

    private void colorsChanged() {
        for (Bookmark bookmark : this.myBookmarks.values()) {
            bookmark.updateHighlighter();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 17: 
            case 23: 
            case 24: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bookmark";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 4: 
            case 11: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 10: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/bookmarks/BookmarkManager";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newList";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/bookmarks/BookmarkManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "addTextBookmark";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublisher";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutoDescription";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidBookmarks";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "readExternal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "editDescription";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addEditorBookmark";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addTextBookmark";
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 22: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addFileBookmark";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAutoDescription";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findEditorBookmark";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findFileBookmark";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeBookmark";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "applyNewStateInTestMode";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "applyNewState";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "moveBookmarkUp";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "moveBookmarkDown";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findLineBookmark";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setMnemonic";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setDescription";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyDocumentListener
    implements DocumentListener {
        private MyDocumentListener() {
        }

        public void beforeDocumentChange(@NotNull DocumentEvent e) {
            if (e == null) {
                MyDocumentListener.$$$reportNull$$$0(0);
            }
            Document doc = e.getDocument();
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(doc);
            if (file2 != null) {
                for (Bookmark bookmark : BookmarkManager.this.myBookmarks.get((Object)file2)) {
                    if (bookmark.getLine() == -1) continue;
                    List list2 = BookmarkManager.this.myBeforeChangeData.computeIfAbsent(doc, __ -> new ArrayList());
                    list2.add(new Trinity((Object)bookmark, (Object)bookmark.getLine(), (Object)doc.getText(new TextRange(doc.getLineStartOffset(bookmark.getLine()), doc.getLineEndOffset(bookmark.getLine())))));
                }
            }
        }

        public void documentChanged(@NotNull DocumentEvent e) {
            if (e == null) {
                MyDocumentListener.$$$reportNull$$$0(1);
            }
            if (!ApplicationManager.getApplication().isDispatchThread()) {
                return;
            }
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(e.getDocument());
            ArrayList<Bookmark> bookmarksToRemove = null;
            if (file2 != null) {
                for (Bookmark bookmark : BookmarkManager.this.myBookmarks.get((Object)file2)) {
                    if (bookmark.isValid() && !this.isDuplicate(bookmark, file2, (List<Bookmark>)bookmarksToRemove)) continue;
                    if (bookmarksToRemove == null) {
                        bookmarksToRemove = new ArrayList<Bookmark>();
                    }
                    bookmarksToRemove.add(bookmark);
                }
            }
            if (bookmarksToRemove != null) {
                for (Bookmark bookmark : bookmarksToRemove) {
                    this.moveToDeleted(bookmark);
                }
            }
            BookmarkManager.this.myBeforeChangeData.remove(e.getDocument());
            Iterator iterator2 = BookmarkManager.this.myDeletedDocumentBookmarks.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = iterator2.next();
                VirtualFile virtualFile = (VirtualFile)((Trinity)entry.getKey()).first;
                if (!virtualFile.isValid()) {
                    iterator2.remove();
                    continue;
                }
                Bookmark bookmark = (Bookmark)entry.getValue();
                Document document = bookmark.getCachedDocument();
                if (document == null || !bookmark.getFile().equals(virtualFile)) continue;
                Integer line = (Integer)((Trinity)entry.getKey()).second;
                if (document.getLineCount() <= line) continue;
                String bookmarkedText = (String)((Trinity)entry.getKey()).third;
                String lineContent = this.getLineContent(document, line);
                if (!bookmarkedText.equals(lineContent) && line > 1 && (bookmarkedText.equals(StringUtil.trimEnd((String)e.getNewFragment().toString(), (String)"\n")) || bookmarkedText.equals(StringUtil.trimEnd((String)e.getOldFragment().toString(), (String)"\n")))) {
                    line = line - 2;
                    lineContent = this.getLineContent(document, line);
                }
                if (!bookmarkedText.equals(lineContent) || BookmarkManager.this.findEditorBookmark(document, line) != null) continue;
                Bookmark restored = BookmarkManager.this.addTextBookmark(bookmark.getFile(), line, bookmark.getDescription());
                if (bookmark.getMnemonic() != '\u0000') {
                    BookmarkManager.this.setMnemonic(restored, bookmark.getMnemonic());
                }
                iterator2.remove();
            }
        }

        private boolean isDuplicate(Bookmark bookmark, @NotNull VirtualFile file2, @Nullable List<Bookmark> toRemove2) {
            if (file2 == null) {
                MyDocumentListener.$$$reportNull$$$0(2);
            }
            for (Bookmark b : BookmarkManager.this.myBookmarks.get((Object)file2)) {
                if (b == bookmark || !b.isValid() || !Comparing.equal((Object)b.getFile(), (Object)bookmark.getFile()) || b.getLine() != bookmark.getLine() || toRemove2 != null && toRemove2.contains(b)) continue;
                return true;
            }
            return false;
        }

        private void moveToDeleted(Bookmark bookmark) {
            List list2 = (List)BookmarkManager.this.myBeforeChangeData.get(bookmark.getCachedDocument());
            if (list2 != null) {
                for (Trinity trinity : list2) {
                    if (trinity.first != bookmark) continue;
                    BookmarkManager.this.removeBookmark(bookmark);
                    BookmarkManager.this.myDeletedDocumentBookmarks.put(new Trinity((Object)bookmark.getFile(), trinity.second, trinity.third), bookmark);
                    break;
                }
            }
        }

        private String getLineContent(Document document, int line) {
            int start2 = document.getLineStartOffset(line);
            int end = document.getLineEndOffset(line);
            return document.getText(new TextRange(start2, end));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/bookmarks/BookmarkManager$MyDocumentListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeDocumentChange";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "documentChanged";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isDuplicate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyEditorMouseListener
    implements EditorMouseListener {
        private MyEditorMouseListener() {
        }

        public void mouseClicked(@NotNull EditorMouseEvent e) {
            if (e == null) {
                MyEditorMouseListener.$$$reportNull$$$0(0);
            }
            if (e.getArea() != EditorMouseEventArea.LINE_MARKERS_AREA) {
                return;
            }
            if (e.getMouseEvent().isPopupTrigger()) {
                return;
            }
            if ((e.getMouseEvent().getModifiers() & (SystemInfo.isMac ? 4 : 2)) == 0) {
                return;
            }
            Editor editor = e.getEditor();
            int line = editor.xyToLogicalPosition((Point)new Point((int)e.getMouseEvent().getX(), (int)e.getMouseEvent().getY())).line;
            if (line < 0) {
                return;
            }
            Document document = editor.getDocument();
            Bookmark bookmark = BookmarkManager.this.findEditorBookmark(document, line);
            if (bookmark == null) {
                BookmarkManager.this.addEditorBookmark(editor, line);
            } else {
                BookmarkManager.this.removeBookmark(bookmark);
            }
            e.consume();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/bookmarks/BookmarkManager$MyEditorMouseListener", "mouseClicked"));
        }
    }

    static final class MyStartupActivity
    implements StartupActivity.DumbAware {
        MyStartupActivity() {
        }

        public void runActivity(@NotNull Project project) {
            if (project == null) {
                MyStartupActivity.$$$reportNull$$$0(0);
            }
            project.getMessageBus().connect().subscribe(PsiDocumentListener.TOPIC, MyStartupActivity::documentCreated);
            BookmarkManager bookmarkManager = BookmarkManager.getInstance(project);
            if (bookmarkManager.myBookmarks.isEmpty() && bookmarkManager.myPendingState.get() == null) {
                return;
            }
            ReadAction.nonBlocking(() -> {
                FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
                FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
                for (VirtualFile file2 : fileEditorManager.getOpenFiles()) {
                    Document document = fileDocumentManager.getDocument(file2);
                    if (document == null) continue;
                    MyStartupActivity.checkFile(document, file2, bookmarkManager, project);
                }
            }).expireWith((Disposable)project).submit((Executor)NonUrgentExecutor.getInstance());
        }

        private static void documentCreated(@NotNull Document document, @Nullable PsiFile psiFile, @NotNull Project project) {
            BookmarkManager bookmarkManager;
            if (document == null) {
                MyStartupActivity.$$$reportNull$$$0(1);
            }
            if (project == null) {
                MyStartupActivity.$$$reportNull$$$0(2);
            }
            if ((bookmarkManager = BookmarkManager.getInstance(project)).myBookmarks.isEmpty()) {
                return;
            }
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
            if (file2 == null) {
                return;
            }
            MyStartupActivity.checkFile(document, file2, bookmarkManager, project);
        }

        private static void checkFile(@NotNull Document document, @NotNull VirtualFile file2, @NotNull BookmarkManager bookmarkManager, @NotNull Project project) {
            Collection fileBookmarks;
            if (document == null) {
                MyStartupActivity.$$$reportNull$$$0(3);
            }
            if (file2 == null) {
                MyStartupActivity.$$$reportNull$$$0(4);
            }
            if (bookmarkManager == null) {
                MyStartupActivity.$$$reportNull$$$0(5);
            }
            if (project == null) {
                MyStartupActivity.$$$reportNull$$$0(6);
            }
            if ((fileBookmarks = bookmarkManager.myBookmarks.get((Object)file2)).isEmpty()) {
                return;
            }
            AppUIUtil.invokeLaterIfProjectAlive(project, () -> {
                MarkupModelEx markup = (MarkupModelEx)DocumentMarkupModel.forDocument(document, project, true);
                for (Bookmark bookmark : fileBookmarks) {
                    bookmark.createHighlighter(markup);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bookmarkManager";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/bookmarks/BookmarkManager$MyStartupActivity";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runActivity";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "documentCreated";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

