/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateDirectoryCompletionContributor;
import com.intellij.ide.actions.CreateDirectoryCompletionContributorEP;
import com.intellij.ide.actions.CreateDirectoryHandler;
import com.intellij.ide.actions.CreateGroupHandler;
import com.intellij.ide.actions.CreatePackageHandler;
import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.ide.ui.newItemPopup.NewItemPopupUtil;
import com.intellij.ide.ui.newItemPopup.NewItemWithTemplatesPopupPanel;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.Consumer;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class CreateDirectoryOrPackageAction
extends AnAction
implements DumbAware {
    private static final ExtensionPointName<CreateDirectoryCompletionContributorEP> EP = ExtensionPointName.create((String)"com.intellij.createDirectoryCompletionContributor");
    public static final DataKey<String> TEST_DIRECTORY_NAME_KEY = DataKey.create((String)"CreateDirectoryOrPackageAction.testName");

    public CreateDirectoryOrPackageAction() {
        super(IdeBundle.messagePointer((String)"action.create.new.directory.or.package", (Object[])new Object[0]), IdeBundle.messagePointer((String)"action.create.new.directory.or.package", (Object[])new Object[0]), null);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        String testDirectoryName;
        String title;
        String message;
        CreateGroupHandler validator;
        if (event == null) {
            CreateDirectoryOrPackageAction.$$$reportNull$$$0(0);
        }
        IdeView view = (IdeView)event.getData(LangDataKeys.IDE_VIEW);
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        if (view == null || project == null) {
            return;
        }
        PsiDirectory directory = DirectoryChooserUtil.getOrChooseDirectory(view);
        if (directory == null) {
            return;
        }
        if (PsiDirectoryFactory.getInstance(project).isPackage(directory)) {
            validator = new CreatePackageHandler(project, directory);
            message = IdeBundle.message((String)"prompt.enter.new.package.name", (Object[])new Object[0]);
            title = IdeBundle.message((String)"title.new.package", (Object[])new Object[0]);
        } else {
            validator = new CreateDirectoryHandler(project, directory);
            message = IdeBundle.message((String)"prompt.enter.new.directory.name", (Object[])new Object[0]);
            title = IdeBundle.message((String)"title.new.directory", (Object[])new Object[0]);
        }
        String initialText = validator.getInitialText();
        java.util.function.Consumer<List<PsiElement>> consumer = elements2 -> {
            for (PsiElement element2 : ContainerUtil.iterateBackward((List)elements2)) {
                view.selectElement(element2);
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode() && (testDirectoryName = (String)event.getData(TEST_DIRECTORY_NAME_KEY)) != null && validator.checkInput(testDirectoryName) && validator.canClose(testDirectoryName)) {
            consumer.accept(Collections.singletonList(validator.getCreatedElement()));
            return;
        }
        if (Experiments.getInstance().isFeatureEnabled("show.create.new.element.in.popup")) {
            CreateDirectoryOrPackageAction.createLightWeightPopup(title, initialText, directory, validator, consumer).showCenteredInCurrentWindow(project);
        } else {
            Messages.showInputDialog((Project)project, (String)message, (String)title, null, (String)initialText, (InputValidator)validator, (TextRange)TextRange.from((int)initialText.length(), (int)0));
            consumer.accept(Collections.singletonList(validator.getCreatedElement()));
        }
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            CreateDirectoryOrPackageAction.$$$reportNull$$$0(1);
        }
        Presentation presentation = event.getPresentation();
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        IdeView view = (IdeView)event.getData(LangDataKeys.IDE_VIEW);
        if (view == null) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        PsiDirectory[] directories = view.getDirectories();
        if (directories.length == 0) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        presentation.setEnabledAndVisible(true);
        boolean isPackage = false;
        PsiDirectoryFactory factory = PsiDirectoryFactory.getInstance(project);
        for (PsiDirectory directory : directories) {
            if (!factory.isPackage(directory)) continue;
            isPackage = true;
            break;
        }
        if (isPackage) {
            presentation.setText(IdeBundle.messagePointer((String)"action.package", (Object[])new Object[0]));
            presentation.setIcon(PlatformIcons.PACKAGE_ICON);
        } else {
            presentation.setText(IdeBundle.messagePointer((String)"action.directory", (Object[])new Object[0]));
            presentation.setIcon(PlatformIcons.FOLDER_ICON);
        }
    }

    private static JBPopup createLightWeightPopup(String title, String initialText, @NotNull PsiDirectory directory, CreateGroupHandler validator, java.util.function.Consumer<List<PsiElement>> consumer) {
        if (directory == null) {
            CreateDirectoryOrPackageAction.$$$reportNull$$$0(2);
        }
        List<CompletionItem> variants = CreateDirectoryOrPackageAction.collectSuggestedDirectories(directory);
        DirectoriesWithCompletionPopupPanel contentPanel2 = new DirectoriesWithCompletionPopupPanel(variants);
        JTextField nameField = contentPanel2.getTextField();
        nameField.setText(initialText);
        JBPopup popup2 = NewItemPopupUtil.createNewItemPopup(title, (JComponent)((Object)contentPanel2), nameField);
        contentPanel2.setApplyAction((Consumer<? super InputEvent>)((Consumer)event -> {
            List<PsiElement> created;
            for (CompletionItem it : contentPanel2.getSelectedItems()) {
                it.reportToStatistics();
            }
            List<Pair> toCreate = ContainerUtil.map(contentPanel2.getSelectedItems(), item -> Pair.create((Object)item.relativePath, item.rootType));
            if (toCreate.isEmpty()) {
                toCreate = Collections.singletonList(Pair.create((Object)nameField.getText(), null));
            }
            if ((created = CreateDirectoryOrPackageAction.createDirectories(toCreate, validator)) != null) {
                popup2.closeOk(event);
                consumer.accept(created);
            } else {
                for (Pair dir : toCreate) {
                    String errorText = validator.getErrorText((String)dir.first);
                    if (errorText == null) continue;
                    String errorMessage = validator.getErrorText(errorText);
                    contentPanel2.setError(errorMessage);
                    break;
                }
            }
        }));
        contentPanel2.addTemplatesVisibilityListener(visible -> SwingUtilities.invokeLater(() -> popup2.pack(false, true)));
        return popup2;
    }

    @NotNull
    private static List<CompletionItem> collectSuggestedDirectories(@NotNull PsiDirectory directory) {
        if (directory == null) {
            CreateDirectoryOrPackageAction.$$$reportNull$$$0(3);
        }
        ArrayList<CompletionItem> variants = new ArrayList<CompletionItem>();
        VirtualFile vDir = directory.getVirtualFile();
        for (CreateDirectoryCompletionContributorEP ep : EP.getExtensionList()) {
            CreateDirectoryCompletionContributor contributor = (CreateDirectoryCompletionContributor)ep.getInstance();
            for (CreateDirectoryCompletionContributor.Variant variant : contributor.getVariants(directory)) {
                Icon icon2;
                String relativePath = FileUtil.toSystemIndependentName((String)variant.path);
                if (FileUtil.isAbsolutePlatformIndependent((String)relativePath) && (!FileUtil.isAncestor((String)vDir.getPath(), (String)relativePath, (boolean)true) || (relativePath = FileUtil.getRelativePath((String)vDir.getPath(), (String)relativePath, (char)'/')) == null) || vDir.findFileByRelativePath(relativePath) != null) continue;
                ModuleSourceRootEditHandler<?> handler2 = variant.rootType != null ? ModuleSourceRootEditHandler.getEditHandler(variant.rootType) : null;
                Icon icon3 = icon2 = handler2 == null ? null : handler2.getRootIcon();
                if (icon2 == null) {
                    icon2 = AllIcons.Nodes.Folder;
                }
                variants.add(new CompletionItem(contributor, relativePath, icon2, variant.rootType));
            }
        }
        variants.sort((o1, o2) -> {
            int result2 = StringUtil.naturalCompare((String)o1.contributor.getDescription(), (String)o2.contributor.getDescription());
            if (result2 != 0) {
                return result2;
            }
            return StringUtil.naturalCompare((String)o1.relativePath, (String)o2.relativePath);
        });
        ArrayList<CompletionItem> arrayList = variants;
        if (arrayList == null) {
            CreateDirectoryOrPackageAction.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nullable
    private static List<PsiElement> createDirectories(List<Pair<String, JpsModuleSourceRootType<?>>> toCreate, CreateGroupHandler validator) {
        ArrayList<PsiElement> createdDirectories = new ArrayList<PsiElement>(toCreate.size());
        if (!ContainerUtil.all(toCreate, dir -> validator.checkInput((String)dir.first))) {
            return null;
        }
        ArrayList<Pair> toMarkAsRoots = new ArrayList<Pair>(toCreate.size());
        for (Pair<String, JpsModuleSourceRootType<?>> dir2 : toCreate) {
            PsiFileSystemItem element2;
            if (!validator.canClose((String)dir2.first) || (element2 = validator.getCreatedElement()) == null) continue;
            createdDirectories.add((PsiElement)element2);
            JpsModuleSourceRootType rootType = (JpsModuleSourceRootType)dir2.second;
            if (rootType == null) continue;
            toMarkAsRoots.add(Pair.create((Object)element2, (Object)rootType));
        }
        if (!toMarkAsRoots.isEmpty()) {
            Project project = ((PsiFileSystemItem)((Pair)toMarkAsRoots.get((int)0)).first).getProject();
            ProjectFileIndex index = ProjectFileIndex.getInstance((Project)project);
            WriteAction.run(() -> ProjectRootManagerEx.getInstanceEx((Project)project).mergeRootsChangesDuring(() -> {
                for (Pair each : toMarkAsRoots) {
                    VirtualFile file2 = ((PsiFileSystemItem)each.first).getVirtualFile();
                    JpsModuleSourceRootType rootType = (JpsModuleSourceRootType)each.second;
                    Module module = index.getModuleForFile(file2);
                    if (module == null || index.getContentRootForFile(file2) == null || index.getSourceFolder(file2) != null) continue;
                    ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                    ContentEntry entry = MarkRootActionBase.findContentEntry((ModuleRootModel)model, file2);
                    if (entry != null) {
                        entry.addSourceFolder(file2, rootType);
                        model.commit();
                        continue;
                    }
                    model.dispose();
                }
            }));
        }
        return createdDirectories;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/CreateDirectoryOrPackageAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/CreateDirectoryOrPackageAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSuggestedDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createLightWeightPopup";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectSuggestedDirectories";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DirectoriesWithCompletionPopupPanel
    extends NewItemWithTemplatesPopupPanel<CompletionItem> {
        private static final SimpleTextAttributes MATCHED = new SimpleTextAttributes(UIUtil.getListBackground(), UIUtil.getListForeground(), null, 64);
        private MinusculeMatcher currentMatcher;
        private boolean locked;

        protected DirectoriesWithCompletionPopupPanel(final @NotNull List<CompletionItem> items) {
            if (items == null) {
                DirectoriesWithCompletionPopupPanel.$$$reportNull$$$0(0);
            }
            super(items, SimpleListCellRenderer.create((String)"", item -> item.displayText));
            this.currentMatcher = null;
            this.locked = false;
            this.setupRenderers();
            ScrollingUtil.redirectExpandSelection((JList)this.myTemplatesList, (JComponent)this.myTextField);
            this.myTemplatesList.getSelectionModel().setSelectionMode(2);
            this.myTemplatesList.addListSelectionListener(e -> {
                CompletionItem selected2 = (CompletionItem)this.myTemplatesList.getSelectedValue();
                if (selected2 != null) {
                    this.locked = true;
                    try {
                        this.myTextField.setText(selected2.displayText);
                    }
                    finally {
                        this.locked = false;
                    }
                }
            });
            this.myTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!locked) {
                        String input = myTextField.getText();
                        currentMatcher = NameUtil.buildMatcher((String)("*" + input)).build();
                        List filtered2 = ContainerUtil.filter((Collection)items, item -> currentMatcher.matches(item.displayText));
                        this.updateTemplatesList(filtered2);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/CreateDirectoryOrPackageAction$DirectoriesWithCompletionPopupPanel$1", "textChanged"));
                }
            });
            final ListModel model = this.myTemplatesList.getModel();
            model.addListDataListener(new ListDataListener(){

                @Override
                public void intervalAdded(ListDataEvent e) {
                    this.setTemplatesListVisible(model.getSize() > 0);
                }

                @Override
                public void intervalRemoved(ListDataEvent e) {
                    this.setTemplatesListVisible(model.getSize() > 0);
                }

                @Override
                public void contentsChanged(ListDataEvent e) {
                    this.setTemplatesListVisible(model.getSize() > 0);
                }
            });
            this.setTemplatesListVisible(model.getSize() > 0);
        }

        @NotNull
        List<CompletionItem> getSelectedItems() {
            List<CompletionItem> list2 = this.myTemplatesList.getSelectedValuesList();
            if (list2 == null) {
                DirectoriesWithCompletionPopupPanel.$$$reportNull$$$0(1);
            }
            return list2;
        }

        private void setupRenderers() {
            ColoredListCellRenderer<CompletionItem> itemRenderer = new ColoredListCellRenderer<CompletionItem>(){

                protected void customizeCellRenderer(@NotNull JList<? extends CompletionItem> list2, @Nullable CompletionItem value2, int index, boolean selected2, boolean hasFocus) {
                    if (list2 == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (!selected2) {
                        this.setBackground(UIUtil.getListBackground());
                    }
                    String text2 = value2 == null ? "" : value2.displayText;
                    FList ranges = currentMatcher == null ? FList.emptyList() : currentMatcher.matchingFragments(text2);
                    SpeedSearchUtil.appendColoredFragments((SimpleColoredComponent)this, (String)text2, (Iterable)ranges, (SimpleTextAttributes)SimpleTextAttributes.REGULAR_ATTRIBUTES, (SimpleTextAttributes)MATCHED);
                    this.setIcon(value2 == null ? null : value2.icon);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ide/actions/CreateDirectoryOrPackageAction$DirectoriesWithCompletionPopupPanel$3", "customizeCellRenderer"));
                }
            };
            this.myTemplatesList.setCellRenderer((arg_0, arg_1, arg_2, arg_3, arg_4) -> this.lambda$setupRenderers$2((ColoredListCellRenderer)itemRenderer, arg_0, arg_1, arg_2, arg_3, arg_4));
        }

        private /* synthetic */ Component lambda$setupRenderers$2(ColoredListCellRenderer itemRenderer, JList list2, CompletionItem value2, int index, boolean isSelected, boolean cellHasFocus) {
            Component item = itemRenderer.getListCellRendererComponent(list2, (Object)value2, index, isSelected, cellHasFocus);
            JPanel wrapperPanel = new JPanel(new BorderLayout());
            wrapperPanel.setBackground(UIUtil.getListBackground());
            if (index == 0 || value2.contributor != ((CompletionItem)list2.getModel().getElementAt((int)(index - 1))).contributor) {
                SeparatorWithText separator = new SeparatorWithText(){

                    protected void paintLinePart(Graphics g, int xMin, int xMax, int hGap, int y) {
                    }
                };
                separator.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
                int vGap = 2;
                separator.setBorder(BorderFactory.createEmptyBorder(vGap * (index == 0 ? 1 : 2), 0, vGap, 0));
                separator.setCaption(value2.contributor.getDescription());
                separator.setCaptionCentered(false);
                wrapperPanel.add((Component)separator, "North");
            }
            wrapperPanel.add(item, "Center");
            return wrapperPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "items";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/CreateDirectoryOrPackageAction$DirectoriesWithCompletionPopupPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/CreateDirectoryOrPackageAction$DirectoriesWithCompletionPopupPanel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelectedItems";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class CompletionItem {
        @NotNull
        final CreateDirectoryCompletionContributor contributor;
        @NotNull
        final String relativePath;
        @Nullable
        final JpsModuleSourceRootType<?> rootType;
        @NotNull
        final String displayText;
        @Nullable
        final Icon icon;

        private CompletionItem(@NotNull CreateDirectoryCompletionContributor contributor, @NotNull String relativePath, @Nullable Icon icon2, @Nullable JpsModuleSourceRootType<?> rootType) {
            if (contributor == null) {
                CompletionItem.$$$reportNull$$$0(0);
            }
            if (relativePath == null) {
                CompletionItem.$$$reportNull$$$0(1);
            }
            this.contributor = contributor;
            this.relativePath = relativePath;
            this.rootType = rootType;
            this.displayText = FileUtil.toSystemDependentName((String)relativePath);
            this.icon = icon2;
        }

        public void reportToStatistics() {
            Class<?> contributorClass = this.contributor.getClass();
            String nameToReport = PluginInfoDetectorKt.getPluginInfo(contributorClass).isSafeToReport() ? contributorClass.getSimpleName() : "third.party";
            FUCounterUsageLogger.getInstance().logEvent("create.directory.dialog", "completion.variant.chosen", new FeatureUsageData().addData("contributor", nameToReport));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "contributor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "relativePath";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/actions/CreateDirectoryOrPackageAction$CompletionItem";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

