/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.FindBundle;
import com.intellij.find.FindSettings;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.PersistentFindUsagesOptions;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PredefinedSearchScopeProvider;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.StateRestoringCheckBox;
import com.intellij.ui.TitledSeparator;
import com.intellij.usageView.UsageViewContentManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFindUsagesDialog
extends DialogWrapper {
    private final Project myProject;
    protected final FindUsagesOptions myFindUsagesOptions;
    private final boolean myToShowInNewTab;
    private final boolean myIsShowInNewTabEnabled;
    private final boolean myIsShowInNewTabVisible;
    private final boolean mySearchForTextOccurrencesAvailable;
    private final boolean mySearchInLibrariesAvailable;
    private JCheckBox myCbToOpenInNewTab;
    protected StateRestoringCheckBox myCbToSearchForTextOccurrences;
    protected JCheckBox myCbToSkipResultsWhenOneUsage;
    private ScopeChooserCombo myScopeCombo;

    protected AbstractFindUsagesDialog(@NotNull Project project, @NotNull FindUsagesOptions findUsagesOptions, boolean toShowInNewTab, boolean mustOpenInNewTab, boolean isSingleFile, boolean searchForTextOccurrencesAvailable, boolean searchInLibrariesAvailable) {
        if (project == null) {
            AbstractFindUsagesDialog.$$$reportNull$$$0(0);
        }
        if (findUsagesOptions == null) {
            AbstractFindUsagesDialog.$$$reportNull$$$0(1);
        }
        super(project, true);
        this.myProject = project;
        this.myFindUsagesOptions = findUsagesOptions;
        this.myToShowInNewTab = toShowInNewTab;
        this.myIsShowInNewTabEnabled = !mustOpenInNewTab && UsageViewContentManager.getInstance((Project)this.myProject).getReusableContentsCount() > 0;
        this.myIsShowInNewTabVisible = !isSingleFile;
        this.mySearchForTextOccurrencesAvailable = searchForTextOccurrencesAvailable;
        this.mySearchInLibrariesAvailable = searchInLibrariesAvailable;
        if (this.myFindUsagesOptions instanceof PersistentFindUsagesOptions) {
            ((PersistentFindUsagesOptions)this.myFindUsagesOptions).setDefaults(this.myProject);
        }
        this.setOKButtonText(FindBundle.message((String)"find.dialog.find.button", (Object[])new Object[0]));
        this.setTitle(FindBundle.message((String)(isSingleFile ? "find.usages.in.file.dialog.title" : "find.usages.dialog.title"), (Object[])new Object[0]));
    }

    protected Action @NotNull [] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            AbstractFindUsagesDialog.$$$reportNull$$$0(2);
        }
        return actionArray;
    }

    protected boolean isInFileOnly() {
        return !this.myIsShowInNewTabVisible;
    }

    protected JComponent createNorthPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = new Insets(0, 0, 4, 0);
        gbConstraints.fill = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.anchor = 17;
        SimpleColoredComponent coloredComponent = new SimpleColoredComponent();
        coloredComponent.setIpad(new Insets(0, 0, 0, 0));
        coloredComponent.setMyBorder(null);
        this.configureLabelComponent(coloredComponent);
        panel2.add((Component)coloredComponent, gbConstraints);
        return panel2;
    }

    public abstract void configureLabelComponent(@NotNull SimpleColoredComponent var1);

    protected JComponent createCenterPanel() {
        JPanel allOptionsPanel;
        JPanel panel2 = new JPanel(new GridBagLayout());
        JPanel _panel = new JPanel(new BorderLayout());
        panel2.add((Component)_panel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (this.myIsShowInNewTabVisible) {
            this.myCbToOpenInNewTab = new JCheckBox(FindBundle.message((String)"find.open.in.new.tab.checkbox", (Object[])new Object[0]));
            this.myCbToOpenInNewTab.setSelected(this.myToShowInNewTab);
            this.myCbToOpenInNewTab.setEnabled(this.myIsShowInNewTabEnabled);
            _panel.add((Component)this.myCbToOpenInNewTab, "East");
        }
        if ((allOptionsPanel = this.createAllOptionsPanel()) != null) {
            panel2.add((Component)allOptionsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        return panel2;
    }

    @NotNull
    public final FindUsagesOptions calcFindUsagesOptions() {
        this.calcFindUsagesOptions(this.myFindUsagesOptions);
        if (this.myFindUsagesOptions instanceof PersistentFindUsagesOptions) {
            ((PersistentFindUsagesOptions)this.myFindUsagesOptions).storeDefaults(this.myProject);
        }
        FindUsagesOptions findUsagesOptions = this.myFindUsagesOptions;
        if (findUsagesOptions == null) {
            AbstractFindUsagesDialog.$$$reportNull$$$0(3);
        }
        return findUsagesOptions;
    }

    protected void init() {
        super.init();
        this.update();
    }

    public void calcFindUsagesOptions(FindUsagesOptions options) {
        options.searchScope = this.myScopeCombo == null || this.myScopeCombo.getSelectedScope() == null ? GlobalSearchScope.allScope((Project)this.myProject) : this.myScopeCombo.getSelectedScope();
        options.isSearchForTextOccurrences = AbstractFindUsagesDialog.isToChange(this.myCbToSearchForTextOccurrences) && AbstractFindUsagesDialog.isSelected(this.myCbToSearchForTextOccurrences);
    }

    protected void update() {
    }

    boolean isShowInSeparateWindow() {
        return this.myCbToOpenInNewTab != null && this.myCbToOpenInNewTab.isSelected();
    }

    private boolean isSkipResultsWhenOneUsage() {
        return this.myCbToSkipResultsWhenOneUsage != null && this.myCbToSkipResultsWhenOneUsage.isSelected();
    }

    protected void doOKAction() {
        if (!this.shouldDoOkAction()) {
            return;
        }
        FindSettings settings = FindSettings.getInstance();
        if (this.myScopeCombo != null) {
            settings.setDefaultScopeName(this.myScopeCombo.getSelectedScopeName());
        }
        if (this.mySearchForTextOccurrencesAvailable && this.myCbToSearchForTextOccurrences != null && this.myCbToSearchForTextOccurrences.isEnabled()) {
            this.myFindUsagesOptions.isSearchForTextOccurrences = this.myCbToSearchForTextOccurrences.isSelected();
        }
        if (this.myCbToSkipResultsWhenOneUsage != null) {
            settings.setSkipResultsWithOneUsage(this.isSkipResultsWhenOneUsage());
        }
        super.doOKAction();
    }

    protected boolean shouldDoOkAction() {
        return this.myScopeCombo == null || this.myScopeCombo.getSelectedScope() != null;
    }

    protected static boolean isToChange(JCheckBox cb) {
        return cb != null && cb.getParent() != null;
    }

    protected static boolean isSelected(JCheckBox cb) {
        return cb != null && cb.getParent() != null && cb.isSelected();
    }

    protected StateRestoringCheckBox addCheckboxToPanel(String name, boolean toSelect2, JPanel panel2, boolean toUpdate) {
        StateRestoringCheckBox cb = new StateRestoringCheckBox(name);
        cb.setSelected(toSelect2);
        panel2.add(cb);
        if (toUpdate) {
            cb.addActionListener(___ -> this.update());
        }
        return cb;
    }

    protected JPanel createAllOptionsPanel() {
        JComponent scopePanel;
        JPanel allOptionsPanel = new JPanel();
        JPanel findWhatPanel = this.createFindWhatPanel();
        JPanel usagesOptionsPanel = this.createUsagesOptionsPanel();
        int grids = 0;
        if (findWhatPanel != null) {
            ++grids;
        }
        if (usagesOptionsPanel != null) {
            ++grids;
        }
        if (grids != 0) {
            allOptionsPanel.setLayout(new GridLayout(1, grids, 8, 0));
            if (findWhatPanel != null) {
                allOptionsPanel.add(findWhatPanel);
            }
            if (usagesOptionsPanel != null) {
                allOptionsPanel.add(usagesOptionsPanel);
            }
        }
        if ((scopePanel = this.createSearchScopePanel()) != null) {
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.add((Component)allOptionsPanel, "North");
            panel2.add((Component)scopePanel, "South");
            return panel2;
        }
        return allOptionsPanel;
    }

    @Nullable
    protected abstract JPanel createFindWhatPanel();

    protected void addUsagesOptions(JPanel optionsPanel) {
        if (this.mySearchForTextOccurrencesAvailable) {
            this.myCbToSearchForTextOccurrences = this.addCheckboxToPanel(FindBundle.message((String)"find.options.search.for.text.occurrences.checkbox", (Object[])new Object[0]), this.myFindUsagesOptions.isSearchForTextOccurrences, optionsPanel, false);
        }
        if (this.myIsShowInNewTabVisible) {
            this.myCbToSkipResultsWhenOneUsage = this.addCheckboxToPanel(FindBundle.message((String)"find.options.skip.results.tab.with.one.usage.checkbox", (Object[])new Object[0]), FindSettings.getInstance().isSkipResultsWithOneUsage(), optionsPanel, false);
        }
    }

    @Nullable
    protected JPanel createUsagesOptionsPanel() {
        JPanel optionsPanel = new JPanel();
        optionsPanel.setBorder(IdeBorderFactory.createTitledBorder((String)FindBundle.message((String)"find.options.group", (Object[])new Object[0])));
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 1));
        this.addUsagesOptions(optionsPanel);
        return optionsPanel.getComponents().length == 0 ? null : optionsPanel;
    }

    @Nullable
    private JComponent createSearchScopePanel() {
        if (this.isInFileOnly()) {
            return null;
        }
        JPanel optionsPanel = new JPanel(new BorderLayout());
        String scope = this.myFindUsagesOptions.searchScope.getDisplayName();
        this.myScopeCombo = new ScopeChooserCombo(this.myProject, this.mySearchInLibrariesAvailable, true, scope);
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myScopeCombo);
        optionsPanel.add((Component)((Object)this.myScopeCombo), "Center");
        TitledSeparator separator = SeparatorFactory.createSeparator((String)FindBundle.message((String)"find.scope.label", (Object[])new Object[0]), this.myScopeCombo.getComboBox());
        optionsPanel.add((Component)separator, "North");
        return optionsPanel;
    }

    @Nullable
    protected JComponent getPreferredFocusedControl() {
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        if (this.myScopeCombo != null) {
            return this.myScopeCombo.getComboBox();
        }
        return this.getPreferredFocusedControl();
    }

    protected final void addScopeData(FeatureUsageData data2, SearchScope scope) {
        if (PredefinedSearchScopeProvider.getInstance().getPredefinedScopes(this.myProject, null, true, true, false, false, true).contains(scope)) {
            data2.addData("searchScope", scope.getDisplayName());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findUsagesOptions";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/findUsages/AbstractFindUsagesDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/findUsages/AbstractFindUsagesDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "calcFindUsagesOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

