/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.find.FindBundle;
import com.intellij.lang.Language;
import com.intellij.lang.findUsages.EmptyFindUsagesProvider;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class FindUsagesInFileAction
extends AnAction
implements PossiblyDumbAware {
    public FindUsagesInFileAction() {
        this.setInjectedContext(true);
    }

    public boolean isDumbAware() {
        return Registry.is((String)"ide.find.in.file.highlight.usages");
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            FindUsagesInFileAction.$$$reportNull$$$0(0);
        }
        if (Registry.is((String)"ide.find.in.file.highlight.usages")) {
            ActionManager.getInstance().getAction("HighlightUsagesInFile").actionPerformed(e);
            return;
        }
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        UsageTarget[] usageTargets = (UsageTarget[])UsageView.USAGE_TARGETS_KEY.getData(dataContext);
        if (usageTargets != null) {
            FileEditor fileEditor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(dataContext);
            if (fileEditor != null) {
                usageTargets[0].findUsagesInEditor(fileEditor);
            }
        } else if (editor == null) {
            Messages.showMessageDialog((Project)project, (String)FindBundle.message((String)"find.no.usages.at.cursor.error", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
        } else {
            HintManager.getInstance().showErrorHint(editor, FindBundle.message((String)"find.no.usages.at.cursor.error", (Object[])new Object[0]));
        }
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            FindUsagesInFileAction.$$$reportNull$$$0(1);
        }
        if (Registry.is((String)"ide.find.in.file.highlight.usages")) {
            ActionManager.getInstance().getAction("HighlightUsagesInFile").update(event);
            return;
        }
        FindUsagesInFileAction.updateFindUsagesAction(event);
    }

    private static boolean isEnabled(DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null || EditorGutter.KEY.getData(dataContext) != null || Boolean.TRUE.equals(dataContext.getData(CommonDataKeys.EDITOR_VIRTUAL_SPACE))) {
            return false;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            UsageTarget[] target2 = (UsageTarget[])UsageView.USAGE_TARGETS_KEY.getData(dataContext);
            return target2 != null && target2.length > 0;
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file2 == null) {
            return false;
        }
        Language language = PsiUtilBase.getLanguageInEditor((Editor)editor, (Project)project);
        if (language == null) {
            language = file2.getLanguage();
        }
        return !(LanguageFindUsages.INSTANCE.forLanguage(language) instanceof EmptyFindUsagesProvider);
    }

    public static void updateFindUsagesAction(@NotNull AnActionEvent event) {
        if (event == null) {
            FindUsagesInFileAction.$$$reportNull$$$0(2);
        }
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        boolean enabled = FindUsagesInFileAction.isEnabled(dataContext);
        presentation.setVisible(enabled || !ActionPlaces.isPopupPlace((String)event.getPlace()));
        presentation.setEnabled(enabled);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/find/actions/FindUsagesInFileAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "updateFindUsagesAction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

