/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer;

import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.designer.LightToolWindow;
import com.intellij.designer.LightToolWindowContent;
import com.intellij.designer.ToggleEditorModeAction;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LightToolWindowManager
implements Disposable {
    public static final String EDITOR_MODE = "UI_DESIGNER_EDITOR_MODE.";
    private final MergingUpdateQueue myWindowQueue;
    protected final Project myProject;
    protected volatile ToolWindow myToolWindow;
    public final String myEditorModeKey;
    private MessageBusConnection myConnection;
    private final Consumer<DesignerEditorPanelFacade> myCreateAction;
    private final Consumer<DesignerEditorPanelFacade> myUpdateAnchorAction;
    private final Consumer<DesignerEditorPanelFacade> myDisposeAction;

    protected LightToolWindowManager(@NotNull Project project) {
        if (project == null) {
            LightToolWindowManager.$$$reportNull$$$0(0);
        }
        this.myWindowQueue = new MergingUpdateQueue(this.getComponentName(), 200, true, null, (Disposable)this);
        this.myCreateAction = designer -> designer.putClientProperty(this.getComponentName(), this.createContent((DesignerEditorPanelFacade)designer));
        this.myUpdateAnchorAction = designer -> {
            LightToolWindow toolWindow = (LightToolWindow)designer.getClientProperty(this.getComponentName());
            toolWindow.updateAnchor(this.getEditorMode());
        };
        this.myDisposeAction = designer -> this.disposeContent((DesignerEditorPanelFacade)designer);
        this.myProject = project;
        this.myEditorModeKey = EDITOR_MODE + this.getComponentName() + ".STATE";
        StartupManager.getInstance((Project)this.myProject).runAfterOpened(() -> {
            if (this.getEditorMode() == null) {
                this.initListeners();
                this.bindToDesigner(this.getActiveDesigner());
            }
        });
    }

    private void initListeners() {
        this.myConnection = this.myProject.getMessageBus().connect();
        this.myConnection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (source == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                LightToolWindowManager.this.bindToDesigner(LightToolWindowManager.this.getActiveDesigner());
            }

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (source == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                ApplicationManager.getApplication().invokeLater(() -> LightToolWindowManager.this.bindToDesigner(LightToolWindowManager.this.getActiveDesigner()));
            }

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(4);
                }
                LightToolWindowManager.this.bindToDesigner(LightToolWindowManager.this.getDesigner(event.getNewEditor()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/designer/LightToolWindowManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileOpened";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileClosed";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "selectionChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void removeListeners() {
        this.myConnection.disconnect();
        this.myConnection = null;
    }

    @Nullable
    protected abstract DesignerEditorPanelFacade getDesigner(FileEditor var1);

    @Nullable
    public DesignerEditorPanelFacade getActiveDesigner() {
        if (this.myProject.isDisposed()) {
            return null;
        }
        for (FileEditor editor : FileEditorManager.getInstance((Project)this.myProject).getSelectedEditors()) {
            DesignerEditorPanelFacade designer = this.getDesigner(editor);
            if (designer == null) continue;
            return designer;
        }
        return null;
    }

    private void bindToDesigner(final DesignerEditorPanelFacade designer) {
        this.myWindowQueue.cancelAllUpdates();
        this.myWindowQueue.queue(new Update("update"){

            public void run() {
                if (LightToolWindowManager.this.myToolWindow == null) {
                    if (designer == null) {
                        return;
                    }
                    LightToolWindowManager.this.initToolWindow();
                }
                LightToolWindowManager.this.updateToolWindow(designer);
            }
        });
    }

    protected abstract void initToolWindow();

    protected abstract void updateToolWindow(@Nullable DesignerEditorPanelFacade var1);

    protected final void initGearActions() {
        ToolWindowEx toolWindow = (ToolWindowEx)this.myToolWindow;
        toolWindow.setAdditionalGearActions((ActionGroup)new DefaultActionGroup(new AnAction[]{this.createGearActions()}));
    }

    protected abstract ToolWindowAnchor getAnchor();

    public AnAction createGearActions() {
        DefaultActionGroup group = DefaultActionGroup.createPopupGroup((Supplier)IdeBundle.messagePointer((String)"popup.title.in.editor.mode", (Object[])new Object[0]));
        group.add((AnAction)this.createToggleAction(ToolWindowAnchor.LEFT));
        group.add((AnAction)this.createToggleAction(ToolWindowAnchor.RIGHT));
        group.add((AnAction)this.createToggleAction(null));
        return group;
    }

    protected abstract ToggleEditorModeAction createToggleAction(ToolWindowAnchor var1);

    public final void bind(@NotNull DesignerEditorPanelFacade designer) {
        if (designer == null) {
            LightToolWindowManager.$$$reportNull$$$0(1);
        }
        if (this.isEditorMode()) {
            this.myCreateAction.accept(designer);
        }
    }

    public final void dispose(@NotNull DesignerEditorPanelFacade designer) {
        if (designer == null) {
            LightToolWindowManager.$$$reportNull$$$0(2);
        }
        if (this.isEditorMode()) {
            this.disposeContent(designer);
        }
    }

    protected final Object getContent(@NotNull DesignerEditorPanelFacade designer) {
        LightToolWindow toolWindow;
        if (designer == null) {
            LightToolWindowManager.$$$reportNull$$$0(3);
        }
        return (toolWindow = (LightToolWindow)designer.getClientProperty(this.getComponentName())) == null ? null : toolWindow.getContent();
    }

    protected abstract LightToolWindow createContent(@NotNull DesignerEditorPanelFacade var1);

    protected final LightToolWindow createContent(@NotNull DesignerEditorPanelFacade designer, @NotNull LightToolWindowContent content2, @NotNull String title, @NotNull Icon icon2, @NotNull JComponent component2, @NotNull JComponent focusedComponent, int defaultWidth, AnAction @Nullable [] actions) {
        if (designer == null) {
            LightToolWindowManager.$$$reportNull$$$0(4);
        }
        if (content2 == null) {
            LightToolWindowManager.$$$reportNull$$$0(5);
        }
        if (title == null) {
            LightToolWindowManager.$$$reportNull$$$0(6);
        }
        if (icon2 == null) {
            LightToolWindowManager.$$$reportNull$$$0(7);
        }
        if (component2 == null) {
            LightToolWindowManager.$$$reportNull$$$0(8);
        }
        if (focusedComponent == null) {
            LightToolWindowManager.$$$reportNull$$$0(9);
        }
        return new LightToolWindow(content2, title, icon2, component2, focusedComponent, designer.getContentSplitter(), this.getEditorMode(), this, this.myProject, this.getComponentName(), defaultWidth, actions);
    }

    protected final void disposeContent(DesignerEditorPanelFacade designer) {
        String key = this.getComponentName();
        LightToolWindow toolWindow = (LightToolWindow)designer.getClientProperty(key);
        designer.putClientProperty(key, null);
        toolWindow.dispose();
    }

    private void runUpdateContent(Consumer<? super DesignerEditorPanelFacade> action2) {
        for (FileEditor editor : FileEditorManager.getInstance((Project)this.myProject).getAllEditors()) {
            DesignerEditorPanelFacade designer = this.getDesigner(editor);
            if (designer == null) continue;
            action2.accept(designer);
        }
    }

    protected final boolean isEditorMode() {
        return this.getEditorMode() != null;
    }

    @Nullable
    public final ToolWindowAnchor getEditorMode() {
        String value2 = PropertiesComponent.getInstance((Project)this.myProject).getValue(this.myEditorModeKey);
        if (value2 == null) {
            return this.getAnchor();
        }
        return value2.equals("ToolWindow") ? null : ToolWindowAnchor.fromText((String)value2);
    }

    protected final void setEditorMode(@Nullable ToolWindowAnchor newState2) {
        ToolWindowAnchor oldState = this.getEditorMode();
        PropertiesComponent.getInstance((Project)this.myProject).setValue(this.myEditorModeKey, newState2 == null ? "ToolWindow" : newState2.toString());
        if (oldState != null && newState2 != null) {
            this.runUpdateContent(this.myUpdateAnchorAction);
        } else if (newState2 != null) {
            this.removeListeners();
            this.updateToolWindow(null);
            this.runUpdateContent(this.myCreateAction);
        } else {
            this.runUpdateContent(this.myDisposeAction);
            this.initListeners();
            this.bindToDesigner(this.getActiveDesigner());
        }
    }

    final ToolWindow getToolWindow() {
        return this.myToolWindow;
    }

    public void dispose() {
        this.myToolWindow = null;
    }

    @NotNull
    protected String getComponentName() {
        String string = this.getClass().getName();
        if (string == null) {
            LightToolWindowManager.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "designer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "focusedComponent";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/designer/LightToolWindowManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/designer/LightToolWindowManager";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "bind";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "dispose";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createContent";
                break;
            }
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

