/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConversionProcessor;
import com.intellij.conversion.ModuleSettings;
import java.util.Collection;
import org.jdom.Element;

public class DetachFacetConversionProcessor
extends ConversionProcessor<ModuleSettings> {
    private final String[] myFacetNames;

    public DetachFacetConversionProcessor(String ... names2) {
        if (names2 == null) {
            DetachFacetConversionProcessor.$$$reportNull$$$0(0);
        }
        this.myFacetNames = names2;
    }

    @Override
    public boolean isConversionNeeded(ModuleSettings moduleSettings) {
        for (String facetName : this.myFacetNames) {
            if (facetName == null || moduleSettings.getFacetElements(facetName).isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void process(ModuleSettings moduleSettings) throws CannotConvertException {
        Element facetManagerElement = moduleSettings.getComponentElement("FacetManager");
        if (facetManagerElement == null) {
            return;
        }
        for (String facetName : this.myFacetNames) {
            for (Element element2 : DetachFacetConversionProcessor.getElements(moduleSettings, facetName)) {
                element2.detach();
            }
        }
    }

    private static Element[] getElements(ModuleSettings moduleSettings, String facetName) {
        Collection<? extends Element> elements2 = moduleSettings.getFacetElements(facetName);
        return elements2.toArray(new Element[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/conversion/DetachFacetConversionProcessor", "<init>"));
    }
}

