/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.longLine;

import com.intellij.application.options.CodeStyle;
import com.intellij.application.options.CodeStyleSchemesConfigurable;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.longLine.LongLineInspectionPolicy;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.ui.HyperlinkLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LongLineInspection
extends LocalInspectionTool {
    @Nullable
    public JComponent createOptionsPanel() {
        HyperlinkLabel codeStyleHyperlink = new HyperlinkLabel("Edit Code Style settings");
        codeStyleHyperlink.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                DataManager.getInstance().getDataContextFromFocus().doWhenDone(context -> {
                    if (context != null) {
                        Settings settings = (Settings)Settings.KEY.getData(context);
                        if (settings != null) {
                            settings.select((Configurable)settings.find(CodeStyleSchemesConfigurable.class));
                        } else {
                            ShowSettingsUtil.getInstance().showSettingsDialog((Project)CommonDataKeys.PROJECT.getData(context), CodeStyleSchemesConfigurable.class);
                        }
                    }
                });
            }
        });
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BorderLayout());
        panel2.add((Component)codeStyleHyperlink, "North");
        return panel2;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            LongLineInspection.$$$reportNull$$$0(0);
        }
        PsiFile file2 = holder.getFile();
        final int codeStyleRightMargin = CodeStyle.getSettings((PsiFile)file2).getRightMargin(file2.getLanguage());
        VirtualFile vFile = file2.getVirtualFile();
        if (vFile instanceof VirtualFileWindow) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                LongLineInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        final Document document = FileDocumentManager.getInstance().getDocument(vFile);
        if (document == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                LongLineInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        return new PsiElementVisitor(){

            public void visitElement(@NotNull PsiElement element2) {
                if (element2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                int length = element2.getTextLength();
                if (element2.getTextLength() != 0 && element2.getFirstChild() == null && !LongLineInspection.ignoreFor(element2)) {
                    int offset = element2.getTextOffset();
                    int endOffset = offset + length;
                    int startLine = document.getLineNumber(offset);
                    if (offset > document.getLineStartOffset(startLine) + codeStyleRightMargin) {
                        ++startLine;
                    }
                    int endLine = document.getLineNumber(endOffset - 1);
                    for (int l = startLine; l <= endLine; ++l) {
                        int highlightingEndOffset;
                        int highlightingStartOffset;
                        int lineMarginOffset;
                        int lineEndOffset = document.getLineEndOffset(l);
                        if (lineEndOffset <= (lineMarginOffset = document.getLineStartOffset(l) + codeStyleRightMargin) || (highlightingStartOffset = lineMarginOffset - offset) >= (highlightingEndOffset = Math.min(endOffset, lineEndOffset) - offset)) continue;
                        TextRange exceedingRange = new TextRange(highlightingStartOffset, highlightingEndOffset);
                        holder.registerProblem(element2, exceedingRange, String.format("Line is longer than allowed by code style (> %s columns)", codeStyleRightMargin), new LocalQuickFix[0]);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/longLine/LongLineInspection$2", "visitElement"));
            }
        };
    }

    private static boolean ignoreFor(@Nullable PsiElement element2) {
        return element2 != null && LongLineInspectionPolicy.EP_NAME.getExtensionList().stream().anyMatch(policy -> policy.ignoreLongLineFor(element2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/longLine/LongLineInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/longLine/LongLineInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

