/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.export;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.export.HTMLExportUtil;
import com.intellij.codeInspection.export.InspectionTreeHtmlExportResources;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.ui.InspectionGroupNode;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionRootNode;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeModel;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.InspectionTreeTailRenderer;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.codeInspection.ui.SuppressableInspectionTreeNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ThrowableConsumer;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class InspectionTreeHtmlWriter {
    private static final String ERROR_COLOR = "ffabab";
    private static final String WARNING_COLOR = "f2f794";
    private final InspectionTree myTree;
    private final Path myOutputDir;
    private final InspectionProfile myProfile;
    private final RefManager myManager;

    public InspectionTreeHtmlWriter(@NotNull InspectionResultsView view, @NotNull Path outputDir) {
        if (view == null) {
            InspectionTreeHtmlWriter.$$$reportNull$$$0(0);
        }
        if (outputDir == null) {
            InspectionTreeHtmlWriter.$$$reportNull$$$0(1);
        }
        this.myTree = view.getTree();
        this.myOutputDir = outputDir;
        this.myProfile = view.getCurrentProfile();
        this.myManager = view.getGlobalInspectionContext().getRefManager();
        this.serializeTreeToHtml();
    }

    private void serializeTreeToHtml() {
        HTMLExportUtil.writeFile(this.myOutputDir, "index.html", this.myTree.getContext().getProject(), (ThrowableConsumer<? super Writer, ? extends IOException>)((ThrowableConsumer)w -> {
            InspectionTreeHtmlWriter.appendHeader(w);
            w.append("<div style=\"width:100%;\"><div style=\"float:left; width:50%;\"><h4>Inspection tree:</h4>");
            InspectionTreeTailRenderer<IOException> tailRenderer = new InspectionTreeTailRenderer<IOException>(this.myTree.getContext()){

                @Override
                protected void appendText(String text2, SimpleTextAttributes attributes) throws IOException {
                    w.append(InspectionTreeHtmlWriter.escapeNonBreakingSymbols(text2));
                }

                @Override
                protected void appendText(String text2) throws IOException {
                    w.append(InspectionTreeHtmlWriter.escapeNonBreakingSymbols(text2));
                }
            };
            InspectionTreeModel model = this.myTree.getInspectionTreeModel();
            InspectionTreeHtmlWriter.traverseInspectionTree(model.getRoot(), (ThrowableConsumer<? super InspectionTreeNode, ? extends IOException>)((ThrowableConsumer)n -> {
                RefEntity e;
                int nodeId = System.identityHashCode(n);
                w.append("<li><label for=\"").append(String.valueOf(nodeId)).append("\">").append(this.convertNodeToHtml((InspectionTreeNode)n)).append("&nbsp;<span class=\"grayout\">");
                tailRenderer.appendTailText((InspectionTreeNode)n);
                w.append("</span></label><input type=\"checkbox\" ");
                if (n instanceof InspectionRootNode) {
                    w.append("checked");
                }
                w.append(" onclick=\"navigate(").append(String.valueOf(nodeId)).append(")\" ");
                w.append(" id=\"").append(String.valueOf(nodeId)).append("\" />");
                if (n instanceof SuppressableInspectionTreeNode && (e = ((SuppressableInspectionTreeNode)n).getElement()) != null) {
                    w.append("<div id=\"d").append(String.valueOf(nodeId)).append("\" style=\"display:none\">");
                    StringBuilder buf = new StringBuilder();
                    ((SuppressableInspectionTreeNode)n).getPresentation().getComposer().compose(buf, e);
                    w.append(buf.toString());
                    w.append("</div>");
                }
                w.append("<ol class=\"tree\">");
            }), (ThrowableConsumer<? super InspectionTreeNode, ? extends IOException>)((ThrowableConsumer)n -> w.append("</ol></li>")));
            w.append("</div><div style=\"float:left; width:50%;\"><h4>Problem description:</h4><div id=\"preview\">Select a problem element in tree</div></div><div></body></html>");
        }));
        InspectionTreeHtmlExportResources.copyInspectionReportResources(this.myOutputDir);
    }

    private static void traverseInspectionTree(InspectionTreeNode node, ThrowableConsumer<? super InspectionTreeNode, ? extends IOException> preAction, ThrowableConsumer<? super InspectionTreeNode, ? extends IOException> postAction) throws IOException {
        if (node.isExcluded()) {
            return;
        }
        preAction.consume((Object)node);
        for (InspectionTreeNode inspectionTreeNode : node.getChildren()) {
            InspectionTreeHtmlWriter.traverseInspectionTree(inspectionTreeNode, preAction, postAction);
        }
        postAction.consume((Object)node);
    }

    private String convertNodeToHtml(InspectionTreeNode node) {
        if (node instanceof InspectionRootNode) {
            return "<b>'" + InspectionTreeHtmlWriter.escapeNonBreakingSymbols(node) + "' project</b>";
        }
        if (node instanceof ProblemDescriptionNode) {
            CommonProblemDescriptor descriptor2 = ((ProblemDescriptionNode)node).getDescriptor();
            String warningLevelName = "";
            String color = null;
            if (descriptor2 instanceof ProblemDescriptorBase) {
                InspectionToolWrapper tool = ((ProblemDescriptionNode)node).getToolWrapper();
                HighlightDisplayKey key = HighlightDisplayKey.find((String)tool.getShortName());
                HighlightSeverity severity = this.myProfile.getErrorLevel(key, ((ProblemDescriptorBase)descriptor2).getStartElement()).getSeverity();
                HighlightDisplayLevel level = HighlightDisplayLevel.find((HighlightSeverity)severity);
                if (HighlightDisplayLevel.ERROR.equals(level)) {
                    color = ERROR_COLOR;
                } else if (HighlightDisplayLevel.WARNING.equals(level)) {
                    color = WARNING_COLOR;
                }
                warningLevelName = level.getName();
            }
            StringBuilder sb = new StringBuilder();
            sb.append("<span style=\"margin:1px;");
            if (color != null) {
                sb.append("background:#");
                sb.append(color);
            }
            sb.append("\">");
            sb.append(warningLevelName);
            sb.append("</span>&nbsp;");
            sb.append(InspectionTreeHtmlWriter.escapeNonBreakingSymbols(node));
            return sb.toString();
        }
        if (node instanceof RefElementNode) {
            String type = this.myManager.getType(Objects.requireNonNull(((RefElementNode)node).getElement()));
            return type + "&nbsp;<b>" + node.toString() + "</b>";
        }
        if (node instanceof InspectionNode) {
            return "<b>" + InspectionTreeHtmlWriter.escapeNonBreakingSymbols(node) + "</b>&nbsp;inspection";
        }
        if (node instanceof InspectionGroupNode) {
            return "<b>" + InspectionTreeHtmlWriter.escapeNonBreakingSymbols(node) + "</b>&nbsp;group";
        }
        return InspectionTreeHtmlWriter.escapeNonBreakingSymbols(node);
    }

    private static void appendHeader(@NotNull Writer writer) throws IOException {
        if (writer == null) {
            InspectionTreeHtmlWriter.$$$reportNull$$$0(2);
        }
        String title = ApplicationNamesInfo.getInstance().getFullProductName() + " inspection report";
        writer.append("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\"><meta name=\"author\" content=\"JetBrains\"><script type=\"text/javascript\" src=\"script.js\"></script><link rel=\"stylesheet\" type=\"text/css\" href=\"styles.css\"/><title>").append(title).append("</title></head><body><h3>").append(title).append(":</h3>");
    }

    private static String escapeNonBreakingSymbols(@NotNull Object source) {
        if (source == null) {
            InspectionTreeHtmlWriter.$$$reportNull$$$0(3);
        }
        return StringUtil.replace((String)StringUtil.escapeXmlEntities((String)source.toString()), Arrays.asList(" ", "-"), Arrays.asList("&nbsp;", "&#8209;"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/export/InspectionTreeHtmlWriter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "appendHeader";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "escapeNonBreakingSymbols";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

