/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.google.common.collect.Lists;
import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.CommandLineInspectionProgressReporter;
import com.intellij.codeInspection.CommandLineInspectionProjectConfigurator;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionToolCmdlineOptionHelpProvider;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.InspectionsReportConverter;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ex.ApplicationInspectionProfileManager;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.GlobalInspectionContextUtil;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.XSLTReportConverter;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.conversion.ConversionListener;
import com.intellij.conversion.ConversionService;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.diff.util.Range;
import com.intellij.ide.impl.PatchProjectUtil;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.VcsPreservingExecutor;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.util.containers.ConcurrentMultiMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.LockSupport;
import one.util.streamex.StreamEx;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;

public final class InspectionApplication
implements CommandLineInspectionProgressReporter {
    static final Logger LOG = Logger.getInstance(InspectionApplication.class);
    public InspectionToolCmdlineOptionHelpProvider myHelpProvider;
    public String myProjectPath;
    public String myOutPath;
    public String mySourceDirectory;
    public String myStubProfile;
    public String myProfileName;
    public String myProfilePath;
    public boolean myRunWithEditorSettings;
    public boolean myRunGlobalToolsOnly;
    public boolean myAnalyzeChanges;
    private int myVerboseLevel;
    private final Map<String, List<Range>> diffMap = new ConcurrentHashMap<String, List<Range>>();
    private final MultiMap<Pair<String, Integer>, String> originalWarnings = new ConcurrentMultiMap();
    private final AsyncPromise<Void> isMappingLoaded = new AsyncPromise();
    public String myOutputFormat;
    private InspectionProfileImpl myInspectionProfile;
    public boolean myErrorCodeRequired = true;
    @NonNls
    public static final String DESCRIPTIONS = ".descriptions";
    @NonNls
    public static final String PROFILE = "profile";
    @NonNls
    public static final String INSPECTIONS_NODE = "inspections";
    @NonNls
    public static final String XML_EXTENSION = ".xml";

    public void startup() {
        if (this.myProjectPath == null) {
            this.reportError("Project to inspect is not defined");
            this.printHelp();
        }
        if (this.myProfileName == null && this.myProfilePath == null && this.myStubProfile == null) {
            this.reportError("Profile to inspect with is not defined");
            this.printHelp();
        }
        ApplicationManagerEx.getApplicationEx().setSaveAllowed(false);
        try {
            this.execute();
        }
        catch (Throwable e) {
            LOG.error(e);
            this.reportError(e.getMessage());
            this.gracefulExit();
            return;
        }
        if (this.myErrorCodeRequired) {
            ApplicationManagerEx.getApplicationEx().exit(true, true);
        }
    }

    public void execute() throws Exception {
        ApplicationManager.getApplication().runReadAction(() -> {
            ApplicationInfoEx appInfo = (ApplicationInfoEx)ApplicationInfo.getInstance();
            this.reportMessageNoLineBreak(1, InspectionsBundle.message((String)"inspection.application.starting.up", (Object[])new Object[]{appInfo.getFullApplicationName() + " (build " + appInfo.getBuild().asString() + ")"}));
            this.reportMessage(1, InspectionsBundle.message((String)"inspection.done", (Object[])new Object[0]));
            Disposable disposable2 = Disposer.newDisposable();
            try {
                this.run(Paths.get(FileUtil.toCanonicalPath((String)this.myProjectPath), new String[0]), disposable2);
            }
            finally {
                Disposer.dispose((Disposable)disposable2);
            }
            return null;
        });
    }

    private void printHelp() {
        assert (this.myHelpProvider != null);
        this.myHelpProvider.printHelpAndExit();
    }

    private void run(@NotNull Path projectPath, @NotNull Disposable parentDisposable) throws IOException, JDOMException {
        VirtualFile vfsProject;
        if (projectPath == null) {
            InspectionApplication.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            InspectionApplication.$$$reportNull$$$0(1);
        }
        if ((vfsProject = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)projectPath.toString()))) == null) {
            this.reportError(InspectionsBundle.message((String)"inspection.application.file.cannot.be.found", (Object[])new Object[]{projectPath}));
            this.printHelp();
        }
        this.reportMessageNoLineBreak(1, InspectionsBundle.message((String)"inspection.application.opening.project", (Object[])new Object[0]));
        if (ConversionService.getInstance().convertSilently(projectPath, this.createConversionListener()).openingIsCanceled()) {
            this.gracefulExit();
            return;
        }
        for (CommandLineInspectionProjectConfigurator configurator : CommandLineInspectionProjectConfigurator.EP_NAME.getExtensionList()) {
            if (!configurator.isApplicable(projectPath, this)) continue;
            configurator.configureEnvironment(projectPath, this);
        }
        Project project = ProjectUtil.openOrImport(projectPath, null, false);
        if (project == null) {
            this.reportError("Unable to open project");
            this.gracefulExit();
            return;
        }
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)new VcsListener(){

            public void directoryMappingChanged() {
                InspectionApplication.this.isMappingLoaded.setResult(null);
            }
        });
        Disposer.register((Disposable)parentDisposable, () -> InspectionApplication.closeProject(project));
        ApplicationManager.getApplication().runWriteAction(() -> VirtualFileManager.getInstance().refreshWithoutFileWatcher(false));
        PatchProjectUtil.patchProject(project);
        this.reportMessage(1, InspectionsBundle.message((String)"inspection.done", (Object[])new Object[0]));
        this.reportMessageNoLineBreak(1, InspectionsBundle.message((String)"inspection.application.initializing.project", (Object[])new Object[0]));
        this.myInspectionProfile = this.loadInspectionProfile(project);
        if (this.myInspectionProfile == null) {
            return;
        }
        GlobalInspectionContextImpl context = this.createGlobalInspectionContext(project);
        if (this.myAnalyzeChanges) {
            ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
            changeListManager.invokeAfterUpdate(() -> {
                List files2 = changeListManager.getAffectedFiles();
                for (VirtualFile file2 : files2) {
                    this.reportMessage(0, "modified file" + file2.getPath());
                }
                try {
                    this.runAnalysisOnScope(projectPath, parentDisposable, project, this.myInspectionProfile, new AnalysisScope(project, (Collection)files2));
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }, InvokeAfterUpdateMode.SYNCHRONOUS_NOT_CANCELLABLE, null, null);
        } else {
            AnalysisScope scope;
            if (this.mySourceDirectory == null) {
                String scopeName = System.getProperty("idea.analyze.scope");
                NamedScope namedScope = scopeName != null ? NamedScopesHolder.getScope((Project)project, (String)scopeName) : null;
                scope = namedScope != null ? new AnalysisScope((SearchScope)GlobalSearchScopesCore.filterScope((Project)project, (NamedScope)namedScope), project) : new AnalysisScope(project);
            } else {
                this.mySourceDirectory = this.mySourceDirectory.replace(File.separatorChar, '/');
                VirtualFile vfsDir = LocalFileSystem.getInstance().findFileByPath(this.mySourceDirectory);
                if (vfsDir == null) {
                    this.reportError(InspectionsBundle.message((String)"inspection.application.directory.cannot.be.found", (Object[])new Object[]{this.mySourceDirectory}));
                    this.printHelp();
                }
                PsiDirectory psiDirectory = PsiManager.getInstance((Project)project).findDirectory(vfsDir);
                scope = new AnalysisScope(Objects.requireNonNull(psiDirectory));
            }
            this.runAnalysisOnScope(projectPath, parentDisposable, project, this.myInspectionProfile, scope);
        }
    }

    @NotNull
    private GlobalInspectionContextImpl createGlobalInspectionContext(Project project) {
        InspectionManagerEx im = (InspectionManagerEx)InspectionManager.getInstance((Project)project);
        GlobalInspectionContextImpl context = im.createNewGlobalContext();
        context.setExternalProfile(this.myInspectionProfile);
        im.setProfile(this.myInspectionProfile.getName());
        GlobalInspectionContextImpl globalInspectionContextImpl = context;
        if (globalInspectionContextImpl == null) {
            InspectionApplication.$$$reportNull$$$0(2);
        }
        return globalInspectionContextImpl;
    }

    private void runAnalysisOnScope(Path projectPath, @NotNull Disposable parentDisposable, Project project, InspectionProfileImpl inspectionProfile, AnalysisScope scope) throws IOException {
        Path resultsDataPath;
        InspectionsReportConverter reportConverter;
        if (parentDisposable == null) {
            InspectionApplication.$$$reportNull$$$0(3);
        }
        this.reportMessage(1, InspectionsBundle.message((String)"inspection.done", (Object[])new Object[0]));
        if (!this.myRunWithEditorSettings) {
            this.reportMessage(1, InspectionsBundle.message((String)"inspection.application.chosen.profile.log.message", (Object[])new Object[]{inspectionProfile.getName()}));
        }
        if ((reportConverter = InspectionApplication.getReportConverter(this.myOutputFormat)) == null && this.myOutputFormat != null && this.myOutputFormat.endsWith(".xsl")) {
            reportConverter = new XSLTReportConverter(this.myOutputFormat);
        }
        if (!(reportConverter != null && reportConverter.useTmpDirForRawData() || this.myOutPath == null)) {
            resultsDataPath = Paths.get(this.myOutPath, new String[0]);
            Files.createDirectories(resultsDataPath, new FileAttribute[0]);
        } else {
            try {
                File tmpDir = FileUtilRt.createTempDirectory((String)INSPECTIONS_NODE, (String)"data", (boolean)false);
                Disposer.register((Disposable)parentDisposable, () -> FileUtil.delete((File)tmpDir));
                resultsDataPath = tmpDir.toPath();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                System.err.println("Cannot create tmp directory.");
                System.exit(1);
                return;
            }
        }
        this.runAnalysis(project, projectPath, inspectionProfile, scope, reportConverter, resultsDataPath);
    }

    private void configureProject(@NotNull Path projectPath, @NotNull Project project, @NotNull AnalysisScope scope) {
        if (projectPath == null) {
            InspectionApplication.$$$reportNull$$$0(4);
        }
        if (project == null) {
            InspectionApplication.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            InspectionApplication.$$$reportNull$$$0(6);
        }
        for (CommandLineInspectionProjectConfigurator configurator : CommandLineInspectionProjectConfigurator.EP_NAME.getIterable()) {
            if (!configurator.isApplicable(projectPath, this)) continue;
            configurator.configureProject(project, scope, this);
        }
    }

    private void runAnalysis(Project project, Path projectPath, InspectionProfileImpl inspectionProfile, AnalysisScope scope, InspectionsReportConverter reportConverter, Path resultsDataPath) throws IOException {
        GlobalInspectionContextImpl context = this.createGlobalInspectionContext(project);
        if (this.myAnalyzeChanges) {
            scope = this.runAnalysisOnCodeWithoutChanges(project, projectPath, this.createGlobalInspectionContext(project), scope, resultsDataPath);
            this.setupSecondAnalysisHandler(project, context);
        }
        ArrayList<Path> inspectionsResults = new ArrayList<Path>();
        this.runUnderProgress(project, projectPath, context, scope, resultsDataPath, inspectionsResults);
        Path descriptionsFile = resultsDataPath.resolve(".descriptions.xml");
        InspectionApplication.describeInspections(descriptionsFile, this.myRunWithEditorSettings ? null : inspectionProfile.getName(), inspectionProfile);
        inspectionsResults.add(descriptionsFile);
        if (reportConverter != null) {
            try {
                reportConverter.convert(resultsDataPath.toString(), this.myOutPath, context.getTools(), ContainerUtil.map2List(inspectionsResults, path -> path.toFile()));
            }
            catch (InspectionsReportConverter.ConversionException e) {
                this.reportError("\n" + e.getMessage());
                this.printHelp();
            }
        }
    }

    @NotNull
    private AnalysisScope runAnalysisOnCodeWithoutChanges(Project project, Path projectPath, GlobalInspectionContextImpl context, AnalysisScope scope, Path resultsDataPath) {
        VirtualFile[] changes = ChangesUtil.getFilesFromChanges((Collection)ChangeListManager.getInstance((Project)project).getAllChanges());
        this.setupFirstAnalysisHandler(context);
        ArrayList inspectionsResults = new ArrayList();
        DumbService dumbService = DumbService.getInstance((Project)project);
        while (dumbService.isDumb()) {
            LockSupport.parkNanos(50000000L);
        }
        if (ProjectLevelVcsManager.getInstance((Project)project).getAllVcsRoots().length == 0) {
            try {
                this.isMappingLoaded.blockingGet(60000);
            }
            catch (ExecutionException | TimeoutException e) {
                this.reportError("Cannot initialize vcs mapping");
                this.gracefulExit();
            }
        }
        InspectionApplication.runAnalysisAfterShelvingSync(project, ChangeListManager.getInstance((Project)project).getAffectedFiles(), this.createProcessIndicator(), () -> {
            InspectionApplication.syncProject(project, changes);
            this.runUnderProgress(project, projectPath, context, scope, resultsDataPath, inspectionsResults);
        });
        InspectionApplication.syncProject(project, changes);
        List files2 = ChangeListManager.getInstance((Project)project).getAffectedFiles();
        if (this.myVerboseLevel == 3) {
            for (VirtualFile file2 : files2) {
                this.reportMessage(1, "modified after unshelving: " + file2.getPath());
            }
        }
        return new AnalysisScope(project, (Collection)files2);
    }

    private static void syncProject(Project project, VirtualFile[] changes) {
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])changes);
        WriteAction.runAndWait(() -> PsiDocumentManager.getInstance((Project)project).commitAllDocuments());
    }

    private void setupFirstAnalysisHandler(GlobalInspectionContextImpl context) {
        if (this.myVerboseLevel > 0) {
            this.reportMessage(1, "Running first analysis stage...");
        }
        context.setGlobalReportedProblemFilter((entity, description) -> {
            if (!(entity instanceof RefElement)) {
                return false;
            }
            Pair<VirtualFile, Integer> fileAndLine = InspectionApplication.findFileAndLineByRefElement((RefElement)entity);
            if (fileAndLine == null) {
                return false;
            }
            this.originalWarnings.putValue((Object)Pair.create((Object)((VirtualFile)fileAndLine.first).getPath(), (Object)fileAndLine.second), (Object)description);
            return false;
        });
        context.setReportedProblemFilter((element2, descriptors) -> {
            List problemDescriptors = StreamEx.of((Object[])descriptors).select(ProblemDescriptorBase.class).toList();
            if (!problemDescriptors.isEmpty()) {
                ProblemDescriptorBase problemDescriptor = (ProblemDescriptorBase)problemDescriptors.get(0);
                VirtualFile file2 = problemDescriptor.getContainingFile();
                if (file2 == null) {
                    return false;
                }
                int lineNumber = problemDescriptor.getLineNumber();
                for (ProblemDescriptorBase it : problemDescriptors) {
                    this.originalWarnings.putValue((Object)Pair.create((Object)file2.getPath(), (Object)lineNumber), (Object)it.toString());
                }
            }
            return false;
        });
    }

    private void setupSecondAnalysisHandler(Project project, GlobalInspectionContextImpl context) {
        if (this.myVerboseLevel > 0) {
            this.reportMessage(1, "Running second analysis stage...");
        }
        this.printBeforeSecondStageProblems();
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        context.setGlobalReportedProblemFilter((entity, description) -> {
            if (!(entity instanceof RefElement)) {
                return false;
            }
            Pair<VirtualFile, Integer> fileAndLine = InspectionApplication.findFileAndLineByRefElement((RefElement)entity);
            if (fileAndLine == null) {
                return false;
            }
            return this.secondAnalysisFilter(changeListManager, description, (VirtualFile)fileAndLine.first, (Integer)fileAndLine.second);
        });
        context.setReportedProblemFilter((element2, descriptors) -> {
            List any = StreamEx.of((Object[])descriptors).select(ProblemDescriptorBase.class).toList();
            if (!any.isEmpty()) {
                ProblemDescriptorBase problemDescriptor = (ProblemDescriptorBase)any.get(0);
                String text2 = problemDescriptor.toString();
                VirtualFile file2 = problemDescriptor.getContainingFile();
                if (file2 == null) {
                    return true;
                }
                int line = problemDescriptor.getLineNumber();
                return this.secondAnalysisFilter(changeListManager, text2, file2, line);
            }
            return true;
        });
    }

    @Nullable
    private static Pair<VirtualFile, Integer> findFileAndLineByRefElement(RefElement refElement) {
        PsiElement element2 = refElement.getPsiElement();
        PsiFile psiFile = element2.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        int line = (Integer)ReadAction.compute(() -> {
            Document document = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(psiFile);
            return document == null ? -1 : document.getLineNumber(element2.getTextRange().getStartOffset());
        });
        return Pair.create((Object)virtualFile, (Object)line);
    }

    private boolean secondAnalysisFilter(ChangeListManager changeListManager, String text2, VirtualFile file2, int line) {
        List<Range> ranges = this.getOrComputeUnchangedRanges(file2, changeListManager);
        Optional first = StreamEx.of(ranges).findFirst(it -> it.start1 <= line && line < it.end1);
        if (!first.isPresent()) {
            this.logNotFiltered(text2, file2, line, -1);
            return true;
        }
        Range originRange = (Range)first.get();
        int position = originRange.start2 + line - originRange.start1;
        Collection problems = this.originalWarnings.get((Object)Pair.create((Object)file2.getPath(), (Object)position));
        if (problems.stream().anyMatch(it -> Objects.equals(it, text2))) {
            return false;
        }
        this.logNotFiltered(text2, file2, line, position);
        return true;
    }

    private void logNotFiltered(String text2, VirtualFile file2, int line, int position) {
        if (text2.contains("unused")) {
            return;
        }
        this.reportMessage(3, "Not filtered: ");
        this.reportMessage(3, file2.getPath() + ":" + (line + 1) + " Original: " + (position + 1));
        this.reportMessage(3, "\t\t" + text2);
    }

    private void printBeforeSecondStageProblems() {
        if (this.myVerboseLevel == 3) {
            this.reportMessage(3, "Old warnings:");
            ArrayList<Map.Entry> entries = new ArrayList<Map.Entry>(this.originalWarnings.entrySet());
            this.reportMessage(3, "total size: " + entries.size());
            entries.sort(Comparator.comparing(o -> (String)((Pair)o.getKey()).first).thenComparingInt(o -> (Integer)((Pair)o.getKey()).second));
            for (Map.Entry entry : entries) {
                this.reportMessage(3, (String)((Pair)entry.getKey()).first + ":" + ((Integer)((Pair)entry.getKey()).second + 1));
                for (String value2 : (Collection)entry.getValue()) {
                    this.reportMessage(3, "\t\t" + value2);
                }
            }
        }
    }

    private void runUnderProgress(@NotNull Project project, @NotNull Path projectPath, @NotNull GlobalInspectionContextImpl context, @NotNull AnalysisScope scope, @NotNull Path resultsDataPath, @NotNull List<? super Path> inspectionsResults) {
        if (project == null) {
            InspectionApplication.$$$reportNull$$$0(7);
        }
        if (projectPath == null) {
            InspectionApplication.$$$reportNull$$$0(8);
        }
        if (context == null) {
            InspectionApplication.$$$reportNull$$$0(9);
        }
        if (scope == null) {
            InspectionApplication.$$$reportNull$$$0(10);
        }
        if (resultsDataPath == null) {
            InspectionApplication.$$$reportNull$$$0(11);
        }
        if (inspectionsResults == null) {
            InspectionApplication.$$$reportNull$$$0(12);
        }
        ProgressManager.getInstance().runProcess(() -> {
            this.configureProject(projectPath, project, scope);
            if (!GlobalInspectionContextUtil.canRunInspections(project, false, () -> {})) {
                this.gracefulExit();
                return;
            }
            context.launchInspectionsOffline(scope, resultsDataPath, this.myRunGlobalToolsOnly, inspectionsResults);
            this.reportMessage(1, "\n" + InspectionsBundle.message((String)"inspection.capitalized.done", (Object[])new Object[0]) + "\n");
            if (!this.myErrorCodeRequired) {
                InspectionApplication.closeProject(project);
            }
        }, (ProgressIndicator)this.createProcessIndicator());
    }

    @NotNull
    private ProgressIndicatorBase createProcessIndicator() {
        return new ProgressIndicatorBase(){
            private String lastPrefix = "";
            private int myLastPercent = -1;
            {
                this.setText("");
            }

            @Override
            public void setText(String text2) {
                if (InspectionApplication.this.myVerboseLevel == 0) {
                    return;
                }
                if (InspectionApplication.this.myVerboseLevel == 1) {
                    if (text2 == null) {
                        return;
                    }
                    String prefix = InspectionApplication.getPrefix(text2);
                    if (prefix == null) {
                        return;
                    }
                    if (prefix.equals(this.lastPrefix)) {
                        InspectionApplication.this.reportMessageNoLineBreak(1, ".");
                        return;
                    }
                    this.lastPrefix = prefix;
                    InspectionApplication.this.reportMessage(1, "");
                    InspectionApplication.this.reportMessage(1, prefix);
                    return;
                }
                if (InspectionApplication.this.myVerboseLevel == 3) {
                    if (text2 == null) {
                        return;
                    }
                    if (!this.isIndeterminate() && this.getFraction() > 0.0) {
                        int percent = (int)(this.getFraction() * 100.0);
                        if (this.myLastPercent == percent) {
                            return;
                        }
                        String prefix = InspectionApplication.getPrefix(text2);
                        this.myLastPercent = percent;
                        String msg = (prefix != null ? prefix : InspectionsBundle.message((String)"inspection.display.name", (Object[])new Object[0])) + " " + percent + "%";
                        InspectionApplication.this.reportMessage(2, msg);
                    }
                    return;
                }
                InspectionApplication.this.reportMessage(2, text2);
            }
        };
    }

    private static void runAnalysisAfterShelvingSync(Project project, List<VirtualFile> files2, ProgressIndicator progressIndicator2, Runnable afterShelve) {
        Set versionedRoots = StreamEx.of(files2).map(it -> ProjectLevelVcsManager.getInstance((Project)project).getVcsRootFor(it)).nonNull().toSet();
        String message = VcsBundle.message((String)"searching.for.code.smells.freezing.process", (Object[])new Object[0]);
        VcsPreservingExecutor.executeOperation((Project)project, (Collection)versionedRoots, (String)message, (ProgressIndicator)progressIndicator2, (Runnable)afterShelve);
    }

    private void gracefulExit() {
        if (!this.myErrorCodeRequired) {
            throw new RuntimeException("Failed to proceed");
        }
        System.exit(1);
    }

    private static void closeProject(@NotNull Project project) {
        if (project == null) {
            InspectionApplication.$$$reportNull$$$0(13);
        }
        if (!project.isDisposed()) {
            ProjectManagerEx.getInstanceEx().forceCloseProject(project);
        }
    }

    @Nullable
    private InspectionProfileImpl loadInspectionProfile(@NotNull Project project) throws IOException, JDOMException {
        if (project == null) {
            InspectionApplication.$$$reportNull$$$0(14);
        }
        InspectionProfileImpl inspectionProfile = null;
        if (this.myProfileName != null) {
            inspectionProfile = this.loadProfileByName(project, this.myProfileName);
            if (inspectionProfile == null) {
                this.reportError("Profile with configured name (" + this.myProfileName + ") was not found (neither in project nor in config directory)");
                this.gracefulExit();
                return null;
            }
            return inspectionProfile;
        }
        if (this.myProfilePath != null) {
            inspectionProfile = this.loadProfileByPath(this.myProfilePath);
            if (inspectionProfile == null) {
                this.reportError("Failed to load profile from '" + this.myProfilePath + "'");
                this.gracefulExit();
                return null;
            }
            return inspectionProfile;
        }
        if (this.myStubProfile != null) {
            if (!this.myRunWithEditorSettings) {
                inspectionProfile = this.loadProfileByName(project, this.myStubProfile);
                if (inspectionProfile != null) {
                    return inspectionProfile;
                }
                inspectionProfile = this.loadProfileByPath(this.myStubProfile);
                if (inspectionProfile != null) {
                    return inspectionProfile;
                }
            }
            inspectionProfile = InspectionProjectProfileManager.getInstance(project).getCurrentProfile();
            this.reportError("Using default project profile");
        }
        return inspectionProfile;
    }

    @Nullable
    private InspectionProfileImpl loadProfileByPath(@NotNull String profilePath) throws IOException, JDOMException {
        InspectionProfileImpl inspectionProfile;
        if (profilePath == null) {
            InspectionApplication.$$$reportNull$$$0(15);
        }
        if ((inspectionProfile = ApplicationInspectionProfileManager.getInstanceImpl().loadProfile(profilePath)) != null) {
            this.reportMessage(1, "Loaded profile '" + inspectionProfile.getName() + "' from file '" + profilePath + "'");
        }
        return inspectionProfile;
    }

    @Nullable
    private InspectionProfileImpl loadProfileByName(@NotNull Project project, @NotNull String profileName) {
        InspectionProjectProfileManager profileManager;
        InspectionProfileImpl inspectionProfile;
        if (project == null) {
            InspectionApplication.$$$reportNull$$$0(16);
        }
        if (profileName == null) {
            InspectionApplication.$$$reportNull$$$0(17);
        }
        if ((inspectionProfile = (profileManager = InspectionProjectProfileManager.getInstance(project)).getProfile(profileName, false)) != null) {
            this.reportMessage(1, "Loaded shared project profile '" + profileName + "'");
        } else {
            for (InspectionProfileImpl profile : profileManager.getProfiles()) {
                if (!Comparing.strEqual((String)profile.getName(), (String)profileName)) continue;
                inspectionProfile = profile;
                this.reportMessage(1, "Loaded local profile '" + profileName + "'");
                break;
            }
        }
        return inspectionProfile;
    }

    @Nullable
    private static InspectionsReportConverter getReportConverter(@Nullable String outputFormat) {
        return InspectionsReportConverter.EP_NAME.getExtensionList().stream().filter(converter -> converter.getFormatName().equals(outputFormat)).findFirst().orElse(null);
    }

    private ConversionListener createConversionListener() {
        return new ConversionListener(){

            @Override
            public void conversionNeeded() {
                InspectionApplication.this.reportMessage(1, InspectionsBundle.message((String)"inspection.application.project.has.older.format.and.will.be.converted", (Object[])new Object[0]));
            }

            @Override
            public void successfullyConverted(@NotNull File backupDir) {
                if (backupDir == null) {
                    3.$$$reportNull$$$0(0);
                }
                InspectionApplication.this.reportMessage(1, InspectionsBundle.message((String)"inspection.application.project.was.succesfully.converted.old.project.files.were.saved.to.0", (Object[])new Object[]{backupDir.getAbsolutePath()}));
            }

            @Override
            public void error(@NotNull String message) {
                if (message == null) {
                    3.$$$reportNull$$$0(1);
                }
                InspectionApplication.this.reportError(InspectionsBundle.message((String)"inspection.application.cannot.convert.project.0", (Object[])new Object[]{message}));
            }

            @Override
            public void cannotWriteToFiles(@NotNull List<? extends File> readonlyFiles) {
                if (readonlyFiles == null) {
                    3.$$$reportNull$$$0(2);
                }
                StringBuilder files2 = new StringBuilder();
                for (File file2 : readonlyFiles) {
                    files2.append(file2.getAbsolutePath()).append("; ");
                }
                InspectionApplication.this.reportError(InspectionsBundle.message((String)"inspection.application.cannot.convert.the.project.the.following.files.are.read.only.0", (Object[])new Object[]{files2.toString()}));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "backupDir";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "readonlyFiles";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/InspectionApplication$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "successfullyConverted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "error";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "cannotWriteToFiles";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    private static String getPrefix(@NotNull String text2) {
        int idx;
        if (text2 == null) {
            InspectionApplication.$$$reportNull$$$0(18);
        }
        if ((idx = text2.indexOf(" in ")) == -1) {
            idx = text2.indexOf(" of ");
        }
        return idx == -1 ? null : text2.substring(0, idx);
    }

    public void setVerboseLevel(int verboseLevel) {
        this.myVerboseLevel = verboseLevel;
    }

    private void reportMessageNoLineBreak(int minVerboseLevel, String message) {
        if (this.myVerboseLevel >= minVerboseLevel) {
            System.out.print(message);
        }
    }

    @Override
    public void reportError(String message) {
        System.err.println(message);
    }

    @Override
    public void reportMessage(int minVerboseLevel, String message) {
        if (this.myVerboseLevel >= minVerboseLevel) {
            System.out.println(message);
        }
    }

    private static void describeInspections(@NonNls Path outputPath, @Nullable String name, @NotNull InspectionProfile profile) throws IOException {
        if (profile == null) {
            InspectionApplication.$$$reportNull$$$0(19);
        }
        InspectionToolWrapper[] toolWrappers = profile.getInspectionTools(null);
        HashMap<String, Set> map2 = new HashMap<String, Set>();
        for (InspectionToolWrapper toolWrapper : toolWrappers) {
            String groupName = toolWrapper.getGroupDisplayName();
            Set groupInspections = map2.computeIfAbsent(groupName, __ -> new HashSet());
            groupInspections.add(toolWrapper);
        }
        try (OutputStreamWriter fw = new OutputStreamWriter(Files.newOutputStream(outputPath, new OpenOption[0]), StandardCharsets.UTF_8);){
            PrettyPrintWriter xmlWriter = new PrettyPrintWriter((Writer)fw);
            xmlWriter.startNode(INSPECTIONS_NODE);
            if (name != null) {
                xmlWriter.addAttribute(PROFILE, name);
            }
            ArrayList<String> inspectionsWithoutDescriptions = new ArrayList<String>(1);
            for (Map.Entry entry : map2.entrySet()) {
                xmlWriter.startNode("group");
                String groupName = (String)entry.getKey();
                xmlWriter.addAttribute("name", groupName);
                Set entries = (Set)entry.getValue();
                for (InspectionToolWrapper toolWrapper : entries) {
                    xmlWriter.startNode("inspection");
                    String shortName = toolWrapper.getShortName();
                    xmlWriter.addAttribute("shortName", shortName);
                    xmlWriter.addAttribute("displayName", toolWrapper.getDisplayName());
                    boolean toolEnabled = profile.isToolEnabled(HighlightDisplayKey.find((String)shortName));
                    xmlWriter.addAttribute("enabled", Boolean.toString(toolEnabled));
                    String description = toolWrapper.loadDescription();
                    if (description != null) {
                        xmlWriter.setValue(description);
                    } else {
                        inspectionsWithoutDescriptions.add(shortName);
                    }
                    xmlWriter.endNode();
                }
                xmlWriter.endNode();
            }
            xmlWriter.endNode();
            if (!inspectionsWithoutDescriptions.isEmpty()) {
                LOG.error("Descriptions are missed for tools: " + StringUtil.join(inspectionsWithoutDescriptions, (String)", "));
            }
        }
    }

    private List<Range> getOrComputeUnchangedRanges(@NotNull VirtualFile virtualFile, @NotNull ChangeListManager changeListManager) {
        if (virtualFile == null) {
            InspectionApplication.$$$reportNull$$$0(20);
        }
        if (changeListManager == null) {
            InspectionApplication.$$$reportNull$$$0(21);
        }
        return this.diffMap.computeIfAbsent(virtualFile.getPath(), key -> InspectionApplication.computeDiff(virtualFile, changeListManager));
    }

    private static List<Range> computeDiff(@NotNull VirtualFile virtualFile, @NotNull ChangeListManager changeListManager) {
        if (virtualFile == null) {
            InspectionApplication.$$$reportNull$$$0(22);
        }
        if (changeListManager == null) {
            InspectionApplication.$$$reportNull$$$0(23);
        }
        try {
            Change change = changeListManager.getChange(virtualFile);
            if (change == null) {
                return Collections.emptyList();
            }
            ContentRevision revision = change.getBeforeRevision();
            if (revision == null) {
                return Collections.emptyList();
            }
            String oldContent = revision.getContent();
            if (oldContent == null) {
                return Collections.emptyList();
            }
            String newContent = VfsUtilCore.loadText((VirtualFile)virtualFile);
            return Lists.newArrayList(RangesBuilder.compareLines(newContent, oldContent, LineOffsetsUtil.create(newContent), LineOffsetsUtil.create(oldContent)).iterateUnchanged());
        }
        catch (VcsException | IOException e) {
            LOG.error("Couldn't load content", e);
            return Collections.emptyList();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/InspectionApplication";
                break;
            }
            case 5: 
            case 7: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultsDataPath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionsResults";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilePath";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profileName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = PROFILE;
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/InspectionApplication";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createGlobalInspectionContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runAnalysisOnScope";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "configureProject";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "runUnderProgress";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "closeProject";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadInspectionProfile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "loadProfileByPath";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "loadProfileByName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPrefix";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "describeInspections";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getOrComputeUnchangedRanges";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "computeDiff";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

