/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.settings;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.impl.TemplateEditorUtil;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.codeInsight.template.postfix.templates.editable.EditablePostfixTemplateWithMultipleExpressions;
import com.intellij.codeInsight.template.postfix.templates.editable.PostfixTemplateEditor;
import com.intellij.codeInsight.template.postfix.templates.editable.PostfixTemplateExpressionCondition;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.openapi.ui.panel.PanelGridBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ListUtil;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PostfixTemplateEditorBase<Condition extends PostfixTemplateExpressionCondition>
implements PostfixTemplateEditor {
    @NotNull
    protected final PostfixTemplateProvider myProvider;
    @NotNull
    protected final Editor myTemplateEditor;
    @NotNull
    protected final JBList<Condition> myExpressionTypesList;
    @NotNull
    protected final DefaultListModel<Condition> myExpressionTypesListModel;
    @NotNull
    protected final JBCheckBox myApplyToTheTopmostJBCheckBox;
    @NotNull
    protected final JPanel myEditTemplateAndConditionsPanel;

    public PostfixTemplateEditorBase(@NotNull PostfixTemplateProvider provider, boolean showExpressionTypes) {
        if (provider == null) {
            PostfixTemplateEditorBase.$$$reportNull$$$0(0);
        }
        this(provider, PostfixTemplateEditorBase.createSimpleEditor(), showExpressionTypes);
    }

    public PostfixTemplateEditorBase(@NotNull PostfixTemplateProvider provider, @NotNull Editor templateEditor, boolean showExpressionTypes) {
        if (provider == null) {
            PostfixTemplateEditorBase.$$$reportNull$$$0(1);
        }
        if (templateEditor == null) {
            PostfixTemplateEditorBase.$$$reportNull$$$0(2);
        }
        this.myProvider = provider;
        this.myTemplateEditor = templateEditor;
        this.myApplyToTheTopmostJBCheckBox = new JBCheckBox(CodeInsightBundle.message((String)"checkbox.apply.to.the.&topmost.expression", (Object[])new Object[0]));
        DialogUtil.registerMnemonic((AbstractButton)this.myApplyToTheTopmostJBCheckBox, (char)'&');
        this.myApplyToTheTopmostJBCheckBox.setBorder((Border)JBUI.Borders.emptyBottom((int)4));
        this.myExpressionTypesListModel = JBList.createDefaultListModel((Object[])new PostfixTemplateExpressionCondition[0]);
        this.myExpressionTypesList = new JBList(this.myExpressionTypesListModel);
        this.myExpressionTypesList.setCellRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", PostfixTemplateExpressionCondition::getPresentableName));
        PanelGridBuilder grid = UI.PanelFactory.grid().resize();
        if (showExpressionTypes) {
            JPanel expressionTypesPanel = ToolbarDecorator.createDecorator(this.myExpressionTypesList).setAddAction(button2 -> this.showAddExpressionTypePopup((AnActionButton)button2)).setRemoveAction(button2 -> ListUtil.removeSelectedItems(this.myExpressionTypesList)).disableUpDownActions().setMinimumSize((Dimension)JBUI.size((int)-1, (int)300)).createPanel();
            grid.add((PanelBuilder)UI.PanelFactory.panel((JComponent)expressionTypesPanel).withLabel(CodeInsightBundle.message((String)"label.applicable.expression.types", (Object[])new Object[0])).resizeY(true).moveLabelOnTop());
        }
        grid.add((PanelBuilder)UI.PanelFactory.panel((JComponent)this.myApplyToTheTopmostJBCheckBox));
        grid.add((PanelBuilder)UI.PanelFactory.panel((JComponent)this.myTemplateEditor.getComponent()).anchorLabelOn(UI.Anchor.Top).withComment(CodeInsightBundle.message((String)"comment.use.expr.variable.to.refer.target.expression", (Object[])new Object[0])).resizeY(true));
        this.myEditTemplateAndConditionsPanel = grid.createPanel();
    }

    @NotNull
    protected static Editor createEditor(@Nullable Project project, @NotNull Document document) {
        if (document == null) {
            PostfixTemplateEditorBase.$$$reportNull$$$0(3);
        }
        Editor editor = TemplateEditorUtil.createEditor(false, document, project);
        if (editor == null) {
            PostfixTemplateEditorBase.$$$reportNull$$$0(4);
        }
        return editor;
    }

    @NotNull
    private static Editor createSimpleEditor() {
        return PostfixTemplateEditorBase.createEditor(null, EditorFactory.getInstance().createDocument((CharSequence)""));
    }

    protected final void showAddExpressionTypePopup(@NotNull AnActionButton button2) {
        if (button2 == null) {
            PostfixTemplateEditorBase.$$$reportNull$$$0(5);
        }
        DefaultActionGroup group = new DefaultActionGroup();
        this.fillConditions(group);
        DataContext context = DataManager.getInstance().getDataContext((Component)button2.getContextComponent());
        ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, context, JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING, true, null);
        popup2.show(Objects.requireNonNull(button2.getPreferredPopupPoint()));
    }

    protected abstract void fillConditions(@NotNull DefaultActionGroup var1);

    public void setTemplate(@Nullable PostfixTemplate rawTemplate) {
        if (!(rawTemplate instanceof EditablePostfixTemplateWithMultipleExpressions)) {
            return;
        }
        EditablePostfixTemplateWithMultipleExpressions template = (EditablePostfixTemplateWithMultipleExpressions)rawTemplate;
        this.myExpressionTypesListModel.clear();
        for (PostfixTemplateExpressionCondition condition : template.getExpressionConditions()) {
            this.myExpressionTypesListModel.addElement(condition);
        }
        this.myApplyToTheTopmostJBCheckBox.setSelected(template.isUseTopmostExpression());
        ApplicationManager.getApplication().runWriteAction(() -> this.myTemplateEditor.getDocument().setText((CharSequence)template.getLiveTemplate().getString()));
    }

    @Override
    public String getHelpId() {
        return "reference.custom.postfix.templates";
    }

    public void dispose() {
        TemplateEditorUtil.disposeTemplateEditor(this.myTemplateEditor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/postfix/settings/PostfixTemplateEditorBase";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/postfix/settings/PostfixTemplateEditorBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showAddExpressionTypePopup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class AddConditionAction
    extends DumbAwareAction {
        @NotNull
        private final Condition myCondition;
        final /* synthetic */ PostfixTemplateEditorBase this$0;

        public AddConditionAction(Condition condition) {
            this.this$0 = this$0;
            super(condition.getPresentableName());
            this.myCondition = condition;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddConditionAction.$$$reportNull$$$0(0);
            }
            this.this$0.myExpressionTypesListModel.addElement(this.myCondition);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplateEditorBase$AddConditionAction", "actionPerformed"));
        }
    }
}

